/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.IndividualRefresh;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.IllegalOperation;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class Metric
extends TreeNode {
    public static final int UNIT_LEN = 99;
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER5";
    private MetricDescriptor _descptor = null;
    private String _units;
    private Sensor _sensor;
    private byte _index;
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.instrument", "oracle.dms.util.dms");

    @Deprecated
    public Metric(String name, String description, String units, Sensor sensor, boolean sanitize, byte valueType, byte index) {
        super(sensor.getParent(), name, description, sanitize);
        if (units == null) {
            throw new IllegalOperation(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), name, description, units, sensor}));
        }
        this._units = sanitize ? DMSUtil.sanitize(units, 99, true, false) : units;
        this._sensor = sensor;
        this._index = index;
        SensorDescriptor sdesc = sensor.getDescriptor();
        if (sdesc != null) {
            this._descptor = sdesc.getMetricDescriptor(this._name);
            if (this._descptor == null) {
                this._descptor = new MetricDescriptor(this._name, this._units, valueType);
                sdesc.addMetricDescriptor(this._descptor);
                NounDescriptor ndesc = this._parent.getDescriptor();
                if (ndesc != null) {
                    ndesc.setLastUpdateTime(Time.currentTimeMillis());
                }
            }
        }
    }

    public static Metric create(String name, String description, String units, Sensor sensor, boolean sanitize, byte valueType, byte index) {
        Metric metric = new Metric(name, description, units, sensor, sanitize, valueType, index);
        return metric;
    }

    public Object getValue() {
        return this.getValue(true);
    }

    Object getValue(boolean refresh) {
        Object retval = null;
        if (refresh) {
            this.refresh(null);
        }
        try {
            if (StatisticsProducer.sampleVal != null) {
                StatisticsProducer.sampleVal.occurred();
            }
            retval = this._sensor.getValue(this);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, this.getClass().getName(), "getValue", e.getMessage(), e);
            }
            retval = new ErrorObject("N/A");
        }
        return retval;
    }

    public MetricDescriptor getDescriptor() {
        return this._descptor;
    }

    void refresh(Set<GroupRefresh> gRefresh) {
        Refresh r = this._sensor.getRefresh();
        if (r != null) {
            Throwable refreshError = null;
            String errorMessageKey = null;
            if (r instanceof IndividualRefresh) {
                try {
                    ((IndividualRefresh)r).refresh(this._sensor);
                }
                catch (Throwable t) {
                    errorMessageKey = "DMS-50742";
                    refreshError = t;
                }
            } else if (r instanceof GroupRefresh) {
                GroupRefresh gr = (GroupRefresh)r;
                if (gRefresh == null) {
                    try {
                        gr.refresh();
                    }
                    catch (Throwable t) {
                        errorMessageKey = "DMS-50743";
                        refreshError = t;
                    }
                } else if (!gRefresh.contains(gr)) {
                    gRefresh.add(gr);
                    try {
                        gr.refresh();
                    }
                    catch (Throwable t) {
                        errorMessageKey = "DMS-50743";
                        refreshError = t;
                    }
                }
            }
            if (refreshError != null) {
                LogRecord lr = new LogRecord(Level.WARNING, errorMessageKey);
                lr.setParameters(new Object[]{this.toString()});
                lr.setThrown(refreshError);
                lr.setResourceBundle(LOGGER.getResourceBundle());
                LOGGER.log(lr);
            }
        }
    }

    public static Object[] getValues(Metric[] mets) {
        HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
        return Metric._getValues(mets, gRefresh);
    }

    private static Object[] _getValues(Metric[] mets, Set<GroupRefresh> gRefresh) {
        if (gRefresh == null) {
            gRefresh = new HashSet<GroupRefresh>();
        }
        Object[] retval = new Object[mets.length];
        for (int i = mets.length - 1; i >= 0; --i) {
            Metric m = mets[i];
            if (m == null) continue;
            m.refresh(gRefresh);
            if (StatisticsProducer.sampleVal != null) {
                StatisticsProducer.sampleVal.occurred();
            }
            retval[i] = m._sensor.getValue(m);
        }
        return retval;
    }

    public static Serializable[] getSerializableValues(Metric[] mets, Set<GroupRefresh> gRefresh) {
        Object[] values = Metric._getValues(mets, gRefresh);
        if (values == null) {
            return null;
        }
        Serializable[] ret = new Serializable[values.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = values[i] == null ? null : (values[i] instanceof Serializable ? (Serializable)values[i] : values[i].toString());
        }
        return ret;
    }

    public String getUnits() {
        return this._units;
    }

    public Sensor getSensor() {
        return this._sensor;
    }

    public byte getIndex() {
        return this._index;
    }
}

