/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.portable;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import oracle.as.jmx.framework.mapping.MBeanProxy;
import oracle.as.management.exception.ASException;
import oracle.as.management.streaming.MBeanInputStream;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.impl.jmx.StreamIntf;
import oracle.dfw.impl.jmx.Streaming;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.Problem;
import oracle.dfw.jmx.IncidentManagerMXBean;
import oracle.dfw.jmx.IncidentManagerProxyMXBean;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class JMXIncidentManagerProxy
implements IncidentManagerProxyMXBean,
MBeanRegistration {
    private Platform m_platform;
    private MBeanServer m_domainMbeanServer;
    private DiagnosticsFramework m_dfw;
    private String m_adminServerName;
    private String m_serverKey;
    private String m_serverKeyValue;
    private static final String INCIDENT_MANAGER_OBJECT_NAME = "oracle.dfw:type=oracle.dfw.jmx.IncidentManagerMXBean,name=IncidentManager";
    private static final String WILDCARD = ",*";
    private static final String STREAMER_OBJECT_NAME = "oracle.dfw:type=oracle.dfw.jmx.Streaming,name=Streamer";
    private static final int IOBUFFERSIZE = 65536;
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();

    public JMXIncidentManagerProxy() throws Exception {
        ServerPlatformSupport helper = ServerPlatformSupportFactory.getInstance();
        this.m_adminServerName = helper.getServerName();
        if (helper.isWebLogic()) {
            this.m_platform = Platform.WEBLOGIC;
            this.m_serverKey = "Location";
            this.m_serverKeyValue = ",Location=";
        } else if (helper.isWebSphere()) {
            this.m_platform = Platform.WEBSPHERE;
            this.m_serverKey = "process";
            this.m_serverKeyValue = ",process=";
        }
    }

    @Override
    public Map<String, List<String>> getADRHomes() throws Exception {
        HashMap<String, List<String>> allHomes = new HashMap<String, List<String>>();
        Set<ObjectName> objNames = this.getDomainMBeanServer().queryNames(new ObjectName("oracle.dfw:type=oracle.dfw.jmx.IncidentManagerMXBean,name=IncidentManager,*"), null);
        for (ObjectName imObjName : objNames) {
            String serverName = imObjName.getKeyProperty(this.m_serverKey);
            try {
                allHomes.put(serverName, this.getIncidentManagerMXBean(imObjName, null).getADRHomes());
            }
            catch (Exception e) {
                LoggerFactory.getFrameworkLogger().log(Level.FINER, "unable to get ADR Home information from server " + serverName, e);
            }
        }
        return allHomes;
    }

    @Override
    public Map<String, List<Problem>> getProblems() throws Exception {
        return this.getProblemsInADRHome(null);
    }

    @Override
    public Map<String, List<Problem>> getProblemsInADRHome(String ADRHome) throws Exception {
        HashMap<String, List<Problem>> allProblems = new HashMap<String, List<Problem>>();
        Set<ObjectName> objNames = this.getDomainMBeanServer().queryNames(new ObjectName("oracle.dfw:type=oracle.dfw.jmx.IncidentManagerMXBean,name=IncidentManager,*"), null);
        for (ObjectName imObjName : objNames) {
            String serverName = imObjName.getKeyProperty(this.m_serverKey);
            try {
                if (ADRHome == null) {
                    allProblems.put(serverName, this.getIncidentManagerMXBean(imObjName, null).getProblems());
                    continue;
                }
                allProblems.put(serverName, this.getIncidentManagerMXBean(imObjName, null).getProblems(ADRHome));
            }
            catch (Exception e) {
                LoggerFactory.getFrameworkLogger().log(Level.FINER, "unable to get problem information from server " + serverName, e);
            }
        }
        return allProblems;
    }

    @Override
    public List<Problem> getProblems(String serverName) throws Exception {
        return this.getProblems(serverName, null);
    }

    @Override
    public List<Problem> getProblems(String serverName, String ADRHome) throws Exception {
        if (ADRHome == null) {
            return this.getIncidentManagerMXBean(null, serverName).getProblems();
        }
        return this.getIncidentManagerMXBean(null, serverName).getProblems(ADRHome);
    }

    @Override
    public Problem getProblem(String serverName, String problemId) throws Exception {
        return this.getProblem(serverName, null, problemId);
    }

    @Override
    public Problem getProblem(String serverName, String ADRHome, String problemId) throws Exception {
        if (problemId == null || problemId.length() == 0) {
            throw new IllegalArgumentException("problemId argument cannot be null");
        }
        if (ADRHome == null) {
            return this.getIncidentManagerMXBean(null, serverName).getProblem(problemId);
        }
        return this.getIncidentManagerMXBean(null, serverName).getProblem(ADRHome, problemId);
    }

    @Override
    public List<Incident> getIncidents(String serverName, String problemId) throws Exception {
        return this.getIncidents(serverName, null, problemId);
    }

    @Override
    public List<Incident> getIncidents(String serverName, String ADRHome, String problemId) throws Exception {
        if (problemId == null || problemId.length() == 0) {
            throw new IllegalArgumentException("problemId argument cannot be null");
        }
        if (ADRHome == null) {
            return this.getIncidentManagerMXBean(null, serverName).getIncidents(problemId);
        }
        return this.getIncidentManagerMXBean(null, serverName).getIncidents(ADRHome, problemId);
    }

    @Override
    public Incident getIncident(String serverName, String incidentId) throws Exception {
        return this.getIncident(serverName, null, incidentId);
    }

    @Override
    public Incident getIncident(String serverName, String ADRHome, String incidentId) throws Exception {
        if (incidentId == null || incidentId.length() == 0) {
            throw new IllegalArgumentException("incidentId argument cannot be null");
        }
        if (ADRHome == null) {
            return this.getIncidentManagerMXBean(null, serverName).getIncident(incidentId);
        }
        return this.getIncidentManagerMXBean(null, serverName).getIncident(ADRHome, incidentId);
    }

    @Override
    public String addIncidentFile(String serverName, String incidentId, String filename) throws Exception {
        return this.addIncidentFile(serverName, null, incidentId, filename);
    }

    @Override
    public String addIncidentFile(String serverName, String ADRHome, String incidentId, String filename) throws Exception {
        IncidentManagerMXBean im = this.getIncidentManagerMXBean(null, serverName);
        String handle = null;
        handle = ADRHome == null ? im.addIncidentFile(incidentId, filename) : im.addIncidentFile(ADRHome, incidentId, filename);
        if (this.m_adminServerName != null && this.m_adminServerName.compareTo(serverName) != 0) {
            StreamIntf sbean = this.getStreamingMBean(serverName);
            Streaming.addRemoteHandle(handle, sbean);
        }
        return handle;
    }

    @Override
    public String getIncidentFileContents(String serverName, String incidentId, String filename) throws Exception {
        return this.getIncidentFileContents(serverName, null, incidentId, filename);
    }

    @Override
    public String getIncidentFileContents(String serverName, String ADRHome, String incidentId, String filename) throws Exception {
        IncidentManagerMXBean im = this.getIncidentManagerMXBean(null, serverName);
        String handle = null;
        handle = ADRHome == null ? im.getIncidentFileContents(incidentId, filename) : im.getIncidentFileContents(ADRHome, incidentId, filename);
        if (this.m_adminServerName != null && this.m_adminServerName.compareTo(serverName) != 0) {
            StreamIntf sbean = this.getStreamingMBean(serverName);
            Streaming.addRemoteHandle(handle, sbean);
        }
        return handle;
    }

    @Override
    public Incident createIncident(String serverName, String incidentTime, String messageId, String executionContextId, String description, String applicationName) throws Exception {
        return this.createIncident(serverName, null, incidentTime, messageId, executionContextId, description, applicationName);
    }

    @Override
    public Incident createIncident(String serverName, String ADRHome, String incidentTime, String messageId, String executionContextId, String description, String applicationName) throws Exception {
        IncidentManagerMXBean bean = this.getIncidentManagerMXBean(null, serverName);
        if (ADRHome == null) {
            return bean.createIncident(incidentTime, messageId, executionContextId, description, applicationName);
        }
        return bean.createIncident(ADRHome, incidentTime, messageId, executionContextId, description, applicationName);
    }

    @Override
    public Map<String, Map<String, List<Incident>>> queryIncidents(String query, List<String> servers) throws Exception {
        if (query == null || query.length() == 0) {
            throw new IllegalArgumentException("Query string is null or empty");
        }
        HashMap<String, Map<String, List<Incident>>> serverAdrIncidents = new HashMap<String, Map<String, List<Incident>>>();
        try {
            if (servers == null || servers.size() == 0) {
                Set<ObjectName> objNames = this.getDomainMBeanServer().queryNames(new ObjectName("oracle.dfw:type=oracle.dfw.jmx.IncidentManagerMXBean,name=IncidentManager,*"), null);
                servers = new ArrayList<String>(objNames.size());
                for (ObjectName imObjName : objNames) {
                    servers.add(imObjName.getKeyProperty(this.m_serverKey));
                }
            }
            for (String serverName : servers) {
                IncidentManagerMXBean bean = this.getIncidentManagerMXBean(null, serverName);
                Map<String, List<Incident>> adrIncidents = bean.queryIncidents(query);
                if (adrIncidents == null || adrIncidents.size() <= 0) continue;
                serverAdrIncidents.put(serverName, adrIncidents);
            }
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        return serverAdrIncidents;
    }

    @Override
    public Map<Incident, Map<String, Map<String, List<Incident>>>> createAggregatedIncident(String query, List<String> servers) throws Exception {
        if (query == null || query.length() == 0) {
            throw new IllegalArgumentException("Query string is null or empty");
        }
        String originalQuery = query;
        query = "(" + query + ")" + "and DFW_AGGREGATED_INCIDENT isnull";
        Map<String, Map<String, List<Incident>>> queryResults = this.queryIncidents(query, servers);
        if (queryResults == null || queryResults.size() == 0) {
            return null;
        }
        int incidentCount = 0;
        for (Map.Entry<String, Map<String, List<Incident>>> serverList : queryResults.entrySet()) {
            for (Map.Entry<String, List<Incident>> adrHome : serverList.getValue().entrySet()) {
                incidentCount += adrHome.getValue().size();
            }
        }
        if (incidentCount == 1) {
            String text = null;
            try {
                text = ResourceBundle.getBundle(DFW_MESSAGES).getString("DFW_INCIDENTPROXYMXBEAN_AGGREGATE_SINGLE_INCIDENT");
            }
            catch (Exception e) {
                text = "Query returned a single incident; aggregated incidents are only created when there are at least two incidents.";
            }
            throw new Exception(text);
        }
        if (this.m_dfw == null) {
            this.m_dfw = new DiagnosticsFramework();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Aggregated incident containing the following incidents:\n");
        for (Map.Entry<String, Map<String, List<Incident>>> serverList : queryResults.entrySet()) {
            buf.append("\nServer: ");
            buf.append(serverList.getKey());
            buf.append("\n");
            int count = 1;
            for (Map.Entry<String, List<Incident>> adrHome : serverList.getValue().entrySet()) {
                buf.append("ADR Home: ");
                buf.append(adrHome.getKey());
                buf.append("\n\n");
                buf.append("Zip File\t\tIncident Id \tIncident Time \t\t\tProblem Key\n");
                for (Incident incident : adrHome.getValue()) {
                    buf.append(serverList.getKey() + "_" + count + "_i" + incident.getIncidentId() + ".zip");
                    buf.append("\t");
                    buf.append(incident.getIncidentId());
                    buf.append("\t\t");
                    buf.append(new Date(incident.getTimeOfIncident()));
                    buf.append("\t");
                    buf.append(incident.getProblemKey());
                    buf.append("\n");
                    ++count;
                }
            }
        }
        buf.append("\nAggregated incident query: ");
        buf.append(originalQuery);
        buf.append("\n");
        IncidentFacts facts = IncidentFacts.createManualIncidentFacts(0L);
        facts.setEvaluateDiagnosticRules(false);
        facts.setComponentModuleId("aggregated", null);
        facts.setContextValue("DFW_AGGREGATED_INCIDENT", "true");
        facts.setDescription(buf.toString());
        Incident inc = this.m_dfw.getDDE().createIncident(facts, true);
        HashMap<Incident, Map<String, Map<String, List<Incident>>>> result = new HashMap<Incident, Map<String, Map<String, List<Incident>>>>(1);
        result.put(inc, queryResults);
        String incDir = inc.getIncidentDirectory();
        ArrayList<String> zippedFiles = new ArrayList<String>();
        for (Map.Entry entry : queryResults.entrySet()) {
            int count = 1;
            IncidentManagerMXBean ibean = this.getIncidentManagerMXBean(null, (String)entry.getKey());
            StreamIntf sbean = this.getStreamingMBean((String)entry.getKey());
            for (Map.Entry adrHome : ((Map)entry.getValue()).entrySet()) {
                for (Incident remoteInc : (List)adrHome.getValue()) {
                    String token = ibean.getZippedIncident((String)adrHome.getKey(), remoteInc.getIncidentId());
                    MBeanInputStream mis = new MBeanInputStream(token, sbean);
                    String filename = (String)entry.getKey() + "_" + count + "_i" + remoteInc.getIncidentId() + ".zip";
                    File zipFile = new File(incDir, filename);
                    FileOutputStream fos = JMXIncidentManagerProxy.getFileOutputStream(zipFile);
                    int len = 0;
                    byte[] buffer = new byte[65536];
                    do {
                        if ((len = mis.read(buffer)) <= 0) continue;
                        fos.write(buffer, 0, len);
                    } while (len > 0);
                    mis.close();
                    fos.close();
                    zippedFiles.add(zipFile.getName());
                    ++count;
                }
            }
        }
        if (zippedFiles.size() > 0) {
            String[] addFiles = zippedFiles.toArray(new String[zippedFiles.size()]);
            this.m_dfw.getIncidentManager().addIncidentFile(inc.getIncidentId(), addFiles);
        }
        return result;
    }

    private IncidentManagerMXBean getIncidentManagerMXBean(ObjectName imObjName, String serverName) throws Exception {
        ObjectName incidentManagerON = null;
        if (imObjName != null) {
            incidentManagerON = imObjName;
        } else {
            if (serverName == null || serverName.length() == 0) {
                throw new IllegalArgumentException("serverName argument cannot be null");
            }
            if (this.m_platform == Platform.WEBLOGIC) {
                incidentManagerON = new ObjectName(INCIDENT_MANAGER_OBJECT_NAME + this.m_serverKeyValue + serverName);
            } else if (this.m_platform == Platform.WEBSPHERE) {
                Set<ObjectName> objNames = this.getDomainMBeanServer().queryNames(new ObjectName(INCIDENT_MANAGER_OBJECT_NAME + this.m_serverKeyValue + serverName + WILDCARD), null);
                if (objNames != null && objNames.size() == 1) {
                    incidentManagerON = objNames.iterator().next();
                } else {
                    throw new Exception("IncidentManager MBean not found for server " + serverName);
                }
            }
        }
        return (IncidentManagerMXBean)MBeanProxy.newProxyInstance((MBeanServerConnection)this.getDomainMBeanServer(), (ObjectName)incidentManagerON, IncidentManagerMXBean.class, (boolean)true);
    }

    private StreamIntf getStreamingMBean(String serverName) throws Exception {
        if (serverName == null || serverName.length() == 0) {
            throw new IllegalArgumentException("serverName argument cannot be null");
        }
        ObjectName streamingON = null;
        if (this.m_platform == Platform.WEBLOGIC) {
            streamingON = new ObjectName(STREAMER_OBJECT_NAME + this.m_serverKeyValue + serverName);
        } else if (this.m_platform == Platform.WEBSPHERE) {
            Set<ObjectName> objNames = this.getDomainMBeanServer().queryNames(new ObjectName(STREAMER_OBJECT_NAME + this.m_serverKeyValue + serverName + WILDCARD), null);
            if (objNames != null && objNames.size() == 1) {
                streamingON = objNames.iterator().next();
            } else {
                throw new Exception("Streaming MBean not found for server " + serverName);
            }
        }
        return (StreamIntf)MBeanProxy.newProxyInstance((MBeanServerConnection)this.getDomainMBeanServer(), streamingON, StreamIntf.class, (boolean)false);
    }

    private static FileOutputStream getFileOutputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private MBeanServer getDomainMBeanServer() throws Exception {
        return this.m_domainMbeanServer;
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_domainMbeanServer = server;
        return name;
    }

    private static enum Platform {
        WEBLOGIC,
        WEBSPHERE;

    }
}

