/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.jmx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.Notification;
import javax.management.NotificationListener;
import oracle.as.jmx.framework.annotations.Inject;
import oracle.as.jmx.framework.services.EventBroadcaster;
import oracle.as.management.exception.ASException;
import oracle.as.management.streaming.Streamer;
import oracle.core.ojdl.logging.LogUtil;
import oracle.core.ojdl.util.TimestampFormat;
import oracle.dfw.common.DFWUtils;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.common.TempFileManager;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.incident.DiagnosticsDataExtractorImpl;
import oracle.dfw.impl.incident.IncidentManagerImpl;
import oracle.dfw.impl.jmx.OpenTypeHelper;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentCreationEvent;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.IncidentManager;
import oracle.dfw.incident.Problem;
import oracle.dfw.jmx.IncidentManagerMXBean;
import oracle.dfw.resource.DiagnosticTranslation;

public class JMXIncidentManager
implements IncidentManagerMXBean,
NotificationListener,
DiagnosticsListener {
    private EventBroadcaster m_eventBroadcaster;
    private IncidentManager m_incidentManager;
    private DiagnosticsDataExtractorImpl m_dde;
    private String m_adrOracleHome;
    private ADRInfo m_defaultADR;
    private static final int IOBUFFERSIZE = 65536;
    private static final String STREAM_CLOSED = "1";
    private static final String STREAM_CANCELLED = "2";
    private static final String INCIDENT_CREATED_NOTIFICATION_TYPE = "oracle.dfw.incident.created";
    private Object[][] m_formats = new Object[][]{{TimestampFormat.getInstance((String)"ISO8601"), null}, {TimestampFormat.getInstance((String)"CLF"), null}, {TimestampFormat.getInstance((String)"HH:mm"), new int[]{11, 12, 13, 14}}, {TimestampFormat.getInstance((String)"HH:mm:ss"), new int[]{11, 12, 13, 14}}, {TimestampFormat.getInstance((String)"yyyy-MM-dd"), null}, {TimestampFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm"), null}, {TimestampFormat.getInstance((String)"yyyy-MM-dd HH:mm"), null}, {TimestampFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss"), null}, {TimestampFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss"), null}, {TimestampFormat.getInstance((String)"yy/MM/dd HH:mm:ss"), null}, {TimestampFormat.getInstance((String)"yy/MM/dd HH:mm"), null}, {TimestampFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss"), null}, {TimestampFormat.getInstance((String)"yyyy/MM/dd HH:mm"), null}, {TimestampFormat.getInstance(), null}};

    public JMXIncidentManager(IncidentManager incidentManager, DiagnosticsDataExtractor dde, String adrOracleHome, ADRInfo defaultADR) {
        this.m_incidentManager = incidentManager;
        this.m_dde = (DiagnosticsDataExtractorImpl)dde;
        this.m_adrOracleHome = adrOracleHome;
        this.m_defaultADR = defaultADR;
        DiagnosticsEventManager.registerListener(this);
    }

    @Inject
    public void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.m_eventBroadcaster = eventBroadcaster;
    }

    @Override
    public List<Problem> getProblems() {
        return this.m_incidentManager.getProblems();
    }

    @Override
    public List<Problem> getProblems(String ADRHome) throws Exception {
        try {
            return this.m_incidentManager.getProblems(ADRHome);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
    }

    @Override
    public Problem getProblem(String problemId) {
        return this.m_incidentManager.getProblem(problemId);
    }

    @Override
    public Problem getProblem(String ADRHome, String problemId) throws Exception {
        try {
            return this.m_incidentManager.getProblem(ADRHome, problemId);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
    }

    @Override
    public List<Incident> getIncidents(String problemId) {
        return this.m_incidentManager.getIncidents(problemId);
    }

    @Override
    public List<Incident> getIncidents(String ADRHome, String problemId) throws Exception {
        try {
            return this.m_incidentManager.getIncidents(ADRHome, problemId);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
    }

    @Override
    public Incident getIncident(String incidentId) {
        return this.m_incidentManager.getIncident(incidentId);
    }

    @Override
    public Incident getIncident(String ADRHome, String incidentId) throws Exception {
        try {
            return this.m_incidentManager.getIncident(ADRHome, incidentId);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
    }

    @Override
    public Incident createIncident(String incidentTime, String messageId, String executionContextId, String description, String applicationName) throws Exception {
        return this.createIncident(this.m_defaultADR.getADRHome(), incidentTime, messageId, executionContextId, description, applicationName);
    }

    @Override
    public Incident createIncident(String ADRHome, String incidentTime, String messageId, String executionContextId, String description, String applicationName) throws Exception {
        if (this.m_dde == null) {
            throw new Exception("incident creation unavailable");
        }
        long incidentLongTime = 0L;
        if (incidentTime != null && incidentTime.length() > 0) {
            incidentLongTime = this.convertTimeToLong(incidentTime);
            if (incidentLongTime == Long.MIN_VALUE) {
                throw new Exception("incident timestamp " + incidentTime + " is invalid");
            }
        } else {
            incidentLongTime = System.currentTimeMillis();
        }
        try {
            IncidentFacts facts = IncidentFacts.createManualIncidentFacts(incidentLongTime);
            facts.setApplicationName(applicationName);
            facts.setExecutionContextId(executionContextId);
            facts.setDescription(description);
            if (messageId != null && messageId.length() > 0) {
                facts.setErrorMessage(new ErrorMessage(messageId));
            }
            ADRInfo adrInfo = ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome);
            facts.setADRHome(adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId());
            return this.m_dde.createIncident(facts, true);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
    }

    @Override
    public String getIncidentFileContents(String incidentId, String filename) throws Exception {
        return this.getIncidentFileContents(this.m_defaultADR.getADRHome(), incidentId, filename);
    }

    @Override
    public String getIncidentFileContents(String ADRHome, String incidentId, String filename) throws Exception {
        if (incidentId == null || incidentId.length() == 0 || ADRHome == null || ADRHome.length() == 0 || filename == null || filename.length() == 0 || filename.startsWith(".") || filename.contains("/") || filename.contains("\\") || filename.contains(":")) {
            throw new IllegalArgumentException("Invalid arguments;ADRHome=" + ADRHome + " incidentId=" + incidentId + " filename=" + filename);
        }
        Incident incident = null;
        try {
            incident = this.m_incidentManager.getIncident(ADRHome, incidentId);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        if (incident == null) {
            DiagnosticsException de = new DiagnosticsException("DFW-40122", incidentId);
            throw ASException.toException(de, Exception.class);
        }
        File incidentFile = new File(incident.getIncidentDirectory(), filename);
        if (!incident.getIncidentFiles().contains(filename)) {
            DiagnosticsException de = new DiagnosticsException("DFW-40123");
            de.addToken(filename);
            de.addToken(incidentId);
            throw ASException.toException(de, Exception.class);
        }
        return Streamer.addInputStream(JMXIncidentManager.getFileInputStream(incidentFile));
    }

    @Override
    public String getADROracleHome() {
        return this.m_adrOracleHome;
    }

    @Override
    public String getADRBase() {
        return this.m_defaultADR.getADRBase();
    }

    @Override
    public String getADRHome() {
        return this.m_defaultADR.getADRHome();
    }

    @Override
    public List<String> getADRHomes() {
        return this.m_incidentManager.getADRHomes();
    }

    @Override
    public List<String> getADRHomesAbsolutePath() {
        ArrayList<String> homes = new ArrayList<String>();
        if (this.m_incidentManager.getADRHomes() != null) {
            for (String adrHome : this.m_incidentManager.getADRHomes()) {
                homes.add(this.m_defaultADR.getADRBase() + File.separatorChar + adrHome);
            }
        }
        return homes;
    }

    @Override
    public String getADRHomeAbsolutePath() {
        return this.m_defaultADR.getADRBase() + File.separatorChar + this.m_defaultADR.getADRHome();
    }

    @Override
    public String getADRProductId(String value) {
        return DFWUtils.getADRProductId(value);
    }

    @Override
    public String getADRInstanceId(String value) {
        return DFWUtils.getADRInstanceId(value);
    }

    @Override
    public String addIncidentFile(String incidentId, String filename) throws Exception {
        return this.addIncidentFile(this.m_defaultADR.getADRHome(), incidentId, filename);
    }

    @Override
    public String addIncidentFile(String ADRHome, String incidentId, String filename) throws Exception {
        if (filename == null || filename.length() == 0 || filename.startsWith(".") || filename.contains("/") || filename.contains("\\") || filename.contains(":") || incidentId == null || incidentId.length() == 0) {
            throw new IllegalArgumentException("Invalid arguments; filename=" + filename + " incidentId=" + incidentId);
        }
        if (filename.length() > 64) {
            throw new Exception("file " + filename + " cannot be added to incident " + incidentId + " as it exceeds the maximum filename length of " + 64 + " characters");
        }
        ADRInfo adrInfo = null;
        try {
            adrInfo = ADRInfo.getADRInfo(this.m_defaultADR.getADRBase(), ADRHome);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        Incident incident = this.m_incidentManager.getIncident(adrInfo.getADRHome(), incidentId);
        if (incident == null) {
            DiagnosticsException de = new DiagnosticsException("DFW-40122", incidentId);
            throw ASException.toException(de, Exception.class);
        }
        File fullPath = new File(incident.getIncidentDirectory(), filename);
        IncidentFile incFile = new IncidentFile(incident.getIncidentId(), fullPath.getAbsolutePath(), adrInfo.getADRHome());
        FileOutputStream fos = JMXIncidentManager.getFileOutputStream(fullPath);
        return Streamer.addOutputStream(fos, this, new Notification(STREAM_CLOSED, incFile, 0L), fos, new Notification(STREAM_CANCELLED, incFile, 0L), fos, 0);
    }

    @Override
    public Map<String, List<Incident>> queryIncidents(String query) throws Exception {
        HashMap<String, List<Incident>> adrIncidents = null;
        try {
            ((IncidentManagerImpl)this.m_incidentManager).validateQuery(query);
            List<String> adrHomes = this.m_incidentManager.getADRHomes();
            adrIncidents = new HashMap<String, List<Incident>>();
            for (String home : adrHomes) {
                List<Incident> incidents = this.m_incidentManager.queryIncidents(home, query);
                if (incidents == null || incidents.size() <= 0) continue;
                adrIncidents.put(home, incidents);
            }
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        return adrIncidents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getZippedIncident(String ADRHome, String incidentId) throws Exception {
        if (incidentId == null || incidentId.length() == 0 || ADRHome == null || ADRHome.length() == 0) {
            throw new IllegalArgumentException("Invalid arguments;ADRHome=" + ADRHome + " incidentId=" + incidentId);
        }
        Incident incident = null;
        try {
            incident = this.m_incidentManager.getIncident(ADRHome, incidentId);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        if (incident == null) {
            DiagnosticsException de = new DiagnosticsException("DFW-40122", incidentId);
            throw ASException.toException(de, Exception.class);
        }
        File zipFile = TempFileManager.createTempFile("jmx_incident", ".zip");
        zipFile.deleteOnExit();
        FileOutputStream fos = JMXIncidentManager.getFileOutputStream(zipFile);
        ZipOutputStream zout = new ZipOutputStream(fos);
        byte[] buffer = new byte[65536];
        try {
            String incDir = incident.getIncidentDirectory();
            for (String filename : incident.getIncidentFiles()) {
                File incFile = new File(incDir, filename);
                FileInputStream fis = JMXIncidentManager.getFileInputStream(incFile);
                int len = 0;
                ZipEntry ze = new ZipEntry(incFile.getName());
                ze.setTime(incFile.lastModified());
                zout.putNextEntry(ze);
                do {
                    if ((len = fis.read(buffer)) <= 0) continue;
                    zout.write(buffer, 0, len);
                } while (len > 0);
                fis.close();
                fos.flush();
            }
        }
        finally {
            try {
                if (zout != null) {
                    zout.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioex) {
                fos = null;
            }
        }
        return Streamer.addInputStream(JMXIncidentManager.getFileInputStream(zipFile));
    }

    @Override
    public Map<String, String> reloadCustomRules(String filename) throws Exception {
        if (this.m_dde == null) {
            throw new Exception("incident support unavailable");
        }
        if (filename != null && filename.length() == 0) {
            filename = null;
        }
        return this.m_dde.reloadCustomRules(filename);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        IncidentFile incFile;
        if (handback instanceof FileOutputStream && notification.getType().equals(STREAM_CLOSED)) {
            IncidentFile incFile2 = (IncidentFile)notification.getSource();
            if (incFile2 != null) {
                try {
                    String filename = new File(incFile2.m_incidentFile).getName();
                    this.m_incidentManager.addIncidentFileWithADRHome(incFile2.m_ADRHome, incFile2.m_incidentId, filename);
                }
                catch (Exception e) {
                    LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40124", (Object[])new Object[]{incFile2.m_incidentFile, incFile2.m_incidentId}, (Throwable)e);
                }
            }
        } else if (handback instanceof FileOutputStream && notification.getType().equals(STREAM_CANCELLED) && (incFile = (IncidentFile)notification.getSource()) != null) {
            final File realFile = new File(incFile.m_incidentFile);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (realFile.exists()) {
                            realFile.delete();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40124", (Object[])new Object[]{incFile.m_incidentFile, incFile.m_incidentId}, (Throwable)e);
            }
        }
    }

    private long convertTimeToLong(String timestamp) {
        for (Object[] entry : this.m_formats) {
            TimestampFormat tf = (TimestampFormat)entry[0];
            ParsePosition pp = new ParsePosition(0);
            long time = tf.parse(timestamp, pp);
            if (time == Long.MIN_VALUE || pp.getIndex() != timestamp.length()) continue;
            int[] fields = (int[])entry[1];
            if (fields != null) {
                Calendar c1 = Calendar.getInstance();
                c1.setTimeInMillis(time);
                Calendar c2 = Calendar.getInstance();
                c2.setLenient(false);
                for (int f : fields) {
                    c2.set(f, c1.get(f));
                }
                return c2.getTimeInMillis();
            }
            return time;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof IncidentCreationEvent) {
            Incident incident = ((IncidentCreationEvent)event).getIncident();
            this.m_eventBroadcaster.sendManagementEvent("diagnostic.incidents", INCIDENT_CREATED_NOTIFICATION_TYPE, DiagnosticTranslation.class.getName(), "DFW_INCIDENT_MANAGER_NOTIF_DESC", new String[]{incident.getIncidentId(), incident.getProblemKey()}, (Serializable)OpenTypeHelper.serializeIncident(incident), (Object)this);
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{IncidentCreationEvent.class};
    }

    private static FileOutputStream getFileOutputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static class IncidentFile {
        String m_incidentId;
        String m_incidentFile;
        String m_ADRHome;

        public IncidentFile(String incidentId, String incidentFile, String ADRHome) {
            this.m_incidentId = incidentId;
            this.m_incidentFile = incidentFile;
            this.m_ADRHome = ADRHome;
        }
    }
}

