/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.sampling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dfw.sampling.DumpSampling;

public class DumpSamplingArchive
extends ComponentDiagnosticDump {
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();
    public static final String SAMPLENAME_ARG = "sampleName";

    public DumpSamplingArchive() {
        this.defineArgument(SAMPLENAME_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_DUMPSAMPLEARCHIVE_SAMPLENAME_ARG");
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        DumpResult result = null;
        String dumpName = context.getArguments().getString(SAMPLENAME_ARG);
        try {
            List<Object> resultantFilenames = null;
            File readmeFile = DumpSampling.generateFileName(context, "readme", "txt");
            FileOutputStream readmeOuts = DumpSampling.getFileOutputStream(readmeFile);
            PrintWriter readmeWriter = new PrintWriter(readmeOuts);
            if (dumpName == null) {
                resultantFilenames = new LinkedList();
                List<DumpSampling> listOfSamplings = DumpSampling.getAllInstances();
                if (listOfSamplings != null) {
                    for (DumpSampling ds : listOfSamplings) {
                        List<String> dumpFilenames = ds.dumpArchives(context, false, readmeWriter);
                        if (dumpFilenames == null || dumpFilenames.size() <= 0) continue;
                        resultantFilenames.addAll(dumpFilenames);
                    }
                }
            } else {
                DumpSampling ds = DumpSampling.getInstance(dumpName);
                if (ds != null) {
                    resultantFilenames = ds.dumpArchives(context, true, readmeWriter);
                }
            }
            if (resultantFilenames == null || resultantFilenames.size() == 0) {
                readmeWriter.println("There is no sample.");
            }
            readmeWriter.flush();
            readmeWriter.close();
            resultantFilenames.add(readmeFile.getName());
            result = new DumpResult(context, resultantFilenames.toArray(new String[resultantFilenames.size()]));
        }
        catch (Exception ex) {
            throw new DumpExecutionException("failure in dumping Dump Archives", ex);
        }
        return result;
    }

    @Override
    public String getName() {
        return "samplingArchive";
    }

    @Override
    public String getOwner() {
        return "dfw";
    }

    public static final String getDiagnosticDumpName() {
        return "dfw.samplingArchive";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.THREADS);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_DUMPARCHIVE_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_DUMPARCHIVE_DESCRIPTION", locale);
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }
}

