/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import oracle.dfw.common.ArgumentDescriptor;
import oracle.dfw.common.ArgumentDescriptorMap;
import oracle.dfw.common.ArgumentMap;
import oracle.dfw.dump.InvalidDumpContextException;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.impl.common.ArgumentMapImpl;
import oracle.dfw.impl.common.TempFileManager;
import oracle.dfw.incident.IncidentFacts;

public class DumpContext
implements Serializable {
    private String m_dumpName;
    private long m_dumpID;
    private String m_adrHome;
    private String m_incidentID;
    private String m_oracleInstancePath;
    private String m_oracleHomePath;
    private String m_incidentPath;
    private String m_customPath;
    private boolean m_isAppScoped;
    private String m_appName;
    private ArgumentMapImpl m_arguments = new ArgumentMapImpl();
    private IncidentFacts m_facts;
    private static AtomicLong DUMPID_COUNT = new AtomicLong();
    private static final long serialVersionUID = 0L;

    private DumpContext(String dumpName) {
        this.m_dumpName = dumpName;
        this.m_dumpID = DUMPID_COUNT.incrementAndGet();
    }

    private DumpContext(String dumpName, String adrHome, String incidentID, String incidentPath, IncidentFacts facts) {
        this(dumpName);
        this.m_incidentID = incidentID;
        this.m_incidentPath = incidentPath;
        this.m_facts = facts;
        this.m_adrHome = adrHome;
    }

    public final String getDumpName() {
        return this.m_dumpName;
    }

    public final String getDumpID() {
        return String.valueOf(this.m_dumpID);
    }

    public final String getIncidentID() {
        return this.m_incidentID;
    }

    public IncidentFacts getIncidentFacts() {
        return this.m_facts;
    }

    public String getADRHome() {
        return this.m_adrHome;
    }

    public final String getDumpPath() {
        if (this.m_incidentPath != null) {
            return this.m_incidentPath;
        }
        if (this.m_customPath != null) {
            return this.m_customPath;
        }
        try {
            return TempFileManager.getTemporaryDirectory().getAbsolutePath();
        }
        catch (Exception e) {
            return ".";
        }
    }

    public final void setDumpPath(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("invalid argument: path is null");
        }
        final File checkPath = new File(path);
        boolean valid = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return checkPath.exists() && checkPath.isDirectory();
            }
        });
        if (!valid) {
            throw new IOException("The path '" + path + "' does not exist, or is " + "not a directory");
        }
        this.m_customPath = path;
    }

    public final File generateUniqueFile(String extension) throws IOException {
        String fileExt;
        File file = null;
        String string = fileExt = extension != null ? extension : "txt";
        if (this.m_incidentPath != null) {
            StringBuilder filename = new StringBuilder();
            filename.append(this.m_dumpName.replace('.', '_'));
            filename.append(this.m_dumpID);
            filename.append("_i");
            filename.append(this.m_incidentID);
            filename.append(".");
            filename.append(fileExt);
            final File ffile = file = new File(this.m_incidentPath, filename.toString());
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        ffile.createNewFile();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        } else {
            file = this.m_customPath != null ? DumpContext.createTempFile(this.m_dumpName.replace('.', '_') + this.m_dumpID + "-", "." + fileExt, new File(this.m_customPath)) : TempFileManager.createTempFile(this.m_dumpName.replace('.', '_'), "." + fileExt);
        }
        return file;
    }

    public String getOracleHomePath() {
        return this.m_oracleHomePath;
    }

    public void setOracleHomePath(String oracleHomePath) {
        this.m_oracleHomePath = oracleHomePath;
    }

    public void setAppScoped(String appName) {
        this.m_isAppScoped = true;
        this.m_appName = appName;
    }

    public boolean isAppScoped() {
        return this.m_isAppScoped;
    }

    public String getAppName() {
        return this.m_appName;
    }

    public final void addArgument(String argName, Serializable argValue) {
        if (argName == null || argValue == null) {
            return;
        }
        this.m_arguments.put(argName, argValue);
    }

    public ArgumentMap getArguments() {
        return this.m_arguments;
    }

    public Set<String> validateDumpArguments(ArgumentDescriptorMap mandatory, ArgumentDescriptorMap optional) throws InvalidDumpContextException {
        String argName;
        HashSet<String> result = new HashSet<String>();
        ArgumentMap map = this.getArguments();
        Enumeration<String> args = mandatory.enumerateKeys();
        while (args.hasMoreElements()) {
            argName = args.nextElement();
            if (map.containsKey(argName)) continue;
            result.add(argName);
        }
        if (!result.isEmpty()) {
            throw new InvalidDumpContextException("DFW-40005", (String)result.iterator().next(), result);
        }
        args = map.enumerateKeys();
        while (args.hasMoreElements()) {
            argName = args.nextElement();
            ArgumentDescriptor desc = mandatory.get(argName);
            if (desc == null) {
                desc = optional.get(argName);
            }
            if (desc == null) {
                result.add(argName);
                continue;
            }
            if (desc.getType().isValidType(map.get(argName)) || desc.getType().convertToType(map.get(argName).toString()) != null) continue;
            InvalidDumpContextException e = new InvalidDumpContextException("DFW-40007");
            e.addToken(argName);
            e.addToken(desc.getType().toString());
            throw e;
        }
        return result;
    }

    public String toString() {
        StringBuffer desc = new StringBuffer();
        desc.append("[dumpName=");
        desc.append(this.m_dumpName);
        desc.append(" args={");
        ArgumentMap map = this.getArguments();
        Enumeration<String> args = map.enumerateKeys();
        boolean first = true;
        while (args.hasMoreElements()) {
            String argName = args.nextElement();
            if (!first) {
                desc.append(",");
            }
            desc.append(argName);
            desc.append("=");
            desc.append(map.get(argName));
            first = false;
        }
        desc.append("}]");
        return desc.toString();
    }

    public static DumpContext createDumpContext(String dumpName) {
        if (dumpName == null || dumpName.length() == 0) {
            throw new IllegalArgumentException("Illegal DumpContext arguments");
        }
        return new DumpContext(dumpName);
    }

    public static DumpContext createDumpContext(String dumpName, String incidentID, String incidentPath, IncidentFacts facts) {
        String adrHome = null;
        DiagnosticsFramework df = null;
        try {
            df = new DiagnosticsFramework();
        }
        catch (Exception e) {
            // empty catch block
        }
        adrHome = df != null && df.getIncidentManager() != null ? df.getIncidentManager().getADRHome() : ".";
        return DumpContext.createDumpContext(dumpName, adrHome, incidentID, incidentPath, facts);
    }

    public static DumpContext createDumpContext(String dumpName, String adrHome, String incidentID, String incidentPath, IncidentFacts facts) {
        if (dumpName == null || dumpName.length() == 0 || adrHome == null || adrHome.length() == 0 || incidentID == null || incidentID.length() == 0 || incidentPath == null || incidentPath.length() == 0 || facts == null) {
            throw new IllegalArgumentException("Illegal DumpContext arguments");
        }
        return new DumpContext(dumpName, adrHome, incidentID, incidentPath, facts);
    }

    private static File createTempFile(final String prefix, final String suffix, final File directory) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return File.createTempFile(prefix, suffix, directory);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

