/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import oracle.dms.instrument.Noun;
import oracle.dms.spy.jvm.ClassLoaderStats;
import oracle.dms.spy.jvm.CompilerStats;
import oracle.dms.spy.jvm.MemoryStats;
import oracle.dms.spy.jvm.OSStats;
import oracle.dms.spy.jvm.RuntimeStats;
import oracle.dms.spy.jvm.ThreadMonitor;
import oracle.dms.spy.jvm.ThreadStats;

public class MgmtStats {
    private static MgmtStats s_stats = null;
    private static Noun s_baseNoun = null;
    private static volatile boolean s_isMemoryStatsEnabled = true;
    private static volatile boolean s_isMemoryStatsInited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MgmtStats() {
        ClassLoaderStats.create(s_baseNoun);
        CompilerStats.create(s_baseNoun);
        RuntimeStats.create(s_baseNoun);
        ThreadStats.create(s_baseNoun);
        ThreadMonitor.create(s_baseNoun);
        OSStats.create(s_baseNoun);
        Class<MgmtStats> clazz = MgmtStats.class;
        synchronized (MgmtStats.class) {
            if (s_isMemoryStatsEnabled) {
                MemoryStats.create(s_baseNoun);
                s_isMemoryStatsInited = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void create(Noun noun) {
        if (s_stats != null) {
            return;
        }
        s_baseNoun = noun != null ? Noun.create(noun, "MxBeans", "") : Noun.create("/JVM/MxBeans");
        s_stats = new MgmtStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit() {
        s_stats = null;
        s_baseNoun = null;
        ClassLoaderStats.exit();
        CompilerStats.exit();
        RuntimeStats.exit();
        ThreadStats.exit();
        ThreadMonitor.exit();
        OSStats.exit();
        Class<MgmtStats> clazz = MgmtStats.class;
        synchronized (MgmtStats.class) {
            if (s_isMemoryStatsInited) {
                MemoryStats.exit();
                s_isMemoryStatsInited = false;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void enableMemoryStats(boolean isMemoryStatsEnabled) {
        s_isMemoryStatsEnabled = isMemoryStatsEnabled;
        if (s_isMemoryStatsInited && !isMemoryStatsEnabled) {
            MemoryStats.exit();
            s_isMemoryStatsInited = false;
        }
    }
}

