/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContextComponents;
import oracle.dms.context.ExecutionContextStub;
import oracle.dms.context.RID;
import oracle.dms.context.WrapOptions;
import oracle.dms.context.WrappedContextDecoder;
import oracle.dms.context.internal.ContextEncode;
import oracle.dms.context.internal.DomainContextFamily;
import oracle.dms.context.internal.DomainContextFamilyStub;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.DomainExecutionContextStub;
import oracle.dms.util.DMSProperties;

public class WrapUtils {
    private static final char VERSION_ONE_PREFIX = '1';
    private static final char VERSION_SEPARATOR = '.';
    private static final char NULL_VERSION = '\u0000';
    private static final int DEFAULT_MAX_WRAP_SIZE = 16384;
    private static final char ContextWrapSep = ';';
    private static final byte ContextWrapRidSep = -128;
    private static final byte ContextWrapParamLog = 1;
    private static final byte ContextWrapParamLimit = 2;
    private static final byte ContextWrapParamName = 4;
    private static final byte ContextWrapParamValue = 8;
    private static final byte ContextWrapParamBase = -128;
    private static final String ContextStringEncode = "UTF-8";
    private static final int ContextWrapRidDigit = 11;
    private static Logger sLogger = DMSContextManager.getLogger();
    private static final int ENCODING_FORMAT_DPSID_LENGTH = 18;
    private static final int ENCODING_FORMAT_IPv4_LENGTH = 17;
    private static final int ENCODING_FORMAT_IPv6_LENGTH = 28;
    private static final int UB1_BITS = 8;
    private static final int UB1_MASK = 255;
    private static final int UB4_BITS = 32;
    private static final int IPv4_SHIFT = 5;
    private static final int IPv4_MOVE = 27;
    private static final int IPv4_MASK = 0x7FFFFFF;
    private static final int IPv6_SHIFT = 11;
    private static final int IPv6_MOVE = 21;
    private static final int IPv6_MASK = 0x1FFFFF;
    private static AtomicLong sECIDCounter = new AtomicLong(0L);
    private static int s_ecidSize;
    private static String s_processId;
    public static final String CLASS_NAME;
    private static final String LOG_KEY = "ctxLogLevel";
    private static final String SQL_KEY = "ctxUpdateSql";
    private static final String TIME_KEY = "ctxTimeOut";
    private static final String TRUE_VALUE = "true";

    private static String createProcessId() {
        String processId = WrapUtils.createProcessIdDPS();
        if (processId == null) {
            processId = WrapUtils.createProcessIdIP();
        }
        return processId;
    }

    private static String createProcessIdDPS() {
        String[] dpsFields;
        String dpsId = DMSProperties.getProperty("oracle.dps.entityid");
        if (dpsId != null && dpsId.matches("\\w\\.\\d+\\.\\d+\\.\\d+") && (dpsFields = dpsId.split("\\.")).length == 4) {
            int[] dpsNums = new int[3];
            for (int count = 0; count < 3; ++count) {
                try {
                    dpsNums[count] = Integer.valueOf(dpsFields[count + 1]);
                    continue;
                }
                catch (Exception e) {
                    dpsNums[count] = -1;
                }
            }
            char[] format = new char[18];
            int index = 0;
            format[index] = dpsFields[0].charAt(0);
            long dpsLong = (long)dpsNums[0] << 32 & 0xFFFFFFFF00000000L | (long)dpsNums[1] & 0xFFFFFFFFL;
            ContextEncode.encodeLong64(dpsLong, format, ++index, 11);
            ContextEncode.encodeInt64(dpsNums[2], format, index += 11, 6);
            index += 6;
            return new String(format);
        }
        return null;
    }

    private static String createProcessIdIP() {
        byte[] ipBytes;
        String processId = null;
        int pid = 0;
        if (pid == 0) {
            long stamp = System.currentTimeMillis();
            pid = (int)((stamp /= 1000L) & 0xFFFFFFFFL);
        }
        try {
            ipBytes = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception e) {
            ipBytes = new byte[]{0, 0, 0, 0};
        }
        processId = ipBytes.length == 16 ? WrapUtils.createProcessIdIPv6(ipBytes, pid) : WrapUtils.createProcessIdIPv4(ipBytes, pid);
        return processId;
    }

    private static String createProcessIdIPv6(byte[] ipBytes, int pid) {
        int[] ipInts = new int[]{ipBytes[0] << 24 & 0xFF000000 | ipBytes[1] << 16 & 0xFF0000 | ipBytes[2] << 8 & 0xFF00 | ipBytes[3] & 0xFF, ipBytes[4] << 24 & 0xFF000000 | ipBytes[5] << 16 & 0xFF0000 | ipBytes[6] << 8 & 0xFF00 | ipBytes[7] & 0xFF, ipBytes[8] << 24 & 0xFF000000 | ipBytes[9] << 16 & 0xFF0000 | ipBytes[10] << 8 & 0xFF00 | ipBytes[11] & 0xFF, ipBytes[12] << 24 & 0xFF000000 | ipBytes[13] << 16 & 0xFF0000 | ipBytes[14] << 8 & 0xFF00 | ipBytes[15] & 0xFF};
        ipInts[1] = ~ipInts[1];
        int save0 = ipInts[0] & 0x1FFFFF;
        int save1 = ipInts[1] & 0x1FFFFF;
        int save2 = ipInts[2] & 0x1FFFFF;
        int save3 = ipInts[3] & 0x1FFFFF;
        ipInts[0] = ipInts[0] >>> 11;
        ipInts[1] = ipInts[1] >>> 11;
        ipInts[2] = ipInts[2] >>> 11;
        ipInts[3] = ipInts[3] >>> 11;
        ipInts[0] = ipInts[0] | save3 << 21;
        ipInts[1] = ipInts[1] | save0 << 21;
        ipInts[2] = ipInts[2] | save1 << 21;
        ipInts[3] = ipInts[3] | save2 << 21;
        save0 = ipInts[0];
        save1 = ipInts[1];
        save2 = ipInts[2];
        save3 = ipInts[3];
        ipInts[0] = WrapUtils.byteSwap(save2, 3, 3) | WrapUtils.byteSwap(save1, 3, 2) | WrapUtils.byteSwap(save1, 1, 1) | WrapUtils.byteSwap(save3, 2, 0);
        ipInts[1] = WrapUtils.byteSwap(save2, 2, 3) | WrapUtils.byteSwap(save0, 0, 2) | WrapUtils.byteSwap(save3, 3, 1) | WrapUtils.byteSwap(save1, 0, 0);
        ipInts[2] = WrapUtils.byteSwap(save2, 1, 3) | WrapUtils.byteSwap(save0, 3, 2) | WrapUtils.byteSwap(save3, 0, 1) | WrapUtils.byteSwap(save0, 1, 0);
        ipInts[3] = WrapUtils.byteSwap(save0, 2, 3) | WrapUtils.byteSwap(save2, 0, 2) | WrapUtils.byteSwap(save1, 2, 1) | WrapUtils.byteSwap(save3, 1, 0);
        ipInts[0] = WrapUtils.bitSwap(ipInts[0], 2);
        ipInts[1] = WrapUtils.bitSwap(ipInts[1], 26);
        ipInts[2] = WrapUtils.bitSwap(ipInts[2], 18);
        ipInts[3] = WrapUtils.bitSwap(ipInts[3], 10);
        long ipHigh = (long)ipInts[0] << 32 & 0xFFFFFFFF00000000L | (long)ipInts[1] & 0xFFFFFFFFL;
        long ipLow = (long)ipInts[2] << 32 & 0xFFFFFFFF00000000L | (long)ipInts[3] & 0xFFFFFFFFL;
        char[] format = new char[28];
        int index = 0;
        ContextEncode.encodeLong64(ipHigh, format, index, 11);
        ContextEncode.encodeLong64(ipLow, format, index += 11, 11);
        ContextEncode.encodeInt64(pid, format, index += 11, 6);
        return new String(format);
    }

    private static String createProcessIdIPv4(byte[] ipBytes, int pid) {
        int[] ipInts = new int[2];
        ipInts[1] = ipBytes[0] << 24 & 0xFF000000 | ipBytes[1] << 16 & 0xFF0000 | ipBytes[2] << 8 & 0xFF00 | ipBytes[3] & 0xFF;
        ipInts[0] = ~ipInts[1];
        int save0 = ipInts[0] & 0x7FFFFFF;
        int save1 = ipInts[1] & 0x7FFFFFF;
        ipInts[0] = ipInts[0] >>> 5;
        ipInts[1] = ipInts[1] >>> 5;
        ipInts[0] = ipInts[0] | save1 << 27;
        ipInts[1] = ipInts[1] | save0 << 27;
        save0 = ipInts[0];
        save1 = ipInts[1];
        ipInts[0] = WrapUtils.byteSwap(save0, 0, 3) | WrapUtils.byteSwap(save1, 0, 2) | WrapUtils.byteSwap(save1, 1, 1) | WrapUtils.byteSwap(save0, 2, 0);
        ipInts[1] = WrapUtils.byteSwap(save0, 1, 3) | WrapUtils.byteSwap(save1, 3, 2) | WrapUtils.byteSwap(save0, 3, 1) | WrapUtils.byteSwap(save1, 2, 0);
        ipInts[0] = WrapUtils.bitSwap(ipInts[0], 12);
        ipInts[1] = WrapUtils.bitSwap(ipInts[1], 22);
        long ipLong = (long)ipInts[0] << 32 & 0xFFFFFFFF00000000L | (long)ipInts[1] & 0xFFFFFFFFL;
        char[] format = new char[17];
        int index = 0;
        ContextEncode.encodeLong64(ipLong, format, index, 11);
        ContextEncode.encodeInt64(pid, format, index += 11, 6);
        return new String(format);
    }

    private static int byteShift(int target) {
        return target * 8;
    }

    private static int byteGet(int value, int target) {
        return value >>> WrapUtils.byteShift(target) & 0xFF;
    }

    private static int byteSwap(int value, int source, int target) {
        return WrapUtils.byteGet(value, source) << WrapUtils.byteShift(target);
    }

    private static int bitSwap(int value, int skip) {
        skip &= 0xFFFFFFFE;
        int swap = 0;
        for (int count = 0; count < 32; count += 2) {
            int bit1 = value & 1 << count;
            int bit2 = value & 2 << count;
            if (count != skip) {
                swap |= bit1 << 1 | bit2 >>> 1;
                continue;
            }
            swap |= bit1 | bit2;
        }
        return swap;
    }

    public static String createECID() {
        StringBuilder ecid = new StringBuilder(s_ecidSize);
        char[] format = new char[11];
        long stamp = System.currentTimeMillis();
        ContextEncode.encodeLong64(stamp, format, 0, 11);
        ecid.append(format);
        ecid.append(s_processId);
        stamp = sECIDCounter.incrementAndGet();
        ContextEncode.encodeLong64(stamp, format, 0, 6);
        ecid.append(format, 0, 6);
        return ecid.toString();
    }

    public static String generateNewWrappedContext() {
        if (!DMSContextManager.isEnabled()) {
            return "";
        }
        String ecid = WrapUtils.createECID();
        int[] levels = new int[]{0, 1};
        byte[] rid = WrapUtils.getWrapRid(levels);
        int size = rid.length + 1;
        byte[] raw = new byte[size];
        int index = WrapUtils.copyBytes(raw, 0, rid, 0);
        raw[index] = 59;
        String encode = ContextEncode.encodeBytes(raw);
        size = ecid.length() + encode.length() + 1;
        StringBuilder wrap = new StringBuilder(size);
        wrap.append('1').append('.');
        wrap.append(ecid);
        wrap.append(';');
        wrap.append(encode);
        return wrap.toString();
    }

    public static String wrap(DomainExecutionContext dctx, WrapOptions wrapOptions) {
        String ecid = dctx.getECID();
        RID rid = dctx.generateKidRID();
        String retVal = null;
        if (wrapOptions == WrapOptions.LIMIT_WRAP_OPTIONS) {
            retVal = WrapUtils.wrap(ecid, rid, dctx.getPropagateMap(), dctx.getParameterNames(DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP), dctx.getParameterNames(DomainContextManager.ParameterAttribute.LOGGABLE), dctx.getParameterNames(DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP), null, null, 16384);
        } else if (wrapOptions == WrapOptions.DEFAULT_WRAP_OPTIONS) {
            retVal = WrapUtils.wrap(ecid, rid, dctx.getPropagateMap(), dctx.getParameterNames(DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP), dctx.getParameterNames(DomainContextManager.ParameterAttribute.LOGGABLE), dctx.getParameterNames(DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP), dctx.isUpdateSqlText(), dctx.getLogLevel(), 16384);
        } else if (wrapOptions.getUpperBound() != null) {
            retVal = WrapUtils.wrap(ecid, rid, dctx.getPropagateMap(), wrapOptions.getPropagateKeys() != null ? wrapOptions.getPropagateKeys() : dctx.getParameterNames(DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP), dctx.getParameterNames(DomainContextManager.ParameterAttribute.LOGGABLE), dctx.getParameterNames(DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP), dctx.isUpdateSqlText(), dctx.getLogLevel(), wrapOptions.getUpperBound());
        }
        return retVal;
    }

    public static String wrap(ExecutionContextComponents components) {
        String retVal = WrapUtils.wrap(components.getECID(), components.getRIDasString() == null ? null : RID.createRID(components.getRIDasString(), false), components.getGlobalMap(), components.getKeys(2), components.getKeys(1), components.getKeys(3), false, components.getLogLevel(), 16384);
        return retVal;
    }

    public static String wrap(String ecid, RID rid, Map<String, String> valueMap, Collection<String> propagateKeys, Collection<String> logKeys, Collection<String> limitKeys, Boolean isUpdateSqlText, Level logLevel, int maxChars) {
        int[] levels;
        int size = 0;
        int index = 0;
        int maxCharsRemaining = maxChars - ecid.length() - 1;
        if (maxCharsRemaining < 2) {
            throw new IllegalArgumentException("Can not generate wrap string of max length " + maxChars + " with an ecid that is of length " + ecid.length());
        }
        byte[] ridBytes = null;
        if (rid != null && ContextEncode.byteCountToCharCount(1 + (ridBytes = WrapUtils.getWrapRid(levels = rid.toArray())).length) > maxCharsRemaining) {
            ridBytes = null;
        }
        size = 1 + (ridBytes == null ? 0 : ridBytes.length);
        int maxBytesRemaining = ContextEncode.charCountToByteCount(maxCharsRemaining) - size;
        LinkedList<ParameterStore> list = new LinkedList<ParameterStore>();
        byte[] raw = new byte[size += WrapUtils.parameterGetList(valueMap, propagateKeys, logKeys, limitKeys, isUpdateSqlText, logLevel, list, maxBytesRemaining)];
        if (ridBytes != null) {
            index = WrapUtils.copyBytes(raw, 0, ridBytes, 0);
        }
        raw[index] = 59;
        WrapUtils.parameterFormatList(list, raw, ++index);
        String encode = ContextEncode.encodeBytes(raw);
        size = ecid.length() + encode.length() + 1;
        StringBuilder wrap = new StringBuilder(size);
        wrap.append('1').append('.');
        wrap.append(ecid);
        wrap.append(';');
        wrap.append(encode);
        String retVal = wrap.toString();
        sLogger.log(Level.FINE, "Generated wrap string: {0}", retVal);
        return retVal;
    }

    private static int parameterGetList(Map<String, String> valueMap, Collection<String> propagateKeys, Collection<String> logKeys, Collection<String> limitKeys, Boolean isUpdateSqlText, Level logLevel, LinkedList<ParameterStore> list, int maxSize) {
        int size = 0;
        if (propagateKeys != null) {
            for (String key : propagateKeys) {
                byte[] valueRaw;
                byte[] keyRaw;
                block16: {
                    String value = valueMap.get(key);
                    if (value == null) continue;
                    try {
                        keyRaw = key.getBytes(ContextStringEncode);
                        valueRaw = value.getBytes(ContextStringEncode);
                        if (keyRaw.length > 4095) {
                            sLogger.log(Level.FINE, "Skipping key+value from valueMap because key contains too many bytes: key-size(in bytes)={0}, key={1}", new Object[]{keyRaw.length, key});
                            continue;
                        }
                        if (valueRaw.length <= 4095) break block16;
                        sLogger.log(Level.FINE, "Truncating value from valueMap because it is too long: value-size(in bytes)={0}, key={1}, value={2}", new Object[]{valueRaw.length, key, value});
                        valueRaw = WrapUtils.truncateString(value, 4095);
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                int pendingSize = size;
                pendingSize += 3 + keyRaw.length;
                if (keyRaw.length > 63) {
                    ++pendingSize;
                }
                pendingSize += valueRaw.length;
                if (valueRaw.length > 63) {
                    ++pendingSize;
                }
                if (pendingSize >= maxSize) break;
                boolean toLog = logKeys != null && logKeys.contains(key);
                boolean toLimit = limitKeys != null && (limitKeys == propagateKeys || limitKeys.contains(key));
                sLogger.log(Level.FINEST, "Wrapped key {0}", key);
                ParameterStore store = new ParameterStore(keyRaw, valueRaw, toLog, toLimit);
                list.addLast(store);
                size = pendingSize;
            }
        }
        if (isUpdateSqlText != null && isUpdateSqlText.booleanValue()) {
            try {
                byte[] keyRaw = SQL_KEY.getBytes(ContextStringEncode);
                byte[] valueRaw = TRUE_VALUE.getBytes(ContextStringEncode);
                int pendingSize = size + 3 + keyRaw.length + valueRaw.length;
                if (pendingSize < maxSize) {
                    size = pendingSize;
                    ParameterStore store = new ParameterStore(keyRaw, valueRaw, false, false);
                    list.addLast(store);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (logLevel != null) {
            String value = logLevel.toString();
            try {
                byte[] keyRaw = LOG_KEY.getBytes(ContextStringEncode);
                byte[] valueRaw = value.getBytes(ContextStringEncode);
                int pendingSize = size + 3 + keyRaw.length + valueRaw.length;
                if (valueRaw.length > 63) {
                    ++pendingSize;
                }
                if (pendingSize < maxSize) {
                    size = pendingSize;
                    ParameterStore store = new ParameterStore(keyRaw, valueRaw, false, false);
                    list.addLast(store);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return size;
    }

    private static void parameterFormatList(LinkedList<ParameterStore> list, byte[] raw, int index) {
        for (int size = list.size(); size != 0; --size) {
            ParameterStore store = list.removeFirst();
            index = WrapUtils.parameterFormat(raw, index, store);
        }
    }

    private static int parameterFormat(byte[] raw, int index, ParameterStore store) {
        int delim = -128;
        if (store.paramLog) {
            delim = (byte)(delim | 1);
        }
        if (store.paramLimit) {
            delim = (byte)(delim | 2);
        }
        int offset = index + 1;
        int length = 1;
        if (store.paramKey.length > 63) {
            delim = (byte)(delim | 4);
            ++length;
        }
        ContextEncode.encodeInt64Byte(store.paramKey.length, raw, offset, length);
        offset += length;
        offset = WrapUtils.copyBytes(raw, offset, store.paramKey, 0);
        length = 1;
        if (store.paramValue.length > 63) {
            delim = (byte)(delim | 8);
            ++length;
        }
        ContextEncode.encodeInt64Byte(store.paramValue.length, raw, offset, length);
        offset += length;
        offset = WrapUtils.copyBytes(raw, offset, store.paramValue, 0);
        raw[index] = delim;
        return offset;
    }

    private static char getUnwrapVersion(String wrappedString) {
        int unwrapVersion = 0;
        if (wrappedString != null && wrappedString.length() >= 2 && wrappedString.charAt(0) == '1' && wrappedString.charAt(1) == '.') {
            unwrapVersion = 49;
        }
        return (char)unwrapVersion;
    }

    public static String getChildWrappedContext(String wrapped) {
        int oldIndex;
        if (!DMSContextManager.isEnabled()) {
            return "";
        }
        if ('1' == WrapUtils.getUnwrapVersion(wrapped) && (oldIndex = (wrapped = wrapped.substring(2)).indexOf(59)) > 0) {
            String ecid = wrapped.substring(0, oldIndex);
            String encoded64 = wrapped.substring(oldIndex + 1, wrapped.length());
            byte[] oldRaw = ContextEncode.decodeBytes(encoded64);
            for (oldIndex = 0; oldIndex < oldRaw.length && oldRaw[oldIndex] != 59; ++oldIndex) {
            }
            if (oldIndex < oldRaw.length) {
                String wRid = WrapUtils.getUnwrapRID(oldRaw, oldIndex);
                RID newRid = RID.createRID(wRid, true);
                int[] levels = newRid.toArray();
                byte[] rid = WrapUtils.getWrapRid(levels);
                int paramDataLen = oldRaw.length - ++oldIndex;
                int size = rid.length + 1 + paramDataLen;
                byte[] newRaw = new byte[size];
                int index = WrapUtils.copyBytes(newRaw, 0, rid, 0);
                newRaw[index] = 59;
                ++index;
                if (paramDataLen != 0) {
                    index = WrapUtils.copyBytes(newRaw, index, oldRaw, oldIndex);
                }
                String reEncoded64 = ContextEncode.encodeBytes(newRaw);
                size = ecid.length() + 1 + reEncoded64.length();
                StringBuilder wrap = new StringBuilder(size);
                wrap.append('1').append('.');
                wrap.append(ecid);
                wrap.append(';');
                wrap.append(reEncoded64);
                return wrap.toString();
            }
        }
        return WrapUtils.generateNewWrappedContext();
    }

    public static UnwrapResult unwrap(DomainContextManager dmgr, String originalWrap, boolean useChildRID, boolean createContext, boolean activateContext, boolean useRIDWithoutLineageIfActualRIDInUse, Level levelToLogProblems) {
        UnwrapResult retVal;
        block18: {
            String METHOD_NAME = "UnwrapResult";
            retVal = new UnwrapResult();
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.log(Level.FINE, originalWrap == null ? "Preparing to unwrap context from a null wrap string: " : "Preparing to unwrap context from wrap string: " + originalWrap);
            }
            String wRid = null;
            DomainContextFamily dctf = null;
            DomainExecutionContext dctx = null;
            String wrap = originalWrap;
            if (!DMSContextManager.isEnabled()) {
                retVal.mUnwrapSuccess = true;
                retVal.mDomainExecutionContext = DomainExecutionContextStub.getTheStub(ExecutionContextStub.StubType.DISABLED);
                retVal.mDomainContextFamily = DomainContextFamilyStub.getTheStub();
                return retVal;
            }
            try {
                RID rid;
                WrapStringDecoderImpl decoder = new WrapStringDecoderImpl(wrap);
                String ecid = decoder.getECID();
                wRid = decoder.getRIDasString();
                if (wRid != null) {
                    rid = RID.createRID(wRid, useChildRID);
                    if (rid == null) {
                        throw new IllegalArgumentException("Invalid RID found in wrapped context string: " + wRid);
                    }
                } else {
                    rid = RID.createRIDWithUnknownLineage();
                }
                boolean newFamily = false;
                dctf = (DomainContextFamily)dmgr.findFamily(ecid);
                if (dctf == null) {
                    newFamily = true;
                    if (createContext) {
                        dctx = (DomainExecutionContext)dmgr.newFamily(ecid, rid);
                        dctf = dctx.getContextFamily();
                    } else {
                        dctf = (DomainContextFamily)dmgr.newFamily(ecid);
                    }
                } else if (createContext) {
                    if (useRIDWithoutLineageIfActualRIDInUse) {
                        dctx = (DomainExecutionContext)dmgr.createContextForUnwrap(dctf, rid);
                        try {
                            dctf.addContext(dctx);
                        }
                        catch (IllegalArgumentException iae) {
                            if (levelToLogProblems != null && sLogger.isLoggable(levelToLogProblems)) {
                                sLogger.logp(levelToLogProblems, CLASS_NAME, "UnwrapResult", "IllegalArgumentException from addContext, will attempt to use a RID with unknown lineage.", iae);
                            }
                            rid = RID.createRIDWithUnknownLineage();
                            dctx = dmgr.createContextForUnwrap(dctf, rid);
                        }
                    } else {
                        dctx = (DomainExecutionContext)dmgr.createContextForUnwrap(dctf, rid);
                    }
                }
                retVal.mDomainContextFamily = dctf;
                retVal.mDomainExecutionContext = dctx;
                decoder.applyParameters(dctf, dctx, newFamily);
                if (dctx != null && activateContext) {
                    dctx.activate();
                }
                retVal.mUnwrapSuccess = true;
            }
            catch (Exception e) {
                retVal.mUnwrapSuccess = false;
                retVal.mException = e;
                if (levelToLogProblems == null) break block18;
                LogRecord lr = new LogRecord(levelToLogProblems, "DMS-57032");
                lr.setResourceBundle(sLogger.getResourceBundle());
                lr.setParameters(new Object[]{originalWrap});
                lr.setThrown(e);
                sLogger.log(lr);
            }
        }
        return retVal;
    }

    private static String getUnwrapRID(byte[] raw, int end) {
        String retVal = null;
        int depth = 0;
        int index = 0;
        for (index = 0; index < end; ++index) {
            if ((byte)(raw[index] & 0xFFFFFF80) != -128) continue;
            ++depth;
        }
        if (depth > 0) {
            StringBuilder rid = new StringBuilder(depth * 11);
            int start = 0;
            for (index = 0; index < end; ++index) {
                if ((byte)(raw[index] & 0xFFFFFF80) != -128) continue;
                int n = index;
                raw[n] = (byte)(raw[n] & 0x7F);
                int length = index - start + 1;
                depth = ContextEncode.decodeInt64(raw, start, length);
                if (start != 0) {
                    rid.append(':');
                }
                if (depth >= 100000000) {
                    rid.append("0x");
                    rid.append(Integer.toHexString(depth));
                } else {
                    rid.append(Integer.toString(depth));
                }
                start = index + 1;
            }
            retVal = rid.toString();
        }
        return retVal;
    }

    private static byte[] getWrapRid(int[] levels) {
        int size = levels.length * 6;
        char[] rid = new char[size];
        int index = 0;
        for (int depth = 0; depth < levels.length; ++depth) {
            int length = ContextEncode.encodeInt64var(levels[depth], rid, index);
            int n = (index += length) - 1;
            rid[n] = (char)(rid[n] | 0xFF80);
        }
        size = index;
        byte[] raw = new byte[size];
        for (index = 0; index < size; ++index) {
            raw[index] = (byte)rid[index];
        }
        return raw;
    }

    private static int copyBytes(byte[] dest, int dIndex, byte[] source, int sIndex) {
        while (sIndex < source.length) {
            dest[dIndex] = source[sIndex];
            ++dIndex;
            ++sIndex;
        }
        return dIndex;
    }

    public static String replaceECIDInWrapString(String original, String newECID) {
        String retVal = original;
        int verSep = original.indexOf(46);
        int dataSep = original.indexOf(59);
        if ('1' == WrapUtils.getUnwrapVersion(original) && verSep > 0 & dataSep > 0) {
            retVal = original.substring(0, verSep + 1) + newECID + original.substring(dataSep);
        }
        return retVal;
    }

    private static byte[] truncateString(String string, int maxBytes) {
        byte[] retVal = null;
        byte[] tmpByteArray = new byte[maxBytes];
        ByteBuffer byteBuffer = ByteBuffer.wrap(tmpByteArray);
        CharBuffer charBuffer = CharBuffer.wrap(string.toCharArray());
        Charset charset = Charset.forName(ContextStringEncode);
        CharsetEncoder encoder = charset.newEncoder();
        encoder.encode(charBuffer, byteBuffer, true);
        if (byteBuffer.position() == maxBytes) {
            retVal = tmpByteArray;
        } else {
            retVal = new byte[byteBuffer.position()];
            System.arraycopy(tmpByteArray, 0, retVal, 0, retVal.length);
        }
        return retVal;
    }

    static {
        s_processId = null;
        s_processId = WrapUtils.createProcessId();
        s_ecidSize = s_processId.length() + 11 + 6;
        CLASS_NAME = WrapUtils.class.getName();
    }

    public static class Direct {
        private static final int SCANNING_RID = 1;
        private static final int SCANNING_PARAM_METADATA = 2;
        private static final int SCANNING_PARAM_NAME_SIZE = 3;
        private static final int SCANNING_PARAM_NAME = 4;
        private static final int SCANNING_PARAM_VALUE_SIZE = 6;
        private static final int SCANNING_PARAM_VALUE = 7;
        private static final byte bitMask_e0_b0 = 63;
        private static final byte bitMask_e1_b0 = 48;
        private static final byte bitMask_e1_b1 = 15;
        private static final byte bitMask_e2_b1 = 60;
        private static final byte bitMask_e2_b2 = 3;
        private static final byte bitMask_e3_b2 = 63;
        private static final int BYTE_ARRAY_SIZE = 512;

        public static String getParameterValueFromWrapString(String wrapString, byte[] requiredParameterName) {
            String retVal = null;
            if (requiredParameterName == null) {
                return null;
            }
            if (wrapString == null) {
                return null;
            }
            if (wrapString.length() < 5) {
                return null;
            }
            if (wrapString.charAt(0) != '1' || wrapString.charAt(1) != '.') {
                return null;
            }
            int base64SepLoc = wrapString.indexOf(59);
            if (base64SepLoc < 0 || base64SepLoc == wrapString.length() - 1) {
                return null;
            }
            String encodedString = wrapString.substring(base64SepLoc + 1);
            int encodedStringLength = encodedString.length();
            int paramNameSizeSize = 0;
            int paramNameSize = 0;
            int paramValueSizeSize = 0;
            int paramValueSize = 0;
            int collectedByteCount = 0;
            byte[] collectedBytes = new byte[512];
            boolean insufficientSpaceInCollectedBytes = false;
            boolean paramNameMatch = false;
            int rawByteIndex = 0;
            byte rawByte = 0;
            int firstCharForByteIndex = 0;
            int functionIndex = 0;
            int state = 1;
            boolean useCachedValues = false;
            byte encodedByte0 = 0;
            byte encodedByte1 = 0;
            do {
                if (!useCachedValues) {
                    useCachedValues = true;
                    char char0 = encodedString.charAt(firstCharForByteIndex);
                    char char1 = encodedString.charAt(firstCharForByteIndex + 1);
                    encodedByte0 = ContextEncode.byteDecode(char0);
                    encodedByte1 = ContextEncode.byteDecode(char1);
                } else {
                    char charNext = encodedString.charAt(firstCharForByteIndex + 1);
                    encodedByte0 = encodedByte1;
                    encodedByte1 = ContextEncode.byteDecode(charNext);
                }
                if (functionIndex == 0) {
                    rawByte = (byte)((encodedByte0 & 0x3F) << 0 | (encodedByte1 & 0x30) << 2);
                } else if (functionIndex == 1) {
                    rawByte = (byte)((encodedByte0 & 0xF) << 0 | (encodedByte1 & 0x3C) << 2);
                } else if (functionIndex == 2) {
                    rawByte = (byte)((encodedByte0 & 3) << 0 | (encodedByte1 & 0x3F) << 2);
                }
                if (state == 1) {
                    if (rawByte == 59) {
                        state = 2;
                    }
                } else if (state == 2) {
                    if ((rawByte & 0xFFFFFF80) == -128) {
                        state = 3;
                        collectedByteCount = 0;
                        paramNameSizeSize = 1;
                        paramValueSizeSize = 1;
                        if ((rawByte & 4) == 4) {
                            paramNameSizeSize = 2;
                        }
                        if ((rawByte & 8) == 8) {
                            paramValueSizeSize = 2;
                        }
                    }
                } else if (state == 3) {
                    if (collectedByteCount < paramNameSizeSize) {
                        collectedBytes[++collectedByteCount - 1] = rawByte;
                        if (collectedByteCount == paramNameSizeSize) {
                            paramNameSize = ContextEncode.decodeInt64(collectedBytes, 0, paramNameSizeSize);
                            collectedByteCount = 0;
                            state = 4;
                            paramNameMatch = true;
                            insufficientSpaceInCollectedBytes = false;
                        }
                    }
                } else if (state == 4) {
                    if (collectedByteCount < paramNameSize) {
                        if (++collectedByteCount > 512) {
                            insufficientSpaceInCollectedBytes = true;
                        } else {
                            collectedBytes[collectedByteCount - 1] = rawByte;
                        }
                        if (paramNameMatch && (insufficientSpaceInCollectedBytes || requiredParameterName.length < collectedByteCount || rawByte != requiredParameterName[collectedByteCount - 1])) {
                            paramNameMatch = false;
                        }
                        if (collectedByteCount == paramNameSize) {
                            if (requiredParameterName.length != collectedByteCount) {
                                paramNameMatch = false;
                            }
                            collectedByteCount = 0;
                            state = 6;
                        }
                    }
                } else if (state == 6) {
                    if (collectedByteCount < paramValueSizeSize) {
                        collectedBytes[++collectedByteCount - 1] = rawByte;
                        if (collectedByteCount == paramValueSizeSize) {
                            paramValueSize = ContextEncode.decodeInt64(collectedBytes, 0, paramNameSizeSize);
                            collectedByteCount = 0;
                            state = 7;
                            insufficientSpaceInCollectedBytes = false;
                        }
                    }
                } else if (state == 7 && collectedByteCount < paramValueSize) {
                    if (++collectedByteCount > 512) {
                        insufficientSpaceInCollectedBytes = true;
                    } else {
                        collectedBytes[collectedByteCount - 1] = rawByte;
                    }
                    if (collectedByteCount == paramValueSize) {
                        if (paramNameMatch) {
                            if (insufficientSpaceInCollectedBytes) break;
                            try {
                                retVal = new String(collectedBytes, 0, collectedByteCount, WrapUtils.ContextStringEncode);
                                break;
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        state = 2;
                        collectedByteCount = 0;
                    }
                }
                functionIndex = ++rawByteIndex % 3;
                ++firstCharForByteIndex;
                if (rawByteIndex % 3 != 0) continue;
                ++firstCharForByteIndex;
                useCachedValues = false;
            } while (firstCharForByteIndex + 1 < encodedStringLength);
            return retVal;
        }
    }

    private static class AugmentedKey {
        String mKeyName;
        boolean mIsLoggable;
        boolean mIsLimit;

        AugmentedKey(String keyName, boolean isLoggable, boolean isLimit) {
            this.mKeyName = keyName;
            this.mIsLoggable = isLoggable;
            this.mIsLimit = isLimit;
        }
    }

    public static class WrapStringDecoderImpl
    implements WrappedContextDecoder,
    ExecutionContextComponents {
        private String mWrappedStringV1;
        private int mWrappedStringV1Pos;
        private byte[] mRawBytes;
        private int mRawBytesPos;
        private String mECID;
        private String mRIDAsString;
        private Level mLogLevel;
        private Map<AugmentedKey, String> mValueMap;
        private Boolean mUpdateSqlText;
        private int mState = 0;
        private static int DONE_ECID = 1;
        private static int DONE_RID = 2;
        private static int DONE_PARAMS = 3;

        public WrapStringDecoderImpl(String wrappedString) {
            char unwrapVersion = WrapUtils.getUnwrapVersion(wrappedString);
            if (unwrapVersion == '\u0000') {
                throw new IllegalArgumentException("No valid version information found in wrap string.");
            }
            if ('1' != unwrapVersion) {
                throw new IllegalArgumentException("Unsupported version of wrap string.");
            }
            this.mWrappedStringV1 = wrappedString.substring(2);
            this.mWrappedStringV1Pos = 0;
        }

        @Override
        public ExecutionContextComponents getExecutionContextComponents() {
            return this;
        }

        @Override
        public String getECID() {
            if (this.mState >= DONE_ECID) {
                return this.mECID;
            }
            int index = this.mWrappedStringV1.indexOf(59);
            if (index <= 0) {
                throw new IllegalArgumentException("Wrap string format invalid - no delineation between ECID and encoded values.");
            }
            this.mECID = this.mWrappedStringV1.substring(0, index);
            this.mWrappedStringV1Pos = index + 1;
            this.mState = DONE_ECID;
            return this.mECID;
        }

        @Override
        public String getRIDasString() {
            if (this.mState >= DONE_RID) {
                return this.mRIDAsString;
            }
            this.getECID();
            String base64EncodedData = this.mWrappedStringV1.substring(this.mWrappedStringV1Pos, this.mWrappedStringV1.length());
            this.mRawBytes = ContextEncode.decodeBytes(base64EncodedData);
            this.mRawBytesPos = 0;
            while (this.mRawBytesPos < this.mRawBytes.length && this.mRawBytes[this.mRawBytesPos] != 59) {
                ++this.mRawBytesPos;
            }
            if (this.mRawBytesPos >= this.mRawBytes.length) {
                throw new IllegalArgumentException("Wrap string format invalid - no end-of-RID marker found in encoded values.");
            }
            this.mRIDAsString = WrapUtils.getUnwrapRID(this.mRawBytes, this.mRawBytesPos);
            this.mState = DONE_RID;
            return this.mRIDAsString;
        }

        void applyParameters(DomainContextFamily dctf, DomainExecutionContext dctx, boolean newFamily) {
            if (this.mState >= DONE_PARAMS) {
                if (dctx != null && this.mUpdateSqlText != null) {
                    dctx.setUpdateSqlText(this.mUpdateSqlText);
                }
                if (dctf != null) {
                    if (this.mLogLevel != null) {
                        dctf.setLogLevel(this.mLogLevel);
                    }
                    for (Map.Entry<AugmentedKey, String> entry : this.mValueMap.entrySet()) {
                        dctx.setGlobalValue(entry.getKey().mKeyName, entry.getValue());
                        dctf.setParameterAttribute(entry.getKey().mKeyName, DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
                        dctf.setParameterAttribute(entry.getKey().mKeyName, DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
                        if (entry.getKey().mIsLimit) {
                            dctf.setParameterAttribute(entry.getKey().mKeyName, DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP);
                        }
                        if (!entry.getKey().mIsLoggable) continue;
                        dctf.setParameterAttribute(entry.getKey().mKeyName, DomainContextManager.ParameterAttribute.LOGGABLE);
                    }
                }
            } else {
                this.extractParameters(false, dctf, dctx);
            }
        }

        @Override
        public Map<String, String> getGlobalMap() {
            this.extractParameters(true, null, null);
            HashMap<String, String> retVal = null;
            if (this.mValueMap.size() > 0) {
                retVal = new HashMap<String, String>();
                for (Map.Entry<AugmentedKey, String> entry : this.mValueMap.entrySet()) {
                    retVal.put(entry.getKey().mKeyName, entry.getValue());
                }
            }
            return retVal;
        }

        @Override
        public Map<String, String> getLocalMap() {
            return null;
        }

        @Override
        public Set<String> getKeys(int keyType) {
            HashSet<String> retVal;
            block7: {
                block8: {
                    block6: {
                        this.extractParameters(true, null, null);
                        retVal = null;
                        if (keyType != 2) break block6;
                        for (Map.Entry<AugmentedKey, String> entry : this.mValueMap.entrySet()) {
                            if (retVal == null) {
                                retVal = new HashSet<String>();
                            }
                            retVal.add(entry.getKey().mKeyName);
                        }
                        break block7;
                    }
                    if (keyType != 1) break block8;
                    for (Map.Entry<AugmentedKey, String> entry : this.mValueMap.entrySet()) {
                        if (!entry.getKey().mIsLoggable) continue;
                        if (retVal == null) {
                            retVal = new HashSet();
                        }
                        retVal.add(entry.getKey().mKeyName);
                    }
                    break block7;
                }
                if (keyType != 3) break block7;
                for (Map.Entry<AugmentedKey, String> entry : this.mValueMap.entrySet()) {
                    if (!entry.getKey().mIsLimit) continue;
                    if (retVal == null) {
                        retVal = new HashSet();
                    }
                    retVal.add(entry.getKey().mKeyName);
                }
            }
            return retVal;
        }

        @Override
        public Level getLogLevel() {
            this.extractParameters(true, null, null);
            return this.mLogLevel;
        }

        private void extractParameters(boolean storeParams, DomainContextFamily dctf, DomainExecutionContext dctx) {
            if (this.mState >= DONE_PARAMS) {
                return;
            }
            this.getRIDasString();
            if (storeParams) {
                this.mValueMap = new HashMap<AugmentedKey, String>();
                this.mLogLevel = null;
                this.mUpdateSqlText = null;
            }
            ++this.mRawBytesPos;
            if (this.mRawBytesPos < this.mRawBytes.length) {
                int index = this.mRawBytesPos;
                int remain = this.mRawBytes.length - index;
                while (remain >= 5 && (byte)(this.mRawBytes[index] & 0xFFFFFF80) == -128) {
                    String value;
                    String key;
                    int length;
                    byte delim = this.mRawBytes[index];
                    ++index;
                    boolean log = (byte)(delim & 1) == 1;
                    boolean limit = (byte)(delim & 2) == 2;
                    int size = 1;
                    if ((byte)(delim & 4) == 4) {
                        ++size;
                    }
                    if ((remain -= 1 + size + (length = ContextEncode.decodeInt64(this.mRawBytes, index, size))) <= 1) break;
                    index += size;
                    try {
                        key = new String(this.mRawBytes, index, length, WrapUtils.ContextStringEncode);
                    }
                    catch (Exception e) {
                        break;
                    }
                    index += length;
                    size = 1;
                    if ((byte)(delim & 8) == 8) {
                        ++size;
                    }
                    if ((remain -= size + (length = ContextEncode.decodeInt64(this.mRawBytes, index, size))) < 0) break;
                    index += size;
                    try {
                        value = new String(this.mRawBytes, index, length, WrapUtils.ContextStringEncode);
                    }
                    catch (Exception e) {
                        break;
                    }
                    index += length;
                    if (storeParams) {
                        if (key.equals(WrapUtils.LOG_KEY)) {
                            this.mLogLevel = Level.parse(value);
                        } else if (key.equals(WrapUtils.SQL_KEY)) {
                            this.mUpdateSqlText = true;
                        } else {
                            AugmentedKey augmentedKey = new AugmentedKey(key, log, limit);
                            this.mValueMap.put(augmentedKey, value);
                        }
                    }
                    if (dctf == null && dctx == null) continue;
                    if (key.equals(WrapUtils.LOG_KEY)) {
                        if (dctf == null) continue;
                        dctf.setLogLevel(Level.parse(value));
                        continue;
                    }
                    if (key.equals(WrapUtils.SQL_KEY)) {
                        if (dctx == null) continue;
                        dctx.setUpdateSqlText(true);
                        continue;
                    }
                    if (dctf == null) continue;
                    dctx.setGlobalValue(key, value);
                    dctf.setParameterAttribute(key, DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
                    dctf.setParameterAttribute(key, DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
                    if (limit) {
                        dctf.setParameterAttribute(key, DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP);
                    }
                    if (!log) continue;
                    dctf.setParameterAttribute(key, DomainContextManager.ParameterAttribute.LOGGABLE);
                }
                if (storeParams) {
                    this.mRawBytesPos = index;
                }
            }
            if (storeParams) {
                this.mState = DONE_PARAMS;
            }
        }

        public Boolean getUpdateSqlText() {
            return this.mUpdateSqlText;
        }
    }

    private static class ParameterStore {
        byte[] paramKey;
        byte[] paramValue;
        boolean paramLog;
        boolean paramLimit;

        ParameterStore(byte[] key, byte[] value, boolean log, boolean limit) {
            this.paramKey = key;
            this.paramValue = value;
            this.paramLog = log;
            this.paramLimit = limit;
        }
    }

    public static class UnwrapResult {
        private DomainExecutionContext mDomainExecutionContext = null;
        private DomainContextFamily mDomainContextFamily = null;
        private boolean mUnwrapSuccess = false;
        private Exception mException = null;

        public boolean getUnwrapSuccess() {
            return this.mUnwrapSuccess;
        }

        public DomainContextFamily getUnwrappedDomainContextFamily() {
            return this.mDomainContextFamily;
        }

        public DomainExecutionContext getUnwrappedDomainExecutionContext() {
            return this.mDomainExecutionContext;
        }

        public Exception getException() {
            return this.mException;
        }
    }
}

