/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.util.List;
import java.util.Map;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.incident.ErrorMessage;

public interface Incident {
    public static final String NON_ADR_INCIDENT_ID = "-1";
    public static final String NON_ADR_FLOOD_CONTROLLED_INCIDENT_ID = "-2";
    public static final String NON_ADR_SPACE_CONTROLLED_INCIDENT_ID = "-3";
    public static final String NON_ADR_PROBLEM_KEY_FILTERED_INCIDENT_ID = "-4";

    public String getIncidentId();

    public long getTimeOfIncident();

    public List<DiagnosticsCategory> getProblemImpacts();

    public String getExecutionContextId();

    public IncidentSource getIncidentSource();

    public ErrorMessage getErrorMessage();

    public String getDescription();

    public String getProblemId();

    public String getProblemKey();

    public boolean isFloodControlled();

    public String getFloodControlledLastIncidentId();

    public List<String> getIncidentFiles();

    public String getADRBase();

    public String getProductType();

    public String getProductId();

    public String getInstanceId();

    public String getIncidentDirectory();

    public Map<String, String> getContextValues();

    public static enum IncidentSource {
        SYSTEM,
        MANUAL;

        private static final long serialVersionUID = 0L;

        public static IncidentSource getIncidentSource(String source) {
            try {
                return IncidentSource.valueOf(source.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

