/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportBasic;
import oracle.dms.util.PlatformSupportNotJRF;

public class PlatformSupportFactory {
    private static final Logger sLogger = Logger.getLogger("oracle.dms.util", "oracle.dms.util.dms");
    private static volatile PlatformSupport sInjectedPlatformSupport = null;

    @Deprecated
    public static synchronized void injectPlatformSupport(PlatformSupport platformSupport) {
        sInjectedPlatformSupport = platformSupport;
    }

    public static PlatformSupport getPlatformSupport() {
        String weblogicName;
        PlatformSupport retVal = sInjectedPlatformSupport;
        if (retVal == null) {
            try {
                Class<?> jrfClass = Class.forName("oracle.jrf.ServerPlatformSupport");
                Class<?> jrfPlatformSupportClass = Class.forName("oracle.dms.util.PlatformSupportForJRF");
                retVal = (PlatformSupport)jrfPlatformSupportClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (PlatformSupportException pse) {
                sLogger.log(Level.FINE, "Could not create instance of PlatformSupportForJRF", pse);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
        if (retVal == null && (weblogicName = DMSProperties.getProperty("weblogic.Name")) != null) {
            String possibleDomainHome = PlatformSupportFactory.getenv("DOMAIN_HOME");
            if (possibleDomainHome == null) {
                possibleDomainHome = DMSProperties.getProperty("domain.home");
            }
            if (possibleDomainHome != null && possibleDomainHome.length() > 0) {
                sLogger.log(Level.FINE, "Environment makes reference to a domain-home location, so assuming environment is WLS standalone without JRF in place.");
                retVal = new PlatformSupportNotJRF(Platform.WebLogicAS);
            }
        }
        if (retVal == null) {
            sLogger.log(Level.FINE, "Nothing in classpath or in environment to suggest that DMS should treat the platform any different from a JSE environment.");
            retVal = new PlatformSupportBasic();
        }
        return retVal;
    }

    static String getenv(final String key) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
        return value;
    }

    public static class PlatformSupportException
    extends RuntimeException {
        public PlatformSupportException(Exception e) {
            super(e);
        }

        public PlatformSupportException(String message) {
            super(message);
        }
    }
}

