/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.ParameterValueListener;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.Filter;
import oracle.dms.event.NullFilterWithEventTypeProxy;
import oracle.dms.jmx.ContextParameterDescriptor;
import oracle.dms.jmx.ContextParameterRuntimeMXBean;
import oracle.dms.util.Time;
import oracle.dms.util.Validatable;

public class ContextParameterRuntimeMXBeanImpl
implements ContextParameterRuntimeMXBean {
    private Map<String, ParameterValueSampleData> mSampledValues = new ConcurrentHashMap<String, ParameterValueSampleData>();
    private ParameterValueListener mParameterValueListener = null;
    private Destination mDestination;
    private Filter mFilter;
    private static final int DEFAULT_MAX_NUM_OF_VALUES = 10;

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<ContextParameterDescriptor> getContextParameterDescriptors(String[] parameterNames) {
        HashSet<ContextParameterDescriptor> retVal;
        block5: {
            retVal = new HashSet<ContextParameterDescriptor>();
            DomainContextManager dcm = DMSContextManager.getDomainContextManager();
            if (dcm == null) break block5;
            if (parameterNames != null && parameterNames.length > 0) {
                void var6_9;
                String[] arr$ = parameterNames;
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_9 < len$) {
                    String parameterName = arr$[var6_9];
                    ContextParameterDescriptorInternal rcpd = dcm.findContextParameterDescriptor(parameterName);
                    if (rcpd != null) {
                        ContextParameterDescriptor jcpd = ContextParameterRuntimeMXBeanImpl.convertDescriptor(rcpd);
                        retVal.add(jcpd);
                    }
                    ++var6_9;
                }
            } else {
                Set<ContextParameterDescriptorInternal> rcpdSet = dcm.getContextParameterDescriptors();
                for (oracle.dms.context.ContextParameterDescriptor contextParameterDescriptor : rcpdSet) {
                    ContextParameterDescriptor jcpd = ContextParameterRuntimeMXBeanImpl.convertDescriptor(contextParameterDescriptor);
                    retVal.add(jcpd);
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateEventListener() {
        ContextParameterRuntimeMXBeanImpl contextParameterRuntimeMXBeanImpl = this;
        synchronized (contextParameterRuntimeMXBeanImpl) {
            EventConfigManager ecm = EventSystem.getEventConfigManager();
            if (this.mSampledValues.size() > 0) {
                if (this.mFilter == null) {
                    this.mParameterValueListener = new ContextValueListener(this.mSampledValues);
                    this.mDestination = new MyDestination(this.mParameterValueListener);
                    this.mFilter = new NullFilterWithEventTypeProxy("$ContextParameterValueSamplingFilter", "Context Parameter Value Sampling Filter", this.mDestination);
                    this.mParameterValueListener = new ContextValueListener(this.mSampledValues);
                    ecm.associateInternalFilterWithDestination(this.mFilter, this.mDestination);
                }
            } else if (this.mFilter != null) {
                ecm.disassociateFilterAndDestination(this.mFilter.getId(), this.mDestination.getId());
                this.mFilter = null;
                this.mDestination = null;
                this.mParameterValueListener = null;
            }
        }
    }

    private static ContextParameterDescriptor convertDescriptor(oracle.dms.context.ContextParameterDescriptor internalDescriptor) {
        Locale locale = Locale.getDefault();
        HashMap<String, String> value2descriptionMap = new HashMap<String, String>();
        if (internalDescriptor.getValueSet() != null) {
            for (String valueName : internalDescriptor.getValueSet()) {
                value2descriptionMap.put(valueName, internalDescriptor.getValueDescription(valueName, locale));
            }
        }
        ContextParameterDescriptor outgoingDescriptor = new ContextParameterDescriptor(internalDescriptor.getName(), internalDescriptor.getDescription(locale), value2descriptionMap.size() == 0 ? (Set<String>)null : value2descriptionMap.keySet(), value2descriptionMap.size() == 0 ? (Map)null : value2descriptionMap);
        return outgoingDescriptor;
    }

    @Override
    public int startSamplingParameter(String parameterName, Integer maxNumOfValues) {
        int retVal = 0;
        ParameterValueSampleData pvsd = this.mSampledValues.get(parameterName);
        if (pvsd == null) {
            int maxToUse = 10;
            if (maxNumOfValues != null) {
                maxToUse = maxNumOfValues;
            }
            this.mSampledValues.put(parameterName, new ParameterValueSampleData(parameterName, maxToUse));
            this.updateEventListener();
            retVal = 2;
        } else {
            retVal = 4;
        }
        return retVal;
    }

    @Override
    public Map<String, Long> getCurrentSampledParameters() {
        TreeMap<String, Long> retVal = null;
        long timeNow = Time.currentTimeMillis();
        if (this.mSampledValues != null && !this.mSampledValues.isEmpty()) {
            retVal = new TreeMap<String, Long>();
            for (Map.Entry<String, ParameterValueSampleData> entry : this.mSampledValues.entrySet()) {
                long durationInSeconds = (timeNow - entry.getValue().mStartSampleTime) / 1000L;
                retVal.put(entry.getKey(), durationInSeconds);
            }
        }
        return retVal;
    }

    @Override
    public Map<String, Long> getHistogramOfSampledValues(String parameterName) {
        TreeMap<String, Long> retVal = null;
        ParameterValueSampleData psvd = null;
        psvd = this.mSampledValues.get(parameterName);
        if (psvd != null) {
            retVal = new TreeMap<String, Long>();
            for (Map.Entry<String, AtomicInteger> entry : psvd.mSampledValues.entrySet()) {
                retVal.put(entry.getKey(), Long.valueOf(entry.getValue().get()));
            }
        }
        return retVal;
    }

    @Override
    public int stopSamplingParameter(String parameterName) {
        int retVal = 0;
        ParameterValueSampleData psvd = this.mSampledValues.remove(parameterName);
        if (psvd == null) {
            retVal = 3;
        } else {
            retVal = 1;
            this.updateEventListener();
        }
        return retVal;
    }

    private static class MyDestination
    implements Destination,
    EventTypeEnthusiast {
        private static final EventType[] sEventTypes = new EventType[]{EventType.getEventType(EventSourceType.EXECUTION_CONTEXT, EventActionType.START)};
        private ParameterValueListener mParameterValueListener;

        MyDestination(ParameterValueListener cvl) {
            this.mParameterValueListener = cvl;
        }

        @Override
        public void handleEvent(Event event) {
            ExecutionContext ctx;
            if (event.getSourceType() == EventSourceType.EXECUTION_CONTEXT && event.getActionType() == EventActionType.START && (ctx = event.getExecutionContext()) != null) {
                ctx.getDomainExecutionContext().registerListener(this.mParameterValueListener);
            }
        }

        @Override
        public boolean needsContext() {
            return true;
        }

        @Override
        public void initDestination() {
        }

        @Override
        public void shutdownDestination() {
        }

        @Override
        public String getId() {
            return "$ContextParameterValueSamplingDestination";
        }

        @Override
        public String getName() {
            return "Context Parameter Value Sampling Destination";
        }

        @Override
        public void validate(Set<Validatable.ValidationLevel> validationLevels) {
        }

        @Override
        public EventType[] getEventTypesOfInterest() {
            return sEventTypes;
        }
    }

    private static class ContextValueListener
    implements ParameterValueListener {
        Map<String, ParameterValueSampleData> mSampledValues;

        ContextValueListener(Map<String, ParameterValueSampleData> sampledValues) {
            this.mSampledValues = sampledValues;
        }

        @Override
        public void parameterValueTouched(ExecutionContext ctx, String parameterName, String parameterValue) {
            ParameterValueSampleData pvsd = this.mSampledValues.get(parameterName);
            if (pvsd != null) {
                AtomicInteger ai = pvsd.mSampledValues.get(parameterValue);
                if (ai != null) {
                    ai.incrementAndGet();
                } else if (pvsd.mMaxNumSamples <= 0 || pvsd.mSampledValues.size() < pvsd.mMaxNumSamples) {
                    pvsd.mSampledValues.put(parameterValue, new AtomicInteger(1));
                }
            }
        }
    }

    private static class ParameterValueSampleData {
        String mParameterName;
        Map<String, AtomicInteger> mSampledValues;
        int mMaxNumSamples;
        long mStartSampleTime;

        ParameterValueSampleData(String parameterName, int maxNumSamples) {
            this.mParameterName = parameterName;
            this.mMaxNumSamples = maxNumSamples > 0 ? maxNumSamples : 0;
            this.mStartSampleTime = Time.currentTimeMillis();
            this.mSampledValues = new ConcurrentHashMap<String, AtomicInteger>();
        }
    }
}

