/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.GCStatistics;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class FullGCSummary
implements GroupRefresh {
    static final String NOUN_NAME = "FullGCSummary";
    static final byte COL_COUNT = 0;
    static final byte COL_TOTALTIME = 1;
    static final byte COL_AVGELAPSED = 2;
    static final byte COL_MAXELAPSED = 3;
    static final byte COL_MINELAPSED = 4;
    static final String[] COLUMN_NAMES = new String[]{"Count", "TotalTime", "AvgElapsed", "MaxElapsed", "MinElapsed"};
    static final String[] COLUMN_DESCS = new String[]{"Total number of Full-GC events", "Total amount of time spent in all Full-GC events", "Average Full-GC elapsed time", "Highest Full-GC elapsed time", "Lowest Full-GC elapsed time"};
    static final byte[] COLUMN_STATES = new byte[]{2, 2, 2, 2, 2};
    private static Noun s_baseNoun;
    private static FullGCSummary s_stats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    FullGCSummary(Noun baseNoun) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/FullGCSummary") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, NOUN_NAME, "JVMMON_FullGCSummary");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new FullGCSummary(base);
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        GCStatistics gcStat = this.dataPsr_.getGCStatistics();
        if (gcStat == null) {
            return;
        }
        block7: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
            State state = this.states_[col];
            switch (col) {
                case 0: {
                    state.update(gcStat.getCount());
                    continue block7;
                }
                case 1: {
                    state.update(gcStat.getTotalAccumElapsed());
                    continue block7;
                }
                case 2: {
                    state.update(gcStat.getAverageElapsed());
                    continue block7;
                }
                case 3: {
                    state.update(gcStat.getHighestElapsed());
                    continue block7;
                }
                case 4: {
                    state.update(gcStat.getLowestElapsed());
                }
            }
        }
    }

    static void exit() {
        s_stats = null;
        s_baseNoun = null;
    }
}

