/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.CpuHotspot;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class CpuHotspotStat
implements GroupRefresh {
    static final String NOUN_NAME = "CpuHotspot";
    static final int MAX_ROW = 5;
    static final byte COL_TRACIID = 0;
    static final byte COL_CLASSNAME = 1;
    static final byte COL_METHODNAME = 2;
    static final byte COL_FILENAME = 3;
    static final byte COL_LINENUMBER = 4;
    static final byte COL_OCCURRENCECOUNT = 5;
    static final byte COL_AVGCPU = 6;
    static final byte COL_MAXCPU = 7;
    static final byte COL_MINCPU = 8;
    static final String[] COLUMN_NAMES = new String[]{"ID", "Classname", "MethodName", "Filename", "LineNumber", "Occurrence", "AvgCPU", "HighestCPU", "LowestCPU"};
    static final String[] COLUMN_DESCS = new String[]{"ID", "class name", "method name", "filename", "line number", "occurrence", "average CPU", "highest CPU detected", "lowest CPU detecte"};
    static final byte[] COLUMN_STATES = new byte[]{3, 5, 5, 5, 2, 2, 2, 2, 2};
    private static Noun s_baseNoun;
    private static Vector<CpuHotspotStat> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    CpuHotspotStat(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/CpuHotspot") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_CpuHotspot");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        CpuHotspotStat.create(base, 5);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new CpuHotspotStat(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        CpuHotspot[] hpts = this.dataPsr_.getCpuHotspots();
        if (hpts == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            CpuHotspotStat ht = s_allStats.elementAt(index);
            block12: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = ht.states_[col];
                switch (col) {
                    case 0: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getID());
                            continue block12;
                        }
                        state.update(0);
                        continue block12;
                    }
                    case 1: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getTopFrame().getClassName());
                            continue block12;
                        }
                        state.update("-NA-");
                        continue block12;
                    }
                    case 2: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getTopFrame().getMethodName());
                            continue block12;
                        }
                        state.update("-NA-");
                        continue block12;
                    }
                    case 3: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getTopFrame().getFileName());
                            continue block12;
                        }
                        state.update("-NA-");
                        continue block12;
                    }
                    case 4: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getTopFrame().getLineNumber());
                            continue block12;
                        }
                        state.update(0);
                        continue block12;
                    }
                    case 5: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getOccurrence());
                            continue block12;
                        }
                        state.update(0);
                        continue block12;
                    }
                    case 6: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getAverageCpuTime());
                            continue block12;
                        }
                        state.update(0);
                        continue block12;
                    }
                    case 7: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getHighestCpuTime());
                            continue block12;
                        }
                        state.update(0);
                        continue block12;
                    }
                    case 8: {
                        if (index < hpts.length) {
                            state.update(hpts[index].getLowestCpuTime());
                            continue block12;
                        }
                        state.update(0);
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

