/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import oracle.dms.spy.ConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DMSProperties {
    public static final String LOGLEVEL_PROPERTY_KEY = "loglevel";
    public static final String LOGWRITER_PROPERTY_KEY = "logwriter";
    private static final String LOGLEVEL_SUFFIX = "LogLevel";
    private static final String LOGWRITER_SUFFIX = "LogWriter";
    private static final String DMS_PREFIX = "oracle.dms.";
    private static final int DMS_PREFIX_LEN = "oracle.dms.".length();
    public static final String DMS_CONFIG_FILE = "oracle.dms.property.file";
    public static final String COMPOMENT_NAME = "oracle.component.name";
    public static final String COMPONENT_TYPE = "oracle.component.type";
    public static final String DPS_ENTITY_ID = "oracle.dps.entityid";
    public static final String FARM_NAME = "oracle.farm.name";
    public static final String ORACLE_HOME = "oracle.home";
    public static final String ORACLE_INSTANCE = "oracle.instance";
    public static final String INSTANCE_NAME = "oracle.instance.name";
    public static final String PCS = "PCS";
    private static Properties s_fileProperties = null;
    private static Properties s_paramProperties = new Properties();
    private static boolean s_inited = false;
    private static HashMap<String, HashMap<String, Object>> s_nounPropertiesMap;
    private static HashMap<String, HashMap<String, String>> s_sensorPropertiesMap;
    private static HashMap<String, Properties> s_logWriterProperties;
    private static HashSet<String> s_goodKeys;

    public static void init() throws ConfigurationError {
        DMSProperties.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Properties props) throws ConfigurationError {
        DMSProperties.append(props);
        Class<DMSProperties> clazz = DMSProperties.class;
        synchronized (DMSProperties.class) {
            if (s_inited) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            s_inited = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String configFile = null;
            try {
                configFile = DMSProperties.getSystemProperty(DMS_CONFIG_FILE);
            }
            catch (SecurityException e) {
                System.err.println("Calling  updateConfiguration(s_paramProperties)");
                DMSProperties.updateConfiguration(s_paramProperties);
                return;
            }
            if (configFile == null || configFile.trim().length() == 0) {
                DMSProperties.updateConfiguration();
                return;
            }
            Properties properties = new Properties();
            InputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(configFile));
                properties.load(input);
                s_fileProperties = properties;
            }
            catch (IOException e) {
                throw new ConfigurationError("50707", configFile, e);
            }
            catch (SecurityException e) {
                throw new ConfigurationError("50701", e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
            DMSProperties.updateConfiguration();
            return;
        }
    }

    public static String getProperty(String key, String defaultString) {
        if (key == null) {
            return defaultString;
        }
        String property = DMSProperties.getProperty(key);
        if (property != null) {
            return property;
        }
        return defaultString;
    }

    public static void append(Properties props) {
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            DMSProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        s_paramProperties.put(key, value);
        try {
            DMSProperties.updateConfiguration(key, value);
        }
        catch (ConfigurationError configurationError) {
            // empty catch block
        }
    }

    public static void concatProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        String oldValue = DMSProperties.getProperty(key);
        if (oldValue == null) {
            DMSProperties.setProperty(key, value);
        } else {
            DMSProperties.setProperty(key, oldValue + value);
        }
    }

    public static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        String property = null;
        if (s_paramProperties != null) {
            property = s_paramProperties.getProperty(key);
        }
        if (property != null) {
            return property;
        }
        try {
            property = DMSProperties.getSystemProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (property != null || s_fileProperties == null) {
            return property;
        }
        return s_fileProperties.getProperty(key);
    }

    public static int getPropertyInt(String key, int defaultInt) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultInt;
        }
        try {
            return Integer.parseInt(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultInt;
        }
    }

    public static long getPropertyLong(String key, long defaultLong) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultLong;
        }
        try {
            return Long.parseLong(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultLong;
        }
    }

    public static double getPropertyDouble(String key, double defaultDouble) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultDouble;
        }
        try {
            return Double.parseDouble(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultDouble;
        }
    }

    public static boolean getPropertyBoolean(String key, boolean defaultBoolean) {
        String property = DMSProperties.getProperty(key);
        if (property == null) {
            return defaultBoolean;
        }
        return Boolean.parseBoolean(property.trim());
    }

    private DMSProperties() {
    }

    public static final boolean hasNounProperties() {
        return s_nounPropertiesMap != null && s_nounPropertiesMap.size() > 0;
    }

    public static final boolean hasSensorProperties() {
        return s_sensorPropertiesMap != null && s_sensorPropertiesMap.size() > 0;
    }

    public static final HashMap<String, Object> getNounProperties(String pathName) {
        if (DMSProperties.hasNounProperties()) {
            return s_nounPropertiesMap.get(pathName);
        }
        return null;
    }

    public static final HashMap<String, String> getSensorProperties(String pathName) {
        if (DMSProperties.hasSensorProperties()) {
            return s_sensorPropertiesMap.get(pathName);
        }
        return null;
    }

    public static Map<String, Properties> getLogWriterProperties() {
        return s_logWriterProperties;
    }

    private static void updateConfiguration(Properties props) throws ConfigurationError {
        if (props == null) {
            return;
        }
        Enumeration<Object> iter = props.keys();
        while (iter.hasMoreElements()) {
            String value;
            String key = (String)iter.nextElement();
            if (!key.startsWith(DMS_PREFIX)) continue;
            try {
                value = props.getProperty(key);
            }
            catch (Exception e) {
                return;
            }
            DMSProperties.updateConfiguration(key, value);
        }
    }

    private static final void updateConfiguration(String key, String value) throws ConfigurationError {
        if (!key.startsWith(DMS_PREFIX)) {
            return;
        }
        int typeEnd = key.indexOf(46, DMS_PREFIX_LEN);
        if (typeEnd < 0) {
            return;
        }
        String type = key.substring(DMS_PREFIX_LEN, typeEnd);
        String prop = null;
        if (typeEnd + 1 < key.length()) {
            prop = key.substring(typeEnd + 1);
        }
        if (type.equals(LOGWRITER_SUFFIX)) {
            DMSProperties.updateLogWriters(prop, value);
        } else if (type.equals("Noun")) {
            DMSProperties.updateNounProperties(prop, value);
        } else if (type.equals("Sensor")) {
            DMSProperties.updateSensorProperties(prop, value);
        }
    }

    private static void updateConfiguration() throws ConfigurationError {
        Properties sysProperties;
        DMSProperties.updateConfiguration(s_fileProperties);
        try {
            sysProperties = DMSProperties.getSystemProperties();
        }
        catch (Exception e) {
            sysProperties = null;
        }
        DMSProperties.updateConfiguration(sysProperties);
        DMSProperties.updateConfiguration(s_paramProperties);
    }

    private static void updateLogWriters(String property, String value) throws ConfigurationError {
        Properties props;
        System.err.println("updateLogWriters(" + property + "," + value + ")");
        int suffixIndex = property.indexOf(46);
        if (suffixIndex < 0) {
            ConfigurationError ce = new ConfigurationError("50706");
            ce.addToken(property);
            ce.addToken(value);
            throw ce;
        }
        String name = property.substring(0, suffixIndex);
        if (name.trim().length() == 0) {
            ConfigurationError ce = new ConfigurationError("50706");
            ce.addToken(property);
            ce.addToken(value);
            throw ce;
        }
        String suffix = property.substring(suffixIndex + 1);
        if (s_logWriterProperties == null) {
            s_logWriterProperties = new HashMap();
        }
        if ((props = s_logWriterProperties.get(name)) == null) {
            props = new Properties();
            s_logWriterProperties.put(name, props);
        }
        props.setProperty(suffix, value);
        System.err.println("Setting property" + suffix + " to " + value);
    }

    private static void updateNounProperties(String property, String value) throws ConfigurationError {
        ArrayList<String> list;
        HashMap<String, Object> prop;
        String path;
        String suffix;
        int suffixIndex = property.lastIndexOf(46);
        if (suffixIndex + 1 == property.length()) {
            ConfigurationError ce = new ConfigurationError("50706");
            ce.addToken(property);
            ce.addToken(value);
            throw ce;
        }
        if (suffixIndex < 0) {
            suffix = property;
            path = "/";
        } else {
            suffix = property.substring(suffixIndex + 1);
            String name = property.substring(0, suffixIndex);
            path = '/' + name.replace('.', '/');
        }
        if (s_nounPropertiesMap == null) {
            s_nounPropertiesMap = new HashMap();
        }
        if ((prop = s_nounPropertiesMap.get(path)) == null) {
            prop = new HashMap();
            s_nounPropertiesMap.put(path, prop);
        }
        if (suffix.equals(LOGLEVEL_SUFFIX)) {
            prop.put(LOGLEVEL_PROPERTY_KEY, value);
        } else if (suffix.equals(LOGWRITER_SUFFIX) && (list = DMSProperties.parseNameList(value)) != null) {
            prop.put(LOGWRITER_PROPERTY_KEY, list);
        }
    }

    private static void updateSensorProperties(String property, String value) throws ConfigurationError {
        HashMap<String, String> prop;
        int suffixIndex = property.lastIndexOf(46);
        if (suffixIndex < 0 || suffixIndex + 1 == property.length()) {
            ConfigurationError ce = new ConfigurationError("50706");
            ce.addToken(property);
            ce.addToken(value);
            throw ce;
        }
        String suffix = property.substring(suffixIndex + 1);
        String name = property.substring(0, suffixIndex);
        String path = '/' + name.replace('.', '/');
        if (s_sensorPropertiesMap == null) {
            s_sensorPropertiesMap = new HashMap();
        }
        if ((prop = s_sensorPropertiesMap.get(path)) == null) {
            prop = new HashMap();
            s_sensorPropertiesMap.put(path, prop);
        }
        if (suffix.equals(LOGLEVEL_SUFFIX)) {
            prop.put(LOGLEVEL_PROPERTY_KEY, value);
        }
    }

    private static ArrayList<String> parseNameList(String s) {
        String aux;
        ArrayList<String> ret = new ArrayList<String>();
        int prevIndex = 0;
        int nextIndex = s.indexOf(44, prevIndex);
        while (nextIndex >= 0) {
            aux = s.substring(prevIndex, nextIndex).trim();
            if (aux.trim().length() > 0) {
                ret.add(aux);
            }
            prevIndex = nextIndex + 1;
            nextIndex = s.indexOf(44, prevIndex);
        }
        aux = s.substring(prevIndex, s.length()).trim();
        if (aux.trim().length() > 0) {
            ret.add(aux);
        }
        return ret;
    }

    static String getSystemProperty(final String key) {
        String value = null;
        if (key.startsWith(DMS_PREFIX) || s_goodKeys.contains(key)) {
            value = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        return value;
    }

    private static Properties getSystemProperties() {
        Properties props = null;
        props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        return props;
    }

    public static synchronized void exit() {
        s_nounPropertiesMap = null;
        s_sensorPropertiesMap = null;
        s_logWriterProperties = null;
        s_fileProperties = null;
        s_paramProperties.clear();
        s_inited = false;
    }

    static {
        s_goodKeys = new HashSet();
        s_goodKeys.add(COMPOMENT_NAME);
        s_goodKeys.add(COMPONENT_TYPE);
        s_goodKeys.add(DPS_ENTITY_ID);
        s_goodKeys.add(FARM_NAME);
        s_goodKeys.add(ORACLE_HOME);
        s_goodKeys.add(ORACLE_INSTANCE);
        s_goodKeys.add(INSTANCE_NAME);
        s_goodKeys.add(PCS);
        s_goodKeys.add("user.dir");
    }
}

