/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import oracle.dms.instrument.Noun;
import oracle.dms.spy.jvm.ClassLoaderStats;
import oracle.dms.spy.jvm.CompilerStats;
import oracle.dms.spy.jvm.MemoryStats;
import oracle.dms.spy.jvm.OSStats;
import oracle.dms.spy.jvm.RuntimeStats;
import oracle.dms.spy.jvm.ThreadMonitor;
import oracle.dms.spy.jvm.ThreadStats;

public class MgmtStats {
    private static MgmtStats s_stats = null;
    private static Noun s_baseNoun = null;

    private MgmtStats() {
        ClassLoaderStats.create(s_baseNoun);
        CompilerStats.create(s_baseNoun);
        RuntimeStats.create(s_baseNoun);
        MemoryStats.create(s_baseNoun);
        ThreadStats.create(s_baseNoun);
        ThreadMonitor.create(s_baseNoun);
        OSStats.create(s_baseNoun);
    }

    public static void create(Noun noun) {
        if (s_stats != null) {
            return;
        }
        s_baseNoun = noun != null ? Noun.create(noun, "MxBeans", "") : Noun.create("/JVM/MxBeans");
        s_stats = new MgmtStats();
    }

    public static void exit() {
        s_stats = null;
        s_baseNoun = null;
        ClassLoaderStats.exit();
        CompilerStats.exit();
        RuntimeStats.exit();
        MemoryStats.exit();
        ThreadStats.exit();
        ThreadMonitor.exit();
        OSStats.exit();
    }
}

