/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryType;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.jvm.GCStats;
import oracle.dms.spy.jvm.MemoryPools;
import oracle.dms.spy.jvm.MemoryTypeStats;

public class MemoryStats
implements GroupRefresh {
    private static MemoryStats s_stats = null;
    private MemoryMXBean m_memory = null;
    private State m_pendingFinalization = null;
    private State m_verbose = null;

    private MemoryStats() {
    }

    private MemoryStats(Noun baseNoun) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        this.m_memory = ManagementFactory.getMemoryMXBean();
        Noun memoryNoun = Noun.create(baseNoun, "memory", "JVM_Memory");
        this.m_pendingFinalization = State.create(memoryNoun, "pendingFinalization", (byte)3, "objects", "pending finalization");
        this.m_pendingFinalization.setRefresh(this);
        this.m_verbose = State.create(memoryNoun, "verbose", (byte)5, "", "whether memory system output is verbose");
        this.m_verbose.setRefresh(this);
        GCStats.create(memoryNoun);
        MemoryPools.create(memoryNoun);
        Noun tnoun = Noun.create(memoryNoun, "type", "");
        for (MemoryType type : MemoryType.values()) {
            MemoryTypeStats.create(tnoun, type);
        }
        this.refresh();
    }

    public static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new MemoryStats(base);
    }

    public void refresh() {
        this.m_pendingFinalization.update(this.m_memory.getObjectPendingFinalizationCount());
        this.m_verbose.update(this.m_memory.isVerbose() ? "TRUE" : "FALSE");
    }

    static void exit() {
        s_stats = null;
        GCStats.exit();
        MemoryPools.exit();
        MemoryTypeStats.exit();
    }
}

