/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

class PropertiesStates
implements GroupRefresh {
    private static Noun s_noun = null;
    private static PropertiesStates s_states = null;
    private static HashMap<String, State> s_pstates = new HashMap();
    private static boolean s_lock = false;

    private PropertiesStates() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesStates(Noun parent) {
        s_noun = Noun.create(parent, "Properties", "");
        PropertiesStates propertiesStates = this;
        synchronized (propertiesStates) {
            s_lock = true;
        }
        this.create_states(this._getSystemProperties());
        propertiesStates = this;
        synchronized (propertiesStates) {
            s_lock = false;
        }
    }

    static PropertiesStates create(Noun parent) {
        if (s_states != null) {
            return s_states;
        }
        s_states = new PropertiesStates(parent);
        return s_states;
    }

    void create_states(Properties props) {
        Enumeration<?> keys = props.propertyNames();
        try {
            while (keys.hasMoreElements()) {
                String pname = (String)keys.nextElement();
                if (pname == null || pname.length() == 0) continue;
                String sname = pname.replaceAll("\\.", "_");
                String val = props.getProperty(pname);
                State state = State.create(s_noun, sname, (byte)5, "", "");
                state.setRefresh(this);
                state.update(val);
                s_pstates.put(pname, state);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        State state;
        PropertiesStates propertiesStates = this;
        synchronized (propertiesStates) {
            if (s_lock) {
                return;
            }
            s_lock = true;
        }
        Properties props = this._getSystemProperties();
        Set<String> states = s_pstates.keySet();
        ArrayList<String> tossStates = new ArrayList<String>();
        Properties newStateProps = new Properties();
        newStateProps.putAll((Map<?, ?>)props);
        for (String name : states) {
            String val = props.getProperty(name);
            if (val != null) {
                state = s_pstates.get(name);
                state.update(val);
                newStateProps.remove(name);
                continue;
            }
            tossStates.add(name);
        }
        int size = tossStates.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String name = (String)tossStates.get(i);
                state = s_pstates.remove(name);
                state.destroy();
            }
        }
        if (newStateProps.size() > 0) {
            this.create_states(newStateProps);
        }
        PropertiesStates propertiesStates2 = this;
        synchronized (propertiesStates2) {
            s_lock = false;
        }
    }

    private Properties _getSystemProperties() {
        Properties props = null;
        props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        return props;
    }

    static synchronized void exit() {
        s_noun = null;
        s_states = null;
        s_pstates.clear();
        s_lock = false;
    }
}

