/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import oracle.dms.http.Request;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.spy.Metric;
import oracle.dms.util.Indentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TreeletReporter
extends Reporter {
    private static final String[] ROOT_NAME = new String[]{"/"};
    protected boolean m_includeDescriptions = true;
    protected boolean m_includeUnits = true;
    protected boolean m_includeValues = true;
    protected boolean m_isOrdered = false;
    protected Indentation m_indent = new Indentation();
    private byte m_includeDescendant = 1;
    private HashMap<Metric, Serializable> m_metricValueTable = new HashMap();
    private ArrayList<Metric> m_metricList = new ArrayList();
    NounTreeletNode m_root = new NounTreeletNode(Noun.getRoot());

    TreeletReporter(Request request) {
        super(request);
    }

    @Override
    public final void printResponse(PrintWriter out) {
        if (this.m_op == 1) {
            this.printResetResponse(out);
        } else if (this.m_op == 2) {
            this.printSetResponse(out);
        } else {
            this.m_includeDescriptions = this.m_request.includeDescription();
            this.m_includeUnits = this.m_request.includeUnits();
            this.m_includeValues = this.m_request.includeValues();
            this.printGetResponse(out);
        }
    }

    @Override
    public void clear() {
        this.m_metricValueTable.clear();
        this.m_metricList.clear();
        this.m_root.clear();
    }

    private void startWalkTree(PrintWriter out) {
        out.print("<statistics>\n");
    }

    private void endWalkTree(PrintWriter out) {
        out.print("</statistics>\n");
    }

    abstract void printHeading(PrintWriter var1);

    abstract void printEnding(PrintWriter var1);

    abstract void startPrintNounNode(NounTreeletNode var1, PrintWriter var2);

    abstract void endPrintNounNode(NounTreeletNode var1, PrintWriter var2);

    abstract void printMetricNode(MetricTreeletNode var1, PrintWriter var2);

    private void printGetResponse(PrintWriter out) {
        HashSet<String> badNames = new HashSet<String>();
        HashSet<String> badTables = new HashSet<String>();
        this.getTreeletNodes(badNames, badTables, null);
        if (this.m_includeValues) {
            this._queryMetricValues();
        }
        this.printHeading(out);
        this.startWalkTree(out);
        this._walk(this.m_root, out);
        this.endWalkTree(out);
        this.printBadParams(badNames, badTables, out);
        this.printEnding(out);
        badNames.clear();
        badTables.clear();
    }

    private void printSetResponse(PrintWriter out) {
        String newValue;
        HashSet<String> badNames = new HashSet<String>();
        HashSet<String> badTables = new HashSet<String>();
        HashSet<Sensor> sensors = new HashSet<Sensor>();
        this.getTreeletNodes(badNames, badTables, sensors);
        if (sensors.size() <= 0 || (newValue = this.m_request.getNewValue()) == null || newValue.trim().length() > 0) {
            // empty if block
        }
        this.printHeading(out);
        this.printBadParams(badNames, badTables, out);
        this.printEnding(out);
        badNames.clear();
        badTables.clear();
        sensors.clear();
    }

    private void printResetResponse(PrintWriter out) {
        HashSet<String> badNames = new HashSet<String>();
        HashSet<String> badTables = new HashSet<String>();
        HashSet<Sensor> sensors = new HashSet<Sensor>();
        this.getTreeletNodes(badNames, badTables, sensors);
        if (sensors.size() > 0) {
            for (Sensor sensor : sensors) {
                sensor.reset();
            }
        }
        this.printHeading(out);
        this.printBadParams(badNames, badTables, out);
        this.printEnding(out);
        badNames.clear();
        badTables.clear();
        sensors.clear();
    }

    private void getTreeletNodes(Collection<String> badNames, Collection<String> badTables, Collection<Sensor> sensors) {
        this.m_includeDescendant = this.m_request.includeDescendents("children") ? (byte)2 : (this.m_request.includeDescendents("none") ? (byte)0 : (this.m_request.includeDescendents("all") ? (byte)1 : (this.m_op == 3 ? (byte)1 : (this.m_op == 1 ? (byte)2 : (byte)0))));
        String[] tables = this.m_request.getTables();
        this._getTreeletNodeByTables(tables, badTables, this.m_root, sensors);
        String[] names = this.m_request.getNames();
        if (names == null || names.length == 0) {
            if (tables == null || tables.length == 0) {
                names = ROOT_NAME;
            } else {
                return;
            }
        }
        for (String name : names) {
            if (name.trim().length() == 0) continue;
            if (name.charAt(0) != '/') {
                badNames.add(name);
                continue;
            }
            TreeletNode node = this._getDescendant(this.m_root, name.substring(1), name.charAt(0), sensors);
            if (node != null) continue;
            badNames.add(name);
        }
    }

    final Serializable getMetricValue(MetricTreeletNode metricNode) {
        Metric metric = (Metric)metricNode.getNode();
        return this.m_metricValueTable.get(metric);
    }

    private TreeletNode _getDescendant(NounTreeletNode parent, String name, char delim, Collection<Sensor> sensors) {
        Noun noun;
        String tok;
        if (parent == null || name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            this._getDescendants(parent, sensors);
            return parent;
        }
        int index = name.indexOf(delim);
        String rest = null;
        if (index == 0) {
            return null;
        }
        if (index > 0) {
            tok = name.substring(0, index);
            rest = name.substring(index + 1);
        } else {
            tok = name;
        }
        Noun parentNoun = (Noun)parent.getNode();
        TreeletNode node = parent.findNoun(tok);
        if (node == null && (noun = parentNoun.getChild(tok)) != null) {
            node = new NounTreeletNode(tok, parent, noun);
        }
        if (node == null) {
            if (rest != null && rest.trim().length() > 0) {
                return null;
            }
            node = parent.findMetric(tok);
            if (node != null) {
                return node;
            }
            index = tok.lastIndexOf(46);
            if (index <= 0) {
                return null;
            }
            Sensor sensor = parentNoun.getSensor(tok.substring(0, index));
            if (sensor == null) {
                return null;
            }
            Metric metric = sensor.getMetric(tok);
            if (metric != null) {
                this.m_metricList.add(metric);
                node = new MetricTreeletNode(tok, parent, metric, this);
            }
            if (sensors != null && node != null) {
                sensors.add(sensor);
            }
            return node;
        }
        if (node instanceof MetricTreeletNode) {
            return node;
        }
        if (rest != null && rest.trim().length() > 0) {
            return this._getDescendant((NounTreeletNode)node, rest, delim, sensors);
        }
        this._getDescendants((NounTreeletNode)node, sensors);
        return node;
    }

    private void _getDescendants(NounTreeletNode parent, Collection<Sensor> sensors) {
        Vector nouns;
        Noun pnoun = (Noun)parent.getNode();
        Sensor[] sens = pnoun.getSensors();
        if (sens != null && (this.m_includeDescendant == 1 || this.m_includeDescendant == 2)) {
            for (Sensor sensor : sens) {
                if (sensors != null) {
                    sensors.add(sensor);
                }
                Vector metrics = new Vector();
                sensor.getMetrics(metrics);
                for (Metric metric : metrics) {
                    String name = metric.getName();
                    MetricTreeletNode metricNode = parent.findMetric(name);
                    if (metricNode != null) continue;
                    this.m_metricList.add(metric);
                    new MetricTreeletNode(metric.getName(), parent, metric, this);
                }
            }
        }
        if (this.m_includeDescendant == 1 && (nouns = pnoun.getNouns()) != null) {
            for (Noun noun : nouns) {
                String nounName = noun.getName();
                NounTreeletNode nounNode = parent.findNoun(nounName);
                if (nounNode == null) {
                    nounNode = new NounTreeletNode(nounName, parent, noun);
                }
                this._getDescendants(nounNode, sensors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _queryMetricValues() {
        Metric[] metrics = null;
        ArrayList<Metric> arrayList = this.m_metricList;
        synchronized (arrayList) {
            metrics = new Metric[this.m_metricList.size()];
            this.m_metricList.toArray(metrics);
        }
        HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
        Serializable[] metricValues = Metric.getSerializableValues(metrics, gRefresh);
        for (int i = 0; i < metrics.length; ++i) {
            this.m_metricValueTable.put(metrics[i], metricValues[i]);
        }
    }

    private void _getTreeletNodeByTables(String[] tables, Collection<String> badTables, NounTreeletNode root, Collection<Sensor> sensors) {
        if (tables == null || tables.length == 0 || root == null) {
            return;
        }
        ArrayList<Noun[]> nounList = this._getNounsByTables(tables, badTables);
        if (nounList == null) {
            return;
        }
        for (Noun[] nounArray : nounList) {
            if (nounArray == null || nounArray.length == 0) continue;
            for (Noun noun : nounArray) {
                this._getTreeletNodeByNoun(root, noun, sensors);
            }
        }
    }

    private ArrayList<Noun[]> _getNounsByTables(String[] tables, Collection<String> badTables) {
        ArrayList<Noun[]> list = new ArrayList<Noun[]>();
        if (tables == null || tables.length == 0) {
            return list;
        }
        for (String table : tables) {
            Noun[] nouns = Noun.getNounsByType(table);
            if (nouns == null || nouns.length == 0) {
                badTables.add(table);
                continue;
            }
            list.add(nouns);
        }
        return list;
    }

    private void _getTreeletNodeByNoun(NounTreeletNode rootNode, Noun noun, Collection<Sensor> sensors) {
        ArrayList<Noun> ancestors = new ArrayList<Noun>();
        Noun root = Noun.getRoot();
        for (Noun anoun = noun; anoun != root; anoun = anoun.getParent()) {
            ancestors.add(anoun);
        }
        NounTreeletNode tln = rootNode;
        NounTreeletNode parent = rootNode;
        for (Noun anoun : ancestors) {
            String name = anoun.getName();
            tln = parent.findNoun(name);
            if (tln == null) {
                tln = new NounTreeletNode(name, parent, anoun);
            }
            parent = tln;
        }
        ancestors.clear();
        if (this.m_includeDescendant == 1 || this.m_includeDescendant == 2) {
            this._getDescendants(tln, sensors);
        }
    }

    private void _walk(NounTreeletNode node, PrintWriter out) {
        Collection<NounTreeletNode> nouns;
        Collection<MetricTreeletNode> metrics;
        if (node != this.m_root) {
            this.startPrintNounNode(node, out);
        }
        if ((metrics = node.getMetrics(this.m_isOrdered)) != null && metrics.size() > 0) {
            for (MetricTreeletNode metric : metrics) {
                this.printMetricNode(metric, out);
            }
            if (this.m_isOrdered) {
                metrics.clear();
            }
        }
        if ((nouns = node.getNouns(this.m_isOrdered)) != null && nouns.size() > 0) {
            for (NounTreeletNode noun : nouns) {
                this._walk(noun, out);
            }
            if (this.m_isOrdered) {
                nouns.clear();
            }
        }
        if (node != this.m_root) {
            this.endPrintNounNode(node, out);
        }
    }
}

