/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.RollupSensor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.State;

public class Rollup
implements GroupRefresh {
    Noun m_top = null;
    Noun m_noun = null;
    State m_count = null;
    String m_type = null;
    boolean m_recurse;
    boolean m_init = false;
    long m_lastRefreshTime = 0L;
    HashMap m_sensors = new HashMap();
    Collection m_ru_sensors = this.m_sensors.values();
    PhaseEvent m_phase = null;

    private Rollup() {
    }

    public Rollup(Noun noun, State count, String type, boolean recurse) {
        this.m_top = noun.getParent();
        this.m_noun = noun;
        this.m_count = count;
        this.m_type = type;
        this.m_recurse = recurse;
        this.m_phase = PhaseEvent.create(noun, "refresh", "update the rollup metrics");
        this.m_phase.deriveMetric(511);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        long token = 0L;
        try {
            token = this.m_phase.start();
            Noun[] nouns = this.m_top.getDescendants(this.m_recurse, this.m_type);
            if (nouns == null) {
                this.m_count.update(0);
                return;
            }
            this.m_count.update(nouns.length);
            this.updateSensors(nouns);
            this.m_lastRefreshTime = System.currentTimeMillis();
        }
        finally {
            this.m_phase.stop(token);
        }
    }

    private void updateSensors(Noun[] nouns) {
        if (nouns == null || nouns.length == 0) {
            this.resetSensors();
            return;
        }
        NounDescriptor ndesc = null;
        ndesc = nouns[0].getDescriptor();
        if (ndesc.getLastUpdateTime() >= this.m_lastRefreshTime) {
            this.update(ndesc, nouns);
        }
        Iterator it = this.m_ru_sensors.iterator();
        RollupSensor ru = null;
        while (it.hasNext()) {
            ru = (RollupSensor)it.next();
            ru.update(nouns, this.m_type);
        }
    }

    private void update(NounDescriptor ndesc, Noun[] nouns) {
        RollupSensor ru_sensor = null;
        SensorDescriptor sdesc = null;
        String[] sensorNames = ndesc.getSensorNames();
        String name = null;
        for (int i = 0; i < sensorNames.length; ++i) {
            name = sensorNames[i];
            sdesc = ndesc.getSensorDescriptor(name);
            Sensor sensor = this.getSensor(name, nouns);
            ru_sensor = (RollupSensor)this.m_sensors.get(name);
            if (ru_sensor == null) {
                ru_sensor = RollupSensor.create(this.m_noun, sensor);
                if (ru_sensor == null) continue;
                ru_sensor.setRefresh(this);
                this.m_sensors.put(name, ru_sensor);
                continue;
            }
            ru_sensor.updateMetrics(sensor);
        }
    }

    private Sensor getSensor(String name, Noun[] nouns) {
        if (name == null || nouns == null || nouns.length == 0) {
            return null;
        }
        Sensor sensor = null;
        for (int i = 0; i < nouns.length; ++i) {
            sensor = nouns[i].getSensor(name);
            if (sensor == null) continue;
            return sensor;
        }
        return null;
    }

    private void resetSensors() {
        Iterator it = this.m_ru_sensors.iterator();
        RollupSensor ru = null;
        while (it.hasNext()) {
            ru = (RollupSensor)it.next();
            ru.reset();
        }
    }
}

