/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.instrument.Descriptor;

public class MetricDescriptor
extends Descriptor {
    public static final byte NLS_STRING = 6;
    public static final byte OBJECT = 5;
    public static final byte STRING = 4;
    public static final byte INTEGER = 3;
    public static final byte LONG = 2;
    public static final byte DOUBLE = 1;
    private String m_unit = null;
    private byte m_valueType = (byte)4;

    public MetricDescriptor(String name, String unit, byte valueType) {
        super(name);
        if (unit == null) {
            throw new IllegalArgumentException(this.toString() + ": unit=" + unit);
        }
        this.m_unit = unit;
        switch (valueType) {
            case 1: 
            case 2: 
            case 3: {
                this.m_valueType = valueType;
            }
        }
    }

    public String getUnit() {
        return this.m_unit;
    }

    public String getValueType() {
        switch (this.m_valueType) {
            case 3: {
                return "integer";
            }
            case 2: {
                return "long";
            }
            case 1: {
                return "double";
            }
        }
        return "string";
    }
}

