/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.text.MessageFormat;
import java.util.Properties;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.LoggerIntf;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class Logger
extends Sensor
implements LoggerIntf {
    private int _count = 0;
    private int _logged = 0;

    protected Logger(Noun parent, String name, String desc, Properties properties) {
        this(true, parent, name, desc, properties);
    }

    private Logger(boolean sanitizeName, Noun parent, String name, String desc, Properties properties) {
        super(sanitizeName, parent, name, desc);
        this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
        this._metrics[0] = new Metric(this._name + ".logged", this._description, "ops", this, false, 3, 0);
        this.setLoggingProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(Noun parent, String name, String desc, Properties properties) {
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            Logger e = (Logger)parent.getSensor(sanitizedName);
            if (e != null) {
                return e;
            }
            return new Logger(false, parent, sanitizedName, desc, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(String pathname, String desc, Properties properties) {
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Logger logger = (Logger)Sensor.lookupCache(pathname);
        if (logger != null) {
            return logger;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            logger = (Logger)parent.getSensor(sanitizedName);
            if (logger != null) {
                logger.addToCache(pathname);
                return logger;
            }
            return new Logger(false, parent, sanitizedName, desc, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(Noun parent, String name, String desc) {
        if (parent == null || desc == null || name == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            Logger e = (Logger)parent.getSensor(sanitizedName);
            if (e != null) {
                return e;
            }
            return new Logger(false, parent, sanitizedName, desc, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(String pathname, String desc) {
        if (pathname == null || pathname.length() == 0 || desc == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Logger logger = (Logger)Sensor.lookupCache(pathname);
        if (logger != null) {
            return logger;
        }
        Noun parent = Sensor.createParent(pathname);
        String name = DMSUtil.getLeafFromPath(pathname);
        Noun noun = parent;
        synchronized (noun) {
            String sanitizedName = DMSUtil.sanitize(name, 511, true, true);
            logger = (Logger)parent.getSensor(sanitizedName);
            if (logger != null) {
                logger.addToCache(pathname);
                return logger;
            }
            return new Logger(false, parent, sanitizedName, desc, null);
        }
    }

    public synchronized void log() {
        ++this._count;
        if (this.isLoggable()) {
            ++this._logged;
            StringBuffer sb = new StringBuffer(32);
            sb.append(this._count);
            sb.append(" ops, ");
            sb.append(this._logged);
            sb.append(" logged");
            this.logActivation(sb.toString());
        }
    }

    public synchronized void log(Level level, String message, Throwable thr, Properties properties) {
        ++this._count;
        if (this.isLoggable(level)) {
            ++this._logged;
            this.logActivation(level, message, thr, properties);
        }
    }

    public synchronized void log(LogLevel level, String message, Throwable thr, Properties properties) {
        this.log((Level)level, message, thr, properties);
    }

    public void log(Level level, String message) {
        this.log(level, message, null, null);
    }

    public synchronized void log(LogLevel level, String message) {
        this.log((Level)level, message, null, null);
    }

    public void log(Level level, String message, Throwable thr) {
        this.log(level, message, thr, null);
    }

    public void log(LogLevel level, String message, Throwable thr) {
        this.log((Level)level, message, thr, null);
    }

    public void log(Level level, String message, Properties properties) {
        this.log(level, message, null, properties);
    }

    public void log(LogLevel level, String message, Properties properties) {
        this.log(level, message, null, properties);
    }

    public synchronized void log(String msg, Throwable thr, Properties properties) {
        String strLevel;
        ++this._count;
        Level level = null;
        if (properties != null && (strLevel = properties.getProperty("Level")) != null) {
            level = Level.getLevel(strLevel);
        }
        if (this.isLoggable(level)) {
            ++this._logged;
            this.logActivation(level, msg, thr, properties);
        }
    }

    public void log(String msg, Properties properties) {
        this.log(msg, (Throwable)null, properties);
    }

    public void log(String msg, Throwable thr) {
        this.log(msg, thr, null);
    }

    public void log(String msg) {
        this.log(msg, (Throwable)null, null);
    }

    public synchronized void log(Level level, String msgPattern, Object[] args) {
        String fmtMsg = null;
        try {
            DMSUtil.cleanFormatArgs(args);
            fmtMsg = MessageFormat.format(msgPattern, args);
        }
        catch (Exception e) {
            fmtMsg = msgPattern;
        }
        this.log(level, fmtMsg, (Throwable)null, null);
    }

    public void log(LogLevel level, String msgPattern, Object[] args) {
        this.log((Level)level, msgPattern, args);
    }

    public synchronized void log(String msgPattern, Object[] args, Properties properties) {
        String fmtMsg = null;
        try {
            DMSUtil.cleanFormatArgs(args);
            fmtMsg = MessageFormat.format(msgPattern, args);
        }
        catch (Exception e) {
            fmtMsg = msgPattern;
        }
        this.log(fmtMsg, (Throwable)null, properties);
    }

    public static void log(String pathname, Level level, String message, Throwable thr, Properties properties) {
        ((Logger)Sensor.get(pathname)).log(level, message, thr, properties);
    }

    public static void log(String pathname, LogLevel level, String message, Throwable thr, Properties properties) {
        ((Logger)Sensor.get(pathname)).log((Level)level, message, thr, properties);
    }

    public synchronized Object getValue(Metric m) {
        if (!this._alive) {
            return new ErrorObject();
        }
        if (m == null) {
            throw new InstrumentationException("Metric: " + m + " does not belong to Logger " + this);
        }
        byte index = m.getIndex();
        if (this._metrics[index] != m) {
            throw new InstrumentationException("Metric: " + m + " does not belong to Logger " + this);
        }
        switch (index) {
            case 1: {
                return new Integer(this._count);
            }
            case 0: {
                return new Integer(this._logged);
            }
        }
        throw new InstrumentationException("Metric: " + m + " does not belong to Logger " + this);
    }

    public synchronized void reset() {
        this._count = 0;
        this._logged = 0;
    }

    public void deriveMetric(int metric) {
    }
}

