/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.management;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentDump;
import oracle.dfw.management.DumpReaderFactory;
import oracle.dfw.management.IncidentManagementException;

public class IncidentPackager {
    private StringBuilder m_readme = new StringBuilder();
    private String m_oracleInstancePath;
    private String m_packageRootPath;
    private String m_packageFile;
    private Logger m_logger;
    private DumpReaderFactory m_dumpReaderFactory;
    private ZipOutputStream m_zipStream;
    private static final String PACKAGE_SUB_PATH = "diagnostics" + File.separatorChar + "incidents" + File.separatorChar + "package";
    private static final String DEFAULT_PACKAGE_EXTENSION = ".zip";
    private static final int BUFFER = 129472;

    public IncidentPackager(String oracleInstancePath, DumpReaderFactory readerFactory) throws IncidentManagementException {
        if (oracleInstancePath == null || oracleInstancePath.length() == 0 || readerFactory == null) {
            throw new IllegalArgumentException("Invalid arguments oracleInstancePath=" + oracleInstancePath + " readerFactory=" + readerFactory);
        }
        String packageRootPath = oracleInstancePath + File.separatorChar + PACKAGE_SUB_PATH;
        File checkPath = new File(packageRootPath);
        try {
            if (!checkPath.exists() && !checkPath.mkdirs()) {
                this.m_logger.log(Level.WARNING, "MAS-40373", packageRootPath);
                throw new IncidentManagementException("40373", packageRootPath);
            }
            this.m_packageRootPath = packageRootPath;
        }
        catch (SecurityException e) {
            this.m_logger.log(Level.WARNING, "MAS-40373", packageRootPath);
            throw new IncidentManagementException("40373", packageRootPath, e);
        }
        this.m_logger = LoggerFactory.getFrameworkLogger();
        this.m_oracleInstancePath = oracleInstancePath;
        this.m_dumpReaderFactory = readerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String packageIncident(Incident incident) throws IncidentManagementException {
        this.m_logger.log(Level.FINER, "Packaging incident " + incident.getIncidentId());
        String packageDirectory = this.m_packageRootPath + File.separatorChar + System.currentTimeMillis();
        File packageFile = new File(packageDirectory);
        try {
            if (!packageFile.exists() && !packageFile.mkdir()) {
                this.m_logger.log(Level.WARNING, "MAS-40373", packageDirectory);
                throw new IncidentManagementException("40373", packageDirectory);
            }
        }
        catch (SecurityException e) {
            this.m_logger.log(Level.WARNING, "MAS-40373", packageDirectory);
            throw new IncidentManagementException("40373", packageDirectory, e);
        }
        try {
            this.m_readme.append("Incident Id: " + incident.getIncidentId());
            this.m_readme.append("\nIncident Status: " + (Object)((Object)incident.getStatus()));
            this.m_readme.append("\nIncident Source: " + (Object)((Object)incident.getIncidentSource()));
            this.m_readme.append("\nIncident Time: " + new Date(incident.getTimeOfIncident()));
            this.m_readme.append("\nProblem Key: " + incident.getProblemKey());
            if (incident.getProblemImpacts() != null) {
                StringBuilder buf = new StringBuilder();
                for (DiagnosticsCategory impact : incident.getProblemImpacts()) {
                    buf.append((Object)impact);
                    buf.append(' ');
                }
                if (buf.length() > 0) {
                    this.m_readme.append("\nProblem Impacts: " + buf);
                }
            }
            if (incident.getErrorMessage() != null) {
                this.m_readme.append("\nError Message: " + incident.getErrorMessage());
            }
            if (incident.getDescription() != null) {
                this.m_readme.append("\nDescription:\n" + incident.getDescription());
            }
            this.createPackageFile(packageDirectory, incident.getIncidentId());
            this.packageDumps(packageDirectory, incident);
            this.addStringAsFile(incident.toXML(), "incident.xml");
            this.addStringAsFile(this.m_readme.toString(), "README");
        }
        finally {
            if (this.m_zipStream != null) {
                try {
                    this.m_zipStream.close();
                }
                catch (Exception e) {}
            }
        }
        this.m_logger.log(Level.INFO, "MAS-40378", new Object[]{this.m_packageFile, incident.getIncidentId()});
        return this.m_packageFile;
    }

    public static void removePackageFiles(String packageFile) throws IOException {
        File zipFile = new File(packageFile);
        if (zipFile.exists() && zipFile.isFile()) {
            File parentDir = zipFile.getParentFile();
            File[] packageFiles = parentDir.listFiles();
            int len = packageFiles.length;
            for (int i = 0; i < len; ++i) {
                packageFiles[i].delete();
            }
            parentDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageDumps(String packageDirectory, Incident incident) {
        List<IncidentDump> dumps = incident.getIncidentDumps();
        if (dumps == null) {
            return;
        }
        this.m_readme.append("\n\nDiagnostic Dumps:");
        ArrayList<DumpFetcher> fetchers = new ArrayList<DumpFetcher>();
        int dumpCount = 1;
        for (IncidentDump dump : dumps) {
            String dumpName = dump.getDumpName().replace('.', '_') + dumpCount++ + dump.getDumpFileExtension();
            String filename = packageDirectory + File.separatorChar + dumpName;
            fetchers.add(new DumpFetcher(dump, filename));
            this.m_readme.append("\n\nName: " + dump.getDumpName());
            if (dump.getDumpArguments() != null && dump.getDumpArguments().length() > 0) {
                this.m_readme.append("\nDump Arguments: " + dump.getDumpArguments());
            }
            if (dump.getTopologyNodePath() != null && dump.getTopologyNodePath().length() > 0) {
                this.m_readme.append("\nContext Topology Node: " + dump.getTopologyNodePath());
            }
            this.m_readme.append("\nPackage File: " + dumpName);
        }
        if (fetchers.size() == 0) {
            return;
        }
        ExecutorService pool = Executors.newFixedThreadPool(3);
        ArrayList<String> files = new ArrayList<String>();
        String dumpFilename = null;
        try {
            List futures = pool.invokeAll(fetchers);
            boolean i = false;
            for (Future future : futures) {
                dumpFilename = (String)future.get();
                files.add(dumpFilename);
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "MAS-40375", e.getMessage());
        }
        finally {
            if (pool != null && !pool.isShutdown()) {
                pool.shutdownNow();
            }
        }
        for (String filename : files) {
            BufferedInputStream buffIn = null;
            try {
                int count;
                buffIn = new BufferedInputStream(new FileInputStream(filename), 129472);
                String name = filename.substring(filename.lastIndexOf(File.separatorChar) + 1);
                ZipEntry entry = new ZipEntry(name);
                this.m_zipStream.putNextEntry(entry);
                byte[] data = new byte[129472];
                while ((count = buffIn.read(data, 0, 129472)) != -1) {
                    if (count < 129472) {
                        byte[] aux = new byte[count];
                        System.arraycopy(data, 0, aux, 0, count);
                        this.m_zipStream.write(aux, 0, count);
                        continue;
                    }
                    this.m_zipStream.write(data, 0, count);
                }
            }
            catch (Exception e) {
                this.m_logger.log(Level.WARNING, "MAS-40376", e.getMessage());
            }
            finally {
                if (buffIn == null) continue;
                try {
                    buffIn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void createPackageFile(String packageDirectory, String incidentId) throws IncidentManagementException {
        this.m_packageFile = packageDirectory + File.separatorChar + incidentId + DEFAULT_PACKAGE_EXTENSION;
        try {
            FileOutputStream dest = new FileOutputStream(this.m_packageFile);
            this.m_zipStream = new ZipOutputStream(new BufferedOutputStream(dest));
        }
        catch (Exception e) {
            throw new IncidentManagementException("40377", this.m_packageFile, e);
        }
    }

    private void addStringAsFile(String stringToAdd, String filename) {
        try {
            ZipEntry entry = new ZipEntry(filename);
            this.m_zipStream.putNextEntry(entry);
            this.m_zipStream.write(stringToAdd.getBytes());
        }
        catch (IOException e) {
            this.m_logger.log(Level.WARNING, "MAS-40376", e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DumpFetcher
    implements Callable<String> {
        private IncidentDump m_dump;
        private String m_packageFilename;
        private boolean m_cancel = false;

        public DumpFetcher(IncidentDump dump, String packageFilename) {
            this.m_dump = dump;
            this.m_packageFilename = packageFilename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            Closeable reader = null;
            FilterOutputStream buffOut = null;
            try {
                byte[] data;
                buffOut = new BufferedOutputStream(new FileOutputStream(this.m_packageFilename), 129472);
                reader = IncidentPackager.this.m_dumpReaderFactory.createDumpReader(this.m_dump.getOracleInstanceId(), this.m_dump.getDumpId(), this.m_dump.getDumpPath(), false);
                while (!this.m_cancel && (data = reader.getDumpOutput(129472)) != null) {
                    if (data.length == 0) {
                        break;
                    }
                    buffOut.write(data);
                }
            }
            catch (Exception e) {
                IncidentPackager.this.m_logger.log(Level.WARNING, "MAS-40375", e.getMessage());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
                if (buffOut != null) {
                    try {
                        buffOut.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return this.m_packageFilename;
        }

        String getFilename() {
            return this.m_packageFilename;
        }

        void cancel() {
            this.m_cancel = true;
        }
    }
}

