/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.core.ojdl.query.AndCondition;
import oracle.core.ojdl.query.Condition;
import oracle.core.ojdl.query.SimpleCondition;
import oracle.dfw.incident.IncidentRulesException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogDetectionConditionParser {
    private Exception m_errorParsing = null;
    private DocumentBuilderFactory m_schemaFactory = DocumentBuilderFactory.newInstance();
    private static final String SCHEMA_FILE = "/oracle/dfw/incident/diagnostic_rules.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String LOG_CONDITIONS = "logDetectionConditions";
    private static final String LOG_CONDITION = "condition";
    private static final String MESSAGE_SEVERITY = "messageSeverity";
    private static final String MESSAGE_FACILITY = "messageFacility";
    private static final String MESSAGE_NUMBER = "messageNumber";
    private static final char MESSAGE_SEPARATOR = '-';

    public LogDetectionConditionParser() throws IncidentRulesException {
        this.m_schemaFactory.setNamespaceAware(true);
        this.m_schemaFactory.setValidating(true);
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        URL defaultSchema = this.getClass().getResource(SCHEMA_FILE);
        if (defaultSchema == null) {
            throw new IncidentRulesException("40368", SCHEMA_FILE);
        }
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
    }

    public List<Condition> parse(Reader conditions) throws Exception {
        NodeList conditionsList;
        this.m_errorParsing = null;
        DocumentBuilder parser = this.m_schemaFactory.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) {
            }

            public void error(SAXParseException exception) {
                LogDetectionConditionParser.this.m_errorParsing = exception;
            }

            public void fatalError(SAXParseException exception) {
                LogDetectionConditionParser.this.m_errorParsing = exception;
            }
        });
        InputSource source = new InputSource(conditions);
        Document document = parser.parse(source);
        if (this.m_errorParsing != null) {
            throw new IncidentRulesException("40370", this.m_errorParsing);
        }
        if (document == null) {
            throw new IncidentRulesException("40370");
        }
        Element diagnosticRules = document.getDocumentElement();
        if (diagnosticRules == null) {
            throw new IncidentRulesException("40370");
        }
        ArrayList<Condition> parsedConditions = new ArrayList<Condition>();
        NodeList logConditions = diagnosticRules.getElementsByTagName(LOG_CONDITIONS);
        if (logConditions != null && logConditions.getLength() > 0 && (conditionsList = ((Element)logConditions.item(0)).getElementsByTagName(LOG_CONDITION)) != null && conditionsList.getLength() > 0) {
            int len = conditionsList.getLength();
            for (int i = 0; i < len; ++i) {
                String msgNumber;
                String msgFacility;
                Element conditionElement = (Element)conditionsList.item(i);
                String severity = conditionElement.getAttribute(MESSAGE_SEVERITY);
                Condition con = this.buildLogCondition(severity, msgFacility = conditionElement.getAttribute(MESSAGE_FACILITY), msgNumber = conditionElement.getAttribute(MESSAGE_NUMBER));
                if (con == null) continue;
                parsedConditions.add(con);
            }
        }
        return parsedConditions;
    }

    private Condition buildLogCondition(String severity, String msgFacility, String msgNumber) {
        SimpleCondition c1 = null;
        if (severity != null && severity.length() > 0) {
            c1 = new SimpleCondition("MSG_TYPE", severity, 4);
        }
        if (msgFacility != null && msgFacility.length() > 0) {
            SimpleCondition c2 = null;
            if (msgNumber != null && msgNumber.length() > 0) {
                String msgId = msgFacility + '-' + msgNumber;
                c2 = new SimpleCondition("MSG_ID", msgId, 1);
            } else {
                c2 = new SimpleCondition("MSG_ID", msgFacility, 3);
            }
            c1 = c1 != null ? new AndCondition(c2, c1) : c2;
        }
        return c1;
    }
}

