/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.resource.DiagnosticConstants;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.util.DMSProperties;

public final class DumpResult
implements Serializable,
DiagnosticConstants {
    private byte[] m_output;
    private String m_dumpLocation;
    private String m_dumpID;
    private DumpContext m_dumpContext;
    private String m_externalDumpLocation;
    private String m_processDpsId;
    private String m_targetFileExtension = ".dmp";
    private static final String DEFAULT_DUMP_FILE_EXTENSION = ".dmp";
    private static ResourceBundle RBL = new DiagnosticTranslation();
    private static final String[] DUMP_RESULT_COMPOSITE_TYPE_FIELDS;
    private static final String[] DUMP_RESULT_COMPOSITE_TYPE_FIELD_DESCRIPTIONS;
    private static CompositeType TMP;
    private static final CompositeType DUMP_RESULT_COMPOSITE_TYPE;

    public DumpResult(DumpContext context, String dumpLocation, String dumpID) {
        if (context == null || dumpLocation == null || dumpID == null) {
            throw new IllegalArgumentException("Invalid arguments: context=" + context + " dumpLocation=" + dumpLocation + " dumpID=" + dumpID);
        }
        this.m_dumpLocation = dumpLocation;
        this.m_dumpID = dumpID;
        this.m_dumpContext = context;
        this.m_processDpsId = DMSProperties.getProperty("oracle.dps.entityid");
    }

    public String getDumpLocation() {
        return this.m_dumpLocation;
    }

    public String getDumpId() {
        return this.m_dumpID;
    }

    public DumpContext getDumpContext() {
        return this.m_dumpContext;
    }

    public String getExternalDumpLocation() {
        return this.m_externalDumpLocation;
    }

    public void setExternalDumpLocation(String externalDumpFile) {
        this.m_externalDumpLocation = externalDumpFile;
    }

    public String getProcessDpsId() {
        return this.m_processDpsId;
    }

    public void setProcessDpsId(String processDpsId) {
        this.m_processDpsId = processDpsId;
    }

    public byte[] getDumpOutput() {
        return this.m_output;
    }

    public void setDumpOutput(byte[] output) {
        this.m_output = output;
    }

    public String getDumpFileExtension() {
        return this.m_targetFileExtension;
    }

    public void setDumpFileExtension(String extension) {
        if (extension != null) {
            this.m_targetFileExtension = extension;
        }
    }

    public CompositeData toCompositeData() throws OpenDataException {
        Byte[] bt;
        byte[] b = this.getDumpOutput();
        Byte[] byteArray = bt = b == null ? null : new Byte[b.length];
        if (bt != null) {
            for (int i = 0; i < b.length; ++i) {
                bt[i] = new Byte(b[i]);
            }
        }
        CompositeDataSupport compositeResult = new CompositeDataSupport(DUMP_RESULT_COMPOSITE_TYPE, DUMP_RESULT_COMPOSITE_TYPE_FIELDS, new Object[]{this.getDumpId(), this.getDumpLocation(), this.getExternalDumpLocation(), this.getProcessDpsId(), bt});
        return compositeResult;
    }

    public static DumpResult fromCompositeData(CompositeData cd) {
        byte[] dumpOutput;
        Object[] values = cd.getAll(DUMP_RESULT_COMPOSITE_TYPE_FIELDS);
        String dumpId = (String)values[0];
        String dumpLocation = (String)values[1];
        String externalLocation = (String)values[2];
        String procId = (String)values[3];
        Byte[] bt = (Byte[])values[4];
        byte[] byArray = dumpOutput = bt == null ? null : new byte[bt.length];
        if (dumpOutput != null) {
            for (int i = 0; i < bt.length; ++i) {
                dumpOutput[i] = bt[i];
            }
        }
        DumpResult dr = new DumpResult(DumpContext.createDumpContext(dumpId), dumpLocation, dumpId);
        dr.setExternalDumpLocation(externalLocation);
        dr.setDumpOutput(dumpOutput);
        dr.setProcessDpsId(procId);
        return dr;
    }

    static {
        try {
            RBL = ResourceBundle.getBundle(DiagnosticTranslation.class.getName());
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        DUMP_RESULT_COMPOSITE_TYPE_FIELDS = new String[]{"DumpID", "DumpLocation", "DumpExternalLocation", "ProcessId", "DumpOutput"};
        DUMP_RESULT_COMPOSITE_TYPE_FIELD_DESCRIPTIONS = RBL.getStringArray("DFW_DUMP_RESULT_COMPOSITE_TYPE_FIELD_DESCRIPTIONS");
        try {
            TMP = new CompositeType("DumpResultType", "Dump Result", DUMP_RESULT_COMPOSITE_TYPE_FIELDS, DUMP_RESULT_COMPOSITE_TYPE_FIELD_DESCRIPTIONS, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.BYTE)});
        }
        catch (Exception exception) {
            // empty catch block
        }
        DUMP_RESULT_COMPOSITE_TYPE = TMP;
    }
}

