/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.logging.Level;
import oracle.core.ojdl.MessageType;

public class ODLLevel
extends Level {
    public static Level TRACE = Level.FINE;
    public static Level NOTIFICATION = Level.INFO;
    public static Level WARNING = Level.WARNING;
    public static Level ERROR = Level.SEVERE;
    public static Level INCIDENT_ERROR;
    public static Level INTERNAL_ERROR;

    public static MessageType getMsgTypeAndLevel(Level level, int[] msgLevel) {
        int intLevel = level.intValue();
        if (intLevel <= Level.FINEST.intValue()) {
            msgLevel[0] = 32;
            return MessageType.TRACE;
        }
        if (intLevel <= Level.FINER.intValue()) {
            msgLevel[0] = 16 + ODLLevel.getArbLevel(intLevel, Level.FINER, Level.FINEST, 16);
            return MessageType.TRACE;
        }
        if (intLevel <= Level.FINE.intValue()) {
            msgLevel[0] = 1 + ODLLevel.getArbLevel(intLevel, Level.FINE, Level.FINER, 15);
            return MessageType.TRACE;
        }
        if (intLevel <= Level.CONFIG.intValue()) {
            msgLevel[0] = 16 + ODLLevel.getArbLevel(intLevel, Level.CONFIG, Level.FINE, 17);
            return MessageType.NOTIFICATION;
        }
        if (intLevel <= Level.INFO.intValue()) {
            msgLevel[0] = 1 + ODLLevel.getArbLevel(intLevel, Level.INFO, Level.CONFIG, 15);
            return MessageType.NOTIFICATION;
        }
        if (intLevel <= Level.WARNING.intValue()) {
            msgLevel[0] = 1 + ODLLevel.getArbLevel(intLevel, Level.WARNING, Level.INFO, 32);
            return MessageType.WARNING;
        }
        if (intLevel <= Level.SEVERE.intValue()) {
            msgLevel[0] = 1 + ODLLevel.getArbLevel(intLevel, Level.SEVERE, Level.WARNING, 32);
            return MessageType.ERROR;
        }
        if (intLevel <= INCIDENT_ERROR.intValue()) {
            msgLevel[0] = 1 + ODLLevel.getArbLevel(intLevel, INCIDENT_ERROR, Level.SEVERE, 32);
            return MessageType.INCIDENT_ERROR;
        }
        msgLevel[0] = 1;
        return MessageType.UNKNOWN;
    }

    public static Level getLevel(MessageType msgType, int level) {
        if (msgType == MessageType.TRACE) {
            if (level < 16) {
                return ODLLevel.getLevel(Level.FINE, Level.FINER, 15, level);
            }
            if (level < 32) {
                return ODLLevel.getLevel(Level.FINER, Level.FINEST, 16, level - 15);
            }
            return Level.FINEST;
        }
        if (msgType == MessageType.NOTIFICATION) {
            if (level < 16) {
                return ODLLevel.getLevel(Level.INFO, Level.CONFIG, 15, level);
            }
            return ODLLevel.getLevel(Level.CONFIG, Level.FINE, 17, level - 15);
        }
        if (msgType == MessageType.WARNING) {
            return ODLLevel.getLevel(Level.WARNING, Level.INFO, 32, level);
        }
        if (msgType == MessageType.ERROR) {
            return ODLLevel.getLevel(Level.SEVERE, Level.WARNING, 32, level);
        }
        return ODLLevel.getLevel(INCIDENT_ERROR, Level.SEVERE, 32, level);
    }

    public static Level parse(String str) {
        int intLev;
        String strLev;
        String strType;
        int indx = str.indexOf(58);
        if (indx >= 0) {
            strType = str.substring(0, indx);
            strLev = str.substring(indx + 1);
        } else {
            strType = str;
            strLev = "1";
        }
        try {
            intLev = Integer.parseInt(strLev);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid argument: " + str);
        }
        if (intLev <= 0 || intLev > 32) {
            throw new IllegalArgumentException("Invalid argument: " + str);
        }
        MessageType t = MessageType.getMessageType(strType);
        if (t == MessageType.UNKNOWN) {
            return Level.parse(str);
        }
        return ODLLevel.getLevel(MessageType.getMessageType(strType), intLev);
    }

    public static String toString(Level level) {
        int[] msgLevel = new int[1];
        MessageType t = ODLLevel.getMsgTypeAndLevel(level, msgLevel);
        return t == MessageType.UNKNOWN ? MessageType.UNKNOWN.toString() : t.toString() + ":" + String.valueOf(msgLevel[0]);
    }

    private static Level getLevel(Level l1, Level l2, int c, int n) {
        int v = l1.intValue() + (l2.intValue() - l1.intValue()) / c * (n - 1);
        return Level.parse(Integer.toString(v));
    }

    private static final int getArbLevel(int n, Level l1, Level l2, int c) {
        int val = (n - l1.intValue()) / ((l2.intValue() - l1.intValue()) / c);
        return val < c ? val : c - 1;
    }

    protected ODLLevel(String name, int value) {
        super(name, value, null);
    }

    static {
        INTERNAL_ERROR = INCIDENT_ERROR = Level.parse(Integer.toString(Level.SEVERE.intValue() + 100));
    }
}

