/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Date;
import java.util.Map;
import oracle.core.ojdl.DateFormat;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.util.XMLUtil;

public class XMLFormatter
implements LogFormatter {
    private static final String LSEP = System.getProperty("line.separator");
    private static final String TAB = "  ";
    private static final String TAB2 = "    ";
    private static final String TAB3 = "      ";
    private boolean m_escapeChars = true;
    private boolean m_useHeadAndTail = false;
    private DateFormat m_dateFmt = new DateFormat();
    private Date m_date = new Date(0L);

    public XMLFormatter(boolean useHeadAndTail) {
        String escapeProp = LogManager.getLogManager().getProperty("XMLFormatter.escapeChars", "true");
        this.m_escapeChars = escapeProp.equals("true");
        this.m_useHeadAndTail = useHeadAndTail;
    }

    public XMLFormatter() {
        this(false);
    }

    public String format(LogMessage msg) {
        String supplDet;
        Map map;
        StringBuffer buf = new StringBuffer(2000);
        buf.append("<MESSAGE>");
        buf.append(LSEP);
        buf.append(TAB);
        buf.append("<HEADER>");
        buf.append(LSEP);
        buf.append(TAB2);
        buf.append("<TSTZ_ORIGINATING>");
        this.m_date.setTime(msg.getTimestamp());
        this.m_dateFmt.format(this.m_date, buf);
        buf.append("</TSTZ_ORIGINATING>");
        buf.append(LSEP);
        if (msg.getOrganizationId() != null) {
            buf.append("    <ORG_ID>" + msg.getOrganizationId() + "</ORG_ID>" + LSEP);
        }
        if (msg.getComponentId() != null) {
            buf.append("    <COMPONENT_ID>" + msg.getComponentId() + "</COMPONENT_ID>" + LSEP);
        } else {
            buf.append("    <COMPONENT_ID>null</COMPONENT_ID>" + LSEP);
        }
        if (msg.getInstanceId() != null) {
            buf.append("    <INSTANCE_ID>" + msg.getInstanceId() + "</INSTANCE_ID>" + LSEP);
        }
        if (msg.getMessageId() != null) {
            buf.append("    <MSG_ID>" + msg.getMessageId() + "</MSG_ID>" + LSEP);
        }
        if (msg.getHostingClientId() != null) {
            buf.append("    <HOSTING_CLIENT_ID>" + msg.getHostingClientId() + "</HOSTING_CLIENT_ID>" + LSEP);
        }
        if (msg.getMessageType() != null) {
            buf.append("    <MSG_TYPE TYPE=\"" + msg.getMessageType().toString() + "\"></MSG_TYPE>" + LSEP);
        } else {
            buf.append("    <MSG_TYPE TYPE=\"UNKNOWN\"></MSG_TYPE>" + LSEP);
        }
        if (msg.getMessageGroup() != null) {
            buf.append("    <MSG_GROUP>" + msg.getMessageGroup() + "</MSG_GROUP>" + LSEP);
        }
        buf.append("    <MSG_LEVEL>" + msg.getMessageLevel() + "</MSG_LEVEL>" + LSEP);
        if (msg.getHostId() != null) {
            buf.append("    <HOST_ID>" + msg.getHostId() + "</HOST_ID>" + LSEP);
        }
        if (msg.getHostNwAddr() != null) {
            buf.append("    <HOST_NWADDR>" + msg.getHostNwAddr() + "</HOST_NWADDR>" + LSEP);
        }
        if (msg.getModuleId() != null) {
            buf.append("    <MODULE_ID>" + msg.getModuleId() + "</MODULE_ID>" + LSEP);
        }
        if (msg.getProcessId() != null) {
            buf.append("    <PROCESS_ID>" + msg.getProcessId() + "</PROCESS_ID>" + LSEP);
        }
        if (msg.getThreadId() != null) {
            buf.append("    <THREAD_ID>" + msg.getThreadId() + "</THREAD_ID>" + LSEP);
        }
        if (msg.getUserId() != null) {
            buf.append("    <USER_ID>" + msg.getUserId() + "</USER_ID>" + LSEP);
        }
        if ((map = msg.getSupplAttrs()) != null && !map.isEmpty()) {
            buf.append("    <SUPPL_ATTRS>" + LSEP);
            for (String name : map.keySet()) {
                buf.append("      <ATTR NAME=\"" + name + "\">");
                Object v = map.get(name);
                if (v != null) {
                    buf.append(v.toString());
                }
                buf.append("</ATTR>" + LSEP);
            }
            buf.append("    </SUPPL_ATTRS>" + LSEP);
        }
        buf.append("  </HEADER>" + LSEP);
        if (msg.getUpstreamCompId() != null || msg.getDownstreamCompId() != null || msg.getExecContextId() != null || msg.getErrorInstanceId() != null) {
            buf.append("  <CORRELATION_DATA>" + LSEP);
            if (msg.getUpstreamCompId() != null) {
                buf.append("    <UPSTREAM_COMPONENT_ID>" + msg.getUpstreamCompId() + "</UPSTREAM_COMPONENT_ID>" + LSEP);
            }
            if (msg.getDownstreamCompId() != null) {
                buf.append("    <DOWNSTREAM_COMPONENT_ID>" + msg.getDownstreamCompId() + "</DOWNSTREAM_COMPONENT_ID>" + LSEP);
            }
            if (msg.getExecContextId() != null) {
                buf.append("    <EXEC_CONTEXT_ID><UNIQUE_ID>" + msg.getExecContextId().getUniqueId() + "</UNIQUE_ID><SEQ>" + msg.getExecContextId().getRID() + "</SEQ></EXEC_CONTEXT_ID>" + LSEP);
            }
            if (msg.getErrorInstanceId() != null) {
                buf.append("    <EID><UNIQUE_ID>" + msg.getErrorInstanceId().getUniqueId() + "</UNIQUE_ID><SEQ>" + msg.getErrorInstanceId().getRID() + "</SEQ></EID>" + LSEP);
            }
            buf.append("  </CORRELATION_DATA>" + LSEP);
        }
        buf.append("  <PAYLOAD>" + LSEP);
        String msgText = msg.getMessageText();
        buf.append("    <MSG_TEXT>");
        if (this.m_escapeChars) {
            XMLUtil.escapeXMLchars(msgText, buf);
        } else {
            buf.append(msgText);
        }
        buf.append("</MSG_TEXT>" + LSEP);
        if (msg.getMessageArgs() != null) {
            LogMessage.MessageArgument[] args = msg.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                buf.append("    <MSG_ARGS>" + LSEP);
                if (args[i].getName() != null) {
                    buf.append("      <NAME>" + args[i].getName() + "</NAME>" + LSEP);
                }
                buf.append("      <VALUE>");
                if (this.m_escapeChars) {
                    XMLUtil.escapeXMLchars(args[i].getValue(), buf);
                } else {
                    buf.append(args[i].getValue());
                }
                buf.append("</VALUE>" + LSEP);
                buf.append("    </MSG_ARGS>" + LSEP);
            }
        }
        if (msg.getDetailLocation() != null) {
            buf.append("    <DETAIL_PATH>" + msg.getDetailLocation() + "</DETAIL_PATH>" + LSEP);
        }
        if ((supplDet = msg.getSupplDetail()) != null) {
            buf.append("    <SUPPL_DETAIL>");
            if (supplDet.indexOf("]]>") < 0) {
                buf.append("<![CDATA[");
                buf.append(supplDet);
                buf.append("]]>");
            } else if (this.m_escapeChars) {
                XMLUtil.escapeXMLchars(supplDet, buf);
            } else {
                buf.append(supplDet);
            }
            buf.append("</SUPPL_DETAIL>" + LSEP);
        }
        buf.append("  </PAYLOAD>" + LSEP + "</MESSAGE>" + LSEP);
        return buf.toString();
    }

    public String header() {
        if (this.m_useHeadAndTail) {
            return "<?xml version='1.0'?>" + LSEP + "<LOG>" + LSEP;
        }
        return "";
    }

    public String tail() {
        if (this.m_useHeadAndTail) {
            return "</LOG>" + LSEP;
        }
        return "";
    }
}

