/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import oracle.core.ojdl.BufferedLogWriter;
import oracle.core.ojdl.FileLogWriterException;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.RotationSupport;
import oracle.core.ojdl.SimpleFormatter;

public class FileLogWriter
extends BufferedLogWriter
implements RotationSupport {
    private static final int MAX_TRIES = 1;
    String m_canonicalPath;
    private File m_logFile;
    private boolean m_keepOpen = true;
    private FileOutputStream m_out;
    private long m_logSize;
    private String m_basename;
    private String m_extension;
    private File m_logDir;
    private long m_maxSegSize;
    private long m_maxSize;
    private boolean m_deleteFiles = true;
    private static final long FREQUENCY_UNIT = 60000L;
    private static final long MAX_FREQUENCY = 128849018820000L;
    private static final long RETENTION_UNIT = 60000L;
    private static final long MAX_RETENTION = 128849018820000L;
    private long m_baseTime = 0L;
    private long m_rotationFrequency = 128849018820000L;
    private long m_nextRotationTime = Long.MAX_VALUE;
    private long m_lastRotationTime;
    private long m_retentionPeriod = 128849018820000L;
    private int m_createCount = 0;
    private static Hashtable s_instances = new Hashtable();
    private Comparator m_comparator = new SegmentComparator();

    FileLogWriter(LogFormatter formatter, File logFile, File logDir, boolean useStandardNamingScheme, String canonicalPath, long maxSegSize, long maxSize, String encoding) throws FileLogWriterException {
        super(formatter, encoding);
        this.m_logFile = logFile;
        this.m_logDir = logDir;
        this.m_canonicalPath = canonicalPath;
        this.m_basename = logFile.getName();
        if (useStandardNamingScheme && this.m_basename.length() > 4 && (this.m_basename.endsWith(".log") || this.m_basename.endsWith(".xml") || this.m_basename.endsWith(".trc"))) {
            this.m_extension = this.m_basename.substring(this.m_basename.length() - 4);
            this.m_basename = this.m_basename.substring(0, this.m_basename.length() - 4);
        }
        this.m_maxSegSize = maxSegSize;
        this.m_maxSize = maxSize;
        this.m_createCount = 1;
        this.m_lastRotationTime = this.m_logFile.exists() ? this.m_logFile.lastModified() : System.currentTimeMillis();
        if (this.m_keepOpen) {
            try {
                this.m_out = this.getFileOutputStream();
            }
            catch (IOException e) {
                throw new FileLogWriterException(e);
            }
            this.m_logSize = this.m_logFile.length();
        }
    }

    public static FileLogWriter create(String filename, long maxSegmentSize, long maxSize, String encoding) throws FileLogWriterException {
        return FileLogWriter.create(new SimpleFormatter(), filename, maxSegmentSize, maxSize, encoding);
    }

    public static FileLogWriter create(LogFormatter formatter, String filename, long maxSegmentSize, long maxSize, String encoding) throws FileLogWriterException {
        return FileLogWriter.create(formatter, filename, false, maxSegmentSize, maxSize, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLogWriter create(LogFormatter formatter, String filename, boolean useStandardNamingScheme, long maxSegmentSize, long maxSize, String encoding) throws FileLogWriterException {
        String canonicalPath;
        if (maxSegmentSize <= 0L) {
            throw new FileLogWriterException("Invalid argument: maximum segment size must be greater than zero.");
        }
        if (maxSize <= 0L) {
            throw new FileLogWriterException("Invalid argument: maximum size must be greater than zero.");
        }
        if (maxSize < maxSegmentSize) {
            throw new FileLogWriterException("Invalid arguments: maximum segment size greater than maximum bus stop size");
        }
        File logFile = new File(filename);
        File logDir = FileLogWriter.getLogDirectory(logFile);
        if (encoding != null) {
            LogManager.getLogManager();
            if (LogManager.checkEncoding(encoding) == null) {
                throw new FileLogWriterException("Invalid encoding: " + encoding);
            }
        } else {
            encoding = LogManager.getLogManager().getEncoding();
        }
        try {
            canonicalPath = logFile.getCanonicalPath();
        }
        catch (IOException e) {
            canonicalPath = logFile.getAbsolutePath();
        }
        Class<FileLogWriter> clazz = FileLogWriter.class;
        synchronized (FileLogWriter.class) {
            FileLogWriter writer = FileLogWriter.getInstance(canonicalPath);
            if (writer == null) {
                writer = new FileLogWriter(formatter, logFile, logDir, useStandardNamingScheme, canonicalPath, maxSegmentSize, maxSize, encoding);
                s_instances.put(canonicalPath, writer);
            }
            // ** MonitorExit[var12_11] (shouldn't be in output)
            return writer;
        }
    }

    static FileLogWriter getInstance(String path) {
        FileLogWriter writer = (FileLogWriter)s_instances.get(path);
        if (writer != null) {
            ++writer.m_createCount;
        }
        return writer;
    }

    static void putInstance(String path, FileLogWriter writer) {
        s_instances.put(path, writer);
    }

    public static FileLogWriter create(String filename) throws FileLogWriterException {
        return FileLogWriter.create(filename, Long.MAX_VALUE, Long.MAX_VALUE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (!this.isOpened()) {
            this.handleException(new LoggingException("Attempt to close an already closed LogWriter"));
            return;
        }
        if (--this.m_createCount > 0) {
            this.flush();
            return;
        }
        super.close();
        try {
            if (this.m_keepOpen && this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        finally {
            this.m_out = null;
            this.m_logSize = 0L;
            this.m_logFile = null;
            s_instances.remove(this.m_canonicalPath);
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.m_canonicalPath;
    }

    protected void writeBytes(byte[] bytes, int offset, int length) {
        if (!this.isOpened()) {
            this.handleException(new LoggingException("Attempt to write to a closed LogWriter"));
            return;
        }
        try {
            long logLength = this.getLogSize();
            if (this.needRotation(logLength, length)) {
                Vector segmentFiles = this.getSegmentFiles(this.m_logDir);
                long currentTime = System.currentTimeMillis();
                long[] pair = this.getTotalSizeAndMinTime(logLength, segmentFiles);
                long size = pair[0];
                long minTime = pair[1];
                boolean deleteOldFiles = false;
                if (this.m_maxSize != Long.MAX_VALUE && size > this.m_maxSize - this.m_maxSegSize) {
                    if (!this.m_deleteFiles) {
                        this.handleException(new LoggingException("Reached maximum log size"));
                        return;
                    }
                    deleteOldFiles = true;
                } else if (this.m_deleteFiles && this.m_retentionPeriod != 128849018820000L && currentTime - minTime > this.m_retentionPeriod) {
                    deleteOldFiles = true;
                }
                if (this.rotate(logLength, segmentFiles) && deleteOldFiles) {
                    try {
                        this.deleteFiles(size, currentTime, segmentFiles);
                    }
                    catch (Exception e) {
                        this.handleException(new LoggingException("cannot delete old segment file"));
                    }
                }
            }
            this.writeToStream(bytes, offset, length);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void rotateLog() {
        if (!this.isOpened()) {
            this.handleException(new LoggingException("Attempt to operate on a closed LogWriter"));
            return;
        }
        try {
            this.rotate(this.getLogSize(), this.getSegmentFiles(this.m_logDir));
            this.m_logFile.createNewFile();
            if (this.m_keepOpen) {
                this.m_out = this.getFileOutputStream();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void setMaxSize(long maxSize) {
        if (maxSize > 0L && maxSize >= this.getMaxSegmentSize()) {
            this.m_maxSize = maxSize;
        }
    }

    public long getMaxSize() {
        return this.m_maxSize;
    }

    public synchronized void setMaxSegmentSize(long maxSegmentSize) {
        if (maxSegmentSize > 0L && maxSegmentSize <= this.getMaxSize()) {
            this.m_maxSegSize = maxSegmentSize;
        }
    }

    public long getMaxSegmentSize() {
        return this.m_maxSegSize;
    }

    public void setBaseRotationTime(long baseTime) {
        this.m_baseTime = baseTime;
        this.m_nextRotationTime = this.getNextRotationTime();
    }

    public long getBaseRotationTime() {
        return this.m_baseTime;
    }

    public void setRotationFrequency(int frequency) {
        if (frequency <= 0) {
            throw new IllegalArgumentException("frequency: " + frequency);
        }
        this.m_rotationFrequency = (long)frequency * 60000L;
        this.m_nextRotationTime = this.getNextRotationTime();
    }

    public int getRotationFrequency() {
        return (int)(this.m_rotationFrequency / 60000L);
    }

    public void setRetentionPeriod(int retentionPeriod) {
        if (retentionPeriod < 0) {
            throw new IllegalArgumentException("retentionPeriod: " + retentionPeriod);
        }
        this.m_retentionPeriod = (long)retentionPeriod * 60000L;
    }

    public int getRetentionPeriod() {
        return (int)(this.m_retentionPeriod / 60000L);
    }

    public void setDeleteFiles(boolean deleteFiles) {
        this.m_deleteFiles = deleteFiles;
    }

    public boolean getDeleteFiles() {
        return this.m_deleteFiles;
    }

    public boolean getKeepOpen() {
        return this.m_keepOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepOpen(boolean keepOpen) {
        if (keepOpen == this.m_keepOpen) {
            return;
        }
        if (this.m_keepOpen && this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (IOException e) {
                this.handleException(e);
            }
            finally {
                this.m_out = null;
                this.m_logSize = 0L;
            }
        }
        this.m_keepOpen = keepOpen;
    }

    private boolean isOpened() {
        return this.m_logFile != null;
    }

    private FileOutputStream getFileOutputStream() throws IOException {
        return new FileOutputStream(this.m_logFile.getAbsolutePath(), true);
    }

    private void writeToStream(byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream out;
        if (!this.m_keepOpen) {
            out = this.getFileOutputStream();
        } else {
            if (this.m_out == null) {
                this.m_out = this.getFileOutputStream();
            }
            out = this.m_out;
        }
        out.write(bytes, offset, length);
        this.m_logSize += (long)length;
        if (!this.m_keepOpen) {
            out.close();
        }
    }

    private long getLogSize() {
        if (this.m_keepOpen && this.m_out != null) {
            return this.m_logSize;
        }
        return this.m_logFile.length();
    }

    private boolean needRotation(long logLength, int length) {
        if (logLength > 0L && logLength + (long)length > this.m_maxSegSize) {
            return true;
        }
        return System.currentTimeMillis() >= this.m_nextRotationTime;
    }

    private long getNextRotationTime() {
        if (this.m_rotationFrequency == 128849018820000L) {
            return Long.MAX_VALUE;
        }
        long t = this.m_baseTime + (this.m_lastRotationTime - this.m_baseTime) / this.m_rotationFrequency * this.m_rotationFrequency;
        if (this.m_baseTime <= this.m_lastRotationTime) {
            t += this.m_rotationFrequency;
        }
        return t > this.m_lastRotationTime ? t : Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rotate(long logLength, Vector segFiles) {
        Vector segmentFiles = segFiles;
        boolean created = false;
        boolean renamed = false;
        File newFile = null;
        if (!this.m_logFile.exists()) {
            return true;
        }
        if (this.m_keepOpen && this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (IOException e) {
                this.handleException(e);
            }
            finally {
                this.m_out = null;
                this.m_logSize = 0L;
            }
        }
        for (int i = 0; i < 1; ++i) {
            String nextName = this.getNextSegmentName(segmentFiles);
            if (nextName == null) {
                return false;
            }
            newFile = new File(this.m_logDir, nextName);
            try {
                renamed = this.m_logFile.renameTo(newFile);
            }
            catch (Exception e) {
                this.debug("rename exception: " + e);
                renamed = false;
            }
            if (renamed) break;
            if (this.m_logFile.length() < logLength) {
                this.debug("renamed failed " + logLength);
                return true;
            }
            segmentFiles = this.getSegmentFiles(this.m_logDir);
        }
        if (!renamed) {
            this.handleException(new LoggingException("Failed to archive log file after 1 attempts " + newFile.getName()));
            return false;
        }
        this.m_lastRotationTime = System.currentTimeMillis();
        if (this.m_lastRotationTime >= this.m_nextRotationTime) {
            this.m_nextRotationTime = this.getNextRotationTime();
        }
        return true;
    }

    private long[] getTotalSizeAndMinTime(long logLength, Vector files) {
        long size = logLength;
        long minTime = Long.MAX_VALUE;
        for (int i = 0; i < files.size(); ++i) {
            String fileName = (String)files.elementAt(i);
            File f = new File(this.m_logDir, fileName);
            size += f.length();
            long lastModified = f.lastModified();
            if (lastModified >= minTime) continue;
            minTime = lastModified;
        }
        return new long[]{size, minTime};
    }

    private void deleteFiles(long size, long currentTime, Vector segmentFiles) {
        String[] segFiles = segmentFiles.toArray(new String[segmentFiles.size()]);
        this.sortLogFiles(segFiles);
        for (int i = 0; i < segFiles.length; ++i) {
            File file = new File(this.m_logDir, segFiles[i]);
            long lastModified = file.lastModified();
            if ((this.m_maxSize == Long.MAX_VALUE || size <= this.m_maxSize - this.m_maxSegSize) && currentTime - lastModified <= this.m_retentionPeriod) break;
            long flen = file.length();
            size -= flen;
            if (file.delete()) {
                this.internalLog("Deleted log file: " + file.getName() + ", size = " + flen + " bytes");
                continue;
            }
            this.debug("*** delete failed " + file.getName());
        }
    }

    private void internalLog(String msgText) {
        try {
            LogMessage msg = new LogMessage("Oracle", "OJDL", null, null, MessageType.NOTIFICATION, null, 16, this.getClass().getName(), null, null, null, null, null, null, msgText, null, null, null);
            String str = this.getFormatter().format(msg);
            byte[] bytes = str.getBytes();
            this.writeToStream(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception exn) {
        this.getExceptionHandler().onException(exn);
    }

    private static File getLogDirectory(File file) throws FileLogWriterException {
        File logDir = null;
        String path = null;
        try {
            path = file.getAbsoluteFile().getParentFile().getPath();
        }
        catch (Exception e) {
            path = null;
        }
        if (path == null) {
            throw new FileLogWriterException("Log directory path is null");
        }
        logDir = new File(path);
        try {
            if (logDir.exists()) {
                if (!logDir.isDirectory()) {
                    throw new FileLogWriterException(path + " is not a directory");
                }
            } else if (!logDir.mkdirs()) {
                throw new FileLogWriterException("cannot create directory " + path);
            }
            if (!logDir.canWrite()) {
                throw new FileLogWriterException("cannot write to directory " + path);
            }
        }
        catch (SecurityException e) {
            throw new FileLogWriterException("access to log directory " + path + " is denied");
        }
        return logDir;
    }

    private Vector getSegmentFiles(File logDir) {
        String[] files = logDir.list();
        Vector<String> segFiles = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            if (this.getSegmentNumber(files[i]) <= 0L) continue;
            segFiles.addElement(files[i]);
        }
        return segFiles;
    }

    private long getSegmentNumber(String fileName) {
        int endIndex;
        int beginIndex;
        if (!fileName.startsWith(this.m_basename)) {
            return -1L;
        }
        if (this.m_extension != null) {
            beginIndex = this.m_basename.length();
            endIndex = fileName.length() - this.m_extension.length();
        } else {
            beginIndex = this.m_basename.length() + 1;
            endIndex = fileName.length();
        }
        try {
            return Long.parseLong(fileName.substring(beginIndex, endIndex));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private String getNextSegmentName(Vector segments) {
        long max = 0L;
        for (int i = 0; i < segments.size(); ++i) {
            long n = this.getSegmentNumber((String)segments.elementAt(i));
            if (n <= max) continue;
            max = n;
        }
        if (max == Long.MAX_VALUE) {
            this.handleException(new LoggingException("out of log file names"));
            return null;
        }
        if (this.m_extension != null) {
            return this.m_basename + (max + 1L) + this.m_extension;
        }
        return this.m_basename + "." + (max + 1L);
    }

    private void sortLogFiles(String[] logFiles) {
        Arrays.sort(logFiles, this.m_comparator);
    }

    private class SegmentComparator
    implements Comparator {
        private SegmentComparator() {
        }

        public int compare(Object o1, Object o2) {
            long s1 = FileLogWriter.this.getSegmentNumber((String)o1);
            long s2 = FileLogWriter.this.getSegmentNumber((String)o2);
            return (int)(s1 - s2);
        }
    }
}

