/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.exception;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import oracle.as.management.exception.ASException;
import oracle.as.management.exception.ASRuntimeException;
import oracle.as.management.translation.NLSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASExceptionHelper
implements Serializable {
    private String m_errorCode = null;
    private String m_prefix = null;
    private String m_messageID;
    private String m_resourceLocation;
    private transient ClassLoader m_loader = null;
    private transient Locale m_locale = NLSupport.getClientLocale();
    private ArrayList<String> m_tokens = new ArrayList();
    private ArrayList<String> m_actionTokens = new ArrayList();
    private ArrayList<String> m_causeTokens = new ArrayList();
    private static final String DMS_MESSAGE_FILE = "oracle.dms.util.dms";
    private String m_causeMessage = null;
    private String m_actionMessage = null;
    private boolean m_isDisplayable = true;
    private boolean m_isSerialized = false;
    private boolean m_isCopiedException = false;
    private String m_message = null;
    private static final long serialVersionUID = -1153800432741L;

    public ASExceptionHelper(String messageID, String resourceLocation) {
        if (messageID == null || messageID.trim().length() == 0 || resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("messageID=" + messageID + "resourceLocation=" + resourceLocation);
        }
        this.m_messageID = messageID;
        this.m_resourceLocation = resourceLocation;
    }

    @Deprecated
    ASExceptionHelper(String errorCode, String prefix, String resourceLocation) {
        if (errorCode == null || errorCode.length() == 0 || prefix == null || resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("errorCode=" + errorCode + "prefix=" + prefix + "resourceLocation=" + resourceLocation);
        }
        this.m_errorCode = errorCode;
        this.m_prefix = prefix;
        this.m_messageID = prefix + errorCode;
        this.m_resourceLocation = resourceLocation;
    }

    @Deprecated
    void setResourceLocation(String resourceLocation, String prefix) {
        if (prefix == null || resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("prefix=" + prefix + " resourceLocation=" + resourceLocation);
        }
        this.m_prefix = prefix;
        for (int i = 0; i < this.m_messageID.length(); ++i) {
            char ch = this.m_messageID.charAt(i);
            if (!Character.isDigit(ch)) continue;
            String errorCode = this.m_messageID.substring(i);
            this.m_messageID = this.m_prefix + errorCode;
            break;
        }
        this.m_resourceLocation = resourceLocation;
    }

    void setResourceLocation(String resourceLocation) {
        if (resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("resourceLocation=" + resourceLocation);
        }
        this.m_resourceLocation = resourceLocation;
    }

    @Deprecated
    String setResourceLocation() {
        return this.m_resourceLocation;
    }

    public String getResourceLocation() {
        return this.m_resourceLocation;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.m_locale = locale;
        }
    }

    Locale getLocale() {
        return this.m_locale;
    }

    public void setClassLoader(ClassLoader loader) {
        if (loader != null) {
            this.m_loader = loader;
        }
    }

    public void addToken(String token) {
        this.m_tokens.add(token);
    }

    public void replaceToken(int pos, String token) {
        this.m_tokens.set(pos, token);
    }

    public List<String> getTokens() {
        return this.m_tokens;
    }

    public void addActionToken(String token) {
        this.m_actionTokens.add(token);
    }

    public void addCauseToken(String token) {
        this.m_causeTokens.add(token);
    }

    @Deprecated
    String getErrorCode() {
        return this.m_errorCode;
    }

    @Deprecated
    String getPrefix() {
        return this.m_prefix;
    }

    public String getMessageID() {
        return this.m_messageID;
    }

    public String getMessage() {
        return this.makeMessage();
    }

    String makeMessage() {
        String actionMessage;
        NLSupport nls = NLSupport.getNLSupport(DMS_MESSAGE_FILE, this.getClass().getClassLoader());
        StringBuilder buf = new StringBuilder();
        buf.append(this.getMessage(this.m_locale));
        String causeMessage = this.getCauseMessage();
        if (causeMessage != null && causeMessage.length() > 0) {
            String nls_cause = nls.getTranslation("NLS_CAUSE", this.m_locale);
            buf.append('\n');
            buf.append(nls_cause);
            buf.append(": ");
            buf.append(causeMessage);
        }
        if ((actionMessage = this.getActionMessage()) != null && actionMessage.length() > 0) {
            buf.append('\n');
            buf.append(nls.getTranslation("NLS_ACTION", this.m_locale));
            buf.append(": ");
            buf.append(actionMessage);
        }
        return buf.toString();
    }

    String getMessage(Locale locale) {
        if (this.m_isSerialized || this.m_isCopiedException) {
            return this.m_message;
        }
        NLSupport nls = NLSupport.getNLSupport(this.m_resourceLocation, this.m_loader);
        try {
            String translation = nls.getTranslation(this.m_messageID, this.m_tokens, locale);
            return this.m_messageID + ": " + translation;
        }
        catch (MissingResourceException e) {
            return this.m_messageID;
        }
    }

    private String _getActionMessage(Locale locale) {
        if (this.m_isSerialized || this.m_isCopiedException) {
            return this.m_actionMessage;
        }
        ArrayList<String> actionTokens = new ArrayList<String>(this.m_actionTokens);
        if (actionTokens.size() == 0 && this.m_tokens.size() > 0) {
            actionTokens.addAll(this.m_tokens);
        }
        NLSupport nls = NLSupport.getNLSupport(this.m_resourceLocation, this.m_loader);
        String key = this.m_messageID + ASException.ACTION_SUFFIX;
        try {
            String translation = nls.getTranslation(key, actionTokens, locale);
            return translation;
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    private String _getCauseMessage(Locale locale) {
        if (this.m_isSerialized || this.m_isCopiedException) {
            return this.m_causeMessage;
        }
        ArrayList<String> causeTokens = new ArrayList<String>(this.m_causeTokens);
        if (causeTokens.size() == 0 && this.m_tokens.size() > 0) {
            causeTokens.addAll(this.m_tokens);
        }
        NLSupport nls = NLSupport.getNLSupport(this.m_resourceLocation, this.m_loader);
        String key = this.m_messageID + ASException.CAUSE_SUFFIX;
        try {
            String translation = nls.getTranslation(key, causeTokens, locale);
            return translation;
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    public Throwable initCauseActionMessage(Throwable cause) {
        if (this.m_isCopiedException) {
            return cause;
        }
        Throwable t = null;
        while (cause != null && cause != t) {
            String mesg = null;
            ASExceptionHelper helper = null;
            if (cause instanceof ASException) {
                mesg = ((ASException)cause).getMessage(this.m_locale);
                helper = ((ASException)cause).getHelper();
            } else if (cause instanceof ASRuntimeException) {
                mesg = ((ASRuntimeException)cause).getMessage(this.m_locale);
                helper = ((ASRuntimeException)cause).getHelper();
            }
            if (helper != null) {
                String actionMesg = super._getActionMessage(this.m_locale);
                if (actionMesg != null) {
                    this.m_actionMessage = actionMesg;
                }
            } else {
                mesg = cause.getMessage();
            }
            this.m_causeMessage = mesg != null && mesg.length() > 0 ? mesg : cause.getClass().getName();
            if (helper != null && cause.getCause() == null) {
                String causeMessage = helper.getCauseMessage();
                String messageId = helper.getMessageID();
                if (causeMessage != null && causeMessage.length() > 0 && messageId != null && messageId.length() > 0) {
                    this.m_causeMessage = causeMessage = messageId + ": " + causeMessage;
                }
            }
            t = cause;
            cause = cause.getCause();
        }
        return t;
    }

    String getCauseMessage() {
        if (this.m_causeMessage != null) {
            return this.m_causeMessage;
        }
        this.m_causeMessage = this._getCauseMessage(this.m_locale);
        return this.m_causeMessage;
    }

    String getActionMessage() {
        if (this.m_actionMessage != null) {
            return this.m_actionMessage;
        }
        this.m_actionMessage = this._getActionMessage(this.m_locale);
        return this.m_actionMessage;
    }

    void setDisplayable(boolean displayable) {
        this.m_isDisplayable = displayable;
    }

    boolean isDisplayable() {
        return this.m_isDisplayable;
    }

    void copyMessageAttributes(ASExceptionHelper sourceHelper) {
        this.m_messageID = sourceHelper.getMessageID();
        this.m_message = sourceHelper.getMessage(sourceHelper.getLocale());
        this.m_causeMessage = sourceHelper.getCauseMessage();
        this.m_actionMessage = sourceHelper.getActionMessage();
        this.m_isDisplayable = sourceHelper.isDisplayable();
        this.m_isCopiedException = true;
    }

    void setMessageText(String msg) {
        this.m_message = msg;
        this.m_causeMessage = "";
        this.m_actionMessage = "";
        this.m_messageID = "";
        this.m_isCopiedException = true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.m_message = this.getMessage(this.getLocale());
        this.m_causeMessage = this.getCauseMessage();
        this.m_actionMessage = this.getActionMessage();
        this.m_isSerialized = true;
        stream.defaultWriteObject();
    }
}

