/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUcpDs;
import oracle.jms.AQjmsUcpDsStats;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolXADataSource;

public class AQjmsUcp {
    static UniversalConnectionPoolManager mgr = null;
    static Object lockMgr = new Object();
    static final HashMap<String, Level> traceLevelMap = new HashMap();
    static ConcurrentHashMap<String, AQjmsUcpDs> poolMap;

    private AQjmsUcp() {
    }

    public static PoolDataSource getPool(String string, String string2, String string3, boolean bl) {
        Properties properties = new Properties();
        properties.put("user", string2);
        properties.put("password", string3);
        return AQjmsUcp.getPool(string, properties, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolDataSource getPool(String string, Properties properties, boolean bl) {
        Object object;
        String string2 = properties.getProperty("user");
        if (string2 == null) {
            return null;
        }
        string2 = string2.toLowerCase();
        string = string.toLowerCase();
        AQjmsUcpDs aQjmsUcpDs = null;
        String string3 = string2 + "_" + string + (bl ? "_XA" : "");
        try {
            object = poolMap;
            synchronized (object) {
                aQjmsUcpDs = poolMap.get(string3);
                if (aQjmsUcpDs != null) {
                    aQjmsUcpDs.incUseCount();
                    return aQjmsUcpDs.getPoolDataSource();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = lockMgr;
            synchronized (object) {
                if (mgr == null) {
                    mgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                    String string4 = null;
                    string4 = System.getProperty("oracle.jms.ucp.trace");
                    if (string4 != null) {
                        try {
                            Level level = traceLevelMap.get(string4);
                            if (level != null) {
                                mgr.setLogLevel(level);
                            }
                        }
                        catch (Exception exception) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsUcp.getPool: Failed to set UCP Tracing to " + string4, exception);
                        }
                    }
                }
                if ((aQjmsUcpDs = poolMap.get(string3)) == null) {
                    int n = Integer.parseInt(System.getProperty("oracle.jms.ucp.initsize", "1"));
                    int n2 = Integer.parseInt(System.getProperty("oracle.jms.ucp.maxsize", AQjmsConstants.DEFAULT_UCPMAXSIZE));
                    n = Math.min(n, n2);
                    AQjmsOracleDebug.trace(3, "AQjmsuCP.getPool", "Creating UCP Pool with Key " + string3 + "\n Requeted Size = " + n);
                    long l = System.currentTimeMillis();
                    PoolDataSource poolDataSource = AQjmsUcp.initializePool(string, properties.getProperty("user"), properties.getProperty("password"), n, bl, string3);
                    if (poolDataSource == null) {
                        AQjmsOracleDebug.trace(3, "AQjmsuCP.getPool", "Failed to create ucp pool ");
                        return null;
                    }
                    long l2 = System.currentTimeMillis();
                    AQjmsOracleDebug.trace(3, "AQjmsuCP.getPool", "UCP Pool Created. Time Taken =" + (l2 - l) / 1000L + " Seconds. \n Available Sessions= " + poolDataSource.getAvailableConnectionsCount());
                    aQjmsUcpDs = new AQjmsUcpDs(poolDataSource, bl);
                    try {
                        String string5 = System.getProperty("oracle.jms.ucp.delay.clean");
                        boolean bl2 = false;
                        bl2 = string5 == null ? poolDataSource.getFastConnectionFailoverEnabled() || poolDataSource.getMinPoolSize() > 0 || Boolean.parseBoolean("false") : Boolean.parseBoolean(string5);
                        if (bl2) {
                            int n3 = Integer.parseInt(System.getProperty("oracle.jms.ucp.clean.wait", "10"));
                            aQjmsUcpDs.setDelayedCleanup(true);
                            aQjmsUcpDs.setWaitTime(n3);
                        }
                    }
                    catch (Exception exception) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsUcp.getPool: setDelayedCleanup ", exception);
                    }
                    poolMap.put(string3, aQjmsUcpDs);
                    aQjmsUcpDs.incUseCount();
                } else {
                    aQjmsUcpDs.incUseCount();
                }
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsUcp.getPool ", exception);
            aQjmsUcpDs = null;
            return null;
        }
        return aQjmsUcpDs.getPoolDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closePool(PoolDataSource poolDataSource) throws Exception {
        if (poolDataSource == null) {
            return;
        }
        String string = poolDataSource.getConnectionPoolName();
        try {
            ConcurrentHashMap<String, AQjmsUcpDs> concurrentHashMap = poolMap;
            synchronized (concurrentHashMap) {
                AQjmsUcpDs aQjmsUcpDs = poolMap.get(string);
                int n = aQjmsUcpDs.decUseCount();
                AQjmsOracleDebug.trace(3, "AQjmsUcp.closePool", "Ucp Key = " + string + "\n Use Count " + n + " Available Connections " + poolDataSource.getAvailableConnectionsCount() + " Borrowed Connections " + poolDataSource.getBorrowedConnectionsCount());
                if (n == 0) {
                    Object object = lockMgr;
                    synchronized (object) {
                        n = aQjmsUcpDs.getUseCount();
                        if (n > 0) {
                            return;
                        }
                        if (aQjmsUcpDs.delayedCleanup) {
                            AQjmsOracleDebug.trace(3, "AQjmsUcp.closePool", "Ucp Key = " + string + "\n Poll will be destroyed in " + aQjmsUcpDs.getWaitTime());
                            aQjmsUcpDs.selfDestruct();
                        } else {
                            AQjmsUcp.deletePool(string);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsuCP.closePool Exception while Destroying Pool, UcpKey  " + string, exception);
        }
    }

    private static PoolDataSource initializePool(String string, String string2, String string3, int n, boolean bl, String string4) throws SQLException, UniversalConnectionPoolException {
        PoolXADataSource poolXADataSource = null;
        try {
            int n2;
            Object object = System.getProperty("oracle.ucp.MaxInitThreads");
            if (object == null || ((String)object).equals("")) {
                n2 = Math.max(n / 4, 1);
                System.setProperty("oracle.ucp.MaxInitThreads", "" + n2);
                object = "" + n2;
            }
            if (bl) {
                poolXADataSource = PoolDataSourceFactory.getPoolXADataSource();
                poolXADataSource.setConnectionFactoryClassName("oracle.jdbc.xa.client.OracleXADataSource");
            } else {
                poolXADataSource = PoolDataSourceFactory.getPoolDataSource();
                poolXADataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
            }
            poolXADataSource.setUser(string2);
            poolXADataSource.setPassword(string3);
            poolXADataSource.setURL(string);
            poolXADataSource.setInitialPoolSize(n);
            poolXADataSource.setConnectionPoolName(string4);
            poolXADataSource.setValidateConnectionOnBorrow(true);
            n2 = 0;
            try {
                String string5 = System.getProperty("oracle.jms.ucp.inactivetimeout", "0");
                n2 = Integer.parseInt(string5);
                poolXADataSource.setInactiveConnectionTimeout(n2);
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting INACTIVE CONNECTION TIMEOUT. UcpKey:  " + string4, exception);
            }
            int n3 = 0;
            try {
                String string6 = System.getProperty("oracle.jms.ucp.reusecount", "0");
                n3 = Integer.parseInt(string6);
                poolXADataSource.setMaxConnectionReuseCount(n3);
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting CONNECTION REUSE COUNT. UcpKey:  " + string4, exception);
            }
            try {
                int n4 = Integer.parseInt(System.getProperty("oracle.jms.ucp.minsize", "0"));
                if (n4 > 0) {
                    poolXADataSource.setMinPoolSize(n4);
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting MIN POOl SIZE. UcpKey  " + string4, exception);
            }
            try {
                int n5 = Integer.parseInt(System.getProperty("oracle.jms.ucp.maxsize", AQjmsConstants.DEFAULT_UCPMAXSIZE));
                if (n5 <= Integer.MAX_VALUE) {
                    poolXADataSource.setMaxPoolSize(n5);
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting MAX POOL SIZE. UcpKey  " + string4, exception);
            }
            try {
                boolean bl2 = Boolean.parseBoolean(System.getProperty("oracle.jms.ucp.fcf", "false"));
                poolXADataSource.setFastConnectionFailoverEnabled(bl2);
                String string7 = System.getProperty("oracle.jms.ons.config");
                if (string7 != null) {
                    poolXADataSource.setONSConfiguration(string7);
                    poolXADataSource.setFastConnectionFailoverEnabled(true);
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting Fast Connection Failover. UcpKey  " + string4, exception);
            }
            mgr.createConnectionPool((UniversalConnectionPoolAdapter)poolXADataSource);
            mgr.startConnectionPool(poolXADataSource.getConnectionPoolName());
            AQjmsOracleDebug.trace(3, "AQjmsuCP.initializePool: Created ", "Pool Name = " + string4 + "\n  Available Connections " + poolXADataSource.getAvailableConnectionsCount() + " Borrowed Connections " + poolXADataSource.getBorrowedConnectionsCount() + " UCP Creator Threads " + (String)object + " Inactive Time Out " + n2 + " ReUse Count " + n3);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while creating Pool, UcpKey  " + string4, exception);
        }
        return poolXADataSource;
    }

    static void deletePool(String string) throws Exception {
        poolMap.remove(string);
        try {
            AQjmsOracleDebug.trace(3, "AQjmsuCP.closePool", "Destroying Pool, UcpKey  " + string);
            mgr.destroyConnectionPool(string);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsuCP.closePool Exception while Destroying Pool, UcpKey  " + string, exception);
            throw exception;
        }
    }

    public static HashMap<String, AQjmsUcpDsStats> getAQjmsUcpStats() {
        HashMap<String, AQjmsUcpDsStats> hashMap = new HashMap<String, AQjmsUcpDsStats>();
        for (Map.Entry<String, AQjmsUcpDs> entry : poolMap.entrySet()) {
            AQjmsUcpDs aQjmsUcpDs = entry.getValue();
            hashMap.put(entry.getKey(), new AQjmsUcpDsStats(aQjmsUcpDs.getPoolDataSource()));
        }
        return hashMap;
    }

    static {
        traceLevelMap.put("ALL", Level.ALL);
        traceLevelMap.put("CONFIG", Level.CONFIG);
        traceLevelMap.put("FINE", Level.FINE);
        traceLevelMap.put("FINER", Level.FINER);
        traceLevelMap.put("FINEST", Level.FINEST);
        traceLevelMap.put("INFO", Level.INFO);
        traceLevelMap.put("OFF", Level.OFF);
        traceLevelMap.put("SEVER", Level.SEVERE);
        traceLevelMap.put("WARNING", Level.WARNING);
        poolMap = new ConcurrentHashMap(2);
    }
}

