/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;

    public AQjmsObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "trying to resolve class " + objectStreamClass.getName());
        try {
            AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "resolve using Class.forName(String, boolean,ClassLoader) method");
            clazz = Class.forName(objectStreamClass.getName(), true, this.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "Class.forName(String, boolean,ClassLoader) fail to find class");
        }
        if (clazz == null) {
            AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "resolve using Class.forName(String) method");
            clazz = Class.forName(objectStreamClass.getName());
        }
        return clazz;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

