/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessageFormatException;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsMessageID;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AQjmsProperty;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.jms.AQjmsTempLobTruncateException;
import oracle.saga.SagaError;
import oracle.saga.SagaUtils;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class AQjmsMessage
implements Message {
    static final Class m_boolClass = new Boolean(false).getClass();
    static final Class m_byteClass = new Byte(0).getClass();
    static final Class m_shortClass = new Byte(0).getClass();
    static final Class m_intClass = new Integer(0).getClass();
    static final Class m_longClass = new Long(0L).getClass();
    static final Class m_floatClass = new Float(0.0f).getClass();
    static final Class m_doubleClass = new Double(0.0).getClass();
    static final Class m_strClass = new String(" ").getClass();
    static Hashtable m_systemProperties;
    static HashSet m_settableSystemProperties;
    AQjmsMessageHeaderExt header_ext;
    AQjmsMessageID message_id;
    long enqueue_time;
    String corr_id;
    Destination msg_dest;
    int del_mode;
    boolean redelivered;
    long expiration;
    int priority;
    Hashtable msg_properties;
    int access_mode;
    boolean prop_read_only;
    long recv_time;
    int msg_state;
    String excp_queue;
    int msg_delay;
    byte[] orig_msg_id;
    AQjmsAgent sender_id;
    int attempts;
    AQjmsSignature m_signature;
    AQjmsSession session;
    boolean m_hdrOnly;
    boolean m_isjmsbody;
    boolean compliant;
    boolean largeBody;
    long bodyLength;
    InputStream m_inputStream;
    byte[] lobLocator;
    private static final String JMS_REPLY_TO = "JMSReplyTo";
    boolean m_writeLobLater = false;
    Object m_tempLob = null;

    private void init(boolean bl) {
        this.message_id = new AQjmsMessageID();
        this.enqueue_time = 0L;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.compliant = this.session == null ? AQjmsConstants.IS_COMPLIANT : this.session.getCompliant();
        this.priority = bl && this.compliant ? 4 : 1;
        this.msg_properties = new Hashtable();
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.m_hdrOnly = false;
        this.m_isjmsbody = bl;
        this.header_ext = new AQjmsMessageHeaderExt();
    }

    AQjmsMessage(boolean bl) {
        this.init(bl);
    }

    AQjmsMessage(AQjmsSession aQjmsSession, boolean bl) {
        this.session = aQjmsSession;
        this.init(bl);
    }

    AQjmsMessage(AQjmsMessage aQjmsMessage) {
        this(aQjmsMessage.session, aQjmsMessage.m_isjmsbody);
        this.header_ext = aQjmsMessage.header_ext;
        this.message_id = aQjmsMessage.message_id;
        this.enqueue_time = aQjmsMessage.enqueue_time;
        this.corr_id = aQjmsMessage.corr_id;
        this.msg_dest = aQjmsMessage.msg_dest;
        this.del_mode = aQjmsMessage.del_mode;
        this.redelivered = aQjmsMessage.redelivered;
        this.expiration = aQjmsMessage.expiration;
        this.priority = aQjmsMessage.priority;
        this.msg_properties = aQjmsMessage.msg_properties;
        this.access_mode = aQjmsMessage.access_mode;
        this.prop_read_only = aQjmsMessage.prop_read_only;
        this.recv_time = aQjmsMessage.recv_time;
        this.msg_state = aQjmsMessage.msg_state;
        this.excp_queue = aQjmsMessage.excp_queue;
        this.msg_delay = aQjmsMessage.msg_delay;
        this.orig_msg_id = aQjmsMessage.orig_msg_id;
        this.sender_id = aQjmsMessage.sender_id;
        this.attempts = aQjmsMessage.attempts;
        this.m_signature = aQjmsMessage.m_signature;
        this.m_hdrOnly = aQjmsMessage.m_hdrOnly;
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    void setPropertiesHashtable(Hashtable hashtable) {
        this.msg_properties = hashtable;
    }

    public String getJMSMessageID() throws JMSException {
        return this.message_id.getJMSMessageID();
    }

    public byte[] getJMSMessageIDAsBytes() throws JMSException {
        return this.message_id.getJMSMessageIDAsBytes();
    }

    void setJMSMessageID(byte[] byArray) throws JMSException {
        this.message_id.setJMSMessageID(byArray);
    }

    public void setJMSMessageID(String string) throws JMSException {
        this.message_id.setJMSMessageID(string);
    }

    public long getJMSTimestamp() throws JMSException {
        long l;
        Object object = this.getObjectProperty("JMS_OracleTimestamp");
        if (object != null && object instanceof Long) {
            l = (Long)object;
            AQjmsOracleDebug.trace(5, "AQjmsMessage.getJMSTimestamp", "JMSTimestamp from property:" + l);
        } else {
            l = this.getEnqueueTime();
            AQjmsOracleDebug.trace(5, "AQjmsMessage.getJMSTimestamp", "JMSTimestamp from AQ enqueue_time:" + l);
        }
        return l;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        this.setLongProperty2("JMS_OracleTimestamp", l);
        AQjmsOracleDebug.println("setJMSTimestamp. timestamp: " + l);
    }

    long getEnqueueTime() {
        return this.enqueue_time;
    }

    void setEnqueueTime(long l) {
        this.enqueue_time = l;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.corr_id;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.corr_id == null) {
            return null;
        }
        return this.corr_id.getBytes();
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        this.corr_id = string;
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        this.corr_id = byArray == null ? null : new String(byArray);
    }

    public Destination getJMSReplyTo() throws JMSException {
        Object object = null;
        try {
            object = this.header_ext.getReplyto();
            if (object != null) {
                String string = ((AQjmsAgent)object).getName();
                if (string != null && string.equalsIgnoreCase(JMS_REPLY_TO)) {
                    object = AQjmsMessage.deserializeDest(((AQjmsAgent)object).getAddress());
                }
                if (object instanceof AQjmsAgent) {
                    String string2 = ((AQjmsAgent)object).getAddress();
                    if ((string == null || string.equals("") || string.equals(" ")) && (string2 == null || string2.equals(""))) {
                        object = null;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        return object;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        try {
            if (destination instanceof AQjmsAgent) {
                String string = ((AQjmsAgent)destination).getName();
                if (string != null && string.equalsIgnoreCase(JMS_REPLY_TO)) {
                    AQjmsError.throwEx(147);
                }
                this.header_ext.setReplyto((AQjmsAgent)destination);
            } else if (destination instanceof AQjmsDestination) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, AQjmsMessage.serializeDest((AQjmsDestination)destination)));
            } else if (destination == null) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, null));
            } else {
                AQjmsError.throwEx(147);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public Destination getJMSDestination() throws JMSException {
        return this.msg_dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.msg_dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.del_mode;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (n != 2 && n != 1) {
            AQjmsError.throwEx(101, Integer.toString(n));
        }
        this.del_mode = n;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        this.redelivered = bl;
    }

    public String getJMSType() throws JMSException {
        try {
            return this.header_ext.getType();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public void setJMSType(String string) throws JMSException {
        try {
            this.header_ext.setType(string);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.expiration = l;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int n) throws JMSException {
        this.priority = n;
    }

    public String getSagaSender() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_sender");
    }

    public void setSagaSender(String string) throws JMSException {
        this.setSagaSender(string, true);
    }

    public void setSagaSender(String string, boolean bl) throws JMSException {
        if (bl) {
            string = SagaUtils.canonicalize((String)string);
        }
        this.setStringProperty2("jms_oracle_aq$_saga_sender", string);
    }

    public String getSagaRecipient() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_recipient");
    }

    public void setSagaRecipient(String string) throws JMSException {
        this.setSagaRecipient(string, true);
    }

    public void setSagaRecipient(String string, boolean bl) throws JMSException {
        if (bl) {
            string = SagaUtils.canonicalize((String)string);
        }
        this.setStringProperty2("jms_oracle_aq$_saga_recipient", string);
    }

    public Integer getSagaOpcode() throws JMSException {
        if (!this.propertyExists("jms_oracle_aq$_saga_opcode")) {
            return null;
        }
        return this.getIntProperty("jms_oracle_aq$_saga_opcode");
    }

    public void setSagaOpcode(Integer n, String string) throws JMSException {
        this.setIntProperty("jms_oracle_aq$_saga_opcode", n);
        if (n == 7 && this.isSagaTimeout(string)) {
            this.updateSagaTimeout(string);
            this.session.commit();
            SagaError.throwEx((int)262, (String)string, null);
        }
        if (n == 7 || n == 1) {
            Object[] objectArray = SagaUtils.getTimeoutParams((AQjmsSession)this.session, (String)string, (Integer)n);
            this.setSagaTimeout((Integer)objectArray[0]);
            this.setSagaBeginTime((String)objectArray[1]);
        }
    }

    public String getSagaId() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_id");
    }

    public void setSagaId(String string) throws JMSException {
        this.setStringProperty2("jms_oracle_aq$_saga_id", string);
    }

    public String getSagaCoordinator() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_coordinator");
    }

    public void setSagaCoordinator(String string) throws JMSException {
        this.setSagaCoordinator(string, true);
    }

    public void setSagaCoordinator(String string, boolean bl) throws JMSException {
        if (bl) {
            string = SagaUtils.canonicalize((String)string);
        }
        this.setStringProperty2("jms_oracle_aq$_saga_coordinator", string);
    }

    public Integer getSagaTimeout() throws JMSException {
        if (!this.propertyExists("jms_oracle_aq$_saga_timeout")) {
            return null;
        }
        return this.getIntProperty("jms_oracle_aq$_saga_timeout");
    }

    private void setSagaTimeout(Integer n) throws JMSException {
        this.setIntProperty("jms_oracle_aq$_saga_timeout", n);
    }

    public Integer getSagaVersion() throws JMSException {
        if (!this.propertyExists("jms_oracle_aq$_saga_version")) {
            return null;
        }
        return this.getIntProperty("jms_oracle_aq$_saga_version");
    }

    public void setSagaVersion(Integer n) throws JMSException {
        this.setIntProperty("jms_oracle_aq$_saga_version", n);
    }

    public String getSagaSpare() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_spare");
    }

    public void setSagaSpare(String string) throws JMSException {
        this.setSagaSpare(string, true);
    }

    public void setSagaSpare(String string, boolean bl) throws JMSException {
        if (string != null) {
            if (bl) {
                string = SagaUtils.canonicalize((String)string);
            }
            this.setStringProperty2("jms_oracle_aq$_saga_spare", string);
        }
    }

    public String getSagaBeginTime() throws JMSException {
        return this.getStringProperty("jms_oracle_aq$_saga_begin_time");
    }

    private void setSagaBeginTime(String string) throws JMSException {
        if (string != null) {
            this.setStringProperty2("jms_oracle_aq$_saga_begin_time", string);
        }
    }

    public void clearProperties() throws JMSException {
        if (this.msg_properties != null) {
            this.msg_properties.clear();
        }
        if (this.header_ext != null) {
            try {
                this.header_ext.setUserid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setAppid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupseq(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setProperties(null);
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.clearProperties", exception);
            }
        }
        this.attempts = 0;
        this.msg_state = 0;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.setPropReadOnly(false);
    }

    public boolean propertyExists(String string) throws JMSException {
        this.checkNullPropertyName(string);
        if (m_systemProperties.containsKey(string)) {
            try {
                return this.getSystemProperty(string) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.msg_properties.containsKey(string);
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Object object;
        block11: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            this.checkNullPropertyName(string);
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Boolean.valueOf(string2);
                    }
                    break block11;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 20: {
                            int n2 = ((Datum)object).intValue();
                            return n2 != 0;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Boolean.valueOf(string3);
                        }
                    }
                    break block11;
                }
                return false;
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String string) throws JMSException {
        Object object;
        block12: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            this.checkNullPropertyName(string);
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Byte.parseByte(string2);
                    }
                    break block12;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: {
                            int n2 = ((Datum)object).intValue();
                            return (byte)n2;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Byte.parseByte(string3);
                        }
                    }
                    break block12;
                }
                throw new NumberFormatException("getByteProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String string) throws JMSException {
        Object object;
        block12: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            this.checkNullPropertyName(string);
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Short.parseShort(string2);
                    }
                    break block12;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: 
                        case 22: {
                            int n2 = ((Datum)object).intValue();
                            return (short)n2;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Short.parseShort(string3);
                        }
                    }
                    break block12;
                }
                throw new NumberFormatException("getShortProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String string) throws JMSException {
        Object object;
        block13: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            this.checkNullPropertyName(string);
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null) {
                        if (clazz == m_strClass) {
                            String string2 = (String)object;
                            return Integer.parseInt(string2);
                        }
                        return ((Datum)object).intValue();
                    }
                    break block13;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)object).intValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Integer.parseInt(string3);
                        }
                    }
                    break block13;
                }
                throw new NumberFormatException("getIntProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public long getLongProperty(String string) throws JMSException {
        Object object;
        block15: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            this.checkNullPropertyName(string);
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Long.parseLong(string2);
                    }
                    if (clazz == m_intClass) {
                        return ((Datum)object).intValue();
                    }
                    if (clazz == m_longClass) {
                        return ((Datum)object).longValue();
                    }
                    break block15;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)object).intValue();
                        }
                        case 24: {
                            return ((Datum)object).longValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Long.parseLong(string3);
                        }
                    }
                    break block15;
                }
                throw new NumberFormatException("getLongProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        this.checkNullPropertyName(string);
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                object = this.getSystemProperty(string);
                if (object != null && clazz == m_strClass) {
                    String string2 = (String)object;
                    return Float.parseFloat(string2);
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 25: {
                            return ((Float)object).floatValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Float.parseFloat(string3);
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        this.checkNullPropertyName(string);
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                object = this.getSystemProperty(string);
                if (object != null && clazz == m_strClass) {
                    String string2 = (String)object;
                    return Double.parseDouble(string2);
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 25: {
                            return ((Float)object).floatValue();
                        }
                        case 26: {
                            return (Double)object;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Double.parseDouble(string3);
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public String getStringProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        this.checkNullPropertyName(string);
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (clazz == m_strClass) {
                        return (String)object;
                    }
                    return ((Datum)object).stringValue();
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 20: {
                            int n2 = ((Datum)object).intValue();
                            if (n2 > 0) {
                                return "true";
                            }
                            return "false";
                        }
                        case 25: {
                            return ((Float)object).toString();
                        }
                        case 26: {
                            return ((Double)object).toString();
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            return ((Datum)object).stringValue();
                        }
                    }
                    return (String)object;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public Object getObjectProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        this.checkNullPropertyName(string);
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                if (clazz == m_strClass && (object = this.getSystemProperty(string)) != null) {
                    return object;
                }
                if (clazz == m_intClass && (object = this.getSystemProperty(string)) != null) {
                    return new Integer(((Datum)object).intValue());
                }
                if (clazz == m_longClass && (object = this.getSystemProperty(string)) != null) {
                    return new Long(((Datum)object).longValue());
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 20: {
                            int n2 = ((Datum)object).intValue();
                            return new Boolean(n2 > 0);
                        }
                        case 21: {
                            int n3 = ((Datum)object).intValue();
                            return new Byte((byte)n3);
                        }
                        case 22: {
                            int n4 = ((Datum)object).intValue();
                            return new Short((short)n4);
                        }
                        case 23: {
                            int n5 = ((Datum)object).intValue();
                            return new Integer(n5);
                        }
                        case 24: {
                            long l = ((Datum)object).longValue();
                            return new Long(l);
                        }
                        case 25: {
                            float f = ((Float)object).floatValue();
                            return new Float(f);
                        }
                        case 26: {
                            double d = (Double)object;
                            return new Double(d);
                        }
                        case 27: {
                            return object;
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage(), exception);
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Vector<String> vector = new Vector<String>(this.msg_properties.size() + m_systemProperties.size());
        Enumeration enumeration = m_systemProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                if (this.compliant && this.getSystemProperty(string) == null) continue;
                vector.addElement(string);
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(2, "AQjmsMessage.getPropertyNames", sQLException);
                AQjmsError.throwEx(122, (Throwable)sQLException);
            }
        }
        enumeration = this.msg_properties.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        return vector.elements();
    }

    public synchronized Enumeration getUserPropertyNames() throws JMSException {
        Vector<String> vector = new Vector<String>(this.msg_properties.size());
        Enumeration enumeration = this.msg_properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (AQjmsMessage.isSystemProperty(string)) continue;
            vector.addElement(string);
        }
        return vector.elements();
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(bl);
            if (AQjmsMessage.isSystemProperty(string)) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(20, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(by);
            if (AQjmsMessage.isSystemProperty(string)) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(21, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setShortProperty(String string, short s) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(s);
            if (AQjmsMessage.isSystemProperty(string)) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(22, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setIntProperty(String string, int n) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(n);
            if (AQjmsMessage.isSystemProperty(string)) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsOracleDebug.println("setIntProperty: Property: " + string + " Value:  " + n);
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(23, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setLongProperty(String string, long l) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.setLongProperty2(string, l);
    }

    void setLongProperty2(String string, long l) throws JMSException {
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(l);
            if (AQjmsMessage.isSystemProperty(string)) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(24, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            if (AQjmsMessage.isSystemProperty(string)) {
                NUMBER nUMBER = new NUMBER(f);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(f);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            if (AQjmsMessage.isSystemProperty(string)) {
                NUMBER nUMBER = new NUMBER(d);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(d);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.setStringProperty2(string, string2);
    }

    void setStringProperty2(String string, String string2) throws JMSException {
        this.checkPropertyName(string);
        try {
            if (AQjmsMessage.isSystemProperty(string)) {
                this.setSystemProperty(string, string2);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, string2);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        if (object == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (object instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByteProperty(string, (Byte)object);
        } else if (object instanceof Short) {
            this.setShortProperty(string, (Short)object);
        } else if (object instanceof Integer) {
            this.setIntProperty(string, (Integer)object);
        } else if (object instanceof Long) {
            this.setLongProperty(string, (Long)object);
        } else if (object instanceof Float) {
            this.setFloatProperty(string, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDoubleProperty(string, (Double)object);
        } else if (object instanceof String) {
            this.setStringProperty(string, (String)object);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void acknowledge() throws JMSException {
        Connection connection = null;
        if (this.session.getAcknowledgeMode() == 2) {
            if (this.session.usedJMSRegistration) {
                AQjmsOracleDebug.trace(5, "AQjmsMessage.acknowledge", "before calling session.ackJmsNtfsAndCommit");
                this.session.ackJmsNtfsAndCommit();
                return;
            }
            connection = this.session.getDBConnection();
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
    }

    public void clearBody() throws JMSException {
    }

    public AQjmsAgent getSenderID() throws JMSException {
        return this.sender_id;
    }

    public void setSenderID(AQjmsAgent aQjmsAgent) throws JMSException {
        this.sender_id = aQjmsAgent;
    }

    public int getAttempts() throws JMSException {
        return this.attempts;
    }

    void setAttempts(int n) throws JMSException {
        this.attempts = n;
    }

    boolean isPropReadOnly() {
        return this.prop_read_only;
    }

    void setPropReadOnly(boolean bl) {
        this.prop_read_only = bl;
    }

    boolean isBodyReadOnly() {
        return this.access_mode == 0;
    }

    boolean isBodyWriteOnly() {
        return this.access_mode == 1;
    }

    boolean isBodyReadWrite() {
        return this.access_mode == 2;
    }

    void setAccessMode(int n) throws JMSException {
        if (n == 0 || n == 1 || n == 2) {
            this.access_mode = n;
        } else {
            AQjmsError.throwEx(152);
        }
    }

    static String ByteArraytoString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray == null) {
            stringBuffer.append("");
        } else {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] & 0xFF;
                if (n2 < 16) {
                    stringBuffer.append("0" + Integer.toHexString(n2));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
        }
        return stringBuffer.toString();
    }

    static AQjmsPropertyList convertHashtableToPropertyList(Hashtable hashtable) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "entry");
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        String string = null;
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        n = hashtable.size();
        AQjmsOracleDebug.println("Num props " + n);
        AQjmsProperty[] aQjmsPropertyArray = new AQjmsProperty[n];
        enumeration2 = hashtable.keys();
        enumeration = hashtable.elements();
        try {
            n2 = 0;
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                aQjmsPropDatum = (AQjmsPropDatum)enumeration.nextElement();
                object = aQjmsPropDatum.getValue();
                aQjmsPropertyArray[n2] = new AQjmsProperty();
                AQjmsOracleDebug.println("Property: " + n2);
                int n3 = aQjmsPropDatum.getType();
                AQjmsOracleDebug.println("Name: " + string + "  Type: " + n3);
                if (n3 == 27) {
                    aQjmsPropertyArray[n2].setName(string);
                    aQjmsPropertyArray[n2].setType(new Integer(100));
                    aQjmsPropertyArray[n2].setStrValue((String)object);
                    aQjmsPropertyArray[n2].setNumValue(null);
                    aQjmsPropertyArray[n2].setJavaType(new Integer(n3));
                    AQjmsOracleDebug.println("Name: " + string + "  Value: " + (String)object + "  Str Type");
                } else {
                    NUMBER nUMBER;
                    if (n3 == 25) {
                        nUMBER = new NUMBER(((Float)object).floatValue());
                        object = nUMBER;
                    } else if (n3 == 26) {
                        nUMBER = new NUMBER(((Double)object).doubleValue());
                        object = nUMBER;
                    }
                    if (object instanceof NUMBER) {
                        aQjmsPropertyArray[n2].setName(string);
                        aQjmsPropertyArray[n2].setType(new Integer(200));
                        aQjmsPropertyArray[n2].setStrValue(null);
                        aQjmsPropertyArray[n2].setNumValue(((Datum)object).bigDecimalValue());
                        aQjmsPropertyArray[n2].setJavaType(new Integer(n3));
                        AQjmsOracleDebug.println("Name: " + string + "  Value: " + ((Datum)object).bigDecimalValue() + "  Num Type");
                    } else {
                        AQjmsOracleDebug.trace(1, "AQjmsMessage.convertHashtableToPropertyList", "Internal error - invalid datum value");
                        AQjmsError.throwEx(122);
                    }
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertHashtableToPropertyList", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsPropertyList aQjmsPropertyList = new AQjmsPropertyList(aQjmsPropertyArray);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "exit");
        return aQjmsPropertyList;
    }

    static Hashtable convertPropertyListToHashtable(AQjmsPropertyList aQjmsPropertyList) throws JMSException {
        Hashtable<String, AQjmsPropDatum> hashtable;
        int n = 0;
        int n2 = 0;
        Object var5_3 = null;
        Object var6_4 = null;
        String string = null;
        AQjmsPropDatum aQjmsPropDatum = null;
        NUMBER nUMBER = null;
        String string2 = null;
        int n3 = 0;
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "entry");
        try {
            n = aQjmsPropertyList.length();
            hashtable = new Hashtable<String, AQjmsPropDatum>();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "num_props: " + n);
            AQjmsProperty[] aQjmsPropertyArray = new AQjmsProperty[n];
            for (n2 = 0; n2 < n; ++n2) {
                aQjmsPropertyArray[n2] = aQjmsPropertyList.getElement(n2);
                string = aQjmsPropertyArray[n2].getName();
                Integer n4 = aQjmsPropertyArray[n2].getType();
                int n5 = n3 = aQjmsPropertyArray[n2].getJavaType() != null ? aQjmsPropertyArray[n2].getJavaType() : 0;
                if (n4 == 100) {
                    string2 = aQjmsPropertyArray[n2].getStrValue();
                    aQjmsPropDatum = new AQjmsPropDatum(n3, string2);
                } else if (n4 == 200) {
                    nUMBER = new NUMBER(aQjmsPropertyArray[n2].getNumValue());
                    if (n3 == 25) {
                        float f = nUMBER.floatValue();
                        aQjmsPropDatum = new AQjmsPropDatum(f);
                    } else if (n3 == 26) {
                        double d = nUMBER.doubleValue();
                        aQjmsPropDatum = new AQjmsPropDatum(d);
                    } else {
                        aQjmsPropDatum = new AQjmsPropDatum(n3, (Datum)nUMBER);
                    }
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.converPropertyListToHashtable", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                hashtable.put(string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "exit");
        return hashtable;
    }

    static boolean isSystemProperty(String string) {
        return string != null && (string.startsWith("JMSX") || string.startsWith("JMS_Oracle"));
    }

    static boolean isSettableSystemProperty(String string) {
        return m_settableSystemProperties.contains(string);
    }

    void setSystemProperty(String string, Object object) throws JMSException, SQLException {
        block44: {
            try {
                if (m_systemProperties.containsKey(string)) {
                    if (string.equals("JMSXUserID")) {
                        AQjmsError.throwEx(110, string);
                        break block44;
                    }
                    if (string.equals("JMSXAppID")) {
                        if (object instanceof String) {
                            this.header_ext.setAppid((String)object);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (string.equals("JMSXDeliveryCount")) {
                        AQjmsError.throwEx(110, string);
                        break block44;
                    }
                    if (string.equals("JMSXGroupID")) {
                        if (object instanceof String) {
                            this.header_ext.setGroupid((String)object);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (string.equals("JMSXGroupSeq")) {
                        if (object instanceof NUMBER) {
                            this.header_ext.setGroupseq(new Integer(((Datum)object).intValue()));
                        } else if (object instanceof String) {
                            try {
                                this.header_ext.setGroupseq(new Integer((String)object));
                            }
                            catch (NumberFormatException numberFormatException) {
                                AQjmsError.throwEx("Failed to set the JMSXGroupSeq property with " + object + ". This property must be a number", (Throwable)numberFormatException);
                            }
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (string.equals("JMSXProducerTXID")) {
                        AQjmsError.throwEx(110);
                        break block44;
                    }
                    if (string.equals("JMSXConsumerTXID")) {
                        AQjmsError.throwEx(110);
                        break block44;
                    }
                    if (string.equals("JMSXRcvTimestamp") || string.equals("JMSXRecvTimestamp")) {
                        AQjmsError.throwEx(110, string);
                        break block44;
                    }
                    if (string.equals("JMSXState")) {
                        AQjmsError.throwEx(110, string);
                        break block44;
                    }
                    if (string.equals("JMS_OracleExcpQ")) {
                        if (object instanceof String) {
                            this.excp_queue = (String)object;
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (string.equals("JMS_OracleDelay")) {
                        if (object instanceof NUMBER) {
                            this.msg_delay = ((Datum)object).intValue();
                        } else if (object instanceof String) {
                            try {
                                this.msg_delay = Integer.parseInt((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                AQjmsError.throwEx("Failed to set the JMS_OracleDelay property with " + object + ". This property must be a number", (Throwable)numberFormatException);
                            }
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (string.equals("JMS_OracleOriginalMessageID")) {
                        AQjmsError.throwEx(110, string);
                        break block44;
                    }
                    if (string.equals("JMS_OracleHeaderOnly")) {
                        AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, "yes");
                        this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                        break block44;
                    }
                    if (string.equals("JMS_OracleDeliveryMode")) {
                        AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, (String)object);
                        this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                        break block44;
                    }
                    if (string.equals("JMS_OracleConnectionID")) {
                        if (object instanceof String) {
                            AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, (String)object);
                            this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (string.equals("JMS_OracleTimestamp")) {
                        Object object2 = object;
                        if (object instanceof String) {
                            try {
                                object2 = new NUMBER(Long.parseLong((String)object));
                            }
                            catch (NumberFormatException numberFormatException) {
                                AQjmsError.throwEx("Failed to set the  JMS_OracleTimestamp property with " + object + ". This property must be a number", (Throwable)numberFormatException);
                            }
                        }
                        if (object2 instanceof NUMBER) {
                            AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(24, (Datum)((NUMBER)object2));
                            this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    AQjmsError.throwEx(140);
                    break block44;
                }
                AQjmsError.throwEx(140);
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setSystemProperty-sqlex", sQLException);
                throw sQLException;
            }
        }
    }

    Object getSystemProperty(String string) throws SQLException {
        Object object;
        block20: {
            object = null;
            Object var3_3 = null;
            int n = 0;
            try {
                if (m_systemProperties.containsKey(string)) {
                    if (string.equals("JMSXUserID")) {
                        object = this.header_ext.getUserid();
                        break block20;
                    }
                    if (string.equals("JMSXAppID")) {
                        object = this.header_ext.getAppid();
                        break block20;
                    }
                    if (string.equals("JMSXDeliveryCount")) {
                        return new NUMBER(this.attempts + 1);
                    }
                    if (string.equals("JMSXGroupID")) {
                        object = this.header_ext.getGroupid();
                        break block20;
                    }
                    if (string.equals("JMSXGroupSeq")) {
                        if (this.header_ext.getGroupseq() != null) {
                            n = this.header_ext.getGroupseq();
                            object = new NUMBER(n);
                            break block20;
                        }
                        return null;
                    }
                    if (string.equals("JMSXProducerTXID")) {
                        return null;
                    }
                    if (string.equals("JMSXConsumerTXID")) {
                        return null;
                    }
                    if (string.equals("JMSXRcvTimestamp") || string.equals("JMSXRecvTimestamp")) {
                        object = new NUMBER(this.recv_time);
                        break block20;
                    }
                    if (string.equals("JMSXState")) {
                        object = new NUMBER(this.msg_state);
                        break block20;
                    }
                    if (string.equals("JMS_OracleExcpQ")) {
                        object = this.excp_queue;
                        break block20;
                    }
                    if (string.equals("JMS_OracleDelay")) {
                        object = new NUMBER(this.msg_delay);
                        break block20;
                    }
                    if (string.equals("JMS_OracleOriginalMessageID")) {
                        object = this.orig_msg_id == null ? null : "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                        break block20;
                    }
                    if (string.equals("JMS_OracleHeaderOnly")) {
                        Object v = this.msg_properties.get(string);
                        object = v != null ? "yes" : null;
                        break block20;
                    }
                    if (string.equals("JMS_OracleConnectionID")) {
                        AQjmsPropDatum aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                        object = aQjmsPropDatum != null ? aQjmsPropDatum.getValue() : null;
                        break block20;
                    }
                    if (string.equals("JMS_OracleDeliveryMode")) {
                        Object v = this.msg_properties.get(string);
                        object = v != null ? ((AQjmsPropDatum)v).getStringValue() : null;
                        break block20;
                    }
                    if (string.equals("JMS_OracleTimestamp")) {
                        Object v = this.msg_properties.get(string);
                        object = v != null ? ((AQjmsPropDatum)v).getDatumValue() : null;
                        break block20;
                    }
                    return null;
                }
                return null;
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getSystemProperty-sqlex", sQLException);
                throw sQLException;
            }
        }
        return object;
    }

    void setReceiveTime(long l) {
        this.recv_time = l;
    }

    void setMessageState(int n) throws JMSException {
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            this.msg_state = n;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsMessage.setMessageState", "Internal error - invalid message state, msg_state: " + n);
            AQjmsError.throwEx(122);
        }
    }

    void setOriginalMessageId(byte[] byArray) throws JMSException {
        this.orig_msg_id = byArray;
    }

    void setExceptionQueue(String string) {
        this.excp_queue = string;
    }

    String getExceptionQueue() {
        return this.excp_queue;
    }

    void setDelay(int n) {
        this.msg_delay = n;
    }

    int getDelay() {
        return this.msg_delay;
    }

    public void setSignature(AQjmsSignature aQjmsSignature) {
        this.m_signature = aQjmsSignature;
    }

    public AQjmsSignature getSignature() {
        return this.m_signature;
    }

    void setHeaderOnly() {
        this.m_hdrOnly = true;
    }

    boolean isHeaderOnly() {
        return this.m_hdrOnly;
    }

    int getMsgState() {
        return this.msg_state;
    }

    String getMsgStateAsString() {
        if (this.msg_state == 0) {
            return "READY";
        }
        if (this.msg_state == 1) {
            return "WAITING";
        }
        if (this.msg_state == 2) {
            return "PROCESSED";
        }
        return "EXPIRED";
    }

    void checkPropertyName(String string) throws JMSException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Property name can not be null or empty string");
        }
    }

    void checkStringPropertyValue(String string, String string2) throws JMSException {
        if (string2 != null) {
            if (string.equalsIgnoreCase("JMSXAppID") || string.equalsIgnoreCase("JMSXUserID") || string.equalsIgnoreCase("JMSXGroupID") || string.equalsIgnoreCase("JMSXType")) {
                if (string2.length() > 100) {
                    AQjmsError.throwEx(165);
                }
            } else if (string2.length() > 4000) {
                AQjmsError.throwEx(165);
            }
        }
    }

    void insertPropertyIntoTable(Hashtable hashtable, String string, AQjmsPropDatum aQjmsPropDatum) throws JMSException {
        hashtable.put(string, aQjmsPropDatum);
    }

    void validateUserProperties() throws JMSException {
        if (this.msg_properties != null) {
            int n = this.msg_properties.size();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.validateUserProperties", "Total number of user properties " + n);
            if (n > 100) {
                AQjmsError.throwEx(132, "" + n);
            }
            Enumeration enumeration = this.msg_properties.keys();
            while (enumeration.hasMoreElements()) {
                AQjmsPropDatum aQjmsPropDatum;
                int n2;
                String string = (String)enumeration.nextElement();
                if (string.length() > 100) {
                    AQjmsError.throwEx(148);
                }
                if ((n2 = (aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string)).getType()) != 27) continue;
                String string2 = (String)aQjmsPropDatum.getValue();
                this.checkStringPropertyValue(string, string2);
            }
        } else {
            AQjmsOracleDebug.trace(4, "AQjmsMessage.validateUserProperties", "There are no user defined properties for this message");
        }
    }

    private static void initSystemPropertyTypeTable() {
        m_systemProperties = new Hashtable();
        m_systemProperties.put("JMSXAppID", m_strClass);
        m_systemProperties.put("JMSXUserID", m_strClass);
        m_systemProperties.put("JMSXRcvTimestamp", m_longClass);
        m_systemProperties.put("JMSXState", m_intClass);
        m_systemProperties.put("JMSXDeliveryCount", m_intClass);
        m_systemProperties.put("JMSXGroupID", m_strClass);
        m_systemProperties.put("JMSXGroupSeq", m_intClass);
        m_systemProperties.put("JMS_OracleExcpQ", m_strClass);
        m_systemProperties.put("JMS_OracleDelay", m_longClass);
        m_systemProperties.put("JMS_OracleOriginalMessageID", m_strClass);
        m_systemProperties.put("JMS_OracleHeaderOnly", m_strClass);
        m_systemProperties.put("JMS_OracleDeliveryMode", m_strClass);
        m_systemProperties.put("JMS_OracleConnectionID", m_strClass);
        m_systemProperties.put("JMS_OracleTimestamp", m_longClass);
        m_settableSystemProperties = new HashSet();
        m_settableSystemProperties.add("JMSXGroupID");
        m_settableSystemProperties.add("JMSXGroupSeq");
    }

    public void printSystemProperties() {
        AQjmsOracleDebug.trace(5, "printSystemProperties", "SYSTEM PROPERTIES");
        try {
            if (this.propertyExists("JMSXAppID")) {
                AQjmsOracleDebug.trace(5, "  JMSXAppID: ", this.getStringProperty("JMSXAppID"));
            }
            if (this.propertyExists("JMSXUserID")) {
                AQjmsOracleDebug.trace(5, "  JMSXUserID: ", this.getStringProperty("JMSXUserID"));
            }
            if (this.propertyExists("JMSXRcvTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXRcvTimestamp: " + this.getLongProperty("JMSXRcvTimestamp"));
            }
            if (this.propertyExists("JMSXState")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXState: " + this.getIntProperty("JMSXState"));
            }
            if (this.propertyExists("JMSXDeliveryCount")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXDeliveryCount: " + this.getIntProperty("JMSXDeliveryCount"));
            }
            if (this.propertyExists("JMSXGroupID")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupID: ", this.getStringProperty("JMSXGroupID"));
            }
            if (this.propertyExists("JMSXGroupSeq")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupSeq: ", this.getStringProperty("JMSXGroupSeq"));
            }
            if (this.propertyExists("JMS_OracleExcpQ")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleExcpQ: ", this.getStringProperty("JMS_OracleExcpQ"));
            }
            if (this.propertyExists("JMS_OracleDelay")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleDelay: " + this.getLongProperty("JMS_OracleDelay"));
            }
            if (this.propertyExists("JMS_OracleOriginalMessageID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleOriginalMessageID: ", this.getStringProperty("JMS_OracleOriginalMessageID"));
            }
            if (this.propertyExists("JMS_OracleDeliveryMode")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleDeliveryMode: ", this.getStringProperty("JMS_OracleDeliveryMode"));
            }
            if (this.propertyExists("JMS_OracleConnectionID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleConnectionID: ", this.getStringProperty("JMS_OracleConnectionID"));
            }
            if (this.propertyExists("JMS_OracleTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleTimestamp: " + this.getLongProperty("JMS_OracleTimestamp"));
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.trace(5, "PrintSystemPropertied", "Caught JMSException " + (Object)((Object)jMSException));
        }
    }

    private static String serializeDest(AQjmsDestination aQjmsDestination) throws JMSException {
        StringWriter stringWriter = new StringWriter();
        try {
            stringWriter.write("type=" + (aQjmsDestination.isQueue() ? 10 : 20) + "\n");
            stringWriter.write("owner=" + (aQjmsDestination.isQueue() ? aQjmsDestination.getQueueOwner() : aQjmsDestination.getTopicOwner()) + "\n");
            stringWriter.write("name=" + (aQjmsDestination.isQueue() ? aQjmsDestination.getQueueName() : aQjmsDestination.getTopicName()) + "\n");
            stringWriter.write("table=" + aQjmsDestination.getQueueTableName() + "\n");
            stringWriter.write("pload_type=" + aQjmsDestination.getPloadType() + "\n");
            stringWriter.write("adt_type=" + aQjmsDestination.getAdtType() + "\n");
            if (aQjmsDestination.isSecure()) {
                stringWriter.write("secure=true\n");
            } else {
                stringWriter.write("secure=false\n");
            }
            AQjmsDestinationProperty aQjmsDestinationProperty = aQjmsDestination.getProperty();
            stringWriter.write("property.queue_type=" + aQjmsDestinationProperty.getQueueType() + "\n");
            stringWriter.write("property.max_retries=" + aQjmsDestinationProperty.getMaxRetries() + "\n");
            stringWriter.write("property.retry_interval=" + aQjmsDestinationProperty.getRetryInterval() + "\n");
            stringWriter.write("property.retention_time=" + aQjmsDestinationProperty.getRetentionTime() + "\n");
            stringWriter.write("property.comment=" + aQjmsDestinationProperty.getComment() + "\n");
            stringWriter.write("property.sharded=" + aQjmsDestinationProperty.isSharded() + "\n");
            stringWriter.flush();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(147);
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AQjmsDestination deserializeDest(String string) throws JMSException {
        if (string == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        AQjmsDestination aQjmsDestination = null;
        boolean bl = false;
        try {
            String string2;
            Properties properties = new Properties();
            properties.load(byteArrayInputStream);
            AQjmsDestinationProperty aQjmsDestinationProperty = new AQjmsDestinationProperty();
            aQjmsDestinationProperty.setQueueType(Integer.parseInt(properties.getProperty("property.queue_type")));
            aQjmsDestinationProperty.setMaxRetries(Integer.parseInt(properties.getProperty("property.max_retries")));
            aQjmsDestinationProperty.setRetryInterval((double)new Double(properties.getProperty("property.retry_interval")));
            aQjmsDestinationProperty.setRetentionTime((double)new Double(properties.getProperty("property.retention_time")));
            aQjmsDestinationProperty.setComment(properties.getProperty("property.comment"));
            String string3 = properties.getProperty("property.sharded");
            if (string3 != null && string3.equals("true")) {
                aQjmsDestinationProperty.setSharded(true);
            }
            int n = Integer.parseInt(properties.getProperty("type"));
            String string4 = properties.getProperty("owner");
            String string5 = properties.getProperty("name");
            String string6 = properties.getProperty("table");
            int n2 = Integer.parseInt(properties.getProperty("pload_type"));
            String string7 = null;
            string3 = properties.getProperty("adt_type");
            if (string3 != null && !string3.equals("null")) {
                string7 = string3;
            }
            if ((string2 = properties.getProperty("secure")).equalsIgnoreCase("true")) {
                bl = true;
            }
            aQjmsDestination = new AQjmsDestination(string4, string5, n, n2, string7, aQjmsDestinationProperty, string6, bl);
        }
        catch (Exception exception) {
            AQjmsError.throwEx(147);
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return aQjmsDestination;
    }

    boolean isJMSBody() {
        return this.m_isjmsbody;
    }

    public static int toJMSPriority(int n) {
        return 9 - n;
    }

    OracleData getMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        return null;
    }

    AQjmsGenMessage_C getGenMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        return null;
    }

    void writeLob(AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, byte[] byArray, boolean bl) throws JMSException {
    }

    void messageSendCallback(boolean bl) throws JMSException {
        this.m_writeLobLater = false;
        if (this.m_tempLob != null) {
            if (AQjmsConstants.CACHE_TEMPLOBS && !bl) {
                if (this.m_tempLob instanceof OracleBlob) {
                    try {
                        ((OracleBlob)this.m_tempLob).truncate(0L);
                    }
                    catch (Exception exception) {
                        AQjmsOracleDebug.traceEx(1, "AQjmsMessage.truncateTemporaryBlob", exception);
                        this.freeTemporaryLob(this.m_tempLob);
                        throw new AQjmsTempLobTruncateException(true, exception);
                    }
                    finally {
                        this.m_tempLob = null;
                    }
                } else {
                    try {
                        ((OracleClob)this.m_tempLob).truncate(0L);
                    }
                    catch (Exception exception) {
                        AQjmsOracleDebug.traceEx(1, "AQjmsMessage.truncateTemporaryClob", exception);
                        this.freeTemporaryLob(this.m_tempLob);
                        throw new AQjmsTempLobTruncateException(false, exception);
                    }
                    finally {
                        this.m_tempLob = null;
                    }
                }
            } else {
                this.freeTemporaryLob(this.m_tempLob);
                this.m_tempLob = null;
            }
        }
    }

    private void freeTemporaryLob(Object object) {
        try {
            if (this.m_tempLob instanceof OracleBlob) {
                ((OracleBlob)this.m_tempLob).free();
            } else {
                ((OracleClob)this.m_tempLob).free();
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(1, "AQjmsMessage.freeTemporaryLob", exception);
        }
    }

    boolean getWriteLobLater() {
        return this.m_writeLobLater;
    }

    void setWriteLobLater(boolean bl) {
        this.m_writeLobLater = bl;
    }

    String getJmsHeaders(int n) throws JMSException {
        Object object;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ++n2;
        stringBuffer.append(",15,JMSDeliveryMode,");
        stringBuffer.append(27);
        if (n == 2) {
            stringBuffer.append(",10,PERSISTENT");
        } else {
            stringBuffer.append(",14,NON_PERSISTENT");
        }
        String string = this.getJMSType();
        if (string != null) {
            this.appendOneProp(stringBuffer, "JMSType", 27, string);
            ++n2;
        }
        try {
            Integer n3;
            String string2;
            String string3;
            String string4;
            object = this.header_ext.getReplyto();
            if (object != null && (string4 = ((AQjmsAgent)object).getAddress()) != null) {
                this.appendOneProp(stringBuffer, JMS_REPLY_TO, 27, string4);
                ++n2;
            }
            if ((string4 = this.header_ext.getUserid()) != null) {
                this.appendOneProp(stringBuffer, "JMSXUserID", 27, string4);
                ++n2;
            }
            if ((string3 = this.header_ext.getAppid()) != null) {
                this.appendOneProp(stringBuffer, "JMSXAppID", 27, string3);
                ++n2;
            }
            if ((string2 = this.header_ext.getGroupid()) != null) {
                this.appendOneProp(stringBuffer, "JMSXGroupID", 27, string2);
                ++n2;
            }
            if ((n3 = this.header_ext.getGroupseq()) != null) {
                this.appendOneProp(stringBuffer, "JMSXGroupSeq", 23, n3);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        stringBuffer.insert(0, n2);
        object = new String(stringBuffer);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.getJmsHeaders", (String)object);
        return object;
    }

    void setJmsHeaders(String string) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setJmsHeaders", "JMS headers string: " + string);
        if (string == null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = this.getPosOfComma(cArray, 0);
        if (n2 <= 0) {
            try {
                n = Integer.parseInt(string);
                if (n == 0) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.invalidHeaderString(string);
        }
        if ((n = Integer.parseInt(new String(cArray, 0, n2))) < 0) {
            this.invalidHeaderString(string);
        }
        ++n2;
        for (int i = 0; i < n; ++i) {
            n2 = this.processOneProperty(cArray, n2, true, string);
        }
    }

    void setUserProperties(String string) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setJmsHeaders", "user properties string: " + string);
        if (string == null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = this.getPosOfComma(cArray, 0);
        if (n2 <= 0) {
            try {
                n = Integer.parseInt(string);
                if (n == 0) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.invalidUserPropertyString(string);
        }
        if ((n = Integer.parseInt(new String(cArray, 0, n2))) < 0) {
            this.invalidUserPropertyString(string);
        }
        ++n2;
        for (int i = 0; i < n; ++i) {
            n2 = this.processOneProperty(cArray, n2, false, string);
        }
    }

    private int processOneProperty(char[] cArray, int n, boolean bl, String string) throws JMSException {
        int n2;
        int n3;
        int n4 = this.getPosOfComma(cArray, n);
        if (n4 <= 0) {
            this.invalidHeaderOrPropertyString(bl, string);
        }
        if ((n3 = Integer.parseInt(new String(cArray, n, n4 - n))) <= 0 || ++n4 + n3 >= cArray.length) {
            this.invalidHeaderOrPropertyString(bl, string);
        }
        String string2 = new String(cArray, n4, n3);
        if ((n4 += n3) >= cArray.length || cArray[n4] != ',') {
            this.invalidHeaderOrPropertyString(bl, string);
        }
        if ((n2 = this.getPosOfComma(cArray, ++n4)) <= 0) {
            this.invalidHeaderOrPropertyString(bl, string);
        }
        int n5 = Integer.parseInt(new String(cArray, n4, n2 - n4));
        n4 = n2 + 1;
        if ((n2 = this.getPosOfComma(cArray, n4)) <= 0) {
            this.invalidHeaderOrPropertyString(bl, string);
        }
        n3 = Integer.parseInt(new String(cArray, n4, n2 - n4));
        n4 = n2 + 1;
        if (n3 < 0 || n4 + n3 > cArray.length) {
            this.invalidHeaderOrPropertyString(bl, string);
        }
        String string3 = new String(cArray, n4, n3);
        if ((n4 += n3) < cArray.length && cArray[n4] == ',') {
            ++n4;
        }
        if (!bl) {
            this.setOneUserProperty(string2, string3, n5);
        } else {
            this.setOneHeaderProperty(string2, string3, n5);
        }
        return n4;
    }

    final void invalidHeaderString(String string) throws JMSException {
        throw new JMSException("Invalid JMS headers string: " + string);
    }

    final void invalidUserPropertyString(String string) throws JMSException {
        throw new JMSException("Invalid user properties string: " + string);
    }

    final void invalidHeaderOrPropertyString(boolean bl, String string) throws JMSException {
        if (bl) {
            throw new JMSException("Invalid JMS headers string: " + string);
        }
        throw new JMSException("Invalid user properties string: " + string);
    }

    private void validateTypeCode(int n, int n2, String string) throws JMSException {
        if (n2 != n) {
            throw new JMSException("Invalid headers or properties string: type code of header or property (" + string + ") is invalid, expected type code: " + n, " + found type code: " + n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setOneHeaderProperty(String string, String string2, int n) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setOneHeaderProperty", "name=" + string + ", type=" + n + ", value=" + string2);
        if (string.equals("JMSDeliveryMode")) {
            this.validateTypeCode(27, n, "JMSDeliveryMode");
            if (string2.equals("PERSISTENT")) {
                this.setJMSDeliveryMode(2);
                return;
            } else {
                if (!string2.equals("NON_PERSISTENT")) throw new JMSException("Invalid JMS headers string, found invalid property value of JMSDeliveryMode: " + string2);
                this.setJMSDeliveryMode(1);
            }
            return;
        } else if (string.equals("JMSType")) {
            this.validateTypeCode(27, n, "JMSType");
            this.setJMSType(string2);
            return;
        } else if (string.equals(JMS_REPLY_TO)) {
            this.validateTypeCode(27, n, JMS_REPLY_TO);
            AQjmsAgent aQjmsAgent = null;
            try {
                aQjmsAgent = new AQjmsAgent(JMS_REPLY_TO, string2);
                this.header_ext.setReplyto(aQjmsAgent);
                return;
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        } else {
            if (!string.startsWith("JMSX")) throw new JMSException("Invalid JMS headers string, found invalid header name: " + string);
            if (!this.setOneSystemProperty(string, string2, n)) return;
            return;
        }
    }

    private void setOneUserProperty(String string, String string2, int n) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsMessage.setOneUserProperty", "name=" + string + ", type=" + n + ", value=" + string2);
        if (string.startsWith("JMSX") && this.setOneSystemProperty(string, string2, n)) {
            return;
        }
        switch (n) {
            case 27: {
                this.setStringProperty2(string, string2);
                break;
            }
            case 20: {
                if (string2.equals("1")) {
                    this.setBooleanProperty(string, true);
                    break;
                }
                if (string2.equals("0")) {
                    this.setBooleanProperty(string, false);
                    break;
                }
                throw new JMSException("Invalid boolean value, name: " + string + ", value: " + string2);
            }
            case 21: {
                byte by = Byte.parseByte(string2);
                this.setByteProperty(string, by);
                break;
            }
            case 22: {
                short s = Short.parseShort(string2);
                this.setShortProperty(string, s);
                break;
            }
            case 23: {
                int n2 = Integer.parseInt(string2);
                this.setIntProperty(string, n2);
                break;
            }
            case 24: {
                long l = Long.parseLong(string2);
                this.setLongProperty(string, l);
                break;
            }
            case 25: {
                float f = Float.parseFloat(string2);
                this.setFloatProperty(string, f);
                break;
            }
            case 26: {
                double d = Double.parseDouble(string2);
                this.setDoubleProperty(string, d);
                break;
            }
            default: {
                throw new JMSException("Invalid type code, name: " + string + ", type: " + n);
            }
        }
    }

    private boolean setOneSystemProperty(String string, String string2, int n) throws JMSException {
        try {
            if (string.equals("JMSXUserID")) {
                this.validateTypeCode(27, n, "JMSXUserID");
                this.header_ext.setUserid(string2);
                return true;
            }
            if (string.equals("JMSXAppID")) {
                this.validateTypeCode(27, n, "JMSXAppID");
                this.header_ext.setAppid(string2);
                return true;
            }
            if (string.equals("JMSXGroupID")) {
                this.validateTypeCode(27, n, "JMSXGroupID");
                this.header_ext.setGroupid(string2);
                return true;
            }
            if (string.equals("JMSXGroupSeq")) {
                this.validateTypeCode(23, n, "JMSXGroupSeq");
                try {
                    this.header_ext.setGroupseq(new Integer(string2));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    AQjmsError.throwEx("Failed to set the JMSXGroupSeq property with value: " + string2 + ". This property must be a number", (Throwable)numberFormatException);
                }
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setOneSystemProperty", sQLException);
            AQjmsError.throwEx(119, (Throwable)sQLException);
        }
        return false;
    }

    private int getPosOfComma(char[] cArray, int n) {
        int n2;
        for (n2 = n; n2 < cArray.length && cArray[n2] != ','; ++n2) {
        }
        if (n2 < cArray.length) {
            return n2;
        }
        return -1;
    }

    public String test_getUserProperties() throws JMSException {
        return this.getUserProperties();
    }

    String getUserProperties() throws JMSException {
        int n = this.msg_properties.size();
        StringBuffer stringBuffer = new StringBuffer(n * 20);
        Enumeration enumeration = this.msg_properties.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            AQjmsPropDatum aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
            int n3 = aQjmsPropDatum.getType();
            Object object = aQjmsPropDatum.getValue();
            if (object == null) {
                this.msg_properties.remove(string);
            } else {
                this.appendOneProp(stringBuffer, string, n3, object);
            }
            ++n2;
        }
        stringBuffer.insert(0, this.msg_properties.size());
        String string = new String(stringBuffer);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.getUserProperties()", string);
        return string;
    }

    private void appendOneProp(StringBuffer stringBuffer, String string, int n, Object object) throws JMSException {
        stringBuffer.append(',');
        stringBuffer.append(string.length());
        stringBuffer.append(',');
        stringBuffer.append(string);
        stringBuffer.append(',');
        stringBuffer.append(n);
        stringBuffer.append(',');
        String string2 = null;
        if (n == 27) {
            string2 = (String)object;
        } else if (n == 25) {
            string2 = ((Float)object).toString();
        } else if (n == 26) {
            string2 = ((Double)object).toString();
        } else if (object instanceof NUMBER) {
            BigDecimal bigDecimal = null;
            try {
                bigDecimal = ((Datum)object).bigDecimalValue();
            }
            catch (SQLException sQLException) {
                AQjmsError.throwEx(sQLException.getMessage(), (Throwable)sQLException);
            }
            string2 = bigDecimal.toString();
        } else if (n == 23) {
            string2 = object.toString();
        } else {
            throw new JMSException("error: getUserProperties() type unkown");
        }
        stringBuffer.append(string2.length());
        stringBuffer.append(',');
        stringBuffer.append(string2);
    }

    private int getSystemProperties(StringBuffer stringBuffer) throws JMSException, SQLException {
        int n;
        int n2 = 0;
        String string = "JMSXUserID";
        Object object = this.getSystemProperty(string);
        if (object != null) {
            ++n2;
            n = 27;
            this.appendOneProp(stringBuffer, string, n, object);
        }
        if ((object = this.getSystemProperty(string = "JMSXAppID")) != null) {
            ++n2;
            n = 27;
            this.appendOneProp(stringBuffer, string, n, object);
        }
        if ((object = this.getSystemProperty(string = "JMSXGroupID")) != null) {
            ++n2;
            n = 27;
            this.appendOneProp(stringBuffer, string, n, object);
        }
        if ((object = this.getSystemProperty(string = "JMSXGroupSeq")) != null) {
            ++n2;
            n = 23;
            this.appendOneProp(stringBuffer, string, n, object);
        }
        return n2;
    }

    byte[] getBytesCont() throws JMSException {
        return null;
    }

    private void checkNullPropertyName(String string) throws JMSException {
        if (string == null) {
            AQjmsError.throwEx(139);
        }
    }

    InputStream getInputStream() {
        return this.m_inputStream;
    }

    public long getBodyLength() throws JMSException {
        return this.bodyLength;
    }

    void setBodyLength(long l) {
        this.bodyLength = l;
    }

    public boolean isLargeBody() {
        return this.largeBody;
    }

    void setLargeBody(boolean bl) {
        this.largeBody = bl;
    }

    byte[] getLobLocator() {
        return this.lobLocator;
    }

    void setLobLocator(byte[] byArray) {
        this.lobLocator = byArray;
    }

    void invalidReadWithStreaming(String string) throws JMSException {
        AQjmsError.throwEx(252, string);
    }

    void setInputStream(InputStream inputStream) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (inputStream == null) {
            AQjmsError.throwEx(249);
        }
        this.validateStreamingSupport();
        this.m_inputStream = inputStream;
    }

    void validateStreamingSupport() throws JMSException {
        if (!AQjmsConstants.useJmsStreaming()) {
            AQjmsError.throwEx(248);
        }
        if (this.getJMSDestination() != null && !((AQjmsDestination)this.getJMSDestination()).isSharded()) {
            AQjmsError.throwInvalidDestEx(245);
        }
        if (this.session == null) {
            AQjmsError.throwEx(194);
        }
        if (this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3) {
            AQjmsError.throwEx(255);
        }
        if (!this.session.getDriver().equalsIgnoreCase("thin")) {
            AQjmsError.throwEx(246, this.session.getDriver());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized OutputStream getBody(OutputStream outputStream, int n, long l) throws JMSException {
        if (outputStream == null) {
            AQjmsError.throwEx(250);
        }
        if (this.message_id.getJMSMessageID() == null) {
            AQjmsError.throwEx(253, "getBody");
        }
        this.validateStreamingSupport();
        if (this.session.isSessionClosed()) {
            AQjmsError.throwIllegalStateEx(131, null);
        }
        if (!this.isLargeBody()) {
            AQjmsError.throwEx(254);
        }
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        if (l <= 0L) {
            l = -1L;
        }
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)this.session.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getBody", exception);
            AQjmsError.throwEx(112, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(5, "AQjmsMessage.getBody", "After getDbConnection");
        BLOB bLOB = null;
        InputStream inputStream = null;
        try {
            bLOB = oracleConnection.createBlob(this.getLobLocator());
            if (bLOB.isEmptyLob()) {
                throw new AQjmsException("LOB Locator is null in Encounter null in getBody", 122);
            }
            inputStream = bLOB.getBinaryStream();
            if (n <= 0) {
                n = 8192;
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            if (l == -1L) {
                while ((n2 = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
            } else {
                long l2 = System.currentTimeMillis() + l;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    if (System.currentTimeMillis() < l2) {
                        outputStream.write(byArray, 0, n2);
                        continue;
                    }
                    throw new TimeoutException("The timeout value specified, " + l + " ms exceeded, getBody timed out.");
                }
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(120, (Throwable)sQLException);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getBody", exception);
            AQjmsError.throwEx(120, (Throwable)exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getBody", exception);
            }
            try {
                if (bLOB != null) {
                    bLOB.free();
                    bLOB.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return outputStream;
    }

    private boolean isSagaTimeout(String string) throws JMSException {
        try {
            OracleConnection oracleConnection = (OracleConnection)this.session.getDBConnection();
            int n = oracleConnection.commitRollbackSaga(" ", SagaUtils.parseHexBinary((String)string), oracleConnection.getSchema(), 17, 0, 0, null);
            if (n == 9) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        return false;
    }

    private void updateSagaTimeout(String string) throws JMSException {
        try {
            OracleConnection oracleConnection = (OracleConnection)this.session.getDBConnection();
            int n = oracleConnection.commitRollbackSaga("", SagaUtils.parseHexBinary((String)string), oracleConnection.getSchema(), 18, 0, 0, null);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    static {
        AQjmsMessage.initSystemPropertyTypeTable();
    }
}

