/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsUtil;

public class AQjmsTextMessage
extends AQjmsMessage
implements TextMessage {
    String m_textData = null;

    public AQjmsTextMessage() {
        super(true);
        this.access_mode = 2;
    }

    AQjmsTextMessage(AQjmsSession aQjmsSession, String string) {
        super(aQjmsSession, true);
        this.m_textData = string;
        this.access_mode = 2;
    }

    AQjmsTextMessage(AQjmsSession aQjmsSession) {
        super(aQjmsSession, true);
        this.access_mode = 2;
    }

    AQjmsTextMessage(AQjmsMessage aQjmsMessage) throws JMSException {
        super(aQjmsMessage);
    }

    AQjmsTextMessage(AQjmsSession aQjmsSession, AQjmsTextMessage_C aQjmsTextMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsTextMessage_C.getHeader();
            this.readTextMessageContainer(aQjmsTextMessage_C);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    AQjmsTextMessage(AQjmsSession aQjmsSession, AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsGenMessage_C.getHeader();
            this.readGenMessageContainer(aQjmsGenMessage_C);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.access_mode = 0;
    }

    public void setText(String string) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.m_textData = string;
    }

    public String getText() throws JMSException {
        return this.m_textData;
    }

    @Override
    public void clearBody() throws JMSException {
        this.m_textData = null;
        this.setAccessMode(2);
    }

    @Override
    OracleData getMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getMessageCont", "entry");
        AQjmsTextMessage_C aQjmsTextMessage_C = new AQjmsTextMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateTextContainer(aQjmsTextMessage_C, this.header_ext, this.m_textData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getMessageCont", "exit");
        return aQjmsTextMessage_C;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getGenMessageCont", "entry");
        AQjmsGenMessage_C aQjmsGenMessage_C = new AQjmsGenMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateTextContainer(aQjmsGenMessage_C, this.header_ext, this.m_textData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getGenMessageCont", "exit");
        return aQjmsGenMessage_C;
    }

    @Override
    void writeLob(AQjmsSession aQjmsSession, String string, byte[] byArray, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsTextmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeClob(this.m_textData, aQjmsSession, string, byArray, bl);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTexttmessage.writeLob", "exit");
    }

    private void readTextMessageContainer(AQjmsTextMessage_C aQjmsTextMessage_C) throws JMSException {
        try {
            this.m_textData = AQjmsUtil.getTextData(aQjmsTextMessage_C.getTextLen(), aQjmsTextMessage_C.getTextLob(), aQjmsTextMessage_C.getTextVc());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        try {
            this.m_textData = AQjmsUtil.getTextData(aQjmsGenMessage_C.getTextLen(), aQjmsGenMessage_C.getTextLob(), aQjmsGenMessage_C.getTextVc());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        byte[] byArray = null;
        if (this.m_textData != null) {
            try {
                byArray = this.m_textData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AQjmsException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return byArray;
    }
}

