/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ;

import oracle.jakarta.AQ.AQException;

public class AQEnqueueOption {
    public static final int DEVIATION_BEFORE = 2;
    public static final int DEVIATION_TOP = 3;
    public static final int VISIBILITY_ONCOMMIT = 2;
    public static final int VISIBILITY_IMMEDIATE = 1;
    static final int DEFAULT_VISIBILITY = 2;
    protected int m_visibility;
    private byte[] rel_msgid;
    Integer seq_deviation;
    private String transfxm;

    public AQEnqueueOption(int visibility, byte[] relative_msgid, int sequence_deviation) throws AQException {
        if (visibility != 1 && visibility != 2) {
            throw new AQException(0, "Invalid value for visibility");
        }
        this.m_visibility = visibility;
        this.rel_msgid = relative_msgid;
        this.seq_deviation = new Integer(sequence_deviation);
    }

    public AQEnqueueOption(int visibility, byte[] relative_msgid, Integer sequence_deviation) throws AQException {
        if (visibility != 1 && visibility != 2) {
            throw new AQException(0, "Invalid value for visibility");
        }
        this.m_visibility = visibility;
        this.rel_msgid = relative_msgid;
        this.seq_deviation = sequence_deviation;
    }

    public AQEnqueueOption() throws AQException {
        this(2, null, null);
    }

    public int getVisibility() throws AQException {
        return this.m_visibility;
    }

    public void setVisibility(int visibility) throws AQException {
        if (visibility != 1 && visibility != 2) {
            throw new AQException(0, "Invalid value for visibility");
        }
        this.m_visibility = visibility;
    }

    public byte[] getRelMessageId() throws AQException {
        return this.rel_msgid;
    }

    public int getSequenceDeviation() throws AQException {
        if (this.seq_deviation != null) {
            return this.seq_deviation;
        }
        return 0;
    }

    public void setSequenceDeviation(int sequence_deviation, byte[] relative_msgid) throws AQException {
        this.seq_deviation = new Integer(sequence_deviation);
        if (relative_msgid != null) {
            if (this.seq_deviation == 2) {
                this.rel_msgid = relative_msgid;
            } else {
                throw new AQException(0, "relative msgid can be specified only with DEVIATION_BEFORE");
            }
        }
    }

    public void setTransformation(String transformation) {
        this.transfxm = transformation;
    }

    public String getTransformation() {
        return this.transfxm;
    }
}

