/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.Session;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import oracle.jakarta.jms.AQjmsConsumer;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsObject;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsSelector;
import oracle.jakarta.jms.AQjmsSession;

public class AQjmsQueueBrowser
extends AQjmsObject
implements QueueBrowser,
Enumeration {
    QueueReceiver receiver;
    byte[] next_msg_id;
    int dequeue_mode;
    int browse_counter;
    boolean sel_msgid_flag = false;
    AQjmsSession jms_sess;
    AQjmsSelector b_selector;
    AQjmsDestination jms_dest;
    AQjmsMessage msg = null;
    AQjmsMessage new_msg = null;
    Hashtable msgid_seen = null;

    AQjmsQueueBrowser(Session session, Destination destination, int dest_type, int deq_mode, String consumer_name, AQjmsSelector selector, Object payload_factory) throws JMSException {
        super("QueueBrowser", (AQjmsSession)session);
        this.jms_sess = (AQjmsSession)session;
        this.dequeue_mode = deq_mode;
        this.jms_dest = (AQjmsDestination)destination;
        this.b_selector = selector;
        this.msgid_seen = new Hashtable();
        this.receiver = new AQjmsConsumer(this.jms_sess, destination, dest_type, deq_mode, consumer_name, payload_factory, selector, null);
        ((AQjmsSession)session).attach(this);
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    protected synchronized void localClose() {
        try {
            AQjmsOracleDebug.trace(5, "AQjmsQueueBrowser.close", "closing receiver");
            this.receiver.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkClosed("getQueue");
        if (this.jms_dest != null) {
            return this.jms_dest;
        }
        AQjmsError.throwEx(143);
        return null;
    }

    public synchronized Enumeration getEnumeration() throws JMSException {
        this.checkClosed("getEnumeration");
        return this;
    }

    public synchronized String getMessageSelector() throws JMSException {
        this.checkClosed("getMessageSelector");
        return this.receiver.getMessageSelector();
    }

    public synchronized Object nextElement() throws NoSuchElementException {
        AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.nextElement", "entry");
        try {
            this.checkClosed("nextElement");
            if (this.msg != null) {
                this.new_msg = this.msg;
                this.msg = null;
            } else {
                if (this.sel_msgid_flag) {
                    AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.nextElement", "no such element exception - deq by msgid");
                    throw new NoSuchElementException();
                }
                this.new_msg = (AQjmsMessage)this.receiver.receiveNoWait();
                if (this.new_msg == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsQueueBrowser.nextElement", "No such element exception");
                    throw new NoSuchElementException();
                }
            }
            AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.nextElement", "exit");
            if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
                this.sel_msgid_flag = true;
            }
            try {
                String id = this.new_msg.getJMSMessageID();
                this.msgid_seen.put(id, id);
            }
            catch (JMSException aq_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsQueueBrowser.nextElement", aq_ex);
            }
            return this.new_msg;
        }
        catch (JMSException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsQueueBrowser.nextElement", aq_ex);
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.sel_msgid_flag) {
            AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.hasMoreElements", "null message returned from receive-deq by msgid");
            return false;
        }
        if (this.msg != null) {
            AQjmsOracleDebug.trace(5, "AQjmsQueueBrowser.hasMoreElements", "message already exists");
            return true;
        }
        try {
            this.msg = (AQjmsMessage)this.receiver.receiveNoWait();
            if (this.msg == null) {
                AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.hasMoreElements", "null message returned from receive");
                return false;
            }
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsQueueBrowser.hasMoreElements - no message", ex);
            if (ex.getLinkedException() != null) {
                AQjmsOracleDebug.traceEx(3, "AQjmsQueueBrowser.hasMoreElements - no message- linked ex", ex.getLinkedException());
            }
            return false;
        }
        AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.hasMoreElements", "received message");
        if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
            this.sel_msgid_flag = true;
        }
        return true;
    }

    public void purgeSeen() throws JMSException {
        String ptype = null;
        int pload_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.purgeSeen", "entry");
        if (this.dequeue_mode != 2) {
            AQjmsOracleDebug.trace(3, "AQjmsQueueBrowser.purgeSeen", "invalid dequeue mode, not LOCKED");
            AQjmsError.throwEx(124);
        }
        pload_type = (ptype = this.jms_dest.getAdtType()).equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE") ? 1 : (ptype.equalsIgnoreCase("SYS.ANYDATA") ? 3 : 2);
        ((AQjmsConsumer)this.receiver).purgeSeen(this.msgid_seen, pload_type);
        this.msgid_seen.clear();
        AQjmsOracleDebug.trace(4, "AQjmsQueueBrowser.purgeSeen", "purged");
    }

    public void setTransformation(String transformation) {
        ((AQjmsConsumer)this.receiver).setTransformation(transformation);
    }

    public String getTransformation() {
        return ((AQjmsConsumer)this.receiver).getTransformation();
    }
}

