/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import oracle.jdbc.util.RepConversion;

class AQjmsMessageID {
    private byte[] systemMsgID = null;
    private String userSetID = null;
    private boolean hasUserSetID = false;

    AQjmsMessageID() {
    }

    synchronized String getJMSMessageID() {
        if (this.hasUserSetID) {
            return this.userSetID;
        }
        if (this.systemMsgID != null) {
            return "ID:" + RepConversion.bArray2String((byte[])this.systemMsgID);
        }
        return null;
    }

    synchronized String getPartialJMSMessageID() {
        if (this.hasUserSetID) {
            return this.userSetID;
        }
        if (this.systemMsgID != null) {
            return RepConversion.bArray2String((byte[])this.systemMsgID);
        }
        return null;
    }

    synchronized byte[] getJMSMessageIDAsBytes() {
        if (this.systemMsgID != null) {
            byte[] ret_msg_id = new byte[this.systemMsgID.length];
            System.arraycopy(this.systemMsgID, 0, ret_msg_id, 0, this.systemMsgID.length);
            return ret_msg_id;
        }
        return null;
    }

    synchronized void setJMSMessageID(byte[] id) {
        this.systemMsgID = id;
        this.userSetID = null;
        this.hasUserSetID = false;
    }

    synchronized void setJMSMessageID(String id) {
        this.userSetID = id;
        this.hasUserSetID = true;
    }
}

