/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import oracle.jakarta.jms.AQjmsClientSubscriberMap;
import oracle.jakarta.jms.AQjmsConnectionMetaData;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsDBConnMgr;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsExceptionListener;
import oracle.jakarta.jms.AQjmsGeneralDBConnection;
import oracle.jakarta.jms.AQjmsObject;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public class AQjmsConnection
extends AQjmsObject
implements QueueConnection,
TopicConnection,
AutoCloseable {
    int conn_type;
    AQjmsConnectionMetaData metadata;
    AQjmsExceptionListener m_el;
    int m_tempCount = 0;
    static Hashtable s_temps = new Hashtable();
    String connection_id;
    String clientID = null;
    private boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private boolean m_usetemplobs = AQjmsConstants.IS_USETEMPLOBS;
    AQjmsDBConnMgr connMgr = null;
    private boolean m_touched = false;
    Set<String> queueSet = new HashSet<String>();

    AQjmsConnection(String hostname, String oracle_sid, int portno, String username, String password, String jdbc_driver, int type) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(hostname, oracle_sid, portno, username, password, jdbc_driver, false);
        this.initialize(type);
    }

    AQjmsConnection(String url, Properties info, int type) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(url, info, false);
        this.initialize(type);
    }

    AQjmsConnection(String url, String username, String password, int type) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(url, username, password, false);
        this.initialize(type);
    }

    AQjmsConnection(Connection db_connection, int type) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(db_connection);
        this.initialize(type);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn ctor (user jdbc conn)", "connection: " + String.valueOf(db_connection) + " type: " + type);
    }

    AQjmsConnection(DataSource ds, String user, String password, int type) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(ds, user, password);
        this.initialize(type);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn ctor (datasource)", " type: " + type);
    }

    AQjmsConnection(OracleOCIConnectionPool cpool, int type) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(cpool);
        this.initialize(type);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn ctor (oci connection pool)", " type: " + type);
    }

    AQjmsConnection() {
        super("Connection", null);
    }

    void initialize(int type) throws JMSException {
        if (type == 10 || type == 20 || type == 30) {
            this.conn_type = type;
        } else {
            if (this.connMgr != null) {
                try {
                    this.connMgr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AQjmsError.throwEx(127);
        }
        this.metadata = new AQjmsConnectionMetaData();
        this.m_el = null;
    }

    String getUserName() {
        return this.connMgr.getUserName();
    }

    public String getClientID() throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        return this.getClientIDForce();
    }

    String getClientIDForce() {
        if (this.clientID == null) {
            return this.getUserName();
        }
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.m_touched) {
            AQjmsError.throwIllegalStateEx(240, null);
        }
        this.m_touched = true;
        this.clientID = clientID;
    }

    public synchronized ConnectionMetaData getMetaData() throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        return this.metadata;
    }

    public synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.m_el != null) {
            this.m_el.setExceptionListener(listener);
        } else {
            AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(true);
            this.m_el = new AQjmsExceptionListener(genConn);
            this.m_el.setParentJmsConn(this);
            if (this.isStarted()) {
                this.m_el.resumeExceptionListener();
            }
            this.m_el.setExceptionListener(listener);
        }
    }

    public synchronized ExceptionListener getExceptionListener() throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.m_el != null) {
            return this.m_el.getExceptionListener();
        }
        return null;
    }

    boolean getCompliant() {
        return this.compliant;
    }

    void setCompliant(boolean compliant) {
        this.compliant = compliant;
        AQjmsOracleDebug.trace(4, "AQjmsConnection.setCompliant", "Current <compliant> is set to:" + compliant);
    }

    protected boolean isUseTempLobs() {
        return this.m_usetemplobs;
    }

    void setUseTempLobs(boolean val) {
        this.m_usetemplobs = val;
        AQjmsOracleDebug.trace(4, "AQjmsConnection.setUseTempLobs", "Set usetemplobs to:" + val);
    }

    public synchronized void start() throws JMSException {
        this.m_touched = true;
        this.startAll("start");
        if (this.m_el != null) {
            this.m_el.resumeExceptionListener();
        }
    }

    public synchronized void stop() throws JMSException {
        this.m_touched = true;
        this.stopAll("stop");
        if (this.m_el != null) {
            this.m_el.suspendExceptionListener();
        }
        try {
            if (AQjmsConstants.useJmsNotification()) {
                this.handleJMSNotification();
            }
        }
        catch (TimeoutException timedOutException) {
            this.m_touched = true;
            this.startAll("start");
            if (this.m_el != null) {
                this.m_el.resumeExceptionListener();
            }
            AQjmsError.throwEx(256);
        }
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    protected synchronized void preClose() {
        AQjmsOracleDebug.trace(4, "AQjmsConnection.preClose", "ENTRY");
        if (this.m_el != null) {
            this.m_el.close();
            this.m_el = null;
        }
        AQjmsOracleDebug.trace(4, "AQjmsConnection.preClose", "EXIT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConnection.localClose", "ENTRY");
        if (AQjmsConstants.FREE_CLOSED_SUB) {
            AQjmsClientSubscriberMap.removeClientID(this.getClientIDForce());
        }
        Vector v = new Vector();
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            Enumeration de = s_temps.keys();
            while (de.hasMoreElements()) {
                Object d = de.nextElement();
                if (s_temps.get(d) != this) continue;
                v.addElement(d);
                s_temps.remove(d);
            }
        }
        if (v.size() > 0) {
            AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(true);
            Connection db_conn = genConn.getDBConnection();
            for (int i = 0; i < v.size(); ++i) {
                AQjmsDestination d = (AQjmsDestination)v.elementAt(i);
                try {
                    this.closeTemp(db_conn, d);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            genConn.close();
        }
        this.connMgr.close();
        AQjmsOracleDebug.trace(5, "AQjmsConnection.closeConnectionResources", "Connection closed");
    }

    public synchronized QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        AQjmsSession aq_sess = null;
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.conn_type != 10) {
            AQjmsError.throwEx(107, this.conn_type == 20 ? "TopicConnection" : "Connection");
        }
        AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(false);
        try {
            Connection dbConn = genConn.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(dbConn);
            }
            aq_sess = new AQjmsSession(this, acknowledgeMode, transacted, 10, genConn);
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createQueueSession", ex);
            throw ex;
        }
        finally {
            if (aq_sess == null) {
                try {
                    if (genConn != null) {
                        genConn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection:createQueueSession", "Created session");
        return aq_sess;
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public synchronized TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        AQjmsSession aq_sess = null;
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.conn_type != 20) {
            AQjmsError.throwEx(107, this.conn_type == 10 ? "QueueConnection" : "Connection");
        }
        AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(false);
        try {
            Connection dbConn = genConn.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(dbConn);
            }
            aq_sess = new AQjmsSession(this, acknowledgeMode, transacted, 20, genConn);
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createTopicSession", ex);
            throw ex;
        }
        finally {
            if (aq_sess == null) {
                try {
                    if (genConn != null) {
                        genConn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection:createTopicSession", "Created session");
        return aq_sess;
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public synchronized Session getCurrentJmsSession() {
        return (Session)super.anyChild();
    }

    public OracleOCIConnectionPool getOCIConnectionPool() {
        return this.connMgr.getOCIConnectionPool();
    }

    String getDriver() {
        return this.connMgr.getDriver();
    }

    short getDBVersion() {
        return this.connMgr.getDBVersion();
    }

    int getDBMaxIdenLength() {
        return this.connMgr.getDBMaxIdenLength();
    }

    int getDBCompatMajorVersion() {
        return this.connMgr.getDBCompatMajorVersion();
    }

    int getDBCompatMinorVersion() {
        return this.connMgr.getDBCompatMinorVersion();
    }

    void releaseExternalConnection() {
        this.connMgr.releaseExternalConnection();
    }

    void setPingPeriod(long period) throws JMSException {
        if (this.m_el != null) {
            this.m_el.setPingPeriod(period);
        } else {
            AQjmsError.throwEx(107, "Session with NO ExceptionListener");
        }
    }

    long getPingPeriod() {
        if (this.m_el != null) {
            return this.m_el.getPingPeriod();
        }
        return 120000L;
    }

    @Override
    protected void finalize() {
        try {
            if (!this.isClosed()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AQjmsOracleDebug.println("AQjmsConnection.finalize");
    }

    synchronized int getTempCount() {
        return ++this.m_tempCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTemp(AQjmsDestination d) throws JMSException {
        d.makeTemp();
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            s_temps.put(d, this);
        }
    }

    synchronized void closeTemp(Connection conn, AQjmsDestination d) throws JMSException {
        OracleCallableStatement stmt = null;
        AQjmsGeneralDBConnection genConn = null;
        try {
            if (conn == null) {
                genConn = this.connMgr.getConnection(true);
                conn = genConn.getDBConnection();
            }
            if (d.isSharded()) {
                String stmtStr = "BEGIN dbms_aqadm.stop_queue(queue_name => ?); dbms_aqadm.drop_sharded_queue(queue_name => ?); END;";
                stmt = (OracleCallableStatement)conn.prepareCall(stmtStr);
                stmt.setString(1, d.getCompleteName());
                stmt.setString(2, d.getCompleteName());
            } else {
                String stmtStr = "DECLARE PRAGMA AUTONOMOUS_TRANSACTION; BEGIN dbms_aqadm.stop_queue(queue_name => ?); dbms_aqadm.drop_queue(queue_name => ?); dbms_aqadm.drop_queue_table(queue_table => ?, force => true, auto_commit => true); END;";
                stmt = (OracleCallableStatement)conn.prepareCall(stmtStr);
                stmt.setString(1, d.getCompleteName());
                stmt.setString(2, d.getCompleteName());
                stmt.setString(3, d.getCompleteTableName());
            }
            stmt.execute();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (genConn != null) {
                genConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void findCloseTemp(AQjmsDestination d) throws JMSException {
        AQjmsConnection c = null;
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            if (!s_temps.containsKey(d)) {
                return;
            }
            c = (AQjmsConnection)s_temps.get(d);
            s_temps.remove(d);
        }
        if (c != null) {
            c.closeTemp(null, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsConnection getJmsConnection(AQjmsDestination d) {
        AQjmsConnection ret = null;
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            if (s_temps.containsKey(d)) {
                ret = (AQjmsConnection)s_temps.get(d);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectionID(Connection con) throws JMSException {
        Statement connIDSt = null;
        ResultSet rs = null;
        try {
            connIDSt = con.createStatement();
            rs = connIDSt.executeQuery("select SYS_GUID() from dual");
            rs.next();
            this.connection_id = this.BytesToString(rs.getBytes(1));
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(122, (Throwable)sql_ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connIDSt != null) {
                    connIDSt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String BytesToString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        for (int l = 0; l < byteArray.length; ++l) {
            int v = byteArray[l] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString();
    }

    String getConnectionID() {
        return this.connection_id;
    }

    public synchronized Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        AQjmsSession aq_sess = null;
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(false);
        try {
            Connection dbConn = genConn.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(dbConn);
            }
            aq_sess = new AQjmsSession(this, acknowledgeMode, transacted, 30, genConn);
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createSession", ex);
            throw ex;
        }
        finally {
            if (aq_sess == null) {
                try {
                    if (genConn != null) {
                        genConn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection:createSession", "Created session");
        return aq_sess;
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    void feedJMSException(JMSException exp) throws JMSException {
        ExceptionListener expListener = this.getExceptionListener();
        if (expListener != null) {
            this.m_el.feedJMSException(exp);
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsConnection:feedJMSException", "Exception Listener found Null for jms connection " + String.valueOf(this) + ". Queue List " + String.valueOf(this.queueSet) + " Time Now: " + String.valueOf(new Date()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueueToSet(String queue) {
        try {
            Set<String> set = this.queueSet;
            synchronized (set) {
                this.queueSet.add(queue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public Session createSession(int sessionMode) throws JMSException {
        return this.createSession(sessionMode == 0, sessionMode);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }
}

