/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import java.util.concurrent.ConcurrentHashMap;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsUcp;
import oracle.jakarta.jms.AQjmsUcpDs;

class AQjmsUcpClnT
extends Thread {
    private final AQjmsUcpDs clnPool;
    volatile boolean abort = false;
    int waitBreak = 10;
    int totalWait = 10;

    AQjmsUcpClnT(AQjmsUcpDs _clnPool) {
        this.clnPool = _clnPool;
        this.totalWait = this.clnPool.getWaitTime();
        try {
            this.waitBreak = Integer.parseInt("10");
        }
        catch (Exception e) {
            this.waitBreak = 10;
        }
    }

    void abortCleanup() {
        this.abort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int waitTimeLeft = this.totalWait;
        int sleepTime = this.waitBreak;
        String poolKey = this.clnPool.getPoolDataSource().getConnectionPoolName();
        try {
            while (waitTimeLeft > 0) {
                try {
                    sleepTime = waitTimeLeft > this.waitBreak ? this.waitBreak : waitTimeLeft;
                    Thread.sleep(sleepTime * 1000);
                    waitTimeLeft -= this.waitBreak;
                    if (!this.abort) continue;
                    AQjmsOracleDebug.trace(3, "AQjmsUcpClnT.run", "Pool with Key = " + poolKey + " back in use. ");
                    return;
                }
                catch (Exception exception) {
                }
            }
            ConcurrentHashMap<String, AQjmsUcpDs> concurrentHashMap = AQjmsUcp.poolMap;
            synchronized (concurrentHashMap) {
                if (this.clnPool.getUseCount() > 0) {
                    return;
                }
                Object object = AQjmsUcp.lockMgr;
                synchronized (object) {
                    if (this.clnPool.getUseCount() > 0) {
                        return;
                    }
                    AQjmsOracleDebug.trace(3, "AQjmsUcpClnT.run", "Deleting Pool with Key = " + this.clnPool.getPoolDataSource().getConnectionPoolName());
                    AQjmsUcp.deletePool(poolKey);
                }
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsUcpClnT.run Exception while Self Destroying Pool, UcpKey  " + poolKey, e);
        }
    }
}

