/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.jakarta.jms.AQjmsConnection;
import oracle.jakarta.jms.AQjmsConnectionFactory;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jakarta.jms.WebLogicHelper;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public class AQjmsQueueConnectionFactory
extends AQjmsConnectionFactory
implements QueueConnectionFactory,
Serializable {
    AQjmsQueueConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        this.data_source = null;
        if (driver != null) {
            if (driver.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (driver.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (driver.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, driver);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "hostname: " + hostname + "  oracle_sid: " + oracle_sid + "  port_no: " + portno + "  driver: " + driver);
    }

    AQjmsQueueConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = null;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "with jdbc connect string");
    }

    AQjmsQueueConnectionFactory(DataSource dsobj) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = dsobj;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "data source object: " + dsobj);
    }

    AQjmsQueueConnectionFactory(DataSource dsobj, String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = dsobj;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "with both ds and jdbc connect string");
    }

    AQjmsQueueConnectionFactory(String dsname) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = (DataSource)AQjmsUtil.lookupObject(dsname, DataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "data source name: " + dsname);
    }

    public AQjmsQueueConnectionFactory() {
    }

    public QueueConnection createQueueConnection() throws JMSException {
        AQjmsConnection qconn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            qconn = new AQjmsConnection(this.data_source, null, null, 10);
        } else {
            qconn = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 10) : (this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 10));
        }
        qconn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "Connection created successfully");
        return qconn;
    }

    public QueueConnection createQueueConnectionInternal() throws JMSException {
        AQjmsConnection qconn = null;
        qconn = this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 10) : (this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 10));
        qconn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnectionInternal", "Connection created successfully");
        return qconn;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        AQjmsConnection qconn = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "with user/pwd");
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            qconn = new AQjmsConnection(this.data_source, userName, password, 10);
        } else {
            Properties new_info = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (userName != null || password != null) {
                        new_info = (Properties)this.jdbc_info.clone();
                        new_info.put("user", userName);
                        new_info.put("password", password);
                    } else {
                        new_info = this.jdbc_info;
                    }
                    qconn = new AQjmsConnection(this.jdbc_conn_str, new_info, 10);
                } else {
                    qconn = new AQjmsConnection(this.jdbc_conn_str, userName, password, 10);
                }
            } else {
                qconn = this.data_source != null ? new AQjmsConnection(this.data_source, userName, password, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, userName, password, this.jdbc_driver, 10);
            }
        }
        qconn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/userName/password", "Connection created successfully");
        return qconn;
    }

    public static QueueConnection createQueueConnection(Connection jdbcConnection) throws JMSException {
        AQjmsConnection qconn = null;
        qconn = new AQjmsConnection(jdbcConnection, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/jdbc_conn", "Connection created successfully");
        return qconn;
    }

    public static QueueConnection createQueueConnection(Connection jdbcConnection, boolean compliant) throws JMSException {
        AQjmsConnection qconn = null;
        qconn = new AQjmsConnection(jdbcConnection, 10);
        qconn.setCompliant(compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/jdbc_conn", "Connection created successfully");
        return qconn;
    }

    public static QueueConnection createQueueConnection(OracleOCIConnectionPool connectionPool) throws JMSException {
        AQjmsConnection qconn = null;
        qconn = new AQjmsConnection(connectionPool, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/OCI_conn_pool", "Connection created successfully");
        return qconn;
    }

    public static QueueConnection createQueueConnection(OracleOCIConnectionPool connectionPool, boolean compliant) throws JMSException {
        AQjmsConnection qconn = null;
        qconn = new AQjmsConnection(connectionPool, 10);
        qconn.setCompliant(compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/OCI_conn_pool", "Connection created successfully");
        return qconn;
    }

    @Override
    boolean getCompliant() {
        return this.compliant;
    }

    @Override
    void setCompliant(boolean compliant) {
        this.compliant = compliant;
        AQjmsOracleDebug.trace(4, "AQjmsQueueConnectionFactory.setCompliant", "Current <compliant> is set to:" + compliant);
    }
}

