/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Topic;
import java.util.Hashtable;
import oracle.jakarta.jms.AQjmsCliSubMapEntry;
import oracle.jakarta.jms.AQjmsConstants;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsUtil;

class AQjmsClientSubscriberMap {
    private static Hashtable m_clientMap = new Hashtable();
    private static Object mapLock = new Object();

    AQjmsClientSubscriberMap() {
    }

    static Object getMapLock() {
        return mapLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsCliSubMapEntry createClientSubscriber(String client_id, String subs_name, Topic topic, String selector, boolean noLocal, String connection_id, String transformation) throws JMSException {
        Object object = mapLock;
        synchronized (object) {
            Hashtable<String, AQjmsCliSubMapEntry> subscriberMap;
            if (!AQjmsUtil.doubleQuoted(subs_name)) {
                subs_name = subs_name.toUpperCase();
            }
            if ((subscriberMap = (Hashtable<String, AQjmsCliSubMapEntry>)m_clientMap.get(client_id)) == null) {
                subscriberMap = new Hashtable<String, AQjmsCliSubMapEntry>();
                m_clientMap.put(client_id, subscriberMap);
                subscriberMap.put(subs_name, new AQjmsCliSubMapEntry(1, topic, selector, noLocal, connection_id, transformation));
                return null;
            }
            AQjmsCliSubMapEntry entry = (AQjmsCliSubMapEntry)subscriberMap.get(subs_name);
            if (entry == null) {
                subscriberMap.put(subs_name, new AQjmsCliSubMapEntry(1, topic, selector, noLocal, connection_id, transformation));
                return null;
            }
            if (entry.m_activeCount > 0) {
                AQjmsError.throwEx(230);
                return null;
            }
            subscriberMap.put(subs_name, new AQjmsCliSubMapEntry(1, topic, selector, noLocal, connection_id, transformation));
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsCliSubMapEntry addClientSubscriber(String client_id, String subs_name, Topic topic) throws JMSException {
        Object object = mapLock;
        synchronized (object) {
            subs_name = subs_name.toUpperCase();
            Hashtable subscriberMap = (Hashtable)m_clientMap.get(client_id);
            if (subscriberMap == null) {
                return null;
            }
            AQjmsCliSubMapEntry entry = (AQjmsCliSubMapEntry)subscriberMap.get(subs_name);
            if (entry != null && AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)entry.m_topic)) {
                ++entry.m_activeCount;
                return entry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsCliSubMapEntry getClientSubscriber(String client_id, String subs_name) {
        Object object = mapLock;
        synchronized (object) {
            subs_name = subs_name.toUpperCase();
            Hashtable subscriberMap = (Hashtable)m_clientMap.get(client_id);
            if (subscriberMap == null) {
                return null;
            }
            return (AQjmsCliSubMapEntry)subscriberMap.get(subs_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recoverClientSubscriber(String client_id, String subs_name, AQjmsCliSubMapEntry entry) {
        Object object = mapLock;
        synchronized (object) {
            subs_name = subs_name.toUpperCase();
            Hashtable<String, AQjmsCliSubMapEntry> subscriberMap = (Hashtable<String, AQjmsCliSubMapEntry>)m_clientMap.get(client_id);
            if (subscriberMap == null) {
                subscriberMap = new Hashtable<String, AQjmsCliSubMapEntry>();
                m_clientMap.put(client_id, subscriberMap);
            }
            subscriberMap.put(subs_name, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsCliSubMapEntry removeClientSubscriber(String client_id, String subs_name) {
        Object object = mapLock;
        synchronized (object) {
            subs_name = subs_name.toUpperCase();
            Hashtable subscriberMap = (Hashtable)m_clientMap.get(client_id);
            if (subscriberMap == null) {
                return null;
            }
            return (AQjmsCliSubMapEntry)subscriberMap.remove(subs_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean deactivateClientSubscriber(String client_id, String subs_name) {
        Object object = mapLock;
        synchronized (object) {
            subs_name = subs_name.toUpperCase();
            Hashtable subscriberMap = (Hashtable)m_clientMap.get(client_id);
            if (subscriberMap == null) {
                return false;
            }
            AQjmsCliSubMapEntry entry = (AQjmsCliSubMapEntry)subscriberMap.get(subs_name);
            if (entry == null) {
                return false;
            }
            if (entry.m_activeCount > 0) {
                --entry.m_activeCount;
            }
            if (AQjmsConstants.FREE_CLOSED_SUB && entry.m_activeCount == 0) {
                entry = (AQjmsCliSubMapEntry)subscriberMap.remove(subs_name);
            }
            return true;
        }
    }

    static boolean unsubscribeClientSubscriber(String client_id, String subs_name) throws JMSException {
        subs_name = subs_name.toUpperCase();
        Hashtable subscriberMap = (Hashtable)m_clientMap.get(client_id);
        if (subscriberMap == null) {
            return false;
        }
        AQjmsCliSubMapEntry entry = (AQjmsCliSubMapEntry)subscriberMap.get(subs_name);
        if (entry == null) {
            return false;
        }
        if (entry.m_activeCount > 0) {
            AQjmsError.throwEx(230);
        }
        subscriberMap.remove(subs_name);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeClientID(String client_id) {
        Object object = mapLock;
        synchronized (object) {
            Hashtable subscriberMap = (Hashtable)m_clientMap.get(client_id);
            if (subscriberMap == null || subscriberMap.size() == 0) {
                Hashtable hashtable = (Hashtable)m_clientMap.remove(client_id);
            }
        }
    }
}

