/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import oracle.jakarta.AQ.xml.AQxmlBase64Encoder;
import oracle.jakarta.AQ.xml.AQxmlClientRequest;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlGenConverter;
import oracle.jakarta.AQ.xml.AQxmlIdapConverter;
import oracle.jakarta.AQ.xml.AQxmlServerResponse;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class AQxmlSession {
    String sess_cookie = null;
    String http_user;
    String password;
    String dest_url;
    HttpURLConnection url_conn;
    AQxmlGenConverter doc_conv;

    AQxmlSession() {
        this.http_user = null;
        this.password = null;
        this.doc_conv = null;
    }

    public AQxmlSession(String dest_url, String http_user, String password) {
        this.http_user = http_user;
        this.password = password;
        AQxmlDebug.println("URL: " + dest_url);
        this.dest_url = dest_url;
        this.url_conn = null;
        this.doc_conv = null;
    }

    public String postAQxmlRequest(AQxmlClientRequest request) throws AQxmlException {
        URL url = null;
        XMLDocument xml_doc = null;
        String data = null;
        StringWriter str_writer = null;
        PrintWriter pr_writer = null;
        OutputStream out_stream = null;
        PrintWriter owriter = null;
        Object obj_stream = null;
        String ret_str = null;
        String ret_cookie = null;
        try {
            url = new URL(this.dest_url);
            this.url_conn = (HttpURLConnection)url.openConnection();
            AQxmlSession.setUserPassword(this.url_conn, this.http_user, this.password);
            if (this.sess_cookie != null) {
                AQxmlSession.setHttpCookie(this.url_conn, this.sess_cookie);
            }
            this.url_conn.setRequestMethod("POST");
            this.url_conn.setDoOutput(true);
            this.url_conn.setDoOutput(true);
            this.url_conn.setUseCaches(false);
            this.url_conn.setRequestProperty("Content-Type", "text/xml");
            str_writer = new StringWriter();
            pr_writer = new PrintWriter(str_writer);
            xml_doc = new XMLDocument();
            if (this.doc_conv == null) {
                this.doc_conv = new AQxmlIdapConverter();
            }
            this.doc_conv.generateDOMDocument((Document)xml_doc, request);
            xml_doc.print(pr_writer);
            data = str_writer.toString();
            AQxmlDebug.println("Generated XML: ");
            AQxmlDebug.println(data);
            out_stream = this.url_conn.getOutputStream();
            owriter = new PrintWriter(out_stream);
            owriter.println(data);
            owriter.flush();
            out_stream.flush();
            out_stream.close();
            this.url_conn.getInputStream();
            ret_cookie = AQxmlSession.getHttpCookie(this.url_conn);
            if (ret_cookie != null) {
                this.sess_cookie = ret_cookie;
            }
            ret_str = AQxmlSession.readHttpResponse(this.url_conn);
        }
        catch (AQxmlException aqxml_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSession.postAQxmlRequest-ex", aqxml_ex);
            throw aqxml_ex;
        }
        catch (IOException ex) {
            AQxmlDebug.traceEx(3, "AQxmlSession.postAQxmlRequest-ex", ex);
            AQxmlError.throwAQEx(403, ex);
        }
        return ret_str;
    }

    public String printAQxmlRequest(AQxmlClientRequest request) throws AQxmlException {
        XMLDocument xml_doc = null;
        String data = null;
        StringWriter str_writer = null;
        PrintWriter pr_writer = null;
        Object out_stream = null;
        Object owriter = null;
        Object obj_stream = null;
        Object ret_str = null;
        Object ret_cookie = null;
        try {
            str_writer = new StringWriter();
            pr_writer = new PrintWriter(str_writer);
            xml_doc = new XMLDocument();
            if (this.doc_conv == null) {
                this.doc_conv = new AQxmlIdapConverter();
            }
            this.doc_conv.generateDOMDocument((Document)xml_doc, request);
            xml_doc.print(pr_writer);
            data = str_writer.toString();
            AQxmlDebug.println("Generated XML: \n" + data);
        }
        catch (AQxmlException aqxml_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSession.printAQxmlRequest-ex", aqxml_ex);
            throw aqxml_ex;
        }
        catch (IOException ex) {
            AQxmlDebug.traceEx(3, "AQxmlSession.printAQxmlRequest-ex", ex);
            AQxmlError.throwAQEx(403, ex);
        }
        return data;
    }

    static String readHttpResponse(HttpURLConnection url_cn) throws AQxmlException {
        String line = null;
        StringBuffer data = null;
        try {
            data = new StringBuffer();
            AQxmlDebug.println("HTTP response code is " + url_cn.getResponseCode());
            AQxmlDebug.println("HTTP Content Length: " + url_cn.getContentLength());
            AQxmlDebug.println("HTTP Content Type: " + url_cn.getContentType());
            InputStream istream = url_cn.getInputStream();
            InputStreamReader ireader = new InputStreamReader(istream);
            BufferedReader bReader = new BufferedReader(ireader);
            while ((line = bReader.readLine()) != null) {
                data.append(line + "\n");
            }
            AQxmlDebug.println("HTTP Content: \n" + data.toString());
        }
        catch (Exception ex) {
            AQxmlDebug.println("Exception-1: " + ex);
        }
        if (data != null) {
            return data.toString();
        }
        return null;
    }

    public AQxmlServerResponse createAQxmlResponse(String response, DOMParser parser) {
        Object conv = null;
        return null;
    }

    static String getHttpCookie(HttpURLConnection url_cn) {
        String cookie = null;
        boolean idx = false;
        String ret_cookie = url_cn.getHeaderField("Set-Cookie");
        AQxmlDebug.trace(4, "AQxmlSession.getHttpCookie", "HTTP cookie header " + ret_cookie);
        if (ret_cookie != null) {
            cookie = ret_cookie.substring(0, ret_cookie.indexOf(59));
        }
        AQxmlDebug.trace(4, "AQxmlSession.getHttpCookie", "Cookie: " + cookie);
        return cookie;
    }

    static void setHttpCookie(HttpURLConnection url_cn, String cookie) {
        AQxmlDebug.trace(4, "AQxmlSession.setHttpCookie", "Cookie: " + cookie);
        if (cookie != null) {
            url_cn.setRequestProperty("Cookie", cookie);
        }
    }

    static void setUserPassword(HttpURLConnection url_cn, String user, String passwd) throws AQxmlException {
        AQxmlBase64Encoder enc = null;
        String userpwd = null;
        String enc_userpwd = null;
        userpwd = user + ":" + passwd;
        enc = new AQxmlBase64Encoder(userpwd);
        enc_userpwd = enc.processString();
        url_cn.setRequestProperty("Authorization", "Basic " + enc_userpwd);
    }
}

