/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.sql.Date;
import java.util.Hashtable;
import oracle.jakarta.AQ.xml.AQxmlAgent;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;

public class AQxmlMessagePropertyList {
    String m_type;
    AQxmlAgent reply_to;
    String userid;
    String appid;
    String groupid;
    int groupseq;
    Date recv_time;
    Hashtable user_properties;

    AQxmlMessagePropertyList(String msg_type) {
        this.m_type = msg_type;
        this.reply_to = null;
        this.userid = null;
        this.appid = null;
        this.groupid = null;
        this.groupseq = 0;
        this.recv_time = null;
        this.user_properties = new Hashtable();
    }

    public AQxmlMessagePropertyList() {
        this(null);
    }

    public void setMessageType(String type) {
        this.m_type = type;
    }

    public String getMessageType() {
        return this.m_type;
    }

    public AQxmlAgent getReplyTo() {
        return this.reply_to;
    }

    public void setReplyTo(AQxmlAgent replyto) {
        this.reply_to = replyto;
    }

    public String getUserId() {
        return this.userid;
    }

    public void setUserId(String uid) {
        this.userid = uid;
    }

    public String getAppId() {
        return this.appid;
    }

    public void setAppId(String app_id) {
        this.appid = app_id;
    }

    public String getGroupId() {
        return this.groupid;
    }

    void setGroupId(String gid) {
        this.groupid = gid;
    }

    public void setGroupSeq(int seq) {
        this.groupseq = seq;
    }

    public int getGroupSeq() {
        return this.groupseq;
    }

    public void setStringProperty(String name, String value) throws AQxmlException {
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        this.insertPropertyIntoTable(this.user_properties, name, value);
    }

    public String getStringProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = (Object)this.user_properties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public void setIntProperty(String name, int value) throws AQxmlException {
        Integer i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Integer(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public int getIntProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof String) {
                return Integer.parseInt(value);
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return 0;
    }

    public void setLongProperty(String name, long value) throws AQxmlException {
        Long i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Long(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public long getLongProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Integer) {
                return ((Integer)value).intValue();
            }
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof String) {
                return Long.parseLong(value);
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return 0L;
    }

    public void setDoubleProperty(String name, double value) throws AQxmlException {
        Double i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Double(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public double getDoubleProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof String) {
                return new Double(value);
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return 0.0;
    }

    public void setBooleanProperty(String name, boolean value) throws AQxmlException {
        Boolean i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Boolean(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public boolean getBooleanProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                return new Boolean(value);
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return false;
    }

    public void setFloatProperty(String name, float value) throws AQxmlException {
        Float i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Float(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public float getFloatProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            if (value instanceof String) {
                return new Float(value).floatValue();
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return 0.0f;
    }

    public void setShortProperty(String name, short value) throws AQxmlException {
        Short i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Short(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public short getShortProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Byte) {
                return ((Byte)value).byteValue();
            }
            if (value instanceof Short) {
                return value;
            }
            if (value instanceof String) {
                return new Short(value);
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return 0;
    }

    public void setByteProperty(String name, byte value) throws AQxmlException {
        Byte i = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        i = new Byte(value);
        this.insertPropertyIntoTable(this.user_properties, name, i);
    }

    public byte getByteProperty(String name) throws AQxmlException {
        Object ret_value = null;
        Object value = null;
        if (name == null) {
            AQxmlError.throwAQEx(425);
        }
        if ((value = this.user_properties.get(name)) != null) {
            if (value instanceof Byte) {
                return value;
            }
            if (value instanceof String) {
                return new Byte(value);
            }
            AQxmlError.throwAQEx(408);
        } else {
            AQxmlError.throwAQEx(426);
        }
        return 0;
    }

    void insertPropertyIntoTable(Hashtable table, String name, Object value) throws AQxmlException {
        if (name != null) {
            if (value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Boolean || value instanceof Float || value instanceof Short) {
                table.put(name, value);
            } else {
                AQxmlError.throwAQEx(423);
            }
        }
    }
}

