/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jakarta.AQ.xml.AQxmlAgent;
import oracle.jakarta.AQ.xml.AQxmlRawMessage;

public class AQxmlMessageHeader {
    byte[] message_id;
    String corr_id;
    Date enqueue_time;
    long expiration;
    int priority;
    boolean redelivered;
    AQxmlAgent sender_id;
    AQxmlAgent[] recp_list;
    int del_count;
    int state;
    int delay;
    String excp_queue;

    AQxmlMessageHeader(byte[] msg_id) {
        this.message_id = msg_id;
        this.corr_id = null;
        this.enqueue_time = null;
        this.expiration = -1L;
        this.priority = 1;
        this.redelivered = false;
        this.sender_id = null;
        this.recp_list = null;
        this.del_count = 0;
        this.state = 0;
        this.delay = 0;
        this.excp_queue = null;
    }

    public AQxmlMessageHeader() {
        this(null);
    }

    public String getMessageID() {
        String ret_msg_id = null;
        if (this.message_id != null) {
            ret_msg_id = AQxmlRawMessage.bArray2String(this.message_id);
        }
        return ret_msg_id;
    }

    public byte[] getMessageIDAsBytes() {
        return this.message_id;
    }

    void setMessageID(byte[] id) {
        this.message_id = id;
    }

    public void setCorrelationID(String correlationID) {
        this.corr_id = correlationID;
    }

    public String getCorrelationID() {
        return this.corr_id;
    }

    public Date getEnqueueTime() {
        return this.enqueue_time;
    }

    public void setEnqueueTime(Date enq_time) {
        this.enqueue_time = enq_time;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expire) {
        this.expiration = expire;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int m_priority) {
        this.priority = m_priority;
    }

    public AQxmlAgent getSenderId() {
        return this.sender_id;
    }

    public void setSenderId(AQxmlAgent senderid) {
        this.sender_id = senderid;
    }

    public boolean getRedelivered() {
        return this.redelivered;
    }

    void setRedelivered(boolean redelivered) {
        this.redelivered = redelivered;
    }

    public AQxmlAgent[] getRecipientList() {
        return this.recp_list;
    }

    public Vector getRcptListAsVector() {
        Vector<AQxmlAgent> recp_list_vec = null;
        if (this.recp_list != null) {
            recp_list_vec = new Vector<AQxmlAgent>();
            for (int i = 0; i < this.recp_list.length; ++i) {
                recp_list_vec.addElement(this.recp_list[i]);
            }
        }
        return recp_list_vec;
    }

    public void setRecipientList(AQxmlAgent[] recipient_list) {
        this.recp_list = recipient_list;
    }

    public void setRecipientList(Vector recipient_list) {
        this.recp_list = new AQxmlAgent[recipient_list.size()];
        Enumeration e = recipient_list.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.recp_list[i++] = (AQxmlAgent)e.nextElement();
        }
    }

    public int getDeliveryCount() {
        return this.del_count;
    }

    public void setDeliveryCount(int count) {
        this.del_count = count;
    }

    public void setDelay(int msg_delay) {
        this.delay = msg_delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getState() {
        return this.state;
    }

    void setState(int msg_state) {
        this.state = msg_state;
    }

    public String getExceptionQueue() {
        return this.excp_queue;
    }

    void setExceptionQueue(String excp_q) {
        this.excp_queue = excp_q;
    }
}

