/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.util.Vector;
import oracle.jakarta.AQ.xml.AQxmlClientRequest;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlJmsMessage;
import oracle.jakarta.AQ.xml.AQxmlMessage;
import oracle.jakarta.AQ.xml.AQxmlProducerOption;

public abstract class AQxmlEnqueueRequest
extends AQxmlClientRequest {
    AQxmlProducerOption prod_opt;
    Vector xml_msg_set;
    boolean jms_type = false;

    AQxmlEnqueueRequest(AQxmlProducerOption prod_option, Vector message_list) throws AQxmlException {
        if (prod_option == null) {
            AQxmlError.throwAQEx(401, "prod_option: null");
        }
        this.prod_opt = prod_option;
        if (message_list == null) {
            AQxmlError.throwAQEx(401, "message_list: null");
        }
        if (message_list.firstElement() instanceof AQxmlJmsMessage) {
            this.jms_type = true;
        }
        this.xml_msg_set = message_list;
    }

    AQxmlEnqueueRequest(AQxmlProducerOption prod_option, AQxmlMessage[] message_list) throws AQxmlException {
        if (prod_option == null) {
            AQxmlError.throwAQEx(401, "prod_option: null");
        }
        this.prod_opt = prod_option;
        if (message_list == null) {
            AQxmlError.throwAQEx(401, "message_list: null");
        } else {
            this.xml_msg_set = this.array2Vector(message_list);
        }
        if (this.xml_msg_set.firstElement() instanceof AQxmlJmsMessage) {
            this.jms_type = true;
        }
    }

    AQxmlEnqueueRequest(AQxmlProducerOption prod_option, AQxmlMessage message) throws AQxmlException {
        if (prod_option == null) {
            AQxmlError.throwAQEx(401, "prod_option: null");
        }
        this.prod_opt = prod_option;
        if (message == null) {
            AQxmlError.throwAQEx(401, "message: null");
        }
        if (message instanceof AQxmlJmsMessage) {
            this.jms_type = true;
        }
        this.xml_msg_set.addElement(message);
    }

    Object[] getJMSMessageList() {
        Object[] jms_msg_set = null;
        int i = 0;
        int num = 0;
        num = this.xml_msg_set.size();
        jms_msg_set = new Object[num];
        for (i = 0; i < num; ++i) {
            if (!(this.xml_msg_set.elementAt(i) instanceof AQxmlJmsMessage)) continue;
            jms_msg_set[i] = ((AQxmlJmsMessage)this.xml_msg_set.elementAt(i)).getJmsMessage();
        }
        if (jms_msg_set[0] != null) {
            return jms_msg_set;
        }
        return null;
    }

    Vector array2Vector(AQxmlMessage[] msg) {
        Vector<AQxmlMessage> ret_v = new Vector<AQxmlMessage>();
        int len = msg.length;
        for (int i = 0; i < len; ++i) {
            ret_v.addElement(msg[i]);
        }
        return ret_v;
    }

    boolean isJmsRequest() {
        return this.jms_type;
    }

    Vector getMessageList() {
        return this.xml_msg_set;
    }

    public AQxmlProducerOption getProducerOption() {
        return this.prod_opt;
    }
}

