/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlGenConverter;
import oracle.jakarta.AQ.xml.AQxmlServContext;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class AQxmlDriver {
    DOMParser parser = null;
    Document doc = null;
    String doc_ns = null;

    AQxmlDriver() {
    }

    public Document parseDocument(HttpServletRequest request, AQxmlServContext serv_ctx) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlDriver.parseDocument", "Entry - request");
        return this.parseDocument(request, null, serv_ctx);
    }

    public Document parseDocument(StringReader sreader, AQxmlServContext serv_ctx) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlDriver.parseDocument", "Entry - sreader");
        return this.parseDocument(null, sreader, serv_ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocument(HttpServletRequest request, StringReader sreader, AQxmlServContext serv_ctx) throws AQxmlException {
        String payload = null;
        StringReader data_stream = null;
        BufferedReader input_reader = null;
        Object schema = null;
        AQxmlGenConverter doc_conv = null;
        NodeList root_nl = null;
        Node root_node = null;
        StringTokenizer st = new StringTokenizer(request.getContentType(), ";");
        try {
            AQxmlDebug.trace(4, "AQxmlDriver.parseDocument", "Entry");
            if (sreader != null && request != null) {
                AQxmlError.throwAQEx(401, "both sreader and request cannot be non-null");
            }
            if (this.parser == null) {
                this.parser = new DOMParser();
            }
            this.parser.setSecureProcessing();
            doc_conv = serv_ctx.getConverter("http://ns.oracle.com/AQ/schemas/envelope");
            schema = doc_conv.getSchemaObject();
            this.parser.setErrorStream(AQxmlDebug.getPrintWriter());
            this.parser.showWarnings(true);
            this.parser.setPreserveWhitespace(false);
            this.parser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
            this.parser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)12);
            AQxmlDebug.trace(3, "AQxmlDriver.parseDocument", "parser " + this.parser);
            if (schema != null) {
                AQxmlDebug.trace(4, "AQxmlDriver.parseDocument", "Schema found - validation enabled:" + schema);
                this.parser.setSchemaValidationMode(true);
                this.parser.setXMLSchema(schema);
            } else {
                AQxmlDebug.trace(4, "AQxmlDriver.parseDocument", "Schema not found");
                this.parser.setValidationMode(false);
            }
            if (sreader != null) {
                AQxmlDebug.trace(5, "AQxmlDriver.parseDocument", "sreader != null");
                this.parser.parse((Reader)sreader);
            } else {
                payload = request.getParameter("aqxmldoc");
                Object object = schema;
                synchronized (object) {
                    if (payload != null) {
                        data_stream = new StringReader(payload);
                        this.parser.parse((Reader)data_stream);
                    } else {
                        AQxmlDebug.trace(5, "AQxmlDriver.constructor", "req_type: " + request.getContentType());
                        if (st.nextToken().equalsIgnoreCase("text/xml")) {
                            input_reader = request.getReader();
                            this.parser.parse((Reader)input_reader);
                        } else {
                            AQxmlError.throwAQEx(448);
                        }
                    }
                }
            }
            this.doc = this.parser.getDocument();
            root_nl = this.doc.getElementsByTagName("*");
            root_node = root_nl.item(0);
            this.doc_ns = ((XMLElement)root_node).getNamespace();
        }
        catch (IOException io_ex) {
            AQxmlDebug.traceEx(3, "AQxmlMessage.i_genXml", io_ex);
            AQxmlError.throwAQEx(403, io_ex);
        }
        catch (XMLParseException p_ex) {
            AQxmlDebug.traceEx(3, "AQxmlMessage.i_genXml", (Exception)((Object)p_ex));
            AQxmlError.throwAQEx(404, (Exception)((Object)p_ex));
        }
        catch (SAXException sax_ex) {
            AQxmlDebug.traceEx(3, "AQxmlMessage.i_genXml", sax_ex);
            AQxmlError.throwAQEx(405, sax_ex);
        }
        return this.doc;
    }

    void generateDOMDocument(AQxmlDocument[] retDocs, Document responseDoc, AQxmlServContext serv_ctx) throws IOException, AQxmlException {
        AQxmlGenConverter doc_conv = null;
        AQxmlDebug.trace(4, "AQxmlDriver.generateDOMDocument", "Entry");
        try {
            if (this.doc_ns == null) {
                AQxmlDebug.trace(4, "AQxmlDriver.generateDOMDocument", "document namespace is null - using IDAP");
                this.doc_ns = "http://ns.oracle.com/AQ/schemas/envelope";
            }
            if (serv_ctx == null) {
                AQxmlError.throwAQEx(401, "servlet context is null");
            }
            if ((doc_conv = serv_ctx.getConverter(this.doc_ns)) == null) {
                AQxmlError.throwAQEx(401, "document convertor is null");
            }
            doc_conv.generateDOMDocument(responseDoc, retDocs);
            if (AQxmlDebug.DEBUG) {
                ((XMLDocument)responseDoc).print(AQxmlDebug.getPrintWriter());
            }
        }
        catch (IOException io_ex) {
            AQxmlDebug.traceEx(3, "AQxmlDriver.GenerateDOMDocument-ioex", io_ex);
            throw io_ex;
        }
        catch (AQxmlException aq_ex) {
            AQxmlDebug.traceEx(3, "AQxmlDriver.generateDOMDocument", aq_ex);
            throw aq_ex;
        }
    }

    AQxmlDocument[] generateAQxmlDocument(Document dom_doc, AQxmlServContext serv_ctx) throws AQxmlException {
        NodeList root_nl = null;
        Node root_node = null;
        AQxmlDocument[] aqxml_docs = null;
        AQxmlGenConverter doc_conv = null;
        AQxmlDebug.trace(4, "AQxmlDriver.generateAQxmlDocument", "Entry");
        if (dom_doc == null) {
            AQxmlError.throwAQEx(401, "dom_doc cannot be null");
        }
        try {
            if (this.doc_ns == null) {
                if (this.doc != null) {
                    root_nl = this.doc.getElementsByTagName("*");
                    root_node = root_nl.item(0);
                    this.doc_ns = ((XMLElement)root_node).getNamespace();
                } else {
                    AQxmlError.throwAQEx(401, "doc and doc_ns cannot be null");
                }
            }
            doc_conv = serv_ctx.getConverter(this.doc_ns);
            aqxml_docs = doc_conv.generateAQxmlDocument(dom_doc);
        }
        catch (AQxmlException aq_ex) {
            AQxmlDebug.traceEx(3, "AQxmlDriver.generateAQxmlDocument", aq_ex);
            throw aq_ex;
        }
        return aqxml_docs;
    }

    Document getDocument() {
        AQxmlDebug.trace(4, "AQxmlDriver.getDocument", "Entry");
        return this.doc;
    }
}

