/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlServContext;

class AQxmlAuthContext {
    public static final int ENQUEUE = 0;
    public static final int DEQUEUE = 1;
    public static final int OTHER = 2;
    String http_user;
    public static int NOT_ALLOWED = 0;
    public static int ALLOWED = 1;
    Hashtable priv_cache;
    String current_db_user;

    AQxmlAuthContext(String http_user) throws AQxmlException {
        if (http_user == null) {
            AQxmlError.throwAQEx(401, "http_user cannot be null");
        }
        this.http_user = http_user;
        this.priv_cache = new Hashtable();
        this.current_db_user = null;
    }

    String getAgentName() {
        return this.http_user;
    }

    String getCurrentDbUser() {
        return this.current_db_user;
    }

    void setCurrentDbUser(String user) {
        this.current_db_user = user;
    }

    String getDBUser(AQxmlServContext serv_ctx, String owner, String queue, int operation, String currDBUser) throws SQLException, AQxmlException {
        AQxmlDebug.trace(4, "AQxmlAuthContext.getDBUser", "entry");
        if (operation != 0 && operation != 1 && operation != 2) {
            AQxmlError.throwAQEx(401, "operation must be one of ENQUEUE, DEQUEUE, or OTHER");
        }
        if (serv_ctx == null || operation != 2 && (owner == null || queue == null)) {
            AQxmlError.throwAQEx(401, "serv_ctx, owner, queue cannot be null");
        }
        Vector cached = null;
        if (operation != 2) {
            owner = owner.toUpperCase();
            queue = queue.toUpperCase();
        }
        if (currDBUser != null) {
            currDBUser = currDBUser.toUpperCase();
        }
        if (operation == 0) {
            cached = this.getPrivEnqUsers(owner, queue);
        } else if (operation == 1) {
            cached = this.getPrivDeqUsers(owner, queue);
        } else if (operation == 2) {
            cached = this.getPrivOthUsers();
        }
        if (cached == null) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.getDBUser", "exit: no cached info");
            return this.get_db_username_for_agent(serv_ctx, owner, queue, operation, currDBUser);
        }
        AQxmlDebug.trace(5, "AQxmlAuthContext.getDBUser", "cache hit");
        if (currDBUser == null || currDBUser.equals("")) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.getDBUser", "exit : no curr db user specified, returning some cached db user");
            return (String)cached.firstElement();
        }
        if (cached.contains(currDBUser)) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.getDBUser", "exit : found current db user " + currDBUser + " in cache");
            return currDBUser;
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.getDBUser", "exit : did not find current db user " + currDBUser + " in cache");
        return this.get_db_username_for_agent(serv_ctx, owner, queue, operation, currDBUser);
    }

    void removeFromCache(String db_username, String owner, String queue, int operation) throws AQxmlException {
        if (operation != 0 && operation != 1 && operation != 2) {
            AQxmlError.throwAQEx(401, "operation must be one of ENQUEUE, DEQUEUE, or OTHER");
        }
        if (db_username == null || operation != 2 && (owner == null || queue == null)) {
            AQxmlError.throwAQEx(401, "all arguments must be non null");
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.removeFromCache", "entry");
        String qName = operation != 2 ? owner.toUpperCase() + "." + queue.toUpperCase() : null;
        String cap_db_username = db_username.toUpperCase();
        if (operation == 2) {
            AQxmlDebug.trace(5, "AQxmlAuthContext.removeFromCache", "removing all occurences of " + cap_db_username);
            Enumeration all_priv_objects = this.priv_cache.elements();
            while (all_priv_objects.hasMoreElements()) {
                AQxmlQueuePriv thisPriv = (AQxmlQueuePriv)all_priv_objects.nextElement();
                thisPriv.removePrivEnqUser(cap_db_username);
                thisPriv.removePrivDeqUser(cap_db_username);
            }
        } else {
            AQxmlQueuePriv indiv_priv = (AQxmlQueuePriv)this.priv_cache.get(qName);
            if (indiv_priv != null) {
                if (operation == 0) {
                    AQxmlDebug.trace(5, "AQxmlAuthContext.removeFromCache", "removing " + cap_db_username + " from the enq list for queue: " + qName);
                    indiv_priv.removePrivEnqUser(cap_db_username);
                } else if (operation == 1) {
                    AQxmlDebug.trace(5, "AQxmlAuthContext.removeFromCache", "removing " + cap_db_username + " from the deq list for queue: " + qName);
                    indiv_priv.removePrivDeqUser(cap_db_username);
                }
            }
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.removeFromCache", "exit");
    }

    String get_db_username_for_agent(AQxmlServContext serv_ctx, String owner, String queue, int operation, String currDBUser) throws SQLException, AQxmlException {
        Connection currConn = null;
        String db_username = null;
        int enq_priv = 0;
        int deq_priv = 0;
        AQxmlDebug.trace(4, "AQxmlAuthContext.get_db_username_for_agent", "entry");
        try {
            currConn = serv_ctx.getParentDBConnection();
            CallableStatement sqlCall = currConn.prepareCall("begin dbms_aqjms.get_db_username_for_agent(agent_name => ?, owner_name => ?, queue_name => ?, operation => ?, curr_db_user => ?, db_username => ?, enq_priv => ?, deq_priv => ?); end;");
            sqlCall.setString(1, this.http_user);
            sqlCall.setString(2, owner);
            sqlCall.setString(3, queue);
            sqlCall.setInt(4, operation);
            sqlCall.setString(5, currDBUser);
            sqlCall.registerOutParameter(6, 12);
            sqlCall.registerOutParameter(7, 4);
            sqlCall.registerOutParameter(8, 4);
            sqlCall.execute();
            AQxmlDebug.trace(5, "AQxmlAuthContext.get_db_username_for_agent", "made sql call with parameters: http_user: " + this.http_user + " owner: " + owner + " queue: " + queue + " operation: " + operation + " currdbuser: " + currDBUser);
            db_username = sqlCall.getString(6);
            if (sqlCall.wasNull()) {
                AQxmlDebug.trace(5, "AQxmlAuthContext.get_db_username_for_agent", "db username returned from sql call was null");
                db_username = null;
            }
            enq_priv = sqlCall.getInt(7);
            deq_priv = sqlCall.getInt(8);
            try {
                sqlCall.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (AQxmlException aqx_ex) {
            AQxmlDebug.traceEx(5, "AQxmlAuthContext.get_db_username_for_agent", aqx_ex);
            throw aqx_ex;
        }
        finally {
            AQxmlDebug.trace(5, "AQxmlAuthContext.get_db_username_for_agent", "close parent conn");
            try {
                currConn.close();
                AQxmlDebug.trace(5, "AQxmlAuthContext.get_db_username_for_agent", "closed parent connection");
            }
            catch (Exception exception) {}
        }
        if (db_username != null) {
            if (operation != 2) {
                AQxmlDebug.trace(5, "AQxmlAuthContext.get_db_username_for_agent", "information received and cached: Queue Name: " + owner + "." + queue + " db username: " + db_username.toUpperCase() + " enq privilege: " + enq_priv + " deq privilege: " + deq_priv);
                this.updateCache(owner, queue, db_username.toUpperCase(), enq_priv, deq_priv);
            }
            AQxmlDebug.trace(4, "AQxmlAuthContext.get_db_username_for_agent", "exit : db username found");
            return db_username.toUpperCase();
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.get_db_username_for_agent", "exit : no db username found");
        return null;
    }

    void updateCache(String owner, String queue, String db_username, int enq_priv, int deq_priv) {
        AQxmlDebug.trace(4, "AQxmlAuthContext.updateCache", "entry");
        String qName = owner.toUpperCase() + "." + queue.toUpperCase();
        AQxmlQueuePriv existing_priv = (AQxmlQueuePriv)this.priv_cache.get(qName);
        if (existing_priv != null) {
            AQxmlDebug.trace(5, "AQxmlAuthContext.updateCache", "previous cache entry found, updating with Queue Name: " + qName + " db username: " + db_username.toUpperCase() + " enq privilege: " + enq_priv + " deq privilege: " + deq_priv);
            existing_priv.updatePrivileges(db_username.toUpperCase(), enq_priv, deq_priv);
        } else if (enq_priv != NOT_ALLOWED || deq_priv != NOT_ALLOWED) {
            AQxmlDebug.trace(5, "AQxmlAuthContext.updateCache", "new cache entry being made: Queue Name: " + qName + "db username: " + db_username.toUpperCase() + "enq privilege: " + enq_priv + "deq privilege: " + deq_priv);
            AQxmlQueuePriv new_priv = new AQxmlQueuePriv(db_username.toUpperCase(), enq_priv, deq_priv);
            this.priv_cache.put(qName, new_priv);
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.updateCache", "exit");
    }

    Vector getPrivEnqUsers(String owner, String queue) {
        AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivEnqUsers", "entry");
        String qName = owner.toUpperCase() + "." + queue.toUpperCase();
        AQxmlQueuePriv pres_priv = (AQxmlQueuePriv)this.priv_cache.get(qName);
        if (pres_priv != null && !pres_priv.getEnqUsers().isEmpty()) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivEnqUsers", "exit: cache hit");
            return pres_priv.getEnqUsers();
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivEnqUsers", "exit: cache miss");
        return null;
    }

    Vector getPrivDeqUsers(String owner, String queue) {
        AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivDeqUsers", "entry");
        String qName = owner.toUpperCase() + "." + queue.toUpperCase();
        AQxmlQueuePriv pres_priv = (AQxmlQueuePriv)this.priv_cache.get(qName);
        if (pres_priv != null && !pres_priv.getDeqUsers().isEmpty()) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivDeqUsers", "exit : cache hit");
            return pres_priv.getDeqUsers();
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivDeqUsers", "exit: cache miss");
        return null;
    }

    Vector getPrivOthUsers() {
        AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivOthUsers", "entry");
        Vector<String> ret_list = new Vector<String>();
        Enumeration users = this.priv_cache.elements();
        while (users.hasMoreElements()) {
            AQxmlQueuePriv thisPrivObj = (AQxmlQueuePriv)users.nextElement();
            Enumeration enq = thisPrivObj.getEnqUsers().elements();
            Enumeration deq = thisPrivObj.getDeqUsers().elements();
            while (enq.hasMoreElements()) {
                ret_list.addElement((String)enq.nextElement());
            }
            while (deq.hasMoreElements()) {
                ret_list.addElement((String)deq.nextElement());
            }
        }
        if (ret_list.isEmpty()) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivOthUsers", "exit : no db users found in cache");
            return null;
        }
        AQxmlDebug.trace(4, "AQxmlAuthContext.getPrivOthUsers", "exit : db users found");
        return ret_list;
    }

    class AQxmlQueuePriv {
        public Vector enq_db_usernames = new Vector();
        public Vector deq_db_usernames = new Vector();

        AQxmlQueuePriv() {
        }

        AQxmlQueuePriv(String db_username, int enq_priv, int deq_priv) {
            this.updatePrivileges(db_username, enq_priv, deq_priv);
        }

        void addPrivEnqUser(String db_username) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.addPrivEnqUser", "entry");
            if (!this.enq_db_usernames.contains(db_username)) {
                AQxmlDebug.trace(5, "AQxmlAuthContext.AQxmlQueuePriv.addPrivEnqUser", "adding to enq list");
                this.enq_db_usernames.addElement(db_username);
            }
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.addPrivEnqUser", "exit");
        }

        void removePrivEnqUser(String db_username) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.removePrivEnqUser", "entry");
            this.enq_db_usernames.removeElement(db_username);
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.removePrivEnqUser", "exit");
        }

        void addPrivDeqUser(String db_username) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.addPrivDeqUser", "entry");
            if (!this.deq_db_usernames.contains(db_username)) {
                this.deq_db_usernames.addElement(db_username);
            }
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.addPrivDeqUser", "exit");
        }

        void removePrivDeqUser(String db_username) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.removePrivDeqUser", "entry");
            this.deq_db_usernames.removeElement(db_username);
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.removePrivDeqUser", "exit");
        }

        Vector getEnqUsers() {
            return this.enq_db_usernames;
        }

        Vector getDeqUsers() {
            return this.deq_db_usernames;
        }

        void updatePrivileges(String db_username, int enq_priv, int deq_priv) {
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.updatePrivileges", "entry");
            if (enq_priv == ALLOWED) {
                this.addPrivEnqUser(db_username);
            }
            if (deq_priv == ALLOWED) {
                this.addPrivDeqUser(db_username);
            }
            AQxmlDebug.trace(4, "AQxmlAuthContext.AQxmlQueuePriv.updatePrivileges", "exit");
        }
    }
}

