/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;

public abstract class ChunkEventHandler
implements Diagnosable {
    static final String CLASS_NAME = ChunkEventHandler.class.getName();
    private Event recentEvent = null;
    private Thread controlThread;
    private final ReentrantLock startStopLock = new ReentrantLock();
    private volatile boolean terminated = false;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private static final Pattern eventAttrFmt = Pattern.compile("([a-zA-Z_]+)=([a-zA-Z_0-9\\.\\-\\:\\%]+|\\([a-zA-Z_0-9,=+/]+\\))");
    private static final Pattern tsFmt = Pattern.compile("(timestamp)=\\s*(\\S+\\s\\S+)");
    private static final Pattern tzFmt = Pattern.compile("(timezone)=(.*)");
    private static final Pattern tsStrFmt = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2}");
    private static final Pattern tzStrFmt = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");

    public ChunkEventHandler(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean start(ONSDriver oNSDriver) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "start", "entering args ({0})", null, null, oNSDriver);
            try {
                void onsDriver;
                this.startStopLock.lock();
                if (null != this.controlThread) {
                    boolean bl = true;
                    boolean bl2 = bl;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "start", "returning {0}", null, null, bl2);
                    return bl2;
                }
                this.controlThread = this.prepareControlThread((ONSDriver)onsDriver);
                this.controlThread.setDaemon(true);
                this.controlThread.start();
            }
            finally {
                this.startStopLock.unlock();
            }
            this.trace(Level.FINEST, CLASS_NAME, "start", "started", null, null, new Object[0]);
            boolean bl = true;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "start", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private Thread prepareControlThread(ONSDriver oNSDriver) {
        try {
            void onsDriver;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "prepareControlThread", "entering args ({0})", null, null, oNSDriver);
            Thread thread = new Thread(new Runnable(){
                volatile Subscriber subscriber = null;
                final /* synthetic */ ONSDriver val$onsDriver;
                {
                    this.val$onsDriver = oNSDriver;
                }

                @Override
                public void run() {
                    try {
                        this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){

                            @Override
                            public Subscriber run() throws UniversalConnectionPoolException {
                                try {
                                    return val$onsDriver.createSubscriber("(%\"eventType=database/event/chunk\")|(%\"eventType=database/event/routing\")");
                                }
                                catch (Exception e) {
                                    ChunkEventHandler.this.trace(Level.WARNING, CLASS_NAME, "prepareTask", "", null, e, new Object[0]);
                                    throw new UniversalConnectionPoolException(e);
                                }
                            }
                        });
                        if (null == this.subscriber) {
                            return;
                        }
                        this.handleNotifications();
                    }
                    catch (PrivilegedActionException e) {
                        ChunkEventHandler.this.trace(Level.WARNING, CLASS_NAME, "prepareTask", "", null, e, new Object[0]);
                    }
                    finally {
                        if (null != this.subscriber) {
                            this.subscriber.close();
                            this.subscriber = null;
                        }
                    }
                }

                private void handleNotifications() {
                    ChunkEventHandler.this.terminated = false;
                    while (!Thread.currentThread().isInterrupted() && !ChunkEventHandler.this.terminated) {
                        try {
                            Notification notification = this.subscriber.receive(true);
                            if (notification == null) {
                                ChunkEventHandler.this.trace(Level.FINE, CLASS_NAME, "handleNotifications", "empty notification", null, null, new Object[0]);
                                continue;
                            }
                            String nType = notification.type();
                            ChunkEventHandler.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", nType.toString(), null, null, new Object[0]);
                            String nBody = new String(notification.body());
                            ChunkEventHandler.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", nBody.toString(), null, null, new Object[0]);
                            Event event = ChunkEventHandler.this.parseNotification(nType, nBody);
                            if (ChunkEventHandler.this.outOfOrder(event)) continue;
                            ChunkEventHandler.this.recentEvent = event;
                            ChunkEventHandler.this.onEvent(event);
                            continue;
                        }
                        catch (Throwable e) {
                            ChunkEventHandler.this.trace(Level.WARNING, CLASS_NAME, "handleNotifications", "", null, e, new Object[0]);
                            continue;
                        }
                        break;
                    }
                    return;
                }
            }, "oracle.ucp.routing.ChunkEventHandler-control");
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "prepareControlThread", "returning {0}", null, null, thread);
            return thread;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "prepareControlThread", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private boolean outOfOrder(Event event) {
        try {
            void newEvent;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "outOfOrder", "entering args ({0})", null, null, event);
            if (this.recentEvent != null && newEvent.timeStamp().before(this.recentEvent.timeStamp())) {
                this.trace(Level.FINEST, CLASS_NAME, "outOfOrder", "Out-of-order chunk event received and ignored", null, null, new Object[0]);
                boolean bl = true;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "outOfOrder", "returning {0}", null, null, bl);
                return bl;
            }
            boolean bl = false;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "outOfOrder", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "outOfOrder", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    Event parseNotification(String string, String string2) {
        try {
            Matcher mg3;
            void nBody;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "parseNotification", "entering args ({0}, {1})", null, null, string, string2);
            Properties propsTmp = new Properties();
            Matcher mg1 = eventAttrFmt.matcher((CharSequence)nBody);
            while (mg1.find()) {
                propsTmp.setProperty(mg1.group(1), mg1.group(2));
            }
            final Properties props = new Properties();
            propsTmp.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> props.setProperty(((String)k).toLowerCase(), (String)v)));
            Matcher mg2 = tsFmt.matcher(nBody.toLowerCase());
            if (mg2.find()) {
                if (tsStrFmt.matcher(mg2.group(2)).find()) {
                    props.setProperty(mg2.group(1), mg2.group(2));
                } else {
                    throw new IllegalStateException("unaccepted timezone format: " + mg2.group(2));
                }
            }
            if ((mg3 = tzFmt.matcher(nBody.toLowerCase())).find()) {
                if (tzStrFmt.matcher(mg3.group(2)).find()) {
                    props.setProperty(mg3.group(1), mg3.group(2));
                } else {
                    throw new IllegalStateException("unaccepted timezone format: " + mg3.group(2));
                }
            }
            Event event = new Event(){
                private final String version;
                private String event_type;
                private final String database;
                private final String instance;
                private final String host;
                private final String dbDomain;
                private final String chunk;
                private final String newChunk;
                private final String toChunk;
                private final String hashBoundary;
                private final int priority;
                private final long lowHash;
                private final long highHash;
                private final Event.Status status;
                private final String[] aKeys;
                private final String[] aSplitValue;
                private Date timestamp;
                {
                    this.version = this.toLowerCase(props.getProperty("version"));
                    this.event_type = this.toLowerCase(props.getProperty("event_type", "UNKNOWN"));
                    this.database = this.toLowerCase(props.getProperty("database"));
                    this.instance = this.toLowerCase(props.getProperty("instance"));
                    this.host = this.toLowerCase(props.getProperty("host"));
                    this.dbDomain = this.toLowerCase(props.getProperty("db_domain"));
                    this.chunk = this.toLowerCase(props.getProperty("chunk"));
                    this.newChunk = this.toLowerCase(props.getProperty("newchunk"));
                    this.toChunk = this.toLowerCase(props.getProperty("tochunk"));
                    this.hashBoundary = this.toLowerCase(props.getProperty("hash"));
                    this.priority = Integer.parseInt(props.getProperty("priority", "0"));
                    this.lowHash = Long.parseLong(props.getProperty("low", "-1"));
                    this.highHash = Long.parseLong(props.getProperty("high", "-1"));
                    this.status = Event.Status.parse(this.toLowerCase(props.getProperty("status", "down")));
                    if (this.status == Event.Status.SPLIT) {
                        if (null == this.newChunk) {
                            throw new IllegalArgumentException("wrong chunk split notification format, New Chunk name is NULL");
                        }
                        if (this.event_type.equals("chunk") && (null == this.version || null == this.chunk || null == this.database || null == this.instance)) {
                            throw new IllegalArgumentException("Wrong chunk event format");
                        }
                        if (!this.event_type.equals("chunk")) {
                            throw new IllegalArgumentException("Wrong chunk event type");
                        }
                    }
                    this.aKeys = this.parseKeys(props.getProperty("keys"));
                    this.aSplitValue = this.parseKeys(props.getProperty("splitvalue"));
                    String ts = props.getProperty("timestamp", "");
                    String tz = props.getProperty("timezone", "");
                    if ("".equals(ts) && !"".equals(tz)) {
                        throw new IllegalStateException("single timezone (without timestamp) is not allowed");
                    }
                    if ("".equals(ts)) {
                        this.timestamp = new Date();
                    } else {
                        try {
                            this.timestamp = "".equals(tz) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ts) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse(ts + " GMT" + tz);
                        }
                        catch (ParseException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }

                private String[] parseKeys(String input) {
                    return null == input ? new String[]{} : input.trim().replaceAll("^\\(|\\)$", "").trim().split(",");
                }

                private String toLowerCase(String msg) {
                    if (Objects.isNull(msg)) {
                        return null;
                    }
                    return msg.toLowerCase();
                }

                public String toString() {
                    return ", version=" + this.version() + ", chunk=" + this.chunkName() + ", event_type=" + this.eventType() + ", db_domain=" + this.dbDomain() + ", instance=" + this.instanceName() + ", host=" + this.host() + ", database=" + this.database() + ", status=" + (Object)((Object)this.status()) + ", priority=" + this.priority() + ", newchunk=" + this.newChunkName() + ", tochunk=" + this.toChunkName() + ", keys=" + Arrays.toString(this.keys()) + ", splitvalue=" + Arrays.toString(this.splitvalue()) + ", hash split boundary=" + this.hashSplitBoundary() + ", timestamp=" + this.timeStamp() + ", low=" + this.lowHash() + ", high=" + this.highHash();
                }

                @Override
                public String version() {
                    return this.version;
                }

                @Override
                public String chunkName() {
                    return this.chunk;
                }

                @Override
                public String database() {
                    return this.database;
                }

                @Override
                public String host() {
                    return this.host;
                }

                @Override
                public String hashSplitBoundary() {
                    return this.hashBoundary;
                }

                @Override
                public Event.Status status() {
                    return this.status;
                }

                @Override
                public int priority() {
                    return this.priority;
                }

                @Override
                public String newChunkName() {
                    return this.newChunk;
                }

                @Override
                public String toChunkName() {
                    return this.toChunk;
                }

                @Override
                public String[] keys() {
                    return this.aKeys;
                }

                @Override
                public String[] splitvalue() {
                    return this.aSplitValue;
                }

                @Override
                public long lowHash() {
                    return this.lowHash;
                }

                @Override
                public long highHash() {
                    return this.highHash;
                }

                @Override
                public String eventType() {
                    return this.event_type;
                }

                @Override
                public String instanceName() {
                    return this.instance;
                }

                @Override
                public String dbDomain() {
                    return this.dbDomain;
                }

                @Override
                public Date timeStamp() {
                    return this.timestamp;
                }
            };
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "parseNotification", "returning {0}", null, null, event);
            return event;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "parseNotification", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Debug(level=Debug.Level.FINEST)
    public void stop() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "stop", "entering args ()", null, null, new Object[0]);
            try {
                this.startStopLock.lock();
                if (null == this.controlThread) {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "stop", "returning void", null, null, new Object[0]);
                    return;
                }
                this.controlThread.interrupt();
                this.controlThread = null;
            }
            finally {
                this.startStopLock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "stop", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.ChunkEventHandler", "stop", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected abstract void onEvent(Event var1) throws EventProcessingException;

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public static interface Event {
        public String version();

        public String eventType();

        public String chunkName();

        public String instanceName();

        public String database();

        public String host();

        public String dbDomain();

        public Status status();

        public String newChunkName();

        public String toChunkName();

        public String[] keys();

        public String[] splitvalue();

        public String hashSplitBoundary();

        public Date timeStamp();

        public int priority();

        public long lowHash();

        public long highHash();

        public static enum Status {
            ADD,
            DROP,
            DOWN,
            UP,
            READONLY,
            ADDVALUES,
            DROPVALUES,
            SPLIT,
            MERGE,
            INVALIDATE,
            PSET_SPLIT,
            NEW_PSET;


            static Status parse(String status) {
                for (Status s : Status.values()) {
                    if (!s.toString().toLowerCase().equals(status)) continue;
                    return s;
                }
                throw new IllegalStateException("unknown status " + status);
            }
        }
    }

    static class EventProcessingException
    extends Exception {
        private static final long serialVersionUID = 4343640747503L;

        EventProcessingException(String msg) {
            super(msg);
        }

        EventProcessingException(Throwable e) {
            super(e);
        }
    }
}

