/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

public class UCPTaskManagerImpl
implements TaskManager,
Diagnosable {
    static final String CLASS_NAME = UCPTaskManagerImpl.class.getName();
    public static final int THREAD_POOL_MAX_SIZE = 24;
    public static final int THREAD_POOL_CORE_SIZE = 2;
    public static final int THREAD_POOL_QUEUE_SIZE = 10;
    public static final int THREAD_POOL_KEEP_ALIVE_TIME = 3;
    private ExecutorService wtp = null;
    private final List<Thread> criticalThreads = Collections.synchronizedList(new ArrayList());
    private static AtomicInteger numCreatedCriticalThreads = new AtomicInteger(0);
    public static final String THREAD_NAME_PREFIX = "UCP-worker-thread-";

    @Override
    public synchronized void start() {
        if (null != this.wtp) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    ThreadFactory tf = new ThreadFactory(){
                        private final AtomicInteger numCreatedThreads = new AtomicInteger(0);

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread newT = new Thread(null, r, UCPTaskManagerImpl.THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                            newT.setPriority(5);
                            newT.setDaemon(true);
                            return newT;
                        }
                    };
                    UCPTaskManagerImpl.this.wtp = new UCPThreadPoolExecutor(2, 24, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), tf, UCPTaskManagerImpl.this.getUCPTaskRejectionHandler());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.trace(Level.WARNING, CLASS_NAME, "start", "", null, e, new Object[0]);
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return null != this.wtp;
    }

    @Override
    public synchronized void stop() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    if (null != UCPTaskManagerImpl.this.wtp) {
                        UCPTaskManagerImpl.this.wtp.shutdown();
                        UCPTaskManagerImpl.this.wtp = null;
                    }
                    List<Thread> list = UCPTaskManagerImpl.this.criticalThreads;
                    synchronized (list) {
                        for (Thread thread : UCPTaskManagerImpl.this.criticalThreads) {
                            if (!thread.isAlive()) continue;
                            thread.interrupt();
                        }
                        UCPTaskManagerImpl.this.criticalThreads.clear();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
        }
    }

    @Override
    public <T> TaskHandle<T> submitTask(Task<T> task) {
        if (null == this.wtp) {
            this.trace(Level.FINEST, CLASS_NAME, "submitTask", "wtp not started", null, null, new Object[0]);
            return null;
        }
        if (!(task instanceof UCPTaskBase)) {
            this.trace(Level.FINEST, CLASS_NAME, "submitTask", "wrong task object", null, null, new Object[0]);
            return null;
        }
        UCPTaskBase ucpTask = (UCPTaskBase)task;
        TaskHandle<T> handle = null;
        handle = ucpTask.isCritical() ? this.submitToDedicatedThread(ucpTask) : this.submitToWTP(ucpTask);
        return handle;
    }

    public <T> TaskHandle<T> submitToDedicatedThread(final Task<T> task) {
        ((UCPTaskBase)task).setFuture(null);
        final Thread newCriticalThread = new Thread("UCP-CriticalTaskExecutorThread-" + numCreatedCriticalThreads.incrementAndGet()){

            @Override
            public void run() {
                try {
                    task.call();
                }
                catch (Exception e) {
                    UCPTaskManagerImpl.this.trace(Level.WARNING, CLASS_NAME, "submitToDedicatedThread", "Exception during executing task: {0} in a dedicated thread {1}", null, null, task, e.getMessage());
                }
            }
        };
        newCriticalThread.setDaemon(true);
        newCriticalThread.start();
        this.criticalThreads.add(newCriticalThread);
        return new TaskHandle<T>(){

            @Override
            public T get(long timeout) throws TaskManagerException {
                try {
                    if (((UCPTaskBase)task).isCancelled()) {
                        newCriticalThread.interrupt();
                    } else if (timeout == 0L) {
                        newCriticalThread.join();
                    } else {
                        newCriticalThread.join(timeout);
                    }
                    if (!newCriticalThread.isAlive()) {
                        UCPTaskManagerImpl.this.criticalThreads.remove(newCriticalThread);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new TaskManagerException(e);
                }
            }

            @Override
            public Task<T> getTask() {
                return task;
            }
        };
    }

    public <T> TaskHandle<T> submitToWTP(final Task<T> task) {
        final Future<T> future = this.wtp.submit(task);
        ((UCPTaskBase)task).setFuture(future);
        return new TaskHandle<T>(){

            @Override
            public T get(long timeout) throws TaskManagerException {
                try {
                    if (timeout == 0L) {
                        return future.get();
                    }
                    return future.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new TaskManagerException(e);
                }
            }

            @Override
            public Task<T> getTask() {
                return task;
            }
        };
    }

    public ExecutorService getUCPThreadPool() {
        return this.wtp;
    }

    protected RejectedExecutionHandler getUCPTaskRejectionHandler() {
        return new UCPTaskRejectionHandler();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }

    final class UCPFutureTask<T>
    extends FutureTask<T> {
        private UCPTaskBase<T> ucpTask;

        public UCPFutureTask(Callable<T> callable) {
            super(callable);
            this.ucpTask = (UCPTaskBase)callable;
        }

        public UCPTaskBase<T> getUCPTask() {
            return this.ucpTask;
        }
    }

    final class UCPThreadPoolExecutor
    extends ThreadPoolExecutor {
        public UCPThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory tf, RejectedExecutionHandler rejectionHandler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, tf, rejectionHandler);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return new UCPFutureTask<T>(callable);
        }
    }

    class UCPTaskRejectionHandler
    extends ThreadPoolExecutor.CallerRunsPolicy {
        UCPTaskRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            UCPFutureTask ucpFutureTask;
            UCPTaskBase ucpRejectedTask;
            if (runnable instanceof UCPFutureTask && (ucpRejectedTask = (ucpFutureTask = (UCPFutureTask)runnable).getUCPTask()).isCritical()) {
                throw new RejectedExecutionException("Failed to execute Critical UCP Task: " + ucpRejectedTask + ", Hence Need to terminate process");
            }
            super.rejectedExecution(runnable, executor);
        }
    }
}

