/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import oracle.ucp.util.Chain;

public class ListChain<T>
implements Chain<T> {
    private final Atom head = new Atom();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private volatile int nAtoms = 0;

    public Atom add(T data) {
        Atom a;
        this.wLock.lock();
        try {
            a = new Atom(this.head, this.head.next, data);
            if (null != this.head.next) {
                this.head.next.prev = a;
            }
            this.head.next = a;
        }
        finally {
            this.wLock.unlock();
            ++this.nAtoms;
        }
        return a;
    }

    @Override
    public void forEach(Consumer<T> consumer) {
        this.rLock.lock();
        try {
            Atom a = this.head.next;
            while (null != a) {
                consumer.accept(a.getData());
                a = a.next;
            }
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public List<T> toList() {
        ArrayList elms = new ArrayList();
        this.rLock.lock();
        try {
            Atom a = this.head.next;
            while (null != a) {
                elms.add(a.getData());
                a = a.next;
            }
        }
        finally {
            this.rLock.unlock();
        }
        return elms;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public void clear() {
        this.wLock.lock();
        try {
            this.head.next = null;
            this.head.prev = null;
        }
        finally {
            this.wLock.unlock();
        }
        this.nAtoms = 0;
    }

    @Override
    public int size() {
        return this.nAtoms;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.nAtoms;
    }

    public class Atom
    implements Chain.Atom<T> {
        private Atom prev;
        private Atom next;
        private final T data;

        private Atom(Atom prev, Atom next, T data) {
            this.prev = prev;
            this.next = next;
            this.data = data;
        }

        private Atom() {
            this(null, null, null);
        }

        @Override
        public T getData() {
            return this.data;
        }

        @Override
        public void remove() {
            ListChain.this.wLock.lock();
            try {
                if (null == this.prev) {
                    return;
                }
                this.prev.next = this.next;
                if (null != this.next) {
                    this.next.prev = this.prev;
                }
                this.next = null;
                this.prev = null;
            }
            finally {
                ListChain.this.wLock.unlock();
                --ListChain.this.nAtoms;
            }
        }
    }
}

