/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.Limits;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.Policies;
import oracle.ucp.common.SelectorsUtil;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.common.waitfreepool.Factory;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.Predicates;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

public final class Core
implements Diagnosable {
    static final String CLASS_NAME = Core.class.getName();
    private final Pool<CoreConnection> waitFreePool = Factory.create();
    private static final boolean isAffinityStrict = Util.isAffinityStrict();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private Set<String> knownServices = ConcurrentHashMap.newKeySet();
    private AtomicReference<ConnectionSource> connectionSource = new AtomicReference<1>(new ConnectionSource(){});
    private AtomicReference<Limits> limits = new AtomicReference<2>(new Limits(){});
    private AtomicReference<Policies> policies = new AtomicReference<3>(new Policies(){
        private final IllegalStateException err = new IllegalStateException("policies are not set up yet");

        @Override
        public ConnectionRetrievalInfo getMostPopularCri() {
            throw this.err;
        }

        @Override
        public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
            throw this.err;
        }
    });
    private final AtomicLong emptyBorrows = new AtomicLong(0L);
    private final AtomicLong totalBorrows = new AtomicLong(0L);
    private final Predicate<CoreConnection> normalitySelector = conn -> {
        if (!conn.reusable()) {
            conn.markBad();
        }
        if (conn.closed() || conn.bad()) {
            this.cleanUselessAsynch();
            return false;
        }
        return true;
    };
    private static final int MAX_LRU_CACHE_SIZE = 512;
    private static final int ATTEMPTS = 5;
    private AtomicInteger pendingAvailableGrows = new AtomicInteger();
    private AtomicInteger pendingBorrowedGrows = new AtomicInteger();
    private volatile boolean noMoreGrows = false;
    private ReentrantLock stoppingLock = new ReentrantLock();
    private Condition stoppingCondition = this.stoppingLock.newCondition();
    private AtomicLong repurposeCount = new AtomicLong(0L);
    private static final int REBORROW_DELAY = 100;
    private ReentrantLock handlersLock = new ReentrantLock();
    private static final Predicate<CoreConnection> markedAlready = conn -> conn.markedCloseOnReturn() || conn.markedToReplace();
    private static final long MAKE_ROOM_POSTPONEMENT = 120L;
    private volatile long notAvailTS = Clock.clock();
    private volatile long latestMakeRoomTimeStamp = 0L;
    private AtomicBoolean cleanUselessInProgress = new AtomicBoolean(false);
    private static final long INITIALIZE_TIMEOUT = 1000L;
    private final AtomicBoolean adjusterEnabled = new AtomicBoolean(false);
    private final AtomicBoolean adjusterBusy = new AtomicBoolean(false);
    private static final int HARVESTING_ATTEMPTS = 5;
    AtomicBoolean keepOverMinimum = new AtomicBoolean(false);
    PeakIntegerCounter peakConnectionsCount = new PeakIntegerCounter();
    PeakIntegerCounter peakBorrowedConnectionsCount = new PeakIntegerCounter();
    public static final int ADJUST_MIN_LIMIT_ATTEMPTS = 10;
    public static final int BEST_INSTANCE_CREATION_ATTEMPTS = 3;
    public static final long ADJUST_MIN_LIMIT_DELAY = 2000L;
    private static final long CLOSE_ALL_TIMEOUT = 5000L;
    private static final Set<Core> coreInstances = Collections.synchronizedSet(new HashSet());

    Core(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
        coreInstances.add(this);
        this.trace(Level.FINEST, CLASS_NAME, "Core", "{0} core object to watch pending grows added", null, null, this.toString());
    }

    private void put(CoreConnection conn) {
        this.waitFreePool.put(conn);
        conn.serviceMember().serviceRef.buildDistributionTable();
        conn.onInsert();
        int totalCount = this.totalCount().get();
        this.peakConnectionsCount.update(totalCount);
        if (totalCount + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() >= this.limits().getMin()) {
            this.keepOverMinimum.set(true);
        }
    }

    void forEach(Consumer<CoreConnection> consumer) {
        this.forSome(p -> true, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreConnection> split(Predicate<CoreConnection> selector) {
        ArrayList<CoreConnection> connections = new ArrayList<CoreConnection>();
        PoolIterator<CoreConnection> it = this.waitFreePool.poolIterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection connection = (CoreConnection)it.next();
                if (!selector.test(connection)) continue;
                it.remove();
                connection.serviceMember().serviceRef.buildDistributionTable();
                connections.add(connection);
                connection.onRetrieve();
            }
        }
        finally {
            it.release();
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forSome(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?>[] suppliers) {
        boolean i = false;
        for (Supplier<?> supplier : suppliers) {
            Object oit = supplier.get();
            assert (oit instanceof PoolIterator) : "should be PoolIterator";
            PoolIterator it = (PoolIterator)oit;
            try {
                while (it.hasNext()) {
                    Object oconn = it.next();
                    assert (oconn instanceof CoreConnection) : "should be CoreConnection";
                    CoreConnection conn = (CoreConnection)oconn;
                    if (!selector.test(conn)) continue;
                    consumer.accept(conn);
                }
            }
            finally {
                it.release();
            }
        }
    }

    private void forSome(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?> supplier) {
        this.forSome(selector, consumer, new Supplier[]{supplier});
    }

    private void forSome(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer) {
        this.forSome(selector, consumer, () -> this.waitFreePool.poolIterator(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forFirst(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?>[] suppliers) {
        boolean i = false;
        for (Supplier<?> supplier : suppliers) {
            Object oit = supplier.get();
            assert (oit instanceof PoolIterator) : "must be PoolIterator";
            PoolIterator it = (PoolIterator)oit;
            try {
                while (it.hasNext()) {
                    Object oconn = it.next();
                    assert (oconn instanceof CoreConnection) : "must be CoreConnection";
                    CoreConnection conn = (CoreConnection)oconn;
                    if (!selector.test(conn)) continue;
                    consumer.accept(conn);
                    return;
                }
            }
            finally {
                it.release();
            }
        }
    }

    private void forFirst(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer, Supplier<?> supplier) {
        this.forFirst(selector, consumer, new Supplier[]{supplier});
    }

    private void forFirst(Predicate<CoreConnection> selector, Consumer<CoreConnection> consumer) {
        this.forFirst(selector, consumer, () -> this.waitFreePool.poolIterator(true));
    }

    private CoreConnection retrieveFirst(Predicate<CoreConnection> selector) {
        return this.retrieveFirst(selector, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection retrieveFirst(Predicate<CoreConnection> selector, boolean revisit) {
        CoreConnection found = null;
        PoolIterator<CoreConnection> it = this.waitFreePool.poolIterator(revisit);
        try {
            while (it.hasNext()) {
                CoreConnection conn = (CoreConnection)it.next();
                if (!selector.test(conn)) continue;
                it.remove();
                conn.serviceMember().serviceRef.buildDistributionTable();
                found = conn;
                conn.onRetrieve();
                break;
            }
        }
        finally {
            it.release();
        }
        return found;
    }

    private void registerService(String serviceName) {
        this.knownServices.add(serviceName);
        ConnectionSource.FailoverCallback failoverCallback = this.prepareFailoverHandler(serviceName);
        ConnectionSource.RebalanceCallback rebalanceCallback = this.prepareRebalanceHandler(serviceName);
        this.connectionSource().registerService(serviceName, failoverCallback, rebalanceCallback);
    }

    final void plugConnectionSource(ConnectionSource connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("null connectionSource");
        }
        this.connectionSource.set(connectionSource);
    }

    public ConnectionSource connectionSource() {
        return this.connectionSource.get();
    }

    final void plugLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("null limits");
        }
        this.limits.set(limits);
    }

    private Limits limits() {
        return this.limits.get();
    }

    final void plugPolicies(Policies policies) {
        if (policies == null) {
            throw new IllegalArgumentException("null policies");
        }
        this.policies.set(policies);
    }

    private Policies policies() {
        return this.policies.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoreConnection borrow(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeout) {
        CoreConnection conn = null;
        try {
            conn = this.helpBorrow(cri, callback, timeout);
            this.totalBorrows.incrementAndGet();
        }
        catch (Throwable throwable) {
            this.totalBorrows.incrementAndGet();
            this.peakBorrowedConnectionsCount.update(this.borrowedCount());
            if (conn != null) {
                try {
                    conn.onBorrow(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "borrow", "", null, e, new Object[0]);
                }
            } else {
                this.emptyBorrows.incrementAndGet();
                if (0L == this.emptyBorrows.get() % 1000L) {
                    String msg = "permits=" + this.connectionSource().getCriMetadata(cri).getBorrowSemaphore().availablePermits() + ", borrows: empty/total= " + (float)this.emptyBorrows.get() / (float)this.totalBorrows.get() * 100.0f + "%";
                    this.trace(Level.FINEST, CLASS_NAME, "borrow", "{0}", null, null, msg);
                }
            }
            throw throwable;
        }
        this.peakBorrowedConnectionsCount.update(this.borrowedCount());
        if (conn != null) {
            try {
                conn.onBorrow(cri);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "borrow", "", null, e, new Object[0]);
            }
        } else {
            this.emptyBorrows.incrementAndGet();
            if (0L == this.emptyBorrows.get() % 1000L) {
                String msg = "permits=" + this.connectionSource().getCriMetadata(cri).getBorrowSemaphore().availablePermits() + ", borrows: empty/total= " + (float)this.emptyBorrows.get() / (float)this.totalBorrows.get() * 100.0f + "%";
                this.trace(Level.FINEST, CLASS_NAME, "borrow", "{0}", null, null, msg);
            }
        }
        return conn;
    }

    private Predicate<CoreConnection> serviceSelector(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        assert (null != cs) : "connection source should be defined at this point";
        String serviceName = cs.serviceName(cri);
        return cs.serviceSelector(serviceName);
    }

    private Predicate<CoreConnection> keyBasedSelector(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        assert (null != cs) : "connection source should be defined at this point";
        if (cs.isShardedDatabase()) {
            Predicate<CoreConnection> prioritizedKeyBasedSelector = cs.routingKeyBasedBorrowSelector(cri, true);
            Predicate<CoreConnection> regularKeyBasedSelector = cs.routingKeyBasedBorrowSelector(cri, false);
            return prioritizedKeyBasedSelector.or(regularKeyBasedSelector);
        }
        if (cs.isRacDataAffinityEnabled()) {
            return cs.routingKeyBasedBorrowSelector(cri, false);
        }
        return p -> true;
    }

    private Predicate<CoreConnection> lbSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback) {
        ConnectionSource cs = this.connectionSource();
        assert (null != cs) : "connection source should be defined at this point";
        return cs.loadBalancedBorrowSelector(cri, callback);
    }

    private static long computeRemainingTimeToWait(long giveUpTimeStamp) {
        return Math.max(0L, giveUpTimeStamp - Clock.clock());
    }

    private CoreConnection helpBorrow(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeout) {
        ConnectionSource cs = this.connectionSource();
        long giveUpTimeStamp = Clock.clock() + timeout;
        BorrowContext borrowCtx = new BorrowContext(cri, callback, giveUpTimeStamp);
        Predicate<CoreConnection> balancedKeyBasedSelector = borrowCtx.basicCommonSelector(true, true);
        Predicate<CoreConnection> balancedNonKeyBasedSelector = borrowCtx.basicCommonSelector(true, false);
        Predicate<CoreConnection> unBalancedKeyBasedSelector = borrowCtx.basicCommonSelector(false, true);
        CoreConnection conn = null;
        try {
            boolean dbAffinity;
            boolean bl = dbAffinity = null != callback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == callback.getAffinityPolicy();
            if ((cs.failoverEnabled() || dbAffinity) && !cs.isColocation()) {
                conn = borrowCtx.findFirst(balancedKeyBasedSelector, 5);
                if (null == conn) {
                    if (cs.isRacDataAffinityEnabled()) {
                        conn = borrowCtx.findFirst(unBalancedKeyBasedSelector, 5);
                        if (null == conn && !isAffinityStrict) {
                            conn = borrowCtx.findFirst(balancedNonKeyBasedSelector, 5);
                        }
                    } else if (!dbAffinity || !isAffinityStrict) {
                        conn = borrowCtx.findFirst(unBalancedKeyBasedSelector, 5);
                    }
                } else if (null != callback) {
                    ConnectionAffinityCallback.AffinityPolicy policy = callback.getAffinityPolicy();
                    if (callback.getConnectionAffinityContext() == null) {
                        ServiceMember chosenConnInstance = conn.serviceMember();
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == policy && chosenConnInstance.affined() || ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == policy) {
                            this.trace(Level.FINEST, CLASS_NAME, "helpBorrow", "Updating affinity context with instance {0}", null, null, chosenConnInstance.name());
                            callback.setConnectionAffinityContext(new AffinityContext(chosenConnInstance.service(), chosenConnInstance.database(), chosenConnInstance.name(), policy));
                        }
                    }
                }
            } else {
                conn = borrowCtx.findFirst(unBalancedKeyBasedSelector, 5);
            }
            if (null != conn) {
                if (cs.failoverEnabled() && !cs.isColocation()) {
                    this.updateRLBStats(conn.serviceMember());
                }
                try {
                    WLSJTAPlugin.checkXAAffinity(conn.serviceMember());
                }
                catch (UniversalConnectionPoolException exc) {
                    this.trace(Level.WARNING, CLASS_NAME, "helpBorrow", "##### WLSJTAPlugin.checkXAAffinity() threw exception: ", null, exc, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            this.handleUncheckedException(e, conn);
            conn = null;
            throw e;
        }
        return conn;
    }

    private void handleUncheckedException(Throwable e, CoreConnection ... connsToInvalidate) {
        this.trace(Level.WARNING, CLASS_NAME, "handleUncheckedException", "got unchecked exception from user-defined connection labeling callback", null, e, new Object[0]);
        for (CoreConnection conn : connsToInvalidate) {
            if (null == conn) continue;
            conn.markBad();
            conn.makeAvailable();
        }
    }

    private void updateRLBStats(ServiceMember serviceMember) {
        if (serviceMember.violatingRLBAdvisory()) {
            serviceMember.lbStats.onFailedLbBorrowed();
            serviceMember.serviceRef.lbStats.onFailedLbBorrowed();
        } else {
            serviceMember.lbStats.onSuccessfulLbBorrowed();
            serviceMember.serviceRef.lbStats.onSuccessfulLbBorrowed();
        }
    }

    void waitForPoolUpdate(ConnectionRetrievalInfo cri, long timeout) {
        CriStats criMetadata = this.connectionSource().getCriMetadata(cri);
        assert (Objects.nonNull(criMetadata));
        criMetadata.waitForPoolUpdate(timeout);
    }

    final void reclaim(CoreConnection conn) {
        this.debug(Level.FINEST, CLASS_NAME, "reclaim", "about to reclaim, conn={0}, status={1}", null, null, conn, ((UniversalPooledConnection)conn.getDelegate()).getStatus());
        if (conn.available()) {
            return;
        }
        boolean replaceOnReturn = false;
        if (conn.normal()) {
            if (conn.reusable()) {
                try {
                    conn.onReturn();
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "reclaim", "", null, e, new Object[0]);
                }
                conn.makeAvailable();
                return;
            }
            if (!conn.markedCloseOnReturn()) {
                replaceOnReturn = true;
            }
        } else if (conn.markedToReplace()) {
            replaceOnReturn = true;
        }
        this.retrieve(conn);
        this.trace(Level.FINEST, CLASS_NAME, "reclaim", "connection reclaim, about to close, conn={0}", null, null, conn);
        conn.handleTimeout();
        conn.abort();
        conn.close();
        if (replaceOnReturn) {
            this.growAvailableAsynch(conn.cri());
        }
    }

    private ConnectionRetrievalInfo updatePasswordFromDefault(ConnectionRetrievalInfo cri) {
        Objects.requireNonNull(cri);
        ConnectionRetrievalInfo defaultCri = this.connectionSource().defaultCriAndService();
        Objects.requireNonNull(defaultCri);
        if (cri instanceof JDBCConnectionRetrievalInfo && defaultCri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jcri = (JDBCConnectionRetrievalInfo)cri;
            JDBCConnectionRetrievalInfo jDefaultCri = (JDBCConnectionRetrievalInfo)defaultCri;
            if (cri.equalsNotIncludingPassword(defaultCri)) {
                return jcri.getCopyWithPassword(jDefaultCri.getPassword());
            }
        }
        return cri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CoreConnection growBorrowed(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry) throws UniversalConnectionPoolException {
        CoreConnection connection = null;
        ConnectionSource cs = this.connectionSource();
        int total = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
        int borrowed = this.borrowedCount();
        boolean shareable = cs.isShareable();
        boolean multitenantDatabase = cs.isMultitenantDatabase();
        int min = this.limits().getMin();
        int max = this.limits().getMax();
        int repurposeThreshold = this.limits().getRepurposeThreshold();
        boolean repurposeAllowed = shareable && multitenantDatabase && total > min && total > repurposeThreshold && total > borrowed;
        boolean makeRoomAllowed = total > max && total > borrowed;
        this.trace(Level.FINEST, CLASS_NAME, "growBorrowed", "repurposeAllowed={0}, makeRoomAllowed={1}, shareable={2}, multitenantDatabase={3}, total={4}, borrowed={5}, min={6}, max={7}, repurposeThreshold={8}", null, null, repurposeAllowed, makeRoomAllowed, shareable, multitenantDatabase, total, borrowed, min, max, repurposeThreshold);
        try {
            int retries = 5;
            String serviceName = cs.serviceName(cri);
            cri = this.updatePasswordFromDefault(cri);
            for (int i = 0; i < 5; ++i) {
                if (this.noMoreGrows) {
                    CoreConnection coreConnection = null;
                    return coreConnection;
                }
                if (repurposeAllowed && Objects.nonNull(connection = this.tryRepurpose(cri))) {
                    this.repurposeCount.getAndIncrement();
                } else {
                    if (!cs.isServiceRegistered(serviceName)) {
                        this.registerService(serviceName);
                    }
                    if (makeRoomAllowed) {
                        if (this.makeRoom(cri)) {
                            connection = this.connectionSource().create(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry);
                            if (connection == null) continue;
                        }
                    } else {
                        connection = cs.create(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry);
                    }
                }
                break;
            }
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "growBorrowed", "", null, e, new Object[0]);
            UCPErrorHandler.throwUniversalConnectionPoolException(e);
        }
        finally {
            this.postGrowBorrowed(cri, connection);
        }
        return connection;
    }

    CompletionStage<CoreConnection> growBorrowedAsync(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry, Executor executor) {
        CompletableFuture<CoreConnection> cf = new CompletableFuture<CoreConnection>();
        this.growBorrowedHelperAsync(cri, callback, timeToRetry, executor).whenCompleteAsync((conn, e) -> {
            if (null != e) {
                this.pendingBorrowedGrows.getAndDecrement();
                cf.completeExceptionally((Throwable)e);
            } else {
                try {
                    this.postGrowBorrowed(cri, (CoreConnection)conn);
                    cf.complete((CoreConnection)conn);
                }
                catch (UniversalConnectionPoolException e2) {
                    cf.completeExceptionally(e2);
                }
            }
        }, executor);
        return cf;
    }

    private CompletionStage<CoreConnection> growBorrowedHelperAsync(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry, Executor executor) {
        int total = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
        if (this.noMoreGrows) {
            return CompletableFuture.completedFuture(null);
        }
        ConnectionSource cs = this.connectionSource();
        int borrowed = this.borrowedCount();
        boolean shareable = cs.isShareable();
        boolean multitenantDatabase = cs.isMultitenantDatabase();
        int min = this.limits().getMin();
        int max = this.limits().getMax();
        int repurposeThreshold = this.limits().getRepurposeThreshold();
        boolean repurposeAllowed = shareable && multitenantDatabase && total > min && total > repurposeThreshold && total > borrowed;
        boolean makeRoomAllowed = total > max && total > borrowed;
        this.trace(Level.FINEST, CLASS_NAME, "growBorrowed", "repurposeAllowed={0}, makeRoomAllowed={1}, shareable={2}, multitenantDatabase={3}, total={4}, borrowed={5}, min={6}, max={7}, repurposeThreshold={8}", null, null, repurposeAllowed, makeRoomAllowed, shareable, multitenantDatabase, total, borrowed, min, max, repurposeThreshold);
        String serviceName = this.connectionSource().serviceName(cri);
        if (repurposeAllowed) {
            return this.tryRepurposeAsync(cri, executor).thenApplyAsync(conn -> {
                if (Objects.nonNull(conn)) {
                    this.repurposeCount.getAndIncrement();
                }
                return conn;
            }, executor);
        }
        if (!cs.isServiceRegistered(serviceName)) {
            this.registerService(serviceName);
        }
        if (makeRoomAllowed) {
            return this.makeRoomAsync(cri, executor).thenComposeAsync(madeRoom -> {
                if (madeRoom.booleanValue()) {
                    return cs.createAsync(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry, executor);
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        return cs.createAsync(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postGrowBorrowed(ConnectionRetrievalInfo cri, CoreConnection conn) throws UniversalConnectionPoolException {
        try {
            if (Objects.nonNull(conn)) {
                if (!this.connectionSource().isServiceRegistered(conn.serviceName())) {
                    this.registerService(conn.serviceName());
                }
                try {
                    conn.onBorrow(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "postGrowBorrowed", "", null, e, new Object[0]);
                    conn.makeAvailable();
                    this.put(conn);
                    conn = null;
                    throw e;
                }
                conn.makeUnavailable();
                this.put(conn);
                this.peakBorrowedConnectionsCount.update(this.borrowedCount());
            }
            this.pendingBorrowedGrows.getAndDecrement();
        }
        catch (Throwable throwable) {
            this.pendingBorrowedGrows.getAndDecrement();
            if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
            if (null != conn) {
                this.trace(Level.FINEST, CLASS_NAME, "postGrowBorrowed", "conn={0}", null, null, conn);
            }
            throw throwable;
        }
        if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.signal();
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
        if (null != conn) {
            this.trace(Level.FINEST, CLASS_NAME, "postGrowBorrowed", "conn={0}", null, null, conn);
        }
    }

    final CompletionStage<CoreConnection> waitForAvailableAsync(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToWait, Executor executor) {
        Long giveUp = Clock.clock() + timeToWait;
        CriStats criStats = this.connectionSource().getCriMetadata(cri);
        assert (Objects.nonNull(criStats));
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        criStats.addAsyncBorrowRequest(cf, timeToWait);
        return cf.thenComposeAsync(p -> {
            CoreConnection conn = this.borrow(cri, callback, 0L);
            if (Objects.nonNull(conn)) {
                return CompletableFuture.completedFuture(conn);
            }
            long updatedTimeToWait = giveUp - Clock.clock();
            if (updatedTimeToWait <= 0L) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture delayedReborrowRequest = new CompletableFuture();
            UniversalConnectionPoolManagerBase.getTimerManager().schedule(() -> criStats.addAsyncBorrowRequest(delayedReborrowRequest, updatedTimeToWait), 100L, 0L);
            return delayedReborrowRequest.thenComposeAsync(pp -> this.waitForAvailableAsync(cri, callback, Math.max(0L, giveUp - Clock.clock()), executor), executor);
        }, executor);
    }

    private ConnectionSource.FailoverCallback prepareFailoverHandler(final String serviceName) {
        return new ConnectionSource.FailoverCallback(){

            @Override
            public ConnectionSource.FailoverCallback.Result handle(Predicate<CoreConnection> cleanupSelector, Predicate<CoreConnection> markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                Core.this.handlersLock.lock();
                try {
                    ConnectionSource.FailoverCallback.Result result = this.handleHelper(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup);
                    return result;
                }
                catch (Throwable e) {
                    Core.this.trace(Level.WARNING, CLASS_NAME, "prepareFailoverHandler", "", null, e, new Object[0]);
                    throw e;
                }
                finally {
                    Core.this.handlersLock.unlock();
                }
            }

            private ConnectionSource.FailoverCallback.Result handleHelper(Predicate<CoreConnection> cleanupSelector, Predicate<CoreConnection> markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                CoreConnection conn2;
                int[] count = new int[]{0};
                ConnectionSource.FailoverCallback.Result.ResultType resultType = ConnectionSource.FailoverCallback.Result.ResultType.FAILURE;
                int avail = Core.this.availableCount();
                int borrowed = Core.this.borrowedCount();
                int availMarkedDown = 0;
                int borrowedMarkedDown = 0;
                int[] availClosed = new int[]{0};
                int[] borrowedClosed = new int[]{0};
                int[] opened = new int[]{0};
                ConnectionSource cs = Core.this.connectionSource();
                Predicate<CoreConnection> serviceSelector = cs.serviceSelector(serviceName);
                Predicate<CoreConnection> availCleanupSelector = SelectorsUtil.availableSelector.and(serviceSelector).and(cleanupSelector);
                Predicate<CoreConnection> notAvailCleanupSelector = SelectorsUtil.notAvailableSelector.and(serviceSelector).and(cleanupSelector);
                Predicate<CoreConnection> anyCleanupSelector = serviceSelector.and(cleanupSelector);
                Predicate<CoreConnection> anyMerkupSelector = markedAlready.negate().and(serviceSelector).and(markupSelector);
                if (cs.isReplayable()) {
                    while (true) {
                        conn2 = Core.this.retrieveFirst(availCleanupSelector);
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "replayable: about to close conn={0}", null, null, conn2);
                        if (null == conn2) break;
                        conn2.close();
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "closed conn={0}", null, null, conn2);
                        if (restoreAfterCleanup) {
                            try {
                                Core.this.growAvailable(conn2.cri());
                                opened[0] = opened[0] + 1;
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareFailoverHandler", "", null, e, new Object[0]);
                            }
                        }
                        availClosed[0] = availClosed[0] + 1;
                        count[0] = count[0] + 1;
                    }
                    if (count[0] > 0) {
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: cleaned up {0} connections", null, null, count[0]);
                    }
                    count[0] = 0;
                    Core.this.forSome(notAvailCleanupSelector, conn -> {
                        conn.markReconnecting();
                        count[0] = count[0] + 1;
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "markreconnecting() done and put back conn={0}", null, null, conn);
                    });
                    if (count[0] > 0) {
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: marked for reconnecting {0} connections", null, null, count[0]);
                    }
                } else {
                    while (true) {
                        conn2 = Core.this.retrieveFirst(anyCleanupSelector);
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "about to close conn={0}", null, null, conn2);
                        if (null == conn2) break;
                        conn2.abort();
                        conn2.close();
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "closed conn={0}", null, null, conn2);
                        if (restoreAfterCleanup) {
                            try {
                                Core.this.growAvailable(conn2.cri());
                                opened[0] = opened[0] + 1;
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareFailoverHandler", "growAvailable hit exception:", null, e, new Object[0]);
                            }
                        }
                        if (conn2.available()) {
                            availClosed[0] = availClosed[0] + 1;
                        } else {
                            borrowedClosed[0] = borrowedClosed[0] + 1;
                        }
                        count[0] = count[0] + 1;
                    }
                }
                if (count[0] > 0) {
                    Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: cleaned up {0} connections", null, null, count[0]);
                }
                count[0] = 0;
                while (true) {
                    boolean[] marked = new boolean[]{false};
                    boolean[] av = new boolean[]{false};
                    Core.this.forFirst(anyMerkupSelector, conn -> {
                        if (isGracefulDraining) {
                            conn.markCloseOnReturn();
                        } else {
                            conn.markToReplace();
                        }
                        Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: marked {0} connections", null, null, count[0]);
                        marked[0] = true;
                        av[0] = conn.available();
                    });
                    if (!marked[0]) break;
                    count[0] = count[0] + 1;
                    if (av[0]) {
                        ++availMarkedDown;
                        continue;
                    }
                    ++borrowedMarkedDown;
                    borrowedClosed[0] = borrowedClosed[0] + 1;
                }
                if (count[0] > 0) {
                    Core.this.trace(Level.FINEST, CLASS_NAME, "prepareFailoverHandler", "FF: marked to replace {0} connections", null, null, count[0]);
                }
                int beforeAvail = Core.this.availableCount();
                int beforeBorrowed = Core.this.borrowedCount();
                ConnectionSource.FailoverCallback.Result result = new ConnectionSource.FailoverCallback.Result();
                result.type = ConnectionSource.FailoverCallback.Result.ResultType.SUCCESS;
                result.availConns = Core.this.availableCount();
                result.borrowedConns = Core.this.borrowedCount();
                result.availOpened = opened[0] + Core.this.availableCount() > beforeAvail ? Core.this.availableCount() - beforeAvail : 0;
                result.availClosed = availClosed[0] + (beforeAvail > Core.this.availableCount() ? beforeAvail - Core.this.availableCount() : 0);
                result.borrowedClosed = borrowedClosed[0] + (beforeBorrowed > Core.this.borrowedCount() ? beforeBorrowed - Core.this.borrowedCount() : 0);
                Core.this.kickAdjuster();
                return result;
            }
        };
    }

    private ConnectionSource.RebalanceCallback prepareRebalanceHandler(final String serviceName) {
        return new ConnectionSource.RebalanceCallback(){

            @Override
            public ConnectionSource.RebalanceCallback.Result handle(final Predicate<CoreConnection> cleanupSelector, final Predicate<CoreConnection> markupSelector) {
                final ConnectionSource.RebalanceCallback.Result res = new ConnectionSource.RebalanceCallback.Result();
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private final Predicate<CoreConnection> serviceSelector;
                    private final Predicate<CoreConnection> gravitatorCleanupSelector;
                    private final Predicate<CoreConnection> gravitatorMarkupSelector;
                    {
                        this.serviceSelector = Core.this.connectionSource().serviceSelector(serviceName);
                        this.gravitatorCleanupSelector = this.serviceSelector.and(this.gravitatorSelector(cleanupSelector));
                        this.gravitatorMarkupSelector = this.serviceSelector.and(this.gravitatorSelector(markupSelector));
                    }

                    @Override
                    public void run() {
                        if (!Core.this.handlersLock.tryLock()) {
                            return;
                        }
                        try {
                            this.runHelper();
                        }
                        finally {
                            Core.this.handlersLock.unlock();
                        }
                    }

                    private Predicate<CoreConnection> gravitatorSelector(Predicate<CoreConnection> eitherCleanupOrMarkupSelector) {
                        return c -> {
                            boolean gravitate;
                            block1: {
                                gravitate = false;
                                if (!eitherCleanupOrMarkupSelector.test((CoreConnection)c)) break block1;
                                ServiceMember inst = c.serviceMember();
                                int delta = inst.connsToRebalance.get();
                                if (delta < 0 && inst.connsToRebalance.compareAndSet(delta, delta + 1)) {
                                    gravitate = true;
                                }
                            }
                            return gravitate;
                        };
                    }

                    private void runHelper() {
                        int maxLimit = Math.max(1, (Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get()) * 15 / 100);
                        int[] count = new int[]{0};
                        while (count[0] < maxLimit) {
                            if (res.terminate.get()) {
                                return;
                            }
                            CoreConnection conn2 = Core.this.retrieveFirst(this.gravitatorCleanupSelector);
                            if (null == conn2) break;
                            conn2.close();
                            try {
                                Core.this.growAvailable(conn2.cri());
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareRebalanceHandler", "", null, e, new Object[0]);
                            }
                            count[0] = count[0] + 1;
                        }
                        Core.this.forSome(this.gravitatorMarkupSelector, conn -> {
                            conn.markToReplace();
                            count[0] = count[0] + 1;
                        });
                        if (count[0] > 0) {
                            Core.this.trace(Level.FINE, CLASS_NAME, "prepareRebalanceHandler", "rebalanced {0} connection(s)", null, null, count[0]);
                        }
                        for (int j = Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get(); j < Core.this.getEffectiveMinPoolSize(); ++j) {
                            if (res.terminate.get()) {
                                return;
                            }
                            try {
                                Core.this.growAvailable(Core.this.policies().getMostPopularCri(), true);
                                Core.this.trace(Level.FINEST, CLASS_NAME, "prepareRebalanceHandler", "grew up one connection to reach the minimum", null, null, new Object[0]);
                                continue;
                            }
                            catch (UniversalConnectionPoolException e) {
                                Core.this.trace(Level.WARNING, CLASS_NAME, "prepareRebalanceHandler", "", null, e, new Object[0]);
                                break;
                            }
                        }
                        if (res.terminate.get()) {
                            return;
                        }
                        Core.this.adjustMaxLimit();
                    }
                });
                return res;
            }
        };
    }

    private CoreConnection findConnectionToRepurpose(ConnectionRetrievalInfo cri) {
        String serviceName;
        ConnectionSource cs = this.connectionSource();
        if (!cs.isServiceRegistered(serviceName = cs.serviceName(cri))) {
            return null;
        }
        if (0 == this.knownServices.size()) {
            return null;
        }
        Predicate<CoreConnection> retrievalSelector = SelectorsUtil.availableSelector.and(cs.serviceSelector(serviceName).negate());
        for (boolean balanced : new boolean[]{true, false}) {
            CoreConnection toRepurpose = this.retrieveFirst(retrievalSelector.and(cs.serviceBasedRepurposeSelector(cri, balanced)));
            if (Objects.nonNull(toRepurpose)) {
                this.trace(Level.FINEST, CLASS_NAME, "findConnectionToRepurpose", "successful rerurpose, conn={0}", null, null, toRepurpose);
                return toRepurpose;
            }
            this.trace(Level.FINEST, CLASS_NAME, "findConnectionToRepurpose", "unable to rerurpose", null, null, new Object[0]);
        }
        return null;
    }

    private CoreConnection tryRepurpose(ConnectionRetrievalInfo cri) {
        CoreConnection toRepurpose = this.findConnectionToRepurpose(cri);
        if (Objects.nonNull(toRepurpose)) {
            if (toRepurpose.repurpose(cri)) {
                return toRepurpose;
            }
            toRepurpose.close();
            return null;
        }
        return null;
    }

    private CompletionStage<CoreConnection> tryRepurposeAsync(ConnectionRetrievalInfo cri, Executor executor) {
        CoreConnection toRepurpose = this.findConnectionToRepurpose(cri);
        if (Objects.nonNull(toRepurpose)) {
            return toRepurpose.repurposeAsync(cri, executor).thenComposeAsync(wasRepurposed -> {
                if (wasRepurposed.booleanValue()) {
                    this.trace(Level.FINEST, CLASS_NAME, "tryRepurposeAsync", "was repurposed", null, null, new Object[0]);
                    return CompletableFuture.completedFuture(toRepurpose);
                }
                return toRepurpose.closeAsync(executor).thenApplyAsync(nil -> {
                    this.trace(Level.FINEST, CLASS_NAME, "tryRepurposeAsync", "was not repurposed and closed", null, null, new Object[0]);
                    return null;
                });
            }, executor);
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean holdOverMakingRoom() {
        if (this.availableCount() == 0) {
            this.notAvailTS = Clock.clock();
            return true;
        }
        return Clock.clock() - this.notAvailTS < 120L;
    }

    private CoreConnection findConnectionToCloseToMakeRoom(ConnectionRetrievalInfo cri) {
        if (this.holdOverMakingRoom()) {
            return null;
        }
        this.trace(Level.FINEST, CLASS_NAME, "findConnectionToCloseToMakeRoom", "about to make room traversal", null, null, new Object[0]);
        ConnectionSource cs = this.connectionSource();
        try {
            Predicate<CoreConnection> optionsToGetRidSelector = SelectorsUtil.badSelector.or(SelectorsUtil.criUnmatchSelector(cri)).or(cs.routingKeyBasedBorrowSelector(cri, false).negate()).or(SelectorsUtil.wrongCostSelector(cri.getLabels()));
            Predicate<CoreConnection> retrievalSelector = SelectorsUtil.availableSelector.and(optionsToGetRidSelector);
            return this.retrieveFirst(retrievalSelector, false);
        }
        catch (Throwable e) {
            this.trace(Level.WARNING, CLASS_NAME, "findConnectionToCloseToMakeRoom", "", null, e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeRoom(ConnectionRetrievalInfo cri) {
        this.adjusterEnabled.set(false);
        try {
            CoreConnection toClose = this.findConnectionToCloseToMakeRoom(cri);
            if (Objects.nonNull(toClose)) {
                toClose.close();
                this.trace(Level.FINEST, CLASS_NAME, "makeRoom", "connection closed", null, null, new Object[0]);
                boolean bl = true;
                return bl;
            }
            this.trace(Level.FINEST, CLASS_NAME, "makeRoom", "makeRoom() was not able to find a connection to close", null, null, new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    private CompletionStage<Boolean> makeRoomAsync(ConnectionRetrievalInfo cri, Executor executor) {
        this.adjusterEnabled.set(false);
        return this.makeRoomHelperAsync(cri, executor).whenCompleteAsync((res, e) -> this.adjusterEnabled.set(true), executor);
    }

    private CompletionStage<Boolean> makeRoomHelperAsync(ConnectionRetrievalInfo cri, Executor executor) {
        CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
        CoreConnection toClose = this.findConnectionToCloseToMakeRoom(cri);
        if (Objects.nonNull(toClose)) {
            return toClose.closeAsync(executor).thenApplyAsync(nil -> {
                this.trace(Level.FINEST, CLASS_NAME, "makeRoomHelperAsync", "connection closed", null, null, new Object[0]);
                return true;
            }, executor);
        }
        this.trace(Level.FINEST, CLASS_NAME, "makeRoomHelperAsync", "makeRoom() was not able to find a connection to close", null, null, new Object[0]);
        cf.complete(false);
        return cf;
    }

    boolean uselessConnsCleanerInProgress() {
        return this.cleanUselessInProgress.get();
    }

    private void cleanUselessAsynch() {
        if (this.cleanUselessInProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                    @Override
                    public void run() {
                        Core.this.cleanUseless();
                    }
                });
            }
            catch (RuntimeException e) {
                this.cleanUselessInProgress.set(false);
            }
        }
    }

    private void cleanUseless() {
        try {
            for (CoreConnection toClean : this.split(conn -> conn.available() && (conn.closed() || conn.bad()))) {
                if (!toClean.bad()) continue;
                toClean.close();
            }
        }
        finally {
            this.cleanUselessInProgress.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growAvailable(ConnectionRetrievalInfo cri, boolean useBestInstance) throws UniversalConnectionPoolException {
        CoreConnection conn = null;
        int total = this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.incrementAndGet();
        try {
            if (total > this.limits().getMax()) {
                return;
            }
            if (this.noMoreGrows) {
                return;
            }
            cri = this.updatePasswordFromDefault(cri);
            conn = this.connectionSource().create(cri, null, useBestInstance ? EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE) : EnumSet.noneOf(ConnectionSource.CreateMode.class), 0L);
            if (conn == null) {
                return;
            }
            if (!this.connectionSource().isServiceRegistered(conn.serviceName())) {
                this.registerService(conn.serviceName());
            }
            conn.makeAvailable();
            this.trace(Level.FINEST, CLASS_NAME, "growAvailable", "conn={0}", null, null, conn);
            this.put(conn);
        }
        finally {
            this.pendingAvailableGrows.getAndDecrement();
            if (this.noMoreGrows && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
        }
    }

    private void growAvailable(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        this.growAvailable(cri, true);
    }

    final void growAvailableAsynch(final ConnectionRetrievalInfo cri) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

            @Override
            public void run() {
                try {
                    Core.this.growAvailable(cri);
                }
                catch (UniversalConnectionPoolException e) {
                    Core.this.trace(Level.WARNING, CLASS_NAME, "growAvailableAsynch", "", null, e, new Object[0]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initialize() throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        final boolean[] succeeded = new boolean[]{true};
        final Throwable[] cause = new Throwable[]{null};
        try {
            int initPoolSize = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService()) - this.totalCount().get();
            final AtomicInteger connsToCreate = new AtomicInteger();
            UCPTaskBase<Boolean> task = new UCPTaskBase<Boolean>(){

                @Override
                public Boolean call() {
                    Core.this.trace(Level.FINEST, CLASS_NAME, "initialize", "launching init thread", null, null, new Object[0]);
                    while (connsToCreate.getAndDecrement() > 0 && Core.this.totalCount().get() < Core.this.limits().getInitial()) {
                        try {
                            CoreConnection conn;
                            ConnectionRetrievalInfo defaultCri = Core.this.connectionSource().defaultCriAndService();
                            String defaultSvcName = Core.this.connectionSource().serviceName(defaultCri);
                            if (!Core.this.connectionSource().isServiceRegistered(defaultSvcName)) {
                                Core.this.registerService(defaultSvcName);
                            }
                            if (null != (conn = Core.this.connectionSource().create(Core.this.policies().getMostPopularCri(), null, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), 1000L))) {
                                conn.makeAvailable();
                                Core.this.put(conn);
                                Core.this.trace(Level.FINEST, CLASS_NAME, "initialize", "connection {0} successfully created", null, null, conn);
                                continue;
                            }
                            Core.this.trace(Level.WARNING, CLASS_NAME, "initialize", "connection not created", null, null, new Object[0]);
                        }
                        catch (UniversalConnectionPoolException e) {
                            Core.this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                            if (e.getCause() instanceof SQLRecoverableException) continue;
                            Core.this.trace(Level.FINEST, CLASS_NAME, "initialize", "failure", null, null, new Object[0]);
                            succeeded[0] = false;
                            cause[0] = e;
                            break;
                        }
                    }
                    return succeeded[0];
                }
            };
            try {
                connsToCreate.set(initPoolSize > 0 ? 1 : 0);
                if (!((Boolean)task.call()).booleanValue()) {
                    this.trace(Level.WARNING, CLASS_NAME, "initialize", "unable to start connection creation task", null, cause[0], new Object[0]);
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, cause[0]);
                }
                int maxInitThreads = Util.getMaxInitThreads();
                int initThreads = Math.min(Math.max(0, maxInitThreads), Math.max(0, initPoolSize));
                this.trace(Level.FINEST, CLASS_NAME, "initialize", "initPoolSize={0}, maxInitThreads={1}, initThreads={2}", null, null, initPoolSize, maxInitThreads, initThreads);
                connsToCreate.set(initPoolSize - 1);
                TaskHandle[] handles = new TaskHandle[initThreads];
                TaskManager tm = UniversalConnectionPoolManagerBase.getTaskManager();
                if (null == tm) {
                    this.trace(Level.WARNING, CLASS_NAME, "initialize", "task manager is not set", null, null, new Object[0]);
                }
                for (int i = 0; i < handles.length; ++i) {
                    TaskHandle taskHandle = handles[i] = null == tm ? null : tm.submitTask(task);
                    if (null != handles[i]) continue;
                    this.trace(Level.WARNING, CLASS_NAME, "initialize", "task manager is not running, so init pool size connections are being started in this thread", null, null, new Object[0]);
                    if (((Boolean)task.call()).booleanValue()) continue;
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, new IllegalStateException("unable to initialize connection", cause[0]));
                }
                for (TaskHandle handle : handles) {
                    if (null == handle) continue;
                    succeeded[0] = succeeded[0] && (Boolean)handle.get(0L) != false;
                }
            }
            catch (Exception e) {
                this.trace(Level.WARNING, CLASS_NAME, "initialize", "", null, e, new Object[0]);
                UCPErrorHandler.throwUniversalConnectionPoolException(66, e);
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
        if (succeeded[0]) {
            return;
        }
        UCPErrorHandler.throwUniversalConnectionPoolException(66, cause[0].getCause());
    }

    final void closeAvailableInactive(long inactivityTimeout) {
        CoreConnection conn;
        if (inactivityTimeout == 0L) {
            return;
        }
        boolean timersAffectAllConnections = Util.timersAffectAllConnections();
        while ((timersAffectAllConnections || this.totalCount().get() + this.pendingGrowsCount() > this.limits().getMin()) && null != (conn = this.retrieveFirst(SelectorsUtil.inactiveSelector(inactivityTimeout)))) {
            conn.close();
        }
        this.kickAdjuster();
    }

    final void reduce(ConnectionRetrievalInfo cri) {
        int htc = this.limits().getHarvestTriggerCount();
        int hmc = this.limits().getHarvestMaxCount();
        Predicate<CoreConnection> limitSelector = htc < Integer.MAX_VALUE ? p -> p.available() && this.totalCount().get() > this.getEffectiveMinPoolSize() && this.availableCount() > htc + hmc : p -> p.available() && this.totalCount().get() > this.getEffectiveMinPoolSize();
        CoreConnection conn = this.retrieveFirst(SelectorsUtil.criMatchSelector(cri).and(limitSelector));
        if (null != conn) {
            conn.close();
        }
        this.kickAdjuster();
    }

    private boolean idle() {
        if (this.borrowedCount() != 0) {
            return false;
        }
        if (this.adjusterBusy.get()) {
            return true;
        }
        return this.pendingGrowsCount() == 0;
    }

    final void replaceNonReusable() {
        boolean timersAffectAllConnections = Util.timersAffectAllConnections();
        this.adjusterEnabled.set(false);
        try {
            this.split(conn -> {
                if (!(conn.reusable() || !timersAffectAllConnections && this.idle() && this.totalCount().get() <= this.limits().getMin())) {
                    if (conn.available()) {
                        conn.close();
                        return true;
                    }
                    conn.markToReplace();
                    return false;
                }
                return false;
            });
        }
        finally {
            this.adjusterEnabled.set(true);
            this.kickAdjuster();
        }
    }

    final void replaceAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(false);
    }

    final void replaceInvalidAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvailable(boolean invalidOnly) throws UniversalConnectionPoolException {
        UniversalPooledConnection.ValidationType vtNetwork = UniversalPooledConnection.ValidationType.NETWORK;
        this.adjusterEnabled.set(false);
        try {
            List<CoreConnection> closedConns = this.split(conn -> {
                if (!conn.available()) {
                    conn.markToReplace();
                    return false;
                }
                if (invalidOnly && ((UniversalPooledConnection)conn.getDelegate()).isValid(vtNetwork)) {
                    return false;
                }
                conn.close();
                return true;
            });
            for (CoreConnection connection : closedConns) {
                this.growAvailable(connection.cri());
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replaceBadConnections() throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        try {
            List<CoreConnection> closedConns = this.split(conn -> {
                if (!conn.available()) {
                    return false;
                }
                if (conn.normal()) {
                    return false;
                }
                conn.close();
                return true;
            });
            for (CoreConnection connection : closedConns) {
                this.growAvailable(connection.cri());
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
        this.kickAdjuster();
    }

    void kickAdjuster() {
        if (!this.adjusterEnabled.get()) {
            return;
        }
        if (this.adjusterBusy.compareAndSet(false, true)) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    try {
                        Core.this.adjustLimits();
                    }
                    finally {
                        Core.this.adjusterBusy.set(false);
                    }
                }
            });
        }
    }

    int pendingAvailableGrows() {
        return this.pendingAvailableGrows.get();
    }

    final void returnAbandoned(int abandonedTimeout) {
        for (CoreConnection conn : this.split(SelectorsUtil.abandonedSelector(abandonedTimeout))) {
            conn.handleTimeout();
            conn.abort();
            conn.close();
        }
        this.kickAdjuster();
    }

    final void returnTTLed(int timeoutTTLed) {
        for (CoreConnection conn : this.split(SelectorsUtil.ttlSelector(timeoutTTLed))) {
            conn.handleTimeout();
            conn.abort();
            conn.close();
        }
        this.kickAdjuster();
    }

    final void harvest(int triggerCount, int maxCount) {
        if (triggerCount >= 0 && triggerCount < Integer.MAX_VALUE && this.availableCount() <= triggerCount) {
            final int[] requestedConns = new int[]{maxCount};
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    for (int i = 0; i < 5 * requestedConns[0] && requestedConns[0] > 0; ++i) {
                        long[] oldestLastAccessedTime = new long[]{Clock.clock()};
                        boolean[] exhausted = new boolean[]{true};
                        Predicate<CoreConnection> notAvailableHarvestableSelector = SelectorsUtil.notAvailableSelector.and(SelectorsUtil.harvestableSelector());
                        Consumer<CoreConnection> consumer = conn -> {
                            long lastAccessedTime = conn.lastAccessedTime();
                            if (lastAccessedTime < oldestLastAccessedTime[0]) {
                                oldestLastAccessedTime[0] = lastAccessedTime;
                                exhausted[0] = false;
                            }
                        };
                        Core.this.forSome(notAvailableHarvestableSelector, consumer);
                        if (exhausted[0] || requestedConns[0] <= 0) break;
                        Predicate<CoreConnection> selector = notAvailableHarvestableSelector.and(c -> requestedConns[0] > 0);
                        Consumer<CoreConnection> consumer2 = conn -> {
                            long lacct = conn.lastAccessedTime();
                            if (lacct <= oldestLastAccessedTime[0]) {
                                conn.cleanupToHarvest();
                                conn.makeAvailable();
                                requestedConns2[0] = requestedConns[0] - 1;
                            }
                        };
                        Core.this.forSome(selector, consumer2);
                    }
                }
            });
        }
    }

    final boolean retrieve(CoreConnection conn) {
        Predicate<CoreConnection> retrievalSelector = this.connectionSource().serviceSelector(conn.serviceName()).and(SelectorsUtil.notAvailableSelector).and(c -> conn == c);
        return null != this.retrieveFirst(retrievalSelector);
    }

    final CoreConnection findSpecificConnection(Object physicalConn) {
        CoreConnection[] selectedConn = new CoreConnection[]{null};
        Predicate<CoreConnection> selector = SelectorsUtil.notAvailableSelector.and(SelectorsUtil.physicalSelector(physicalConn));
        this.forFirst(selector, conn -> {
            selectedConn[0] = conn;
        });
        return selectedConn[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPendingGrowsToFinish() {
        this.noMoreGrows = true;
        int GROWTH_CHECK_ATTEMPTS = 10;
        boolean pendingGrowsFinished = false;
        for (int attempts = 10; attempts > 0; --attempts) {
            if (0 == this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.get()) {
                pendingGrowsFinished = true;
                break;
            }
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.await(1L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "waitForPendingGrowsToFinish", "interrupted while waiting for pending connection creations to finish", null, e, new Object[0]);
                break;
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
        if (!pendingGrowsFinished) {
            this.trace(Level.INFO, CLASS_NAME, "waitForPendingGrowsToFinish", "waiting for 10 seconds for recent connection creation operations to be finished, these operations will be aborted", null, null, new Object[0]);
        }
    }

    private void enablePendingGrows() {
        this.noMoreGrows = false;
    }

    final void closeAll() {
        this.closeAll(0L);
    }

    final void closeAll(long timeout) {
        this.closeAll(timeout, false);
    }

    final void closeAll(long timeout, boolean rollback) {
        this.keepOverMinimum.set(false);
        this.peakConnectionsCount.reset();
        this.peakBorrowedConnectionsCount.reset();
        long giveUp = Clock.clock() + timeout;
        while (true) {
            boolean[] allClosed = new boolean[]{true};
            boolean over = Clock.clock() >= giveUp;
            this.split(conn -> {
                if (0L == timeout || conn.available() || over) {
                    if (rollback && !conn.available()) {
                        conn.handleTimeout();
                        conn.abort();
                    }
                    conn.close();
                    return true;
                }
                allClosed[0] = false;
                return false;
            });
            if (allClosed[0] || over) break;
            this.trace(Level.WARNING, CLASS_NAME, "closeAll", "Attempted to close borrowed connections, waiting for {0} milliseconds", null, null, timeout);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void adjustLimits() {
        this.adjustMinLimit(10);
        this.adjustMaxLimit();
    }

    private int getEffectiveMinPoolSize() {
        return this.keepOverMinimum.get() ? this.limits().getMin() : this.peakConnectionsCount.get();
    }

    void adjustMinLimit(final int attempts) {
        Policies policies = this.policies();
        while (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < this.getEffectiveMinPoolSize()) {
            try {
                this.trace(Level.FINE, CLASS_NAME, "adjustMinLimit", "growing...", null, null, new Object[0]);
                this.growAvailable(policies.getMostPopularCri(), attempts < 3);
                this.trace(Level.FINE, CLASS_NAME, "adjustMinLimit", "grew up 1 connection to reach the minimum", null, null, new Object[0]);
            }
            catch (UniversalConnectionPoolException e) {
                this.trace(Level.WARNING, CLASS_NAME, "adjustMinLimit", "", null, e, new Object[0]);
                break;
            }
        }
        if (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < this.getEffectiveMinPoolSize() && attempts > 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "adjustMinLimit", "", null, e, new Object[0]);
            }
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){

                @Override
                public void run() {
                    Core.this.adjustMinLimit(attempts - 1);
                }
            });
        }
    }

    void adjustMaxLimit() {
        Limits limits = this.limits();
        Predicate<CoreConnection> splitSelector = Predicates.and(SelectorsUtil.availableSelector, conn -> this.totalCount().get() > limits.getMax());
        for (CoreConnection conn2 : this.split(splitSelector)) {
            conn2.close();
            this.trace(Level.FINE, CLASS_NAME, "adjustMaxLimit", "closed one connection to stay under max limit", null, null, new Object[0]);
        }
    }

    private Counter totalCount() {
        return this.connectionSource().totalCount();
    }

    private int borrowedCount() {
        return this.connectionSource().borrowedCount().get();
    }

    int availableCount() {
        return this.totalCount().get() - this.borrowedCount();
    }

    public long repurposeCount() {
        return this.repurposeCount.get();
    }

    void start(ConnectionRetrievalInfo cri, boolean keepMetadataConn) throws UniversalConnectionPoolException {
        this.enablePendingGrows();
        final ConnectionSource cs = this.connectionSource();
        int initPoolSize = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService());
        Consumer<String> serviceRegistrator = serviceName -> {
            if (!cs.isServiceRegistered((String)serviceName)) {
                this.registerService((String)serviceName);
            }
        };
        Consumer<CoreConnection> coreConnectionConsumer = conn -> {
            conn.makeAvailable();
            this.trace(Level.FINEST, CLASS_NAME, "start", "conn={0}", null, null, conn);
            this.put((CoreConnection)conn);
        };
        cs.start(cri, serviceRegistrator, initPoolSize > 0 || keepMetadataConn ? coreConnectionConsumer : null);
        this.plugPolicies(new Policies(){

            @Override
            public ConnectionRetrievalInfo getMostPopularCri() {
                return cs.defaultCriAndService();
            }

            @Override
            public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
                return !cs.defaultCriAndService().equalsIncludingPassword(cri);
            }
        });
    }

    void stop() {
        this.waitForPendingGrowsToFinish();
        this.closeAll(5000L);
        this.connectionSource().stop();
        this.knownServices.clear();
        coreInstances.remove(this);
    }

    boolean available(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        if (!cs.validateCri(cri)) {
            return false;
        }
        return cs.available(cri);
    }

    int pendingGrowsCount() {
        return this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get();
    }

    boolean noMoreGrows() {
        return this.noMoreGrows;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    static {
        if (Util.isShutdownHookEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    coreInstances.forEach(p -> {
                        p.waitForPendingGrowsToFinish();
                        p.closeAll(5000L, true);
                        p.trace(Level.FINEST, CLASS_NAME, "shutdownHook", "{0}: pending grows finished gracefully", null, null, p.toString());
                    });
                }
            });
        } else {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "shutdownHook", "The smooth shutdown was explicitly disabled and it is customer\u2019s \nresponsibility to explicitly roll back ongoing transactions on shutdown", null, null, null);
        }
    }

    private class BorrowContext {
        private final ConnectionRetrievalInfo cri;
        private ConnectionAffinityCallback callback;
        final long giveUpTimeStamp;
        private final ConnectionSource cs;
        private final Predicate<CoreConnection> baseSelector;
        private final Properties reqLabels;
        private final CriStats criMetadata;
        private final int lruCacheSize;
        private final Map<CoreConnection, Integer> costCache;

        private BorrowContext(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long giveUpTimeStamp) {
            this.cs = Core.this.connectionSource();
            this.costCache = new HashMap<CoreConnection, Integer>();
            this.cri = cri;
            this.callback = callback;
            this.giveUpTimeStamp = giveUpTimeStamp;
            this.baseSelector = Predicates.and(Core.this.normalitySelector, SelectorsUtil.criMatchSelector(cri), Core.this.serviceSelector(cri), WLSJTAPlugin.xaAffSelector());
            this.reqLabels = cri.getLabels();
            this.criMetadata = this.cs.getCriMetadata(cri);
            this.lruCacheSize = Math.min(512, this.criMetadata.totalConnCount().get());
        }

        private Predicate<CoreConnection> basicCommonSelector(boolean lbBased, boolean keyBased) {
            return Predicates.and(SelectorsUtil.availableSelector, this.baseSelector, lbBased ? Core.this.lbSelector(this.cri, this.callback) : Predicates.EVERY, keyBased ? Core.this.keyBasedSelector(this.cri) : Predicates.EVERY);
        }

        private CoreConnection findFirst(Predicate<CoreConnection> selector) {
            int[] reservedCost = new int[]{Integer.MAX_VALUE};
            CoreConnection[] reservedConn = new CoreConnection[]{null};
            try {
                Core.this.waitFreePool.findFirst(conn -> {
                    if (!selector.test((CoreConnection)conn)) {
                        return false;
                    }
                    if (null == this.reqLabels) {
                        reservedConn[0] = conn;
                        reservedConn[0].makeUnavailable();
                        reservedCost[0] = 0;
                        return true;
                    }
                    int cost = this.costCache.computeIfAbsent((CoreConnection)conn, p -> p.labelingCost(this.reqLabels));
                    if (Integer.MAX_VALUE == cost) {
                        return false;
                    }
                    if (null != reservedConn[0]) {
                        if (cost < reservedCost[0]) {
                            reservedCost[0] = cost;
                            reservedConn[0].makeAvailable();
                            reservedConn[0] = conn;
                            reservedConn[0].makeUnavailable();
                            return false;
                        }
                        return false;
                    }
                    reservedCost[0] = cost;
                    reservedConn[0] = conn;
                    reservedConn[0].makeUnavailable();
                    return 0 == cost;
                }, conn -> {}, this.criMetadata.getWaitFreePoolCache(), this.lruCacheSize);
            }
            catch (Throwable e) {
                Core.this.trace(Level.WARNING, CLASS_NAME, "findFirst", "", null, e, new Object[0]);
                if (null != reservedConn[0]) {
                    reservedConn[0].makeAvailable();
                    reservedConn[0] = null;
                }
                throw e;
            }
            return reservedConn[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoreConnection findFirst(Predicate<CoreConnection> selector, int attempts) {
            CoreConnection conn;
            block7: {
                conn = null;
                try {
                    CriStats.BorrowSemaphore borrowSemaphore;
                    boolean acquired;
                    for (int i = 0; i < attempts && this.criMetadata.totalConnCount().get() - this.criMetadata.borrowedConnCount().get() > 0; ++i) {
                        conn = this.findFirst(selector);
                        if (null == conn) continue;
                        return conn;
                    }
                    long remainingTimeToWait = Core.computeRemainingTimeToWait(this.giveUpTimeStamp);
                    if (remainingTimeToWait <= 0L || !(acquired = ((Semaphore)(borrowSemaphore = this.criMetadata.getBorrowSemaphore())).tryAcquire(remainingTimeToWait, TimeUnit.MILLISECONDS))) break block7;
                    try {
                        conn = this.findFirst(selector);
                    }
                    finally {
                        borrowSemaphore.release();
                    }
                }
                catch (InterruptedException e) {
                    Core.this.handleUncheckedException(e, conn);
                    conn = null;
                }
                catch (Throwable e) {
                    Core.this.handleUncheckedException(e, conn);
                    conn = null;
                    throw e;
                }
            }
            return conn;
        }
    }
}

