/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.events.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import oracle.ucp.events.core.UCPEventListener;
import oracle.ucp.events.core.UCPEventListenerProvider;
import oracle.ucp.events.spi.DefaultUCPEventListenerProvider;

public final class UCPResourceType<T extends UCPEventListenerProvider, U> {
    public static final UCPResourceType<UCPEventListenerProvider, UCPEventListener> UCP_EVENT_LISTENER = new UCPResourceType<UCPEventListenerProvider, UCPEventListener>("ucpEventListenerProvider", UCPEventListenerProvider.class, UCPEventListenerProvider::getListener, "default-ucp-listener", DefaultUCPEventListenerProvider::new);
    private static final Collection<UCPResourceType<?, ?>> ALL_TYPES = Collections.singletonList(UCP_EVENT_LISTENER);
    private final String propertyName;
    private final String defaultProviderName;
    private final FutureTask<T> defaultProviderTask;
    private final Class<T> providerClass;
    private final BiFunction<T, Map<String, String>, U> resourceFunction;

    private UCPResourceType(String propertyName, Class<T> providerClass, BiFunction<T, Map<String, String>, U> resourceFunction, String defaultProviderName, Callable<T> defaultProviderSupplier) {
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName must not be null");
        this.providerClass = Objects.requireNonNull(providerClass, "providerClass must not be null");
        this.resourceFunction = Objects.requireNonNull(resourceFunction, "resourceFunction must not be null");
        this.defaultProviderName = Objects.requireNonNull(defaultProviderName, "defaultProviderName must not be null");
        this.defaultProviderTask = new FutureTask<T>(defaultProviderSupplier);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getDefaultProviderName() {
        return this.defaultProviderName;
    }

    public Class<T> getProviderClass() {
        return this.providerClass;
    }

    public T getDefaultProvider() throws Exception {
        if (!this.defaultProviderTask.isDone()) {
            this.defaultProviderTask.run();
        }
        return (T)((UCPEventListenerProvider)this.defaultProviderTask.get());
    }

    public U getResource(T provider, Map<String, String> config) {
        return this.resourceFunction.apply((UCPEventListenerProvider)Objects.requireNonNull(provider, "provider must not be null"), Objects.requireNonNull(config, "config must not be null"));
    }

    public static Collection<UCPResourceType<?, ?>> allTypes() {
        return ALL_TYPES;
    }
}

