/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.events.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import oracle.ucp.events.api.UCPResourceType;
import oracle.ucp.events.core.UCPEventListenerProvider;

public final class UCPInstalledProviders<T extends UCPEventListenerProvider> {
    private final Map<String, T> providers;

    private UCPInstalledProviders(Map<String, T> providers) {
        this.providers = Collections.unmodifiableMap(new HashMap<String, T>(providers));
    }

    public T get(String name) {
        return (T)((UCPEventListenerProvider)this.providers.get(name));
    }

    public Collection<String> getNames() {
        return Collections.unmodifiableSet(this.providers.keySet());
    }

    public static <T extends UCPEventListenerProvider> UCPInstalledProviders<T> load(UCPResourceType<T, ?> type) {
        TreeMap<String, UCPEventListenerProvider> found = new TreeMap<String, UCPEventListenerProvider>(String.CASE_INSENSITIVE_ORDER);
        ServiceLoader<UCPEventListenerProvider> loader = ServiceLoader.load(type.getProviderClass());
        for (UCPEventListenerProvider provider : loader) {
            String name = provider.getName();
            if (name == null || found.containsKey(name)) continue;
            found.put(name, provider);
        }
        return new UCPInstalledProviders(found);
    }
}

